/*
 * Decompiled with CFR 0.152.
 */
package com.creawor.meip2.extent;

import com.creawor.meip2.Server;
import com.creawor.meip2.beans.SessionBean;
import com.creawor.meip2.beans.SmReceived;
import com.creawor.meip2.beans.SmToBeSent;
import com.creawor.meip2.db.SmDatabase;
import com.creawor.meip2.extent.QueryModeListener;
import com.creawor.meip2.main.Main;
import com.haibo.log.TraceFactory;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class ExtentManager {
    private static ExtentManager instance = null;
    Hashtable listerMap = new Hashtable();
    long querySuccessCount = 0L;
    long queryErrorCount = 0L;

    private ExtentManager() {
    }

    private void init() {
        String queryModeUse = Main.getCfg().readString("QueryModeUse");
        if (queryModeUse != null && queryModeUse.trim().length() > 0) {
            String[] uses = queryModeUse.split(",");
            if (uses != null && uses.length > 0) {
                int i = 0;
                while (i < uses.length) {
                    String useName = uses[i];
                    if (useName != null && useName.trim().length() > 0) {
                        String upNumber = Main.getCfg().readString(String.valueOf(useName) + "_UpNumberExt");
                        String queryClass = Main.getCfg().readString(String.valueOf(useName) + "_Class");
                        try {
                            QueryModeListener listener = (QueryModeListener)Class.forName(queryClass).newInstance();
                            this.addListener(upNumber, listener);
                            TraceFactory.getTrace().trace("[ExtentManager] init :" + queryClass, 2);
                        }
                        catch (Exception e) {
                            TraceFactory.getTrace().trace("[ExtentManager] init Error! queryClass:" + queryClass, 8);
                            TraceFactory.getTrace().trace(e, 8);
                        }
                    }
                    ++i;
                }
            }
            TraceFactory.getTrace().trace("[ExtentManager] init successful! Total:" + this.listerMap.size(), 2);
        }
    }

    public static synchronized ExtentManager getInstance() {
        if (instance == null) {
            instance = new ExtentManager();
            instance.init();
        }
        return instance;
    }

    public synchronized void addListener(String upNumberExtend, QueryModeListener listener) {
        if (upNumberExtend != null && listener != null) {
            this.listerMap.put(upNumberExtend, listener);
        }
    }

    public synchronized void receiveSms(Vector vtsms) {
        if (vtsms == null || vtsms.size() <= 0) {
            return;
        }
        int i = 0;
        while (i < vtsms.size()) {
            SmReceived smrd = (SmReceived)vtsms.get(i);
            if (smrd.content != null && smrd.content.equalsIgnoreCase("00000000")) {
                String retString = "\u67e5\u8be2\u6210\u529f\u6570\uff1a" + this.querySuccessCount + ",\u67e5\u8be2\u5931\u8d25\u6570\uff1a" + this.queryErrorCount + ",\u67e5\u8be2\u603b\u6570\uff1a" + (this.querySuccessCount + this.queryErrorCount);
                ExtentManager.returnToMobile(retString, "", smrd.mobile);
            } else {
                String unNumberExt = "";
                Iterator iterator = this.listerMap.keySet().iterator();
                while (iterator.hasNext()) {
                    QueryModeListener listener;
                    String unNumber = (String)iterator.next();
                    if (!unNumber.equalsIgnoreCase("*") && !unNumberExt.startsWith(unNumber) || (listener = (QueryModeListener)this.listerMap.get(unNumber)) == null) continue;
                    try {
                        TraceFactory.getTrace().trace("[ExtentManager] \u63a5\u6536\u5230\u67e5\u8be2\u3002 moblie:" + smrd.mobile + ", content:" + smrd.content, 2);
                        long currentTime = System.currentTimeMillis();
                        listener.doWhenRecieveSms(smrd.content, unNumberExt, smrd.mobile);
                        TraceFactory.getTrace().trace("[ExtentManager] \u67e5\u8be2\u5b8c\u6bd5\u3002 moblie:" + smrd.mobile + ", content:" + smrd.content + ",\u8017\u65f6:" + (System.currentTimeMillis() - currentTime), 2);
                        ++this.querySuccessCount;
                    }
                    catch (Exception e) {
                        ++this.queryErrorCount;
                        TraceFactory.getTrace().trace("[ExtentManager] doWhenRecieveSms Error! moblie:" + smrd.mobile + ", content:" + smrd.content, 8);
                        TraceFactory.getTrace().trace(e, 8);
                    }
                }
            }
            ++i;
        }
    }

    public static synchronized void returnToMobile(String content, String unNumberExt, String mobile) {
        Vector<SmToBeSent> vec = new Vector<SmToBeSent>();
        String retContent = content;
        while (retContent != null) {
            SmToBeSent sm = null;
            Object sender = null;
            sm = new SmToBeSent();
            sm.mobile = mobile;
            if (retContent.length() <= 255) {
                sm.content = retContent;
                retContent = null;
            } else {
                sm.content = retContent.substring(0, 255);
                retContent = retContent.substring(255);
            }
            SessionBean sb = Server.getSessionBean();
            if (sb != null) {
                sm.eid = sb.getEid();
                sm.userid = sb.getUid();
                sm.password = sb.getPassword();
            }
            vec.addElement(sm);
            TraceFactory.getTrace().trace("[ExtentManager] \u67e5\u8be2\u7ed3\u679c moblie:" + mobile + ", content:" + sm.content, 2);
        }
        try {
            SmDatabase.AddSmToBeSent(vec);
            TraceFactory.getTrace().trace("[ExtentManager] returnToMobile successful! moblie:" + mobile, 2);
        }
        catch (Exception e) {
            TraceFactory.getTrace().trace("[ExtentManager] returnToMobile Error! moblie:" + mobile + ", content:" + content, 8);
            TraceFactory.getTrace().trace(e, 8);
        }
    }
}

