/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.util;

import cn.org.gddsn.semaphore.MultiReadOneWrite;
import cn.org.gddsn.util.FixQueue;
import cn.org.gddsn.util.QueueAddElementEvent;

public class SynchronizedFixQueue
extends FixQueue {
    private MultiReadOneWrite controler = new MultiReadOneWrite();

    public SynchronizedFixQueue(int newMaxQueueSize, String queueID) {
        super(newMaxQueueSize, queueID);
    }

    public void addBack(Object obj) {
        this.controler.enterWrite();
        super.addBackNoNotify(obj);
        this.controler.leaveWrite();
        this.fireQueueAddElementEventListener(new QueueAddElementEvent(this, this.queueID, obj));
    }

    public void popFront() {
        this.controler.enterWrite();
        super.popFront();
        this.controler.leaveWrite();
    }

    public void removeAll() {
        this.controler.enterWrite();
        super.removeAll();
        this.controler.leaveWrite();
    }

    public Object getFront() {
        this.controler.enterRead();
        Object obj = super.getFront();
        this.controler.leaveRead();
        return obj;
    }

    public Object getBack() {
        this.controler.enterRead();
        Object obj = super.getBack();
        this.controler.leaveRead();
        return obj;
    }

    public boolean isEmpty() {
        this.controler.enterRead();
        boolean bEmpty = super.isEmpty();
        this.controler.leaveRead();
        return bEmpty;
    }

    public Object at(int index) {
        this.controler.enterRead();
        Object obj = super.at(index);
        this.controler.leaveRead();
        return obj;
    }

    public int getSize() {
        this.controler.enterRead();
        int size = super.getSize();
        this.controler.leaveRead();
        return size;
    }
}

