/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.util;

import cn.org.gddsn.semaphore.MultiReadOneWrite;
import cn.org.gddsn.util.FixHashQueue;
import cn.org.gddsn.util.QueueAddElementEvent;

public class SynchronizedFixHashQueue
extends FixHashQueue {
    private MultiReadOneWrite controler = new MultiReadOneWrite();

    public SynchronizedFixHashQueue(int newMaxQueueSize, String queueID) {
        super(newMaxQueueSize, queueID);
    }

    public void remove(Object key) {
        this.controler.enterWrite();
        super.remove(key);
        this.controler.leaveWrite();
    }

    public void insert(Object key, Object value) {
        this.controler.enterWrite();
        super.insert(key, value);
        this.controler.leaveWrite();
    }

    public void addBack(Object key, Object value) {
        this.controler.enterWrite();
        super.addBackNoNotify(key, value);
        this.controler.leaveWrite();
        this.fireQueueAddElementEventListener(new QueueAddElementEvent(this, this.queueID, value));
    }

    public Object getFront() {
        this.controler.enterRead();
        Object obj = super.getFront();
        this.controler.leaveRead();
        return obj;
    }

    public Object getBack() {
        this.controler.enterRead();
        Object obj = super.getBack();
        this.controler.leaveRead();
        return obj;
    }

    public boolean isEmpty() {
        this.controler.enterRead();
        boolean bEmpty = super.isEmpty();
        this.controler.leaveRead();
        return bEmpty;
    }

    public void popFront() {
        this.controler.enterWrite();
        super.popFront();
        this.controler.leaveWrite();
    }

    public Object at(int index) {
        this.controler.enterRead();
        Object obj = super.at(index);
        this.controler.leaveRead();
        return obj;
    }

    public Object at(Object key) {
        this.controler.enterRead();
        Object obj = super.at(key);
        this.controler.leaveRead();
        return obj;
    }

    public int getSize() {
        this.controler.enterRead();
        int size = super.getSize();
        this.controler.leaveRead();
        return size;
    }
}

