/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.util;

import cn.org.gddsn.io.LittleEndianInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class EdasSteim2 {
    static Logger logger;
    public static final int MASK2 = 3;
    public static final int MASK4 = 15;
    public static final int MASK5 = 31;
    public static final int MASK6 = 63;
    public static final int MASK8 = 255;
    public static final int MASK10 = 1023;
    public static final int MASK15 = Short.MAX_VALUE;
    public static final int MASK30 = 0x3FFFFFFF;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.util.EdasSteim2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    private EdasSteim2() {
    }

    public static void decodeSteim2(int[] steim2_data_ptr, int bytes_block, int[] seismic_data) {
        int[] compression_flag = new int[16];
        int last_value = 0;
        int[] temp_data = new int[7];
        int nsample = 0;
        int[] seismic_data_ptr = seismic_data;
        int frame_num = bytes_block / 64;
        if (bytes_block % 64 != 0) {
            ++frame_num;
        }
        int p = 0;
        int q = 0;
        int i = 0;
        while (i < frame_num) {
            if (nsample == seismic_data.length) break;
            int temp_wj = steim2_data_ptr[p++];
            int j = 15;
            while (j >= 0) {
                compression_flag[j] = temp_wj & 3;
                temp_wj >>>= 2;
                --j;
            }
            j = 1;
            while (j < 16) {
                block41: {
                    block0 : switch (compression_flag[j]) {
                        case 0: {
                            if (i > 0 || q == seismic_data.length) break;
                            last_value = steim2_data_ptr[p++];
                            seismic_data_ptr[q++] = last_value;
                            ++nsample;
                            break;
                        }
                        case 1: {
                            temp_wj = steim2_data_ptr[p++];
                            int k = 3;
                            while (k >= 0) {
                                temp_data[k] = temp_wj & 0xFF;
                                if (temp_data[k] > 127) {
                                    int n = k;
                                    temp_data[n] = temp_data[n] | 0xFFFFFF00;
                                }
                                temp_wj >>>= 8;
                                --k;
                            }
                            k = 0;
                            while (k < 4) {
                                if (q == seismic_data.length) break block0;
                                seismic_data_ptr[q++] = last_value += temp_data[k];
                                ++nsample;
                                ++k;
                            }
                            break;
                        }
                        case 2: {
                            int k;
                            temp_wj = steim2_data_ptr[p++];
                            int dnib = temp_wj >>> 30 & 3;
                            switch (dnib) {
                                case 1: {
                                    temp_data[0] = temp_wj & 0x3FFFFFFF;
                                    if (temp_data[0] > 0x1FFFFFFF) {
                                        temp_data[0] = temp_data[0] | 0xC0000000;
                                    }
                                    if (q == seismic_data.length) break block0;
                                    seismic_data_ptr[q++] = last_value += temp_data[0];
                                    ++nsample;
                                    break;
                                }
                                case 2: {
                                    k = 1;
                                    while (k >= 0) {
                                        temp_data[k] = temp_wj & Short.MAX_VALUE;
                                        if (temp_data[k] > 16383) {
                                            int n = k;
                                            temp_data[n] = temp_data[n] | Short.MIN_VALUE;
                                        }
                                        temp_wj >>>= 15;
                                        --k;
                                    }
                                    k = 0;
                                    while (k < 2) {
                                        if (q == seismic_data.length) break block0;
                                        seismic_data_ptr[q++] = last_value += temp_data[k];
                                        ++nsample;
                                        ++k;
                                    }
                                    break block0;
                                }
                                case 3: {
                                    k = 2;
                                    while (k >= 0) {
                                        temp_data[k] = temp_wj & 0x3FF;
                                        if (temp_data[k] > 511) {
                                            int n = k;
                                            temp_data[n] = temp_data[n] | 0xFFFFFC00;
                                        }
                                        temp_wj >>>= 10;
                                        --k;
                                    }
                                    k = 0;
                                    while (k < 3) {
                                        if (q == seismic_data.length) break block0;
                                        seismic_data_ptr[q++] = last_value += temp_data[k];
                                        ++nsample;
                                        ++k;
                                    }
                                    break block6;
                                }
                            }
                            break;
                        }
                        case 3: {
                            int k;
                            temp_wj = steim2_data_ptr[p++];
                            int dnib = temp_wj >>> 30 & 3;
                            switch (dnib) {
                                case 0: {
                                    k = 4;
                                    while (k >= 0) {
                                        temp_data[k] = temp_wj & 0x3F;
                                        if (temp_data[k] > 31) {
                                            int n = k;
                                            temp_data[n] = temp_data[n] | 0xFFFFFFC0;
                                        }
                                        temp_wj >>>= 6;
                                        --k;
                                    }
                                    k = 0;
                                    while (k < 5) {
                                        if (q != seismic_data.length) {
                                            seismic_data_ptr[q++] = last_value += temp_data[k];
                                            ++nsample;
                                            ++k;
                                            continue;
                                        }
                                        break block41;
                                    }
                                    break block41;
                                }
                                case 1: {
                                    k = 5;
                                    while (k >= 0) {
                                        temp_data[k] = temp_wj & 0x1F;
                                        if (temp_data[k] > 15) {
                                            int n = k;
                                            temp_data[n] = temp_data[n] | 0xFFFFFFE0;
                                        }
                                        temp_wj >>>= 5;
                                        --k;
                                    }
                                    k = 0;
                                    while (k < 6) {
                                        if (q != seismic_data.length) {
                                            seismic_data_ptr[q++] = last_value += temp_data[k];
                                            ++nsample;
                                            ++k;
                                            continue;
                                        }
                                        break block41;
                                    }
                                    break block41;
                                }
                                case 2: {
                                    k = 6;
                                    while (k >= 0) {
                                        temp_data[k] = temp_wj & 0xF;
                                        if (temp_data[k] > 7) {
                                            int n = k;
                                            temp_data[n] = temp_data[n] | 0xFFFFFFF0;
                                        }
                                        temp_wj >>>= 4;
                                        --k;
                                    }
                                    k = 0;
                                    while (k < 7) {
                                        if (q == seismic_data.length) break block0;
                                        seismic_data_ptr[q++] = last_value += temp_data[k];
                                        ++nsample;
                                        ++k;
                                    }
                                    break block0;
                                }
                            }
                        }
                    }
                }
                if (compression_flag[j] == 0 && i > 0) break;
                ++j;
            }
            ++i;
        }
    }

    public static void decodeSteim2(byte[] bdata, int offset, int length, int[] seismic_data) {
        int[] idata = new int[length / 4];
        try {
            LittleEndianInputStream dis = new LittleEndianInputStream(new ByteArrayInputStream(bdata, offset, length));
            int i = 0;
            while (i < idata.length) {
                idata[i] = dis.readInt();
                ++i;
            }
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        EdasSteim2.decodeSteim2(idata, length, seismic_data);
    }

    public static void main(String[] args) {
        new EdasSteim2();
    }
}

