/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.util;

import java.io.FileInputStream;
import java.util.zip.Checksum;

public class CRC64
implements Checksum {
    private static final long POLY64 = -2882303761517117440L;
    private static final long[] crcTable = new long[256];
    private long crc;

    static {
        int i = 0;
        while (i < 256) {
            long part = i;
            int j = 0;
            while (j < 8) {
                part = (part & 1L) != 0L ? part >>> 1 ^ 0xD800000000000000L : part >>> 1;
                ++j;
            }
            CRC64.crcTable[i] = part;
            ++i;
        }
    }

    public void update(int b) {
        long low = this.crc >>> 8;
        long high = crcTable[(int)((this.crc ^ (long)b) & 0xFFL)];
        this.crc = low ^ high;
    }

    public void update(byte[] b, int offset, int length) {
        int i = offset;
        while (i < length) {
            this.update(b[i]);
            ++i;
        }
    }

    public void update(String s) {
        int size = s.length();
        int i = 0;
        while (i < size) {
            this.update(s.charAt(i));
            ++i;
        }
    }

    public long getValue() {
        return this.crc;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Long.toHexString(this.crc >>> 4));
        buffer.append(Long.toHexString(this.crc & 0xFL));
        int i = 16 - buffer.length();
        while (i > 0) {
            buffer.insert(0, '0');
            --i;
        }
        return buffer.toString().toUpperCase();
    }

    public void reset() {
        this.crc = 0L;
    }

    public static void main(String[] args) throws Exception {
        byte[] data = new byte[84];
        FileInputStream fis = new FileInputStream("/tmp/155.dat");
        fis.read(data, 0, data.length - 8);
        fis.close();
        CRC64 crc64 = new CRC64();
        crc64.update(data, 0, data.length);
        System.out.println("---------------");
        crc64.reset();
        int i = 0;
        while (i < data.length) {
            crc64.update(data[i]);
            System.out.println(Long.toHexString(crc64.getValue()));
            ++i;
        }
        crc64.reset();
        crc64.update("ILIKEMATH");
        System.out.println(Long.toHexString(crc64.getValue()));
    }
}

