/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import org.apache.log4j.Logger;

public class Alarm
implements LineListener {
    static Logger logger;
    Clip clip = null;
    boolean looping = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.util.Alarm");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public Alarm(File audioFile, boolean looping) {
        this.looping = looping;
        try {
            this.create(AudioSystem.getAudioInputStream(audioFile));
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public Alarm(InputStream in, boolean looping) {
        this.looping = looping;
        try {
            this.create(AudioSystem.getAudioInputStream(in));
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public Alarm(URL url, boolean looping) {
        this.looping = looping;
        try {
            this.create(AudioSystem.getAudioInputStream(url));
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    private void create(AudioInputStream ais) {
        try {
            Class<?> clazz;
            AudioFormat format = ais.getFormat();
            if (format.getEncoding() == AudioFormat.Encoding.ULAW || format.getEncoding() == AudioFormat.Encoding.ALAW) {
                AudioFormat tmp = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
                ais = AudioSystem.getAudioInputStream(tmp, ais);
                format = tmp;
            }
            if ((clazz = class$1) == null) {
                try {
                    clazz = class$1 = Class.forName("javax.sound.sampled.Clip");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DataLine.Info info = new DataLine.Info(clazz, format, (int)(ais.getFrameLength() * (long)format.getFrameSize()));
            this.clip = (Clip)AudioSystem.getLine(info);
            Thread.sleep(1000L);
            this.clip.open(ais);
            this.clip.addLineListener(this);
        }
        catch (IllegalArgumentException iaEx) {
            throw iaEx;
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public Alarm(File audioFile) {
        this(audioFile, true);
    }

    public synchronized void startAlarm() {
        if (this.clip.isActive()) {
            return;
        }
        try {
            if (this.looping) {
                this.clip.loop(-1);
            } else {
                this.clip.start();
            }
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public void update(LineEvent event) {
        if (event.getType() != LineEvent.Type.STOP) {
            // empty if block
        }
    }

    public synchronized void stopAlarm() {
        if (!this.clip.isActive()) {
            return;
        }
        try {
            this.clip.stop();
            this.clip.close();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }
}

