/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.sms;

import cn.org.gddsn.sms.JassonGW;
import cn.org.gddsn.sms.SendSMS;
import cn.org.gddsn.sms.SendSMSByGW;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class SMSClient {
    static Logger logger = Logger.getLogger(SMSClient.class);
    private static String SMS_CONF = "cfg/sms.xml";
    private String gateway = "218.204.249.80";
    private int port = 80;
    private String eid = "dzjczx";
    private String uid = "gz0140837";
    private String pwd = "dzjgddsnorg";
    private Group[] groups = null;
    private String[] messages;
    private String phonesSMS = "13600050073;";
    private String messageSMS = "Hello, test";
    private SendSMS sender;
    private String msgTitle = "\u81ea\u52a8\u5b9a\u4f4d\u7ed3\u679c\uff1a";

    public SendSMS getSender() {
        return this.sender;
    }

    public void setSender(SendSMS sender) {
        this.sender = sender;
    }

    public void setSender(SendSMSByGW sender) {
        this.sender = sender;
        sender.setGateway(this.gateway);
        sender.setPort(this.port);
        sender.setEid(this.eid);
        sender.setUid(this.uid);
        sender.setPassword(this.pwd);
    }

    public SMSClient() {
        this.init();
    }

    public int send() {
        StringTokenizer st = new StringTokenizer(this.phonesSMS, ";");
        String[] phones = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            phones[i++] = st.nextToken();
        }
        return this.sender.send(phones, String.valueOf(this.msgTitle) + this.messageSMS);
    }

    public static void main(String[] args) throws Exception {
        SMSClient c = new SMSClient();
        c.setSender(new JassonGW());
        c.setMsgTitle("\u56fd\u5bb6\u5907\u4efd\u4e2d\u5fc3\u81ea\u52a8\uff1a");
        c.setMessageSMS("\u6d4b\u8bd5\uff0c\u4f60\u597d\uff0c\u522b\u7406\u6211\uff0c\u4e00\u8f88\u5b50\u522b\u78b0\u7535\u8111,\u6536\u5230\u8bf7\u56de\u6211\u3002");
        c.send();
    }

    private void init() {
        try {
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build(SMS_CONF);
            Element root = doc.getRootElement();
            Namespace tns = Namespace.getNamespace("tns", "http://gddsn.org.cn/sms");
            XPath xpath = XPath.newInstance("//tns:connection");
            xpath.addNamespace(tns);
            List list = xpath.selectNodes(root);
            if (list.size() == 0) {
                logger.warn("Warning: " + SMS_CONF + " should include connection tag!");
            }
            Element connection = (Element)list.get(0);
            this.gateway = connection.getAttributeValue("gateway");
            try {
                this.port = Integer.parseInt(connection.getAttributeValue("port"));
            }
            catch (NumberFormatException nfEx) {
                this.port = 80;
            }
            this.eid = connection.getAttributeValue("eid");
            this.uid = connection.getAttributeValue("uid");
            this.pwd = connection.getAttributeValue("pwd");
            xpath = XPath.newInstance("//tns:message");
            xpath.addNamespace(tns);
            list = xpath.selectNodes(root);
            list = xpath.selectNodes(root);
            int size = list.size();
            this.messages = new String[size];
            int i = 0;
            while (i < this.messages.length) {
                this.messages[i] = ((Element)list.get(i)).getAttributeValue("content");
                ++i;
            }
            xpath = XPath.newInstance("//tns:group");
            xpath.addNamespace(tns);
            list = xpath.selectNodes(root);
            size = list.size();
            this.groups = new Group[size];
            StringBuffer ph = new StringBuffer();
            int i2 = 0;
            while (i2 < size) {
                Element group = (Element)list.get(i2);
                this.groups[i2] = new Group();
                this.groups[i2].name = group.getAttributeValue("name");
                List personList = group.getChildren("person", tns);
                int size_person = personList.size();
                this.groups[i2].persons = new Person[size_person];
                int j = 0;
                while (j < size_person) {
                    Element person = (Element)personList.get(j);
                    this.groups[i2].persons[j] = new Person();
                    this.groups[i2].persons[j].phone = person.getAttributeValue("phone");
                    ph.append(String.valueOf(this.groups[i2].persons[j].phone) + ";");
                    this.groups[i2].persons[j].name = person.getAttributeValue("name");
                    ++j;
                }
                ++i2;
            }
            this.setPhonesSMS(ph.substring(0));
            logger.info("phones : " + this.phonesSMS);
        }
        catch (JDOMException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    public Group[] getGroups() {
        return this.groups;
    }

    public String getEid() {
        return this.eid;
    }

    public String getGateway() {
        return this.gateway;
    }

    public int getPort() {
        return this.port;
    }

    public String getPwd() {
        return this.pwd;
    }

    public String getUid() {
        return this.uid;
    }

    public String getMessageSMS() {
        return this.messageSMS;
    }

    public String getPhonesSMS() {
        return this.phonesSMS;
    }

    public String[] getMessages() {
        return this.messages;
    }

    public void setEid(String eid) {
        this.eid = eid;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMessageSMS(String messageSMS) {
        this.messageSMS = messageSMS;
    }

    public void setPhonesSMS(String phonesSMS) {
        this.phonesSMS = phonesSMS;
    }

    public void setMessages(String[] messages) {
        this.messages = messages;
    }

    public String getMsgTitle() {
        return this.msgTitle;
    }

    public void setMsgTitle(String msgTitle) {
        this.msgTitle = msgTitle;
    }

    public static class Group {
        public String name;
        public Person[] persons;
    }

    public static class Person {
        public String phone;
        public String name;

        public String toString() {
            return this.name;
        }
    }
}

