/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.seismograph;

public class ChinaIntensity {
    private static double[] ACC = new double[]{22.0, 45.0, 90.0, 178.0, 354.0, 708.0, 1415.0};
    private static double[] VEL = new double[]{2.0, 5.0, 10.0, 19.0, 36.0, 72.0, 142.0};

    private ChinaIntensity() {
    }

    public static int getIntensity(double acc, double vel) {
        int iacc = ChinaIntensity.getIntensityByAcc(acc);
        int ivel = ChinaIntensity.getIntensityByVel(vel);
        return Math.max(iacc, ivel);
    }

    private static int getIntensityByAcc(double acc) {
        if (acc > ACC[6]) {
            return 11;
        }
        if (acc > ACC[5]) {
            return 10;
        }
        if (acc > ACC[4]) {
            return 9;
        }
        if (acc > ACC[3]) {
            return 8;
        }
        if (acc > ACC[2]) {
            return 7;
        }
        if (acc > ACC[1]) {
            return 6;
        }
        if (acc > ACC[0]) {
            return 5;
        }
        return 4;
    }

    private static int getIntensityByVel(double vel) {
        if (vel > VEL[6]) {
            return 11;
        }
        if (vel > VEL[5]) {
            return 10;
        }
        if (vel > VEL[4]) {
            return 9;
        }
        if (vel > VEL[3]) {
            return 8;
        }
        if (vel > VEL[2]) {
            return 7;
        }
        if (vel > VEL[1]) {
            return 6;
        }
        if (vel > VEL[0]) {
            return 5;
        }
        return 4;
    }

    public static void main(String[] args) {
        System.out.println(ChinaIntensity.getIntensity(1.0, 1.0));
        System.out.println(ChinaIntensity.getIntensity(31.0, 3.0));
        System.out.println(ChinaIntensity.getIntensity(63.0, 6.0));
        System.out.println(ChinaIntensity.getIntensity(125.0, 13.0));
        System.out.println(ChinaIntensity.getIntensity(250.0, 25.0));
        System.out.println(ChinaIntensity.getIntensity(500.0, 50.0));
        System.out.println(ChinaIntensity.getIntensity(1000.0, 100.0));
        System.out.println(ChinaIntensity.getIntensity(2000.0, 200.0));
    }
}

