/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter.design;

public class FIRFilter {
    public static final int LP = 1;
    public static final int HP = 2;
    public static final int BP = 3;
    public static final int RECTANGULAR = 4;
    public static final int HANNING = 5;
    public static final int HAMMING = 6;
    public static final int BLACKMAN = 7;
    private int order = 1;
    private int windowType = 4;
    private int filterType = 1;
    private int freqPoints;
    private double f1 = 0.0;
    private double f2 = 10.0;
    private double fN = 4000.0;
    private double[] a;

    public void setWindowType(String wt) {
        if (wt.equals("Rectangular")) {
            this.windowType = 4;
        }
        if (wt.equals("Hanning")) {
            this.windowType = 5;
        }
        if (wt.equals("Hamming")) {
            this.windowType = 6;
        }
        if (wt.equals("Blackman")) {
            this.windowType = 7;
        }
    }

    public void setWindowType(int wt) {
        this.windowType = wt;
    }

    public void setFilterType(String ft) {
        if (ft.equals("LP")) {
            this.filterType = 1;
        }
        if (ft.equals("BP")) {
            this.filterType = 3;
        }
        if (ft.equals("HP")) {
            this.filterType = 2;
        }
    }

    public void setFilterType(int ft) {
        this.filterType = ft;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public void setRate(double rate) {
        this.fN = 0.5 * rate;
    }

    public void setFreq1(double f1) {
        this.f1 = f1;
    }

    public void setFreq2(double f2) {
        this.f2 = f2;
    }

    public void setFreqPoints(int fp) {
        this.freqPoints = fp;
    }

    public double getCoeff(int i) {
        return this.a[i];
    }

    public double atten() {
        switch (this.windowType) {
            case 4: {
                return 21.0;
            }
            case 5: {
                return 44.0;
            }
            case 6: {
                return 53.0;
            }
            case 7: {
                return 74.0;
            }
        }
        return 999.0;
    }

    public double trBand() {
        switch (this.windowType) {
            case 4: {
                return (double)1.84f * this.fN / (double)this.order;
            }
            case 5: {
                return (double)6.22f * this.fN / (double)this.order;
            }
            case 6: {
                return (double)6.64f * this.fN / (double)this.order;
            }
            case 7: {
                return (double)11.13f * this.fN / (double)this.order;
            }
        }
        return 999.0;
    }

    public void design() {
        int m = this.order / 2;
        double[] win = new double[m + 1];
        switch (this.windowType) {
            case 4: {
                int n = 1;
                while (n <= m) {
                    win[n] = 1.0;
                    ++n;
                }
                break;
            }
            case 5: {
                double r = Math.PI / (double)(m + 1);
                int n = 1;
                while (n <= m) {
                    win[n] = 0.5 + 0.5 * Math.cos((double)n * r);
                    ++n;
                }
                break;
            }
            case 6: {
                double r = Math.PI / (double)m;
                int n = 1;
                while (n <= m) {
                    win[n] = 0.54 + 0.46 * Math.cos((double)n * r);
                    ++n;
                }
                break;
            }
            case 7: {
                double r = Math.PI / (double)m;
                int n = 1;
                while (n <= m) {
                    win[n] = 0.42 + 0.5 * Math.cos((double)n * r) + (double)0.08f * Math.cos((double)(2 * n) * r);
                    ++n;
                }
                break;
            }
            default: {
                int n = 1;
                while (n <= m) {
                    win[n] = 1.0;
                    ++n;
                }
                break block0;
            }
        }
        double w0 = 0.0;
        double w1 = 0.0;
        switch (this.filterType) {
            case 1: {
                w0 = 0.0;
                w1 = Math.PI * (this.f2 + 0.5 * this.trBand()) / this.fN;
                break;
            }
            case 2: {
                w0 = Math.PI;
                w1 = Math.PI * (1.0 - (this.f1 - 0.5 * this.trBand()) / this.fN);
                break;
            }
            case 3: {
                w0 = 1.5707963267948966 * (this.f1 + this.f2) / this.fN;
                w1 = 1.5707963267948966 * (this.f2 - this.f1 + this.trBand()) / this.fN;
            }
        }
        this.a = new double[this.order + 1];
        this.a[0] = w1 / Math.PI;
        int n = 1;
        while (n <= m) {
            this.a[n] = Math.sin((double)n * w1) * Math.cos((double)n * w0) * win[n] / ((double)n * Math.PI);
            ++n;
        }
        n = m + 1;
        while (n <= this.order) {
            this.a[n] = this.a[n - m];
            ++n;
        }
        n = 0;
        while (n <= m - 1) {
            this.a[n] = this.a[this.order - n];
            ++n;
        }
        this.a[m] = w1 / Math.PI;
    }

    public double[] filterGain() {
        double[] g = new double[this.freqPoints + 1];
        double gMax = -100.0;
        double sc = 10.0 / Math.log(10.0);
        double t = Math.PI / (double)this.freqPoints;
        int i = 0;
        while (i <= this.freqPoints) {
            double theta = (double)i * t;
            double sac = 0.0;
            double sas = 0.0;
            int k = 0;
            while (k <= this.order) {
                double c = Math.cos((double)k * theta);
                double s = Math.sin((double)k * theta);
                sac += c * this.a[k];
                sas += s * this.a[k];
                ++k;
            }
            g[i] = sc * Math.log(sac * sac + sas * sas);
            gMax = Math.max(gMax, g[i]);
            ++i;
        }
        i = 0;
        while (i <= this.freqPoints) {
            int n = i++;
            g[n] = g[n] - gMax;
        }
        double normFactor = Math.pow(10.0, -0.05 * gMax);
        int i2 = 0;
        while (i2 <= this.order) {
            int n = i2++;
            this.a[n] = this.a[n] * normFactor;
        }
        return g;
    }
}

