/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.Complex;
import cn.org.gddsn.signal.filter.IIRFilterType;

class NotchFilter
extends IIRFilterType {
    double wc;
    double a;
    double b;
    double bw;

    NotchFilter() {
    }

    int select() {
        this.auxLabels[0] = "Notch Frequency";
        this.auxBars[0] = 500;
        this.auxLabels[1] = "Bandwidth";
        this.auxBars[1] = 900;
        return 2;
    }

    void setup() {
        this.wc = (double)this.auxBars[0] * Math.PI / 1000.0;
        this.bw = (double)this.auxBars[1] * Math.PI / 2000.0;
        this.a = (1.0 - Math.tan(this.bw / 2.0)) / (1.0 + Math.tan(this.bw / 2.0));
        this.b = Math.cos(this.wc);
    }

    void getPole(int i, Complex c1) {
        c1.set(-4.0 * this.a + (this.b + this.a * this.b) * (this.b + this.a * this.b));
        c1.sqrt();
        if (i == 1) {
            c1.mult(-1.0);
        }
        c1.add(this.b + this.a * this.b);
        c1.mult(0.5);
    }

    int getPoleCount() {
        return 2;
    }

    void getInfo(String[] x) {
        x[0] = "Notch (IIR)";
        x[1] = "Notch Frequency: " + this.getOmegaText(this.wc);
        x[2] = "Bandwidth: " + this.getOmegaText(this.bw);
    }

    int getZeroCount() {
        return 2;
    }

    void getZero(int i, Complex c1) {
        c1.set(this.b * this.b - 1.0);
        c1.sqrt();
        if (i == 1) {
            c1.mult(-1.0);
        }
        c1.add(this.b);
    }
}

