/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.Complex;
import cn.org.gddsn.signal.filter.DirectFilter;
import cn.org.gddsn.signal.filter.FIRFilterType;
import cn.org.gddsn.signal.filter.Filter;

class InverseCombFilter
extends FIRFilterType {
    int n;
    double mult;
    double peak;

    InverseCombFilter() {
    }

    int select() {
        this.auxLabels[0] = "2nd Zero";
        this.auxBars[0] = 60;
        this.auxLabels[1] = "Sharpness";
        this.auxBars[1] = 1000;
        return 2;
    }

    void setup() {
        this.n = 1990 / this.auxBars[0];
        this.mult = (double)this.auxBars[1] / 1000.0;
        this.peak = 1.0 + this.mult;
    }

    void getZero(int i, Complex c1) {
        c1.setMagPhase(Math.pow(this.mult, 1.0 / (double)this.n), Math.PI * 2 * (double)i / (double)this.n);
    }

    int getZeroCount() {
        return this.n;
    }

    Filter genFilter() {
        DirectFilter f = new DirectFilter();
        f.aList = new double[]{1.0 / this.peak, -this.mult / this.peak};
        int[] nArray = new int[2];
        nArray[1] = this.n;
        f.nList = nArray;
        this.setResponse(f);
        return f;
    }

    void getInfo(String[] x) {
        x[0] = "Inverse Comb (FIR)";
        x[1] = "Zeros every " + this.getOmegaText(Math.PI * 2 / (double)this.n);
    }
}

