/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.ChebyFilterType;
import cn.org.gddsn.signal.filter.Complex;

abstract class InvChebyFilterType
extends ChebyFilterType {
    double scale;

    InvChebyFilterType() {
    }

    void selectCheby(int s) {
        this.auxLabels[s] = "Stopband Attenuation";
        this.auxBars[s] = 600;
    }

    void setupCheby(int a) {
        this.epsilon = Math.exp((double)(-this.auxBars[a]) / 120.0);
        this.scale = this.cosh(this.acosh(1.0 / this.epsilon) / (double)this.n);
    }

    void getSPole(int i, Complex c1, double wc) {
        wc = Math.PI - wc;
        super.getSPole(i, c1, wc);
        c1.recip();
        c1.mult(this.scale);
    }

    void getChebyZero(int i, Complex c1, double wc) {
        double bk = 1.0 / Math.cos((double)(2 * i + 1) * Math.PI / (double)(2 * this.n)) * this.scale;
        double a = Math.sin(0.7853981633974483 - wc / 2.0) / Math.sin(0.7853981633974483 + wc / 2.0);
        c1.set(1.0 + a, bk * (1.0 - a));
        Complex c2 = new Complex(1.0 + a, bk * (a - 1.0));
        c1.div(c2);
    }

    void getInfoCheby(String[] x) {
        x[2] = "Stopband attenuation: " + -10.0 * Math.log(1.0 + 1.0 / (this.epsilon * this.epsilon)) / 2.302585092994046 + " dB";
    }

    int getPoleCount() {
        return this.n;
    }

    int getZeroCount() {
        return this.n;
    }

    double cosh(double x) {
        return 0.5 * (Math.exp(x) + Math.exp(-x));
    }

    double sinh(double x) {
        return 0.5 * (Math.exp(x) - Math.exp(-x));
    }

    double acosh(double x) {
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }
}

