/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.AllPassFilter;
import cn.org.gddsn.signal.filter.ButterBandPass;
import cn.org.gddsn.signal.filter.ButterBandStop;
import cn.org.gddsn.signal.filter.ButterHighPass;
import cn.org.gddsn.signal.filter.ButterLowPass;
import cn.org.gddsn.signal.filter.ChebyBandPass;
import cn.org.gddsn.signal.filter.ChebyBandStop;
import cn.org.gddsn.signal.filter.ChebyHighPass;
import cn.org.gddsn.signal.filter.ChebyLowPass;
import cn.org.gddsn.signal.filter.CombFilter;
import cn.org.gddsn.signal.filter.Complex;
import cn.org.gddsn.signal.filter.CustomFIRFilter;
import cn.org.gddsn.signal.filter.CustomIIRFilter;
import cn.org.gddsn.signal.filter.DFilter;
import cn.org.gddsn.signal.filter.DFilterCanvas;
import cn.org.gddsn.signal.filter.DFilterLayout;
import cn.org.gddsn.signal.filter.DelayFilter;
import cn.org.gddsn.signal.filter.DirectFilter;
import cn.org.gddsn.signal.filter.EllipticBandPass;
import cn.org.gddsn.signal.filter.EllipticBandStop;
import cn.org.gddsn.signal.filter.EllipticHighPass;
import cn.org.gddsn.signal.filter.EllipticLowPass;
import cn.org.gddsn.signal.filter.FFT;
import cn.org.gddsn.signal.filter.Filter;
import cn.org.gddsn.signal.filter.FilterType;
import cn.org.gddsn.signal.filter.GaussianFilter;
import cn.org.gddsn.signal.filter.InvChebyBandPass;
import cn.org.gddsn.signal.filter.InvChebyBandStop;
import cn.org.gddsn.signal.filter.InvChebyHighPass;
import cn.org.gddsn.signal.filter.InvChebyLowPass;
import cn.org.gddsn.signal.filter.InverseCombFilter;
import cn.org.gddsn.signal.filter.MovingAverageFilter;
import cn.org.gddsn.signal.filter.NoFilter;
import cn.org.gddsn.signal.filter.NotchFilter;
import cn.org.gddsn.signal.filter.PluckedStringFilter;
import cn.org.gddsn.signal.filter.RandomFilter;
import cn.org.gddsn.signal.filter.ResonatorFilter;
import cn.org.gddsn.signal.filter.ResonatorZeroFilter;
import cn.org.gddsn.signal.filter.SincBandPassFilter;
import cn.org.gddsn.signal.filter.SincBandStopFilter;
import cn.org.gddsn.signal.filter.SincHighPassFilter;
import cn.org.gddsn.signal.filter.SincLowPassFilter;
import cn.org.gddsn.signal.filter.TriangleFilter;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

class DFilterFrame
extends Frame
implements ComponentListener,
ActionListener,
AdjustmentListener,
MouseMotionListener,
MouseListener,
ItemListener {
    Dimension winSize;
    Image dbimage;
    View respView;
    View impulseView;
    View phaseView;
    View stepView;
    View spectrumView;
    View waveformView;
    View poleInfoView;
    View polesView;
    Random random;
    int maxSampleCount = 70;
    int sampleCountR;
    int sampleCountTh;
    int modeCountR;
    int modeCountTh;
    int selectedPole;
    int selectedZero;
    Complex[] customPoles;
    Complex[] customZeros;
    int maxDispRModes = 5;
    int maxDispThModes = 5;
    int lastPoleCount = 2;
    int lastZeroCount = 2;
    public static final double epsilon = 1.0E-5;
    public static final double epsilon2 = 0.003;
    public static final double log10 = 2.302585092994046;
    public static int WINDOW_KAISER = 4;
    Checkbox soundCheck;
    Checkbox displayCheck;
    Checkbox shiftSpectrumCheck;
    CheckboxMenuItem freqCheckItem;
    CheckboxMenuItem phaseCheckItem;
    CheckboxMenuItem spectrumCheckItem;
    CheckboxMenuItem impulseCheckItem;
    CheckboxMenuItem stepCheckItem;
    CheckboxMenuItem waveformCheckItem;
    CheckboxMenuItem logFreqCheckItem;
    CheckboxMenuItem logAmpCheckItem;
    CheckboxMenuItem allWaveformCheckItem;
    CheckboxMenuItem ferrisCheckItem;
    MenuItem exitItem;
    Choice filterChooser;
    int selection;
    final int SELECT_RESPONSE = 1;
    final int SELECT_SPECTRUM = 2;
    final int SELECT_POLES = 3;
    int filterSelection;
    Choice inputChooser;
    Choice windowChooser;
    Choice rateChooser;
    Scrollbar[] auxBars;
    Label[] auxLabels;
    Label inputLabel;
    Scrollbar inputBar;
    Label shiftFreqLabel;
    Scrollbar shiftFreqBar;
    Label kaiserLabel;
    Scrollbar kaiserBar;
    boolean editingFunc;
    boolean dragStop;
    double inputW;
    static final double pi = Math.PI;
    double step;
    double waveGain = 1.52587890625E-5;
    double outputGain = 1.0;
    int sampleRate;
    int[] xpoints = new int[4];
    int[] ypoints = new int[4];
    int dragX;
    int dragY;
    int dragStartX;
    int dragStartY;
    int mouseX;
    int mouseY;
    boolean dragSet;
    boolean dragClear;
    boolean dragging;
    boolean unstable;
    MemoryImageSource imageSource;
    Image memimage;
    int[] pixels;
    double t;
    int pause;
    PlayThread playThread;
    Filter curFilter;
    FilterType filterType;
    double[] spectrumBuf;
    FFT spectrumFFT;
    Waveform wformInfo;
    PhaseColor[] phaseColors;
    static final int phaseColorCount = 400;
    boolean filterChanged;
    DFilterCanvas cv;
    DFilter applet;
    NumberFormat showFormat;
    boolean java2 = false;
    String[] mp3List;
    String mp3Error;
    long lastTime;
    double minlog;
    double logrange;

    public String getAppletInfo() {
        return "DFilter Series by Paul Falstad";
    }

    int getrand(int x) {
        int q = this.random.nextInt();
        if (q < 0) {
            q = -q;
        }
        return q % x;
    }

    DFilterFrame(DFilter a) {
        super("Digital Filters Applet v1.2");
        this.applet = a;
    }

    public void init() {
        this.mp3List = new String[20];
        try {
            String param = this.applet.getParameter("PAUSE");
            if (param != null) {
                this.pause = Integer.parseInt(param);
            }
            int i = 0;
            while (i < this.mp3List.length) {
                param = this.applet.getParameter("mp3File" + (i + 1));
                if (param != null) {
                    this.mp3List[i] = param;
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception param) {
            // empty catch block
        }
        String jv = System.getProperty("java.class.version");
        double jvf = new Double(jv);
        if (jvf >= 48.0) {
            this.java2 = true;
        }
        int pc8 = 50;
        this.phaseColors = new PhaseColor[400];
        int i = 0;
        while (i != 8) {
            int j = 0;
            while (j != pc8) {
                double ang = Math.atan((double)j / (double)pc8);
                this.phaseColors[i * pc8 + j] = this.genPhaseColor(i, ang);
                ++j;
            }
            ++i;
        }
        this.customPoles = new Complex[20];
        this.customZeros = new Complex[20];
        i = 0;
        while (i != this.customPoles.length) {
            this.customPoles[i] = new Complex();
            ++i;
        }
        i = 0;
        while (i != this.customZeros.length) {
            this.customZeros[i] = new Complex();
            ++i;
        }
        this.setLayout(new DFilterLayout());
        this.cv = new DFilterCanvas(this);
        this.cv.addComponentListener(this);
        this.cv.addMouseMotionListener(this);
        this.cv.addMouseListener(this);
        this.add(this.cv);
        MenuBar mb = new MenuBar();
        Menu m = new Menu("File");
        mb.add(m);
        this.exitItem = this.getMenuItem("Exit");
        m.add(this.exitItem);
        m = new Menu("View");
        mb.add(m);
        this.freqCheckItem = this.getCheckItem("Frequency Response", true);
        m.add(this.freqCheckItem);
        this.phaseCheckItem = this.getCheckItem("Phase Response", false);
        m.add(this.phaseCheckItem);
        this.spectrumCheckItem = this.getCheckItem("Spectrum", true);
        m.add(this.spectrumCheckItem);
        this.waveformCheckItem = this.getCheckItem("Waveform", this.java2);
        m.add(this.waveformCheckItem);
        this.impulseCheckItem = this.getCheckItem("Impulse Response", true);
        m.add(this.impulseCheckItem);
        this.stepCheckItem = this.getCheckItem("Step Response", false);
        m.add(this.stepCheckItem);
        m.addSeparator();
        this.logFreqCheckItem = this.getCheckItem("Log Frequency Scale", false);
        m.add(this.logFreqCheckItem);
        this.allWaveformCheckItem = this.getCheckItem("Show Entire Waveform", false);
        m.add(this.allWaveformCheckItem);
        this.ferrisCheckItem = this.getCheckItem("Ferris Plot", false);
        m.add(this.ferrisCheckItem);
        this.logAmpCheckItem = this.getCheckItem("Log Amplitude Scale", true);
        this.setMenuBar(mb);
        this.soundCheck = new Checkbox("Sound On");
        if (this.java2) {
            this.soundCheck.setState(true);
        } else {
            this.soundCheck.disable();
        }
        this.soundCheck.addItemListener(this);
        this.add(this.soundCheck);
        this.displayCheck = new Checkbox("Stop Display");
        this.displayCheck.addItemListener(this);
        this.add(this.displayCheck);
        this.shiftSpectrumCheck = new Checkbox("Shift Spectrum");
        this.shiftSpectrumCheck.addItemListener(this);
        this.add(this.shiftSpectrumCheck);
        this.inputChooser = new Choice();
        this.add(this.inputChooser);
        this.inputChooser.add("Input = Noise");
        this.inputChooser.add("Input = Sine Wave");
        this.inputChooser.add("Input = Sawtooth");
        this.inputChooser.add("Input = Triangle Wave");
        this.inputChooser.add("Input = Square Wave");
        this.inputChooser.add("Input = Periodic Noise");
        this.inputChooser.add("Input = Sweep");
        this.inputChooser.add("Input = Impulses");
        i = 0;
        while (this.mp3List[i] != null) {
            this.inputChooser.add("Input = " + this.mp3List[i]);
            ++i;
        }
        this.inputChooser.addItemListener(this);
        this.filterChooser = new Choice();
        this.add(this.filterChooser);
        this.filterChooser.add("Filter = FIR Low-pass");
        this.filterChooser.add("Filter = FIR High-pass");
        this.filterChooser.add("Filter = FIR Band-pass");
        this.filterChooser.add("Filter = FIR Band-stop");
        this.filterChooser.add("Filter = Custom FIR");
        this.filterChooser.add("Filter = None");
        this.filterChooser.add("Filter = Butterworth Low-pass");
        this.filterChooser.add("Filter = Butterworth High-pass");
        this.filterChooser.add("Filter = Butterworth Band-pass");
        this.filterChooser.add("Filter = Butterworth Band-stop");
        this.filterChooser.add("Filter = Chebyshev Low-pass");
        this.filterChooser.add("Filter = Chebyshev High-pass");
        this.filterChooser.add("Filter = Chebyshev Band-pass");
        this.filterChooser.add("Filter = Chebyshev Band-stop");
        this.filterChooser.add("Filter = Inv Cheby Low-pass");
        this.filterChooser.add("Filter = Inv Cheby High-pass");
        this.filterChooser.add("Filter = Inv Cheby Band-pass");
        this.filterChooser.add("Filter = Inv Cheby Band-stop");
        this.filterChooser.add("Filter = Elliptic Low-pass");
        this.filterChooser.add("Filter = Elliptic High-pass");
        this.filterChooser.add("Filter = Elliptic Band-pass");
        this.filterChooser.add("Filter = Elliptic Band-stop");
        this.filterChooser.add("Filter = Comb (+)");
        this.filterChooser.add("Filter = Comb (-)");
        this.filterChooser.add("Filter = Delay");
        this.filterChooser.add("Filter = Plucked String");
        this.filterChooser.add("Filter = Inverse Comb");
        this.filterChooser.add("Filter = Reson");
        this.filterChooser.add("Filter = Reson w/ Zeros");
        this.filterChooser.add("Filter = Notch");
        this.filterChooser.add("Filter = Moving Average");
        this.filterChooser.add("Filter = Triangle");
        this.filterChooser.add("Filter = Allpass");
        this.filterChooser.add("Filter = Gaussian");
        this.filterChooser.add("Filter = Random");
        this.filterChooser.add("Filter = Custom IIR");
        this.filterChooser.addItemListener(this);
        this.filterSelection = -1;
        this.windowChooser = new Choice();
        this.add(this.windowChooser);
        this.windowChooser.add("Window = Rectangular");
        this.windowChooser.add("Window = Hamming");
        this.windowChooser.add("Window = Hann");
        this.windowChooser.add("Window = Blackman");
        this.windowChooser.add("Window = Kaiser");
        this.windowChooser.add("Window = Bartlett");
        this.windowChooser.add("Window = Welch");
        this.windowChooser.addItemListener(this);
        this.windowChooser.select(1);
        this.rateChooser = new Choice();
        this.add(this.rateChooser);
        this.rateChooser.add("Sampling Rate = 8000");
        this.rateChooser.add("Sampling Rate = 11025");
        this.rateChooser.add("Sampling Rate = 16000");
        this.rateChooser.add("Sampling Rate = 22050");
        this.rateChooser.add("Sampling Rate = 32000");
        this.rateChooser.add("Sampling Rate = 44100");
        this.rateChooser.select(3);
        this.sampleRate = 22050;
        this.rateChooser.addItemListener(this);
        this.auxLabels = new Label[5];
        this.auxBars = new Scrollbar[5];
        i = 0;
        while (i != 5) {
            this.auxLabels[i] = new Label("", 1);
            this.add(this.auxLabels[i]);
            this.auxBars[i] = new Scrollbar(0, 25, 1, 1, 999);
            this.add(this.auxBars[i]);
            this.auxBars[i].addAdjustmentListener(this);
            ++i;
        }
        this.inputLabel = new Label("Input Frequency", 1);
        this.add(this.inputLabel);
        this.inputBar = new Scrollbar(0, 40, 1, 1, 999);
        this.add(this.inputBar);
        this.inputBar.addAdjustmentListener(this);
        this.shiftFreqLabel = new Label("Shift Frequency", 1);
        this.add(this.shiftFreqLabel);
        this.shiftFreqBar = new Scrollbar(0, 10, 1, 0, 1001);
        this.add(this.shiftFreqBar);
        this.shiftFreqBar.addAdjustmentListener(this);
        this.shiftFreqLabel.hide();
        this.shiftFreqBar.hide();
        this.kaiserLabel = new Label("Kaiser Parameter", 1);
        this.add(this.kaiserLabel);
        this.kaiserBar = new Scrollbar(0, 500, 1, 1, 999);
        this.add(this.kaiserBar);
        this.kaiserBar.addAdjustmentListener(this);
        this.setInputLabel();
        this.reinit();
        this.cv.setBackground(Color.black);
        this.cv.setForeground(Color.lightGray);
        this.showFormat = DecimalFormat.getInstance();
        this.showFormat.setMaximumFractionDigits(2);
        this.resize(640, 640);
        this.handleResize();
        Dimension x = this.getSize();
        Dimension screen = this.getToolkit().getScreenSize();
        this.setLocation((screen.width - x.width) / 2, (screen.height - x.height) / 2);
        this.show();
    }

    void reinit() {
        this.setupFilter();
        this.setInputW();
    }

    MenuItem getMenuItem(String s) {
        MenuItem mi = new MenuItem(s);
        mi.addActionListener(this);
        return mi;
    }

    CheckboxMenuItem getCheckItem(String s, boolean b) {
        CheckboxMenuItem mi = new CheckboxMenuItem(s);
        mi.setState(b);
        mi.addItemListener(this);
        return mi;
    }

    int getPower2(int n) {
        int o = 2;
        while (o < n) {
            o *= 2;
        }
        return o;
    }

    PhaseColor genPhaseColor(int sec, double ang) {
        ang += (double)sec * Math.PI / 4.0;
        int hsec = (int)(ang *= 0.954929658551372);
        double a2 = ang % 1.0;
        double a3 = 1.0 - a2;
        PhaseColor c = null;
        switch (hsec) {
            case 0: 
            case 6: {
                c = new PhaseColor(1.0, a2, 0.0);
                break;
            }
            case 1: {
                c = new PhaseColor(a3, 1.0, 0.0);
                break;
            }
            case 2: {
                c = new PhaseColor(0.0, 1.0, a2);
                break;
            }
            case 3: {
                c = new PhaseColor(0.0, a3, 1.0);
                break;
            }
            case 4: {
                c = new PhaseColor(a2, 0.0, 1.0);
                break;
            }
            case 5: {
                c = new PhaseColor(1.0, 0.0, a3);
            }
        }
        return c;
    }

    void handleResize() {
        Dimension d = this.winSize = this.cv.getSize();
        if (this.winSize.width == 0) {
            return;
        }
        int ct = 1;
        this.waveformView = null;
        this.stepView = null;
        this.phaseView = null;
        this.impulseView = null;
        this.spectrumView = null;
        this.respView = null;
        if (this.freqCheckItem.getState()) {
            ++ct;
        }
        if (this.phaseCheckItem.getState()) {
            ++ct;
        }
        if (this.spectrumCheckItem.getState()) {
            ++ct;
        }
        if (this.waveformCheckItem.getState()) {
            ++ct;
        }
        if (this.impulseCheckItem.getState()) {
            ++ct;
        }
        if (this.stepCheckItem.getState()) {
            ++ct;
        }
        int dh3 = d.height / ct;
        this.dbimage = this.createImage(d.width, d.height);
        int bd = 15;
        int i = 0;
        if (this.freqCheckItem.getState()) {
            this.respView = this.getView(i++, ct);
        }
        if (this.phaseCheckItem.getState()) {
            this.phaseView = this.getView(i++, ct);
        }
        if (this.spectrumCheckItem.getState()) {
            this.spectrumView = this.getView(i++, ct);
        }
        if (this.waveformCheckItem.getState()) {
            this.waveformView = this.getView(i++, ct);
        }
        if (this.impulseCheckItem.getState()) {
            this.impulseView = this.getView(i++, ct);
        }
        if (this.stepCheckItem.getState()) {
            this.stepView = this.getView(i++, ct);
        }
        this.poleInfoView = this.getView(i++, ct);
        if (this.poleInfoView.height > 200) {
            this.poleInfoView.height = 200;
        }
        this.polesView = new View(this.poleInfoView.x, this.poleInfoView.y, this.poleInfoView.height, this.poleInfoView.height);
        this.getPoleBuffer();
    }

    View getView(int i, int ct) {
        int dh3 = this.winSize.height / ct;
        int bd = 5;
        int tpad = 15;
        return new View(bd, bd + i * dh3 + tpad, this.winSize.width - bd * 2, dh3 - bd * 2 - tpad);
    }

    void getPoleBuffer() {
        this.pixels = null;
        if (this.java2) {
            try {
                Class<?> biclass = Class.forName("java.awt.image.BufferedImage");
                Class<?> dbiclass = Class.forName("java.awt.image.DataBufferInt");
                Class<?> rasclass = Class.forName("java.awt.image.Raster");
                Constructor<?> cstr = biclass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                this.memimage = (Image)cstr.newInstance(new Integer(this.polesView.width), new Integer(this.polesView.height), new Integer(1));
                Method m = biclass.getMethod("getRaster", null);
                Object ras = m.invoke((Object)this.memimage, null);
                Object db = rasclass.getMethod("getDataBuffer", null).invoke(ras, null);
                this.pixels = (int[])dbiclass.getMethod("getData", null).invoke(db, null);
            }
            catch (Exception ee) {
                System.out.println("BufferedImage failed");
            }
        }
        if (this.pixels == null) {
            this.pixels = new int[this.polesView.width * this.polesView.height];
            int i = 0;
            while (i != this.polesView.width * this.polesView.height) {
                this.pixels[i] = -16777216;
                ++i;
            }
            this.imageSource = new MemoryImageSource(this.polesView.width, this.polesView.height, this.pixels, 0, this.polesView.width);
            this.imageSource.setAnimated(true);
            this.imageSource.setFullBufferUpdates(true);
            this.memimage = this.cv.createImage(this.imageSource);
        }
    }

    void centerString(Graphics g, String s, int y) {
        FontMetrics fm = g.getFontMetrics();
        g.drawString(s, (this.winSize.width - fm.stringWidth(s)) / 2, y);
    }

    public void paint(Graphics g) {
        this.cv.repaint();
    }

    public void updateDFilter(Graphics realg) {
        int x;
        double q;
        int k;
        int flen;
        int oy;
        int y;
        int i;
        Graphics g = this.dbimage.getGraphics();
        if (this.winSize == null || this.winSize.width == 0 || this.dbimage == null) {
            return;
        }
        if (this.curFilter == null) {
            Filter f;
            this.curFilter = f = this.filterType.genFilter();
            if (this.playThread != null) {
                this.playThread.setFilter(f);
            }
            this.filterChanged = true;
            this.unstable = false;
        }
        if (this.playThread == null && !this.unstable && this.soundCheck.getState()) {
            this.playThread = new PlayThread();
            this.playThread.start();
        }
        if (this.displayCheck.getState()) {
            return;
        }
        g.setColor(this.cv.getBackground());
        g.fillRect(0, 0, this.winSize.width, this.winSize.height);
        g.setColor(this.cv.getForeground());
        double minf = 40.0 / (double)this.sampleRate;
        this.minlog = Math.log(minf);
        this.logrange = Math.log(0.5) - this.minlog;
        Complex cc = new Complex();
        if (this.respView != null) {
            double q2;
            this.respView.drawLabel(g, "Frequency Response");
            g.setColor(Color.darkGray);
            g.fillRect(this.respView.x, this.respView.y, this.respView.width, this.respView.height);
            g.setColor(Color.black);
            double ym = 0.069;
            i = 0;
            while (!((q2 = ym * (double)i) > 1.0)) {
                int y2 = this.respView.y + (int)(q2 * (double)this.respView.height);
                g.drawLine(this.respView.x, y2, this.respView.right, y2);
                i += 2;
            }
            i = 1;
            while (true) {
                double ll = this.logrange - (double)i * Math.log(2.0);
                int x2 = 0;
                x2 = this.logFreqCheckItem.getState() ? (int)(ll * (double)this.respView.width / this.logrange) : this.respView.width / (1 << i);
                if (x2 <= 0) break;
                g.drawLine(x2 += this.respView.x, this.respView.y, x2, this.respView.bottom);
                ++i;
            }
            g.setColor(Color.white);
            int ox = -1;
            int oy2 = -1;
            int ox2 = -1;
            int oy22 = -1;
            i = 0;
            while (i != this.respView.width) {
                double w = 0.0;
                if (!this.logFreqCheckItem.getState()) {
                    w = Math.PI * (double)i / (double)this.respView.width;
                } else {
                    double f = Math.exp(this.minlog + (double)i * this.logrange / (double)this.respView.width);
                    w = Math.PI * 2 * f;
                }
                this.filterType.getResponse(w, cc);
                double bw = cc.magSquared();
                double val = -ym * Math.log(bw * bw) / 2.302585092994046;
                int x3 = i + this.respView.x;
                if (val > 1.0) {
                    if (ox != -1) {
                        g.drawLine(ox, oy2, ox, this.respView.bottom);
                    }
                    ox = -1;
                } else {
                    int y3 = this.respView.y + (int)((double)this.respView.height * val);
                    if (ox != -1) {
                        g.drawLine(ox, oy2, x3, y3);
                    } else if (x3 > this.respView.x) {
                        g.drawLine(x3, this.respView.bottom, x3, y3);
                    }
                    ox = x3;
                    oy2 = y3;
                }
                if (this.filterType instanceof CustomFIRFilter) {
                    g.setColor(Color.white);
                    CustomFIRFilter cf = (CustomFIRFilter)this.filterType;
                    bw = cf.getUserResponse(w);
                    val = -ym * Math.log(bw * bw) / 2.302585092994046;
                    if (val > 1.0) {
                        if (ox2 != -1) {
                            g.drawLine(ox2, oy22, ox2, this.respView.bottom);
                        }
                        ox2 = -1;
                    } else {
                        y = this.respView.y + (int)((double)this.respView.height * val);
                        if (ox2 != -1) {
                            g.drawLine(ox2, oy22, x3, y);
                        } else if (x3 > this.respView.x) {
                            g.drawLine(x3, this.respView.bottom, x3, y);
                        }
                        ox2 = x3;
                        oy22 = y;
                    }
                    g.setColor(Color.red);
                }
                ++i;
            }
        }
        g.setColor(Color.white);
        if (this.phaseView != null) {
            this.phaseView.drawLabel(g, "Phase Response");
            g.setColor(Color.darkGray);
            g.fillRect(this.phaseView.x, this.phaseView.y, this.phaseView.width, this.phaseView.height);
            g.setColor(Color.black);
            i = 0;
            while (i < 5) {
                double q3 = (double)i * 0.25;
                int y4 = this.phaseView.y + (int)(q3 * (double)this.phaseView.height);
                g.drawLine(this.phaseView.x, y4, this.phaseView.right, y4);
                ++i;
            }
            i = 1;
            while (true) {
                double ll = this.logrange - (double)i * Math.log(2.0);
                int x4 = 0;
                x4 = this.logFreqCheckItem.getState() ? (int)(ll * (double)this.phaseView.width / this.logrange) : this.phaseView.width / (1 << i);
                if (x4 <= 0) break;
                g.drawLine(x4 += this.phaseView.x, this.phaseView.y, x4, this.phaseView.bottom);
                ++i;
            }
            g.setColor(Color.white);
            int ox = -1;
            int oy3 = -1;
            i = 0;
            while (i != this.phaseView.width) {
                double w = 0.0;
                if (!this.logFreqCheckItem.getState()) {
                    w = Math.PI * (double)i / (double)this.phaseView.width;
                } else {
                    double f = Math.exp(this.minlog + (double)i * this.logrange / (double)this.phaseView.width);
                    w = Math.PI * 2 * f;
                }
                this.filterType.getResponse(w, cc);
                double val = 0.5 + cc.phase / (Math.PI * 2);
                int y5 = this.phaseView.y + (int)((double)this.phaseView.height * val);
                int x5 = i + this.phaseView.x;
                if (ox != -1) {
                    g.drawLine(ox, oy3, x5, y5);
                } else if (x5 > this.phaseView.x) {
                    g.drawLine(x5, this.phaseView.bottom, x5, y5);
                }
                ox = x5;
                oy3 = y5;
                ++i;
            }
        }
        int polect = this.filterType.getPoleCount();
        int zeroct = this.filterType.getZeroCount();
        int infoX = 10;
        int ph = 0;
        int pw = 0;
        int cx = 0;
        int cy = 0;
        if (this.poleInfoView != null && (polect > 0 || zeroct > 0 || this.ferrisCheckItem.getState())) {
            Complex c1;
            pw = ph = this.polesView.height / 2;
            cx = this.polesView.x + pw;
            cy = this.polesView.y + ph;
            infoX = cx + pw + 10;
            if (!this.ferrisCheckItem.getState()) {
                int c1y;
                g.setColor(Color.white);
                FontMetrics fm = g.getFontMetrics();
                String s = "Poles/Zeros";
                g.drawString(s, cx - fm.stringWidth(s) / 2, this.polesView.y - 5);
                g.drawOval(cx - pw, cy - ph, pw * 2, ph * 2);
                g.drawLine(cx, cy - ph, cx, cy + ph);
                g.drawLine(cx - ph, cy, cx + ph, cy);
                c1 = new Complex();
                i = 0;
                while (i != polect) {
                    this.filterType.getPole(i, c1);
                    g.setColor(i == this.selectedPole ? Color.yellow : Color.white);
                    int c1x = cx + (int)((double)pw * c1.re);
                    c1y = cy - (int)((double)ph * c1.im);
                    g.drawLine(c1x - 3, c1y - 3, c1x + 3, c1y + 3);
                    g.drawLine(c1x - 3, c1y + 3, c1x + 3, c1y - 3);
                    ++i;
                }
                i = 0;
                while (i != zeroct) {
                    this.filterType.getZero(i, c1);
                    g.setColor(i == this.selectedZero ? Color.yellow : Color.white);
                    int c1x = cx + (int)((double)pw * c1.re);
                    c1y = cy - (int)((double)ph * c1.im);
                    g.drawOval(c1x - 3, c1y - 3, 6, 6);
                    ++i;
                }
                if (this.filterChanged) {
                    this.setCustomPolesZeros();
                }
            } else {
                if (this.filterChanged) {
                    c1 = new Complex();
                    int ri = 0;
                    while (ri != this.polesView.width) {
                        int ii = 0;
                        while (ii != this.polesView.height) {
                            c1.set((double)(ri - pw) / (double)pw, (double)(ii - pw) / (double)pw);
                            if (c1.re == 0.0 && c1.im == 0.0) {
                                c1.set(1.0E-30);
                            }
                            this.curFilter.evalTransfer(c1);
                            double cv = 0.0;
                            double wv = 0.0;
                            double m = Math.sqrt(c1.mag);
                            if (m < 1.0) {
                                cv = m;
                                wv = 1.0 - cv;
                            } else if (m < 2.0) {
                                cv = 2.0 - m;
                            }
                            cv *= 255.0;
                            wv *= 255.0;
                            double p = c1.phase;
                            if (p < 0.0) {
                                p += Math.PI * 2;
                            }
                            if (p >= Math.PI * 2) {
                                p -= Math.PI * 2;
                            }
                            PhaseColor pc = this.phaseColors[(int)(p * 400.0 / (Math.PI * 2))];
                            this.pixels[ri + ii * this.polesView.width] = -16777216 + 65536 * (int)(pc.r * cv + wv) + 256 * (int)(pc.g * cv + wv) + 1 * (int)(pc.b * cv + wv);
                            ++ii;
                        }
                        ++ri;
                    }
                }
                if (this.imageSource != null) {
                    this.imageSource.newPixels();
                }
                g.drawImage(this.memimage, this.polesView.x, this.polesView.y, null);
            }
        }
        if (this.poleInfoView != null) {
            double f;
            g.setColor(Color.white);
            String[] info = new String[10];
            this.filterType.getInfo(info);
            i = 0;
            while (i != 10) {
                if (info[i] == null) break;
                ++i;
            }
            if (this.wformInfo.needsFrequency()) {
                info[i++] = "Input Freq = " + (int)(this.inputW * (double)this.sampleRate / (Math.PI * 2));
            }
            info[i++] = "Output adjust = " + this.showFormat.format(-10.0 * Math.log(this.outputGain) / Math.log(0.1)) + " dB";
            i = 0;
            while (i != 10) {
                if (info[i] == null) break;
                g.drawString(info[i], infoX, this.poleInfoView.y + 5 + 20 * i);
                ++i;
            }
            if ((this.respView != null && this.respView.contains(this.mouseX, this.mouseY) || this.spectrumView != null && this.spectrumView.contains(this.mouseX, this.mouseY)) && (f = this.getFreqFromX(this.mouseX, this.respView)) >= 0.0) {
                double fw = Math.PI * 2 * f;
                g.setColor(Color.yellow);
                String s = "Selected Freq = " + (int)(f *= (double)this.sampleRate);
                if (this.respView.contains(this.mouseX, this.mouseY)) {
                    this.filterType.getResponse(fw, cc);
                    double bw = cc.magSquared();
                    bw = Math.log(bw * bw) / 4.605170185988092;
                    s = String.valueOf(s) + ", Response = " + this.showFormat.format(10.0 * bw) + " dB";
                }
                g.drawString(s, infoX, this.poleInfoView.y + 5 + 20 * i);
                if (ph > 0) {
                    int x6 = cx + (int)((double)pw * Math.cos(fw));
                    y = cy - (int)((double)pw * Math.sin(fw));
                    if (this.ferrisCheckItem.getState()) {
                        g.setColor(Color.black);
                        g.fillOval(x6 - 3, y - 3, 7, 7);
                    }
                    g.setColor(Color.yellow);
                    g.fillOval(x6 - 2, y - 2, 5, 5);
                }
            }
        }
        if (this.impulseView != null) {
            this.impulseView.drawLabel(g, "Impulse Response");
            g.setColor(Color.darkGray);
            g.fillRect(this.impulseView.x, this.impulseView.y, this.impulseView.width, this.impulseView.height);
            g.setColor(Color.black);
            g.drawLine(this.impulseView.x, this.impulseView.y + this.impulseView.height / 2, this.impulseView.x + this.impulseView.width - 1, this.impulseView.y + this.impulseView.height / 2);
            g.setColor(Color.white);
            int offset = this.curFilter.getImpulseOffset();
            double[] impBuf = this.curFilter.getImpulseResponse(offset);
            int len = this.curFilter.getImpulseLen(offset, impBuf);
            int ox = -1;
            oy = -1;
            double mult = 0.5 / this.max(impBuf);
            int n = flen = len < 50 ? 50 : len;
            if (len < flen && flen < impBuf.length - offset) {
                len = flen;
            }
            i = 0;
            while (i != len) {
                k = offset + i;
                q = impBuf[k] * mult;
                int y6 = this.impulseView.y + (int)((double)this.impulseView.height * (0.5 - q));
                x = this.impulseView.x + this.impulseView.width * i / flen;
                if (len < 100) {
                    g.drawLine(x, this.impulseView.y + this.impulseView.height / 2, x, y6);
                    g.fillOval(x - 2, y6 - 2, 5, 5);
                } else {
                    if (ox != -1) {
                        g.drawLine(ox, oy, x, y6);
                    }
                    ox = x;
                    oy = y6;
                }
                ++i;
            }
        }
        if (this.stepView != null) {
            this.stepView.drawLabel(g, "Step Response");
            g.setColor(Color.darkGray);
            g.fillRect(this.stepView.x, this.stepView.y, this.stepView.width, this.stepView.height);
            g.setColor(Color.black);
            g.drawLine(this.stepView.x, this.stepView.y + this.stepView.height / 2, this.stepView.x + this.stepView.width - 1, this.stepView.y + this.stepView.height / 2);
            g.setColor(Color.white);
            int offset = this.curFilter.getStepOffset();
            double[] impBuf = this.curFilter.getStepResponse(offset);
            int len = this.curFilter.getStepLen(offset, impBuf);
            int ox = -1;
            oy = -1;
            double mult = 0.5 / this.max(impBuf);
            int n = flen = len < 50 ? 50 : len;
            if (len < flen && flen < impBuf.length - offset) {
                len = flen;
            }
            i = 0;
            while (i != len) {
                k = offset + i;
                q = impBuf[k] * mult;
                int y7 = this.stepView.y + (int)((double)this.stepView.height * (0.5 - q));
                x = this.stepView.x + this.stepView.width * i / flen;
                if (len < 100) {
                    g.drawLine(x, this.stepView.y + this.stepView.height / 2, x, y7);
                    g.fillOval(x - 2, y7 - 2, 5, 5);
                } else {
                    if (ox != -1) {
                        g.drawLine(ox, oy, x, y7);
                    }
                    ox = x;
                    oy = y7;
                }
                ++i;
            }
        }
        if (this.playThread != null) {
            int splen = this.playThread.spectrumLen;
            if (this.spectrumBuf == null || this.spectrumBuf.length != splen * 2) {
                this.spectrumBuf = new double[splen * 2];
            }
            int off = this.playThread.spectrumOffset;
            int mask = this.playThread.fbufmask;
            int i2 = 0;
            i = 0;
            while (i != splen) {
                int o = mask & off + i;
                this.spectrumBuf[i2] = this.playThread.fbufLo[o] + this.playThread.fbufRo[o];
                this.spectrumBuf[i2 + 1] = 0.0;
                ++i;
                i2 += 2;
            }
        } else {
            this.spectrumBuf = null;
        }
        if (this.waveformView != null && this.spectrumBuf != null) {
            this.waveformView.drawLabel(g, "Waveform");
            g.setColor(Color.darkGray);
            g.fillRect(this.waveformView.x, this.waveformView.y, this.waveformView.width, this.waveformView.height);
            g.setColor(Color.black);
            g.drawLine(this.waveformView.x, this.waveformView.y + this.waveformView.height / 2, this.waveformView.x + this.waveformView.width - 1, this.waveformView.y + this.waveformView.height / 2);
            g.setColor(Color.white);
            int ox = -1;
            int oy4 = -1;
            if (this.waveGain < 0.1) {
                this.waveGain = 0.1;
            }
            double max = 0.0;
            i = 0;
            while (i != this.spectrumBuf.length) {
                if (this.spectrumBuf[i] > max) {
                    max = this.spectrumBuf[i];
                }
                if (this.spectrumBuf[i] < -max) {
                    max = -this.spectrumBuf[i];
                }
                i += 2;
            }
            if (this.waveGain > 1.0 / max) {
                this.waveGain = 1.0 / max;
            } else if (this.waveGain * 1.05 < 1.0 / max) {
                this.waveGain *= 1.05;
            }
            double mult = 0.5 * this.waveGain;
            int nb = this.waveformView.width;
            if (nb > this.spectrumBuf.length || this.allWaveformCheckItem.getState()) {
                nb = this.spectrumBuf.length;
            }
            i = 0;
            while (i < nb) {
                double bf = 0.5 - this.spectrumBuf[i] * mult;
                int ya = (int)((double)this.waveformView.height * bf);
                if (ya > this.waveformView.height) {
                    ox = -1;
                } else {
                    int y8 = this.waveformView.y + ya;
                    int x7 = this.waveformView.x + i * this.waveformView.width / nb;
                    if (ox != -1) {
                        g.drawLine(ox, oy4, x7, y8);
                    }
                    ox = x7;
                    oy4 = y8;
                }
                i += 2;
            }
        }
        if (this.spectrumView != null && this.spectrumBuf != null) {
            double q4;
            this.spectrumView.drawLabel(g, "Spectrum");
            g.setColor(Color.darkGray);
            g.fillRect(this.spectrumView.x, this.spectrumView.y, this.spectrumView.width, this.spectrumView.height);
            g.setColor(Color.black);
            double ym = 0.138;
            i = 0;
            while (!((q4 = ym * (double)i) > 1.0)) {
                int y9 = this.spectrumView.y + (int)(q4 * (double)this.spectrumView.height);
                g.drawLine(this.spectrumView.x, y9, this.spectrumView.x + this.spectrumView.width, y9);
                ++i;
            }
            i = 1;
            while (true) {
                double ll = this.logrange - (double)i * Math.log(2.0);
                int x8 = 0;
                x8 = this.logFreqCheckItem.getState() ? (int)(ll * (double)this.spectrumView.width / this.logrange) : this.spectrumView.width / (1 << i);
                if (x8 <= 0) break;
                g.drawLine(x8 += this.spectrumView.x, this.spectrumView.y, x8, this.spectrumView.bottom);
                ++i;
            }
            g.setColor(Color.white);
            int isub = this.spectrumBuf.length / 2;
            double cosmult = Math.PI * 2 / (double)(this.spectrumBuf.length - 2);
            i = 0;
            while (i != this.spectrumBuf.length) {
                double ht = 0.54 - 0.46 * Math.cos((double)i * cosmult);
                int n = i;
                this.spectrumBuf[n] = this.spectrumBuf[n] * ht;
                i += 2;
            }
            if (this.spectrumFFT == null || this.spectrumFFT.size != this.spectrumBuf.length / 2) {
                this.spectrumFFT = new FFT(this.spectrumBuf.length / 2);
            }
            this.spectrumFFT.transform(this.spectrumBuf, false);
            double logmult = (double)this.spectrumView.width / Math.log(this.spectrumBuf.length / 2 + 1);
            int ox = -1;
            int oy5 = -1;
            double bufmult = 1.0 / (double)(this.spectrumBuf.length / 2);
            bufmult = this.logAmpCheckItem.getState() ? (bufmult /= 65536.0) : (bufmult /= 768.0);
            bufmult *= bufmult;
            double[] specArray = new double[this.spectrumView.width];
            if (this.logFreqCheckItem.getState()) {
                i = 0;
                while (i != this.spectrumBuf.length / 2) {
                    double f = (double)i / (double)this.spectrumBuf.length;
                    int ix = (int)((double)specArray.length * (Math.log(f) - this.minlog) / this.logrange);
                    if (ix >= 0) {
                        int n = ix;
                        specArray[n] = specArray[n] + (this.spectrumBuf[i] * this.spectrumBuf[i] + this.spectrumBuf[i + 1] * this.spectrumBuf[i + 1]);
                    }
                    i += 2;
                }
            } else {
                i = 0;
                while (i != this.spectrumBuf.length / 2) {
                    int ix;
                    int n = ix = specArray.length * i * 2 / this.spectrumBuf.length;
                    specArray[n] = specArray[n] + (this.spectrumBuf[i] * this.spectrumBuf[i] + this.spectrumBuf[i + 1] * this.spectrumBuf[i + 1]);
                    i += 2;
                }
            }
            int maxi = specArray.length;
            i = 0;
            while (i != this.spectrumView.width) {
                double bf = specArray[i] * bufmult;
                bf = this.logAmpCheckItem.getState() ? -ym * Math.log(bf) / 2.302585092994046 : 1.0 - bf;
                int ya = (int)((double)this.spectrumView.height * bf);
                if (ya <= this.spectrumView.height) {
                    int y10 = this.spectrumView.y + ya;
                    int x9 = this.spectrumView.x + i * this.spectrumView.width / maxi;
                    g.drawLine(x9, y10, x9, this.spectrumView.y + this.spectrumView.height - 1);
                }
                ++i;
            }
        }
        if (this.spectrumView != null && !this.java2) {
            g.setColor(Color.white);
            this.centerString(g, "Need java 2 for sound", this.spectrumView.y + this.spectrumView.height / 2);
        }
        if (this.unstable) {
            g.setColor(Color.red);
            this.centerString(g, "Filter is unstable", this.winSize.height / 2);
        }
        if (this.mp3Error != null) {
            g.setColor(Color.red);
            this.centerString(g, this.mp3Error, this.winSize.height / 2 + 20);
        }
        if (this.respView != null && this.respView.contains(this.mouseX, this.mouseY)) {
            g.setColor(Color.yellow);
            g.drawLine(this.mouseX, this.respView.y, this.mouseX, this.respView.y + this.respView.height - 1);
        }
        if (this.spectrumView != null && this.spectrumView.contains(this.mouseX, this.mouseY)) {
            g.setColor(Color.yellow);
            g.drawLine(this.mouseX, this.spectrumView.y, this.mouseX, this.spectrumView.y + this.spectrumView.height - 1);
        }
        this.filterChanged = false;
        realg.drawImage(this.dbimage, 0, 0, this);
    }

    void setCutoff(double f) {
    }

    void setCustomPolesZeros() {
        if (this.filterType instanceof CustomIIRFilter) {
            return;
        }
        int polect = this.filterType.getPoleCount();
        int zeroct = this.filterType.getZeroCount();
        Complex c1 = new Complex();
        int n = 0;
        int i = 0;
        while (i != polect) {
            this.filterType.getPole(i, c1);
            if (c1.im >= 0.0) {
                this.customPoles[n++].set(c1);
                this.customPoles[n++].set(c1.re, -c1.im);
                if (n == this.customPoles.length) break;
            }
            ++i;
        }
        this.lastPoleCount = n;
        n = 0;
        i = 0;
        while (i != zeroct) {
            this.filterType.getZero(i, c1);
            if (c1.im >= 0.0) {
                this.customZeros[n++].set(c1);
                this.customZeros[n++].set(c1.re, -c1.im);
                if (n == this.customZeros.length) break;
            }
            ++i;
        }
        this.lastZeroCount = n;
    }

    double max(double[] buf) {
        double max = 0.0;
        int i = 0;
        while (i != buf.length) {
            double qa = Math.abs(buf[i]);
            if (qa > max) {
                max = qa;
            }
            ++i;
        }
        return max;
    }

    double getFreqFromX(int x, View v) {
        double f = 0.5 * (double)(x - v.x) / (double)v.width;
        if (f <= 0.0 || f >= 0.5) {
            return -1.0;
        }
        if (this.logFreqCheckItem.getState()) {
            return Math.exp(this.minlog + 2.0 * f * this.logrange);
        }
        return f;
    }

    void setupFilter() {
        int filt = this.filterChooser.getSelectedIndex();
        switch (filt) {
            case 0: {
                this.filterType = new SincLowPassFilter();
                break;
            }
            case 1: {
                this.filterType = new SincHighPassFilter();
                break;
            }
            case 2: {
                this.filterType = new SincBandPassFilter();
                break;
            }
            case 3: {
                this.filterType = new SincBandStopFilter();
                break;
            }
            case 4: {
                this.filterType = new CustomFIRFilter();
                break;
            }
            case 5: {
                this.filterType = new NoFilter();
                break;
            }
            case 6: {
                this.filterType = new ButterLowPass();
                break;
            }
            case 7: {
                this.filterType = new ButterHighPass();
                break;
            }
            case 8: {
                this.filterType = new ButterBandPass();
                break;
            }
            case 9: {
                this.filterType = new ButterBandStop();
                break;
            }
            case 10: {
                this.filterType = new ChebyLowPass();
                break;
            }
            case 11: {
                this.filterType = new ChebyHighPass();
                break;
            }
            case 12: {
                this.filterType = new ChebyBandPass();
                break;
            }
            case 13: {
                this.filterType = new ChebyBandStop();
                break;
            }
            case 14: {
                this.filterType = new InvChebyLowPass();
                break;
            }
            case 15: {
                this.filterType = new InvChebyHighPass();
                break;
            }
            case 16: {
                this.filterType = new InvChebyBandPass();
                break;
            }
            case 17: {
                this.filterType = new InvChebyBandStop();
                break;
            }
            case 18: {
                this.filterType = new EllipticLowPass();
                break;
            }
            case 19: {
                this.filterType = new EllipticHighPass();
                break;
            }
            case 20: {
                this.filterType = new EllipticBandPass();
                break;
            }
            case 21: {
                this.filterType = new EllipticBandStop();
                break;
            }
            case 22: {
                this.filterType = new CombFilter(1);
                break;
            }
            case 23: {
                this.filterType = new CombFilter(-1);
                break;
            }
            case 24: {
                this.filterType = new DelayFilter();
                break;
            }
            case 25: {
                this.filterType = new PluckedStringFilter();
                break;
            }
            case 26: {
                this.filterType = new InverseCombFilter();
                break;
            }
            case 27: {
                this.filterType = new ResonatorFilter();
                break;
            }
            case 28: {
                this.filterType = new ResonatorZeroFilter();
                break;
            }
            case 29: {
                this.filterType = new NotchFilter();
                break;
            }
            case 30: {
                this.filterType = new MovingAverageFilter();
                break;
            }
            case 31: {
                this.filterType = new TriangleFilter();
                break;
            }
            case 32: {
                this.filterType = new AllPassFilter();
                break;
            }
            case 33: {
                this.filterType = new GaussianFilter();
                break;
            }
            case 34: {
                this.filterType = new RandomFilter();
                break;
            }
            case 35: {
                this.filterType = new CustomIIRFilter();
            }
        }
        if (this.filterSelection != filt) {
            this.filterSelection = filt;
            int i = 0;
            while (i != this.auxBars.length) {
                this.auxBars[i].setMaximum(999);
                ++i;
            }
            int ax = this.filterType.select();
            i = 0;
            while (i != ax) {
                this.auxLabels[i].show();
                this.auxBars[i].show();
                ++i;
            }
            i = ax;
            while (i != this.auxBars.length) {
                this.auxLabels[i].hide();
                this.auxBars[i].hide();
                ++i;
            }
            if (this.filterType.needsWindow()) {
                this.windowChooser.show();
                this.setWindow();
            } else {
                this.windowChooser.hide();
                this.setWindow();
            }
            this.validate();
        }
        this.filterType.setup();
        this.curFilter = null;
    }

    void setInputLabel() {
        this.wformInfo = this.getWaveformObject();
        String inText = this.wformInfo.getInputText();
        if (inText == null) {
            this.inputLabel.hide();
            this.inputBar.hide();
        } else {
            this.inputLabel.setText(inText);
            this.inputLabel.show();
            this.inputBar.show();
        }
        this.validate();
    }

    Waveform getWaveformObject() {
        Waveform wform;
        int ic = this.inputChooser.getSelectedIndex();
        switch (ic) {
            case 0: {
                wform = new NoiseWaveform();
                break;
            }
            case 1: {
                wform = new SineWaveform();
                break;
            }
            case 2: {
                wform = new SawtoothWaveform();
                break;
            }
            case 3: {
                wform = new TriangleWaveform();
                break;
            }
            case 4: {
                wform = new SquareWaveform();
                break;
            }
            case 5: {
                wform = new PeriodicNoiseWaveform();
                break;
            }
            case 6: {
                wform = new SweepWaveform();
                break;
            }
            case 7: {
                wform = new ImpulseWaveform();
                break;
            }
            default: {
                wform = new Mp3Waveform(ic - 8);
            }
        }
        return wform;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        this.cv.repaint(this.pause);
    }

    public void componentResized(ComponentEvent e) {
        this.handleResize();
        this.cv.repaint(this.pause);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.exitItem) {
            this.applet.destroyFrame();
            return;
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.setupFilter();
        System.out.print(String.valueOf(((Scrollbar)e.getSource()).getValue()) + "\n");
        if (e.getSource() == this.inputBar) {
            this.setInputW();
        }
        this.cv.repaint(this.pause);
    }

    void setInputW() {
        this.inputW = Math.PI * (double)this.inputBar.getValue() / 1000.0;
    }

    public boolean handleEvent(Event ev) {
        if (ev.id == 201) {
            if (this.playThread != null) {
                this.playThread.requestShutdown();
            }
            this.applet.destroyFrame();
            return true;
        }
        return super.handleEvent(ev);
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.edit(e);
        this.cv.repaint(this.pause);
    }

    public void mouseMoved(MouseEvent e) {
        this.dragX = this.mouseX = e.getX();
        this.dragY = this.mouseY = e.getY();
        this.cv.repaint(this.pause);
        if (this.respView != null && this.respView.contains(e.getX(), e.getY())) {
            this.selection = 1;
        }
        if (this.spectrumView != null && this.spectrumView.contains(e.getX(), e.getY())) {
            this.selection = 2;
        }
        if (this.polesView != null && this.polesView.contains(e.getX(), e.getY()) && !this.ferrisCheckItem.getState()) {
            this.selection = 3;
            this.selectPoleZero(e.getX(), e.getY());
        }
    }

    void selectPoleZero(int x, int y) {
        int dist;
        int c1y;
        int c1x;
        int ph;
        this.selectedZero = -1;
        this.selectedPole = -1;
        int pw = ph = this.polesView.height / 2;
        int cx = this.polesView.x + pw;
        int cy = this.polesView.y + ph;
        Complex c1 = new Complex();
        int polect = this.filterType.getPoleCount();
        int zeroct = this.filterType.getZeroCount();
        int bestdist = 10000;
        int i = 0;
        while (i != polect) {
            this.filterType.getPole(i, c1);
            c1x = cx + (int)((double)pw * c1.re);
            c1y = cy - (int)((double)ph * c1.im);
            dist = this.distanceSq(c1x, c1y, x, y);
            if (dist <= bestdist) {
                bestdist = dist;
                this.selectedPole = i;
                this.selectedZero = -1;
            }
            ++i;
        }
        i = 0;
        while (i != zeroct) {
            this.filterType.getZero(i, c1);
            c1x = cx + (int)((double)pw * c1.re);
            c1y = cy - (int)((double)ph * c1.im);
            dist = this.distanceSq(c1x, c1y, x, y);
            if (dist < bestdist) {
                bestdist = dist;
                this.selectedPole = -1;
                this.selectedZero = i;
            }
            ++i;
        }
    }

    int distanceSq(int x1, int y1, int x2, int y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.mouseMoved(e);
        this.edit(e);
    }

    public void mouseReleased(MouseEvent e) {
    }

    void edit(MouseEvent e) {
        double f;
        if (this.selection == 1) {
            if (this.filterType instanceof CustomFIRFilter) {
                this.editCustomFIRFilter(e);
                return;
            }
            f = this.getFreqFromX(e.getX(), this.respView);
            if (f < 0.0) {
                return;
            }
            this.filterType.setCutoff(f);
            this.setupFilter();
        }
        if (this.selection == 2) {
            if (!this.wformInfo.needsFrequency()) {
                return;
            }
            f = this.getFreqFromX(e.getX(), this.spectrumView);
            if (f < 0.0) {
                return;
            }
            this.inputW = Math.PI * 2 * f;
            this.inputBar.setValue((int)(2000.0 * f));
        }
        if (this.selection == 3 && this.filterType instanceof CustomIIRFilter) {
            this.editCustomIIRFilter(e);
            return;
        }
    }

    void editCustomFIRFilter(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.dragX == x) {
            this.editCustomFIRFilterPoint(x, y);
            this.dragY = y;
        } else {
            int x1 = x < this.dragX ? x : this.dragX;
            int y1 = x < this.dragX ? y : this.dragY;
            int x2 = x > this.dragX ? x : this.dragX;
            int y2 = x > this.dragX ? y : this.dragY;
            this.dragX = x;
            this.dragY = y;
            x = x1;
            while (x <= x2) {
                y = y1 + (y2 - y1) * (x - x1) / (x2 - x1);
                this.editCustomFIRFilterPoint(x, y);
                ++x;
            }
        }
        this.setupFilter();
    }

    void editCustomFIRFilterPoint(int x, int y) {
        double xx1 = this.getFreqFromX(x, this.respView) * 2.0;
        double xx2 = this.getFreqFromX(x + 1, this.respView) * 2.0;
        y -= this.respView.y;
        double ym = 0.069;
        double yy = Math.exp((double)(-y) * Math.log(10.0) / (ym * 4.0 * (double)this.respView.height));
        if (yy >= 1.0) {
            yy = 1.0;
        }
        ((CustomFIRFilter)this.filterType).edit(xx1, xx2, yy);
    }

    void editCustomIIRFilter(MouseEvent e) {
        int ph;
        if (this.ferrisCheckItem.getState()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int pw = ph = this.polesView.height / 2;
        int cx = this.polesView.x + pw;
        int cy = this.polesView.y + ph;
        Complex c1 = new Complex();
        c1.set((double)(x - cx) / (double)pw, (double)(y - cy) / (double)ph);
        ((CustomIIRFilter)this.filterType).editPoleZero(c1);
        this.setupFilter();
    }

    public void itemStateChanged(ItemEvent e) {
        this.filterChanged = true;
        if (e.getSource() == this.displayCheck) {
            this.cv.repaint(this.pause);
            return;
        }
        if (e.getSource() == this.inputChooser) {
            if (this.playThread != null) {
                this.playThread.requestShutdown();
            }
            this.setInputLabel();
        }
        if (e.getSource() == this.rateChooser) {
            if (this.playThread != null) {
                this.playThread.requestShutdown();
            }
            this.inputW *= (double)this.sampleRate;
            switch (this.rateChooser.getSelectedIndex()) {
                case 0: {
                    this.sampleRate = 8000;
                    break;
                }
                case 1: {
                    this.sampleRate = 11025;
                    break;
                }
                case 2: {
                    this.sampleRate = 16000;
                    break;
                }
                case 3: {
                    this.sampleRate = 22050;
                    break;
                }
                case 4: {
                    this.sampleRate = 32000;
                    break;
                }
                case 5: {
                    this.sampleRate = 44100;
                }
            }
            this.inputW /= (double)this.sampleRate;
        }
        if (e.getSource() == this.shiftSpectrumCheck) {
            if (this.shiftSpectrumCheck.getState()) {
                this.shiftFreqLabel.show();
                this.shiftFreqBar.show();
            } else {
                this.shiftFreqLabel.hide();
                this.shiftFreqBar.hide();
            }
            this.validate();
        }
        if (e.getSource() == this.windowChooser) {
            this.setWindow();
        }
        if (e.getSource() instanceof CheckboxMenuItem) {
            this.handleResize();
        } else {
            this.setupFilter();
        }
        this.cv.repaint(this.pause);
    }

    void setWindow() {
        if (this.windowChooser.getSelectedIndex() == WINDOW_KAISER && this.filterType.needsWindow()) {
            this.kaiserLabel.show();
            this.kaiserBar.show();
        } else {
            this.kaiserLabel.hide();
            this.kaiserBar.hide();
        }
        this.validate();
    }

    void setSampleRate(int r) {
        int x = 0;
        switch (r) {
            case 8000: {
                x = 0;
                break;
            }
            case 11025: {
                x = 1;
                break;
            }
            case 16000: {
                x = 2;
                break;
            }
            case 22050: {
                x = 3;
                break;
            }
            case 32000: {
                x = 4;
                break;
            }
            case 44100: {
                x = 5;
            }
        }
        this.rateChooser.select(x);
        this.sampleRate = r;
    }

    class ImpulseWaveform
    extends Waveform {
        int ix;

        ImpulseWaveform() {
        }

        int getChannels() {
            return 1;
        }

        boolean start() {
            this.getBuffer();
            this.ix = 0;
            return true;
        }

        int getData() {
            int ww = DFilterFrame.this.inputBar.getValue() / 51 + 1;
            int period = 10000 / ww;
            int i = 0;
            while (i != this.buffer.length) {
                int q = 0;
                if (this.ix % period == 0) {
                    q = Short.MAX_VALUE;
                }
                ++this.ix;
                this.buffer[i] = q;
                ++i;
            }
            return this.buffer.length;
        }

        String getInputText() {
            return "Impulse Frequency";
        }

        boolean needsFrequency() {
            return false;
        }
    }

    class Mp3Waveform
    extends Waveform {
        Mp3Waveform(int f) {
        }

        boolean start() {
            return true;
        }

        int getData() {
            return 1;
        }

        int getChannels() {
            return 1;
        }

        String getInputText() {
            return null;
        }

        boolean needsFrequency() {
            return false;
        }
    }

    class NoiseWaveform
    extends Waveform {
        NoiseWaveform() {
        }

        boolean start() {
            this.getBuffer();
            return true;
        }

        int getData() {
            int i = 0;
            while (i != this.buffer.length) {
                this.buffer[i] = (short)DFilterFrame.this.random.nextInt();
                ++i;
            }
            return this.buffer.length;
        }

        String getInputText() {
            return null;
        }

        boolean needsFrequency() {
            return false;
        }
    }

    class PeriodicNoiseWaveform
    extends Waveform {
        short[] smbuf;
        int ix;

        PeriodicNoiseWaveform() {
        }

        int getChannels() {
            return 1;
        }

        boolean start() {
            this.getBuffer();
            this.smbuf = new short[1];
            this.ix = 0;
            return true;
        }

        int getData() {
            int i;
            int period = (int)(Math.PI * 2 / DFilterFrame.this.inputW);
            if (period != this.smbuf.length) {
                this.smbuf = new short[period];
                i = 0;
                while (i != period) {
                    this.smbuf[i] = (short)DFilterFrame.this.random.nextInt();
                    ++i;
                }
            }
            i = 0;
            while (i != this.buffer.length) {
                if (this.ix >= period) {
                    this.ix = 0;
                }
                this.buffer[i] = this.smbuf[this.ix];
                ++i;
                ++this.ix;
            }
            return this.buffer.length;
        }
    }

    class PhaseColor {
        public double r;
        public double g;
        public double b;

        PhaseColor(double rr, double gg, double bb) {
            this.r = rr;
            this.g = gg;
            this.b = bb;
        }
    }

    class PlayThread
    extends Thread {
        SourceDataLine line;
        Waveform wform;
        boolean shutdownRequested = false;
        boolean stereo;
        Filter filt;
        Filter newFilter;
        double[] fbufLi;
        double[] fbufRi;
        double[] fbufLo;
        double[] fbufRo;
        double[] stateL;
        double[] stateR;
        int fbufmask;
        int fbufsize;
        int spectrumOffset;
        int spectrumLen;
        int inbp;
        int outbp;
        int spectCt;
        double[] impulseBuf;
        double[] convolveBuf;
        int convBufPtr;
        FFT convFFT;
        byte[] ob;

        PlayThread() {
        }

        void requestShutdown() {
            this.shutdownRequested = true;
        }

        void setFilter(Filter f) {
            this.newFilter = f;
        }

        void openLine() {
            try {
                this.stereo = this.wform.getChannels() == 2;
                AudioFormat playFormat = new AudioFormat(DFilterFrame.this.sampleRate, 16, 2, true, false);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, playFormat);
                if (!AudioSystem.isLineSupported(info)) {
                    throw new LineUnavailableException("sorry, the sound format cannot be played");
                }
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.open(playFormat, DFilterFrame.this.getPower2(DFilterFrame.this.sampleRate / 4));
                this.line.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void run() {
            try {
                this.doRun();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DFilterFrame.this.playThread = null;
        }

        void doRun() {
            DFilterFrame.this.rateChooser.enable();
            this.wform = DFilterFrame.this.getWaveformObject();
            DFilterFrame.this.mp3Error = null;
            DFilterFrame.this.unstable = false;
            if (!this.wform.start()) {
                DFilterFrame.this.cv.repaint();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            this.fbufsize = 32768;
            this.fbufmask = this.fbufsize - 1;
            this.fbufLi = new double[this.fbufsize];
            this.fbufRi = new double[this.fbufsize];
            this.fbufLo = new double[this.fbufsize];
            this.fbufRo = new double[this.fbufsize];
            this.openLine();
            this.spectCt = 0;
            this.outbp = 0;
            this.inbp = 0;
            int ss = this.stereo ? 2 : 1;
            DFilterFrame.this.outputGain = 1.0;
            this.newFilter = this.filt = DFilterFrame.this.curFilter;
            this.spectrumLen = DFilterFrame.this.getPower2(DFilterFrame.this.sampleRate / 12);
            int gainCounter = 0;
            boolean maxGain = true;
            boolean useConvolve = false;
            this.ob = new byte[16384];
            int shiftCtr = 0;
            while (!this.shutdownRequested && DFilterFrame.this.soundCheck.getState() && DFilterFrame.this.applet.ogf != null) {
                int length;
                if (this.newFilter != null) {
                    gainCounter = 0;
                    maxGain = true;
                    if (this.wform instanceof SweepWaveform || this.wform instanceof SineWaveform) {
                        maxGain = false;
                    }
                    DFilterFrame.this.outputGain = 1.0;
                    if (this.filt == null || this.filt.getLength() != this.newFilter.getLength()) {
                        this.spectCt = 0;
                        this.outbp = 0;
                        this.inbp = 0;
                        this.convBufPtr = 0;
                    }
                    this.filt = this.newFilter;
                    this.newFilter = null;
                    this.impulseBuf = null;
                    useConvolve = this.filt.useConvolve();
                    this.stateL = this.filt.createState();
                    this.stateR = this.filt.createState();
                }
                if ((length = this.wform.getData()) == 0) break;
                short[] ib = this.wform.buffer;
                int i = this.inbp;
                int i2 = 0;
                while (i2 < length) {
                    this.fbufLi[i] = ib[i2];
                    i = i + 1 & this.fbufmask;
                    i2 += ss;
                }
                i = this.inbp;
                if (this.stereo) {
                    i2 = 0;
                    while (i2 < length) {
                        this.fbufRi[i] = ib[i2 + 1];
                        i = i + 1 & this.fbufmask;
                        i2 += 2;
                    }
                } else {
                    i2 = 0;
                    while (i2 < length) {
                        this.fbufRi[i] = this.fbufLi[i];
                        i = i + 1 & this.fbufmask;
                        ++i2;
                    }
                }
                if (DFilterFrame.this.shiftSpectrumCheck.getState()) {
                    double shiftFreq = (double)DFilterFrame.this.shiftFreqBar.getValue() * Math.PI / 1000.0;
                    if (shiftFreq > Math.PI) {
                        shiftFreq = Math.PI;
                    }
                    i = this.inbp;
                    i2 = 0;
                    while (i2 < length) {
                        double q = Math.cos(shiftFreq * (double)shiftCtr++);
                        int n = i;
                        this.fbufLi[n] = this.fbufLi[n] * q;
                        int n2 = i;
                        this.fbufRi[n2] = this.fbufRi[n2] * q;
                        i = i + 1 & this.fbufmask;
                        i2 += ss;
                    }
                }
                int sampleCount = length / ss;
                if (useConvolve) {
                    this.doConvolveFilter(sampleCount, maxGain);
                } else {
                    this.doFilter(sampleCount);
                    if (DFilterFrame.this.unstable) break;
                    int outlen = sampleCount * 4;
                    this.doOutput(outlen, maxGain);
                }
                if (DFilterFrame.this.unstable) break;
                if (this.spectCt >= this.spectrumLen) {
                    this.spectrumOffset = this.outbp - this.spectrumLen & this.fbufmask;
                    this.spectCt -= this.spectrumLen;
                    DFilterFrame.this.cv.repaint();
                }
                if (!maxGain || (gainCounter += sampleCount) < DFilterFrame.this.sampleRate) continue;
                gainCounter = 0;
                maxGain = false;
            }
            if (this.shutdownRequested || DFilterFrame.this.unstable || !DFilterFrame.this.soundCheck.getState()) {
                this.line.flush();
            } else {
                this.line.drain();
            }
            DFilterFrame.this.cv.repaint();
        }

        void doFilter(int sampleCount) {
            this.filt.run(this.fbufLi, this.fbufLo, this.inbp, this.fbufmask, sampleCount, this.stateL);
            this.filt.run(this.fbufRi, this.fbufRo, this.inbp, this.fbufmask, sampleCount, this.stateR);
            this.inbp = this.inbp + sampleCount & this.fbufmask;
            double q = this.fbufLo[this.inbp - 1 & this.fbufmask];
            if (Double.isNaN(q) || Double.isInfinite(q)) {
                DFilterFrame.this.unstable = true;
            }
        }

        void doConvolveFilter(int sampleCount, boolean maxGain) {
            int i;
            int fi2 = this.inbp;
            double[] filtA = ((DirectFilter)this.filt).aList;
            int cblen = DFilterFrame.this.getPower2(512 + filtA.length * 2);
            if (this.convolveBuf == null || this.convolveBuf.length != cblen) {
                this.convolveBuf = new double[cblen];
            }
            if (this.impulseBuf == null) {
                this.impulseBuf = new double[cblen];
                i = 0;
                while (i != filtA.length) {
                    this.impulseBuf[i * 2] = filtA[i];
                    ++i;
                }
                this.convFFT = new FFT(this.convolveBuf.length / 2);
                this.convFFT.transform(this.impulseBuf, false);
            }
            int cbptr = this.convBufPtr;
            int cbptrmax = this.convolveBuf.length + 2 - 2 * filtA.length;
            i = 0;
            while (i != sampleCount) {
                int i20 = fi2 & this.fbufmask;
                this.convolveBuf[cbptr] = this.fbufLi[i20];
                this.convolveBuf[cbptr + 1] = this.fbufRi[i20];
                if ((cbptr += 2) == cbptrmax) {
                    int j20;
                    this.convFFT.transform(this.convolveBuf, false);
                    double mult = 2.0 / (double)cblen;
                    int j = 0;
                    while (j != cblen) {
                        double a = this.convolveBuf[j] * this.impulseBuf[j] - this.convolveBuf[j + 1] * this.impulseBuf[j + 1];
                        double b = this.convolveBuf[j] * this.impulseBuf[j + 1] + this.convolveBuf[j + 1] * this.impulseBuf[j];
                        this.convolveBuf[j] = a * mult;
                        this.convolveBuf[j + 1] = b * mult;
                        j += 2;
                    }
                    this.convFFT.transform(this.convolveBuf, true);
                    int fj2 = this.outbp;
                    int overlap = cblen - cbptrmax;
                    j = 0;
                    while (j != overlap) {
                        int n = j20 = fj2 & this.fbufmask;
                        this.fbufLo[n] = this.fbufLo[n] + this.convolveBuf[j];
                        int n2 = j20;
                        this.fbufRo[n2] = this.fbufRo[n2] + this.convolveBuf[j + 1];
                        j += 2;
                        ++fj2;
                    }
                    while (j != cblen) {
                        j20 = fj2 & this.fbufmask;
                        this.fbufLo[j20] = this.convolveBuf[j];
                        this.fbufRo[j20] = this.convolveBuf[j + 1];
                        j += 2;
                        ++fj2;
                    }
                    cbptr = 0;
                    this.doOutput(cbptrmax * 2, maxGain);
                    j = 0;
                    while (j != cblen) {
                        this.convolveBuf[j] = 0.0;
                        ++j;
                    }
                }
                ++i;
                ++fi2;
            }
            this.inbp = fi2 & this.fbufmask;
            this.convBufPtr = cbptr;
        }

        void doOutput(int outlen, boolean maxGain) {
            int i;
            if (this.ob.length < outlen) {
                this.ob = new byte[outlen];
            }
            while (true) {
                int qi;
                int max = 0;
                i = this.outbp;
                int i2 = 0;
                while (i2 < outlen) {
                    qi = (int)(this.fbufLo[i] * DFilterFrame.this.outputGain);
                    if (qi > max) {
                        max = qi;
                    }
                    if (qi < -max) {
                        max = -qi;
                    }
                    this.ob[i2 + 1] = (byte)(qi >> 8);
                    this.ob[i2] = (byte)qi;
                    i = i + 1 & this.fbufmask;
                    i2 += 4;
                }
                i = this.outbp;
                i2 = 2;
                while (i2 < outlen) {
                    qi = (int)(this.fbufRo[i] * DFilterFrame.this.outputGain);
                    if (qi > max) {
                        max = qi;
                    }
                    if (qi < -max) {
                        max = -qi;
                    }
                    this.ob[i2 + 1] = (byte)(qi >> 8);
                    this.ob[i2] = (byte)qi;
                    i = i + 1 & this.fbufmask;
                    i2 += 4;
                }
                if (max > Short.MAX_VALUE) {
                    DFilterFrame.this.outputGain *= 30000.0 / (double)max;
                    if (!(DFilterFrame.this.outputGain < 1.0E-8) && !Double.isInfinite(DFilterFrame.this.outputGain)) continue;
                    DFilterFrame.this.unstable = true;
                    break;
                }
                if (!maxGain || max >= 24000) break;
                if (max == 0) {
                    if (DFilterFrame.this.outputGain == 1.0) break;
                    DFilterFrame.this.outputGain = 1.0;
                    continue;
                }
                DFilterFrame.this.outputGain *= 30000.0 / (double)max;
            }
            if (DFilterFrame.this.unstable) {
                return;
            }
            int oldoutbp = this.outbp;
            this.outbp = i;
            this.line.write(this.ob, 0, outlen);
            this.spectCt += outlen / 4;
        }
    }

    class SawtoothWaveform
    extends Waveform {
        int ix;
        short[] smbuf;

        SawtoothWaveform() {
        }

        int getChannels() {
            return 1;
        }

        boolean start() {
            this.getBuffer();
            this.ix = 0;
            this.smbuf = new short[1];
            return true;
        }

        int getData() {
            int i;
            int period = (int)(Math.PI * 2 / DFilterFrame.this.inputW);
            if (period != this.smbuf.length) {
                this.smbuf = new short[period];
                double p2 = (double)period / 2.0;
                i = 0;
                while (i != period) {
                    this.smbuf[i] = (short)(((double)i / p2 - 1.0) * 32000.0);
                    ++i;
                }
            }
            i = 0;
            while (i != this.buffer.length) {
                if (this.ix >= period) {
                    this.ix = 0;
                }
                this.buffer[i] = this.smbuf[this.ix];
                ++i;
                ++this.ix;
            }
            return this.buffer.length;
        }
    }

    class SineWaveform
    extends Waveform {
        int ix;

        SineWaveform() {
        }

        int getChannels() {
            return 1;
        }

        boolean start() {
            this.getBuffer();
            this.ix = 0;
            return true;
        }

        int getData() {
            int i = 0;
            while (i != this.buffer.length) {
                ++this.ix;
                this.buffer[i] = (short)(Math.sin((double)this.ix * DFilterFrame.this.inputW) * 32000.0);
                ++i;
            }
            return this.buffer.length;
        }
    }

    class SquareWaveform
    extends Waveform {
        int ix;
        double omega;
        short[] smbuf;

        SquareWaveform() {
        }

        int getChannels() {
            return 1;
        }

        boolean start() {
            this.getBuffer();
            this.ix = 0;
            this.smbuf = new short[1];
            return true;
        }

        int getData() {
            int i;
            int period = (int)(Math.PI * 2 / DFilterFrame.this.inputW);
            if (period != this.smbuf.length) {
                this.smbuf = new short[period];
                i = 0;
                while (i != period / 2) {
                    this.smbuf[i] = 32000;
                    ++i;
                }
                if ((period & 1) > 0) {
                    this.smbuf[i++] = 0;
                }
                while (i != period) {
                    this.smbuf[i] = -32000;
                    ++i;
                }
            }
            i = 0;
            while (i != this.buffer.length) {
                if (this.ix >= period) {
                    this.ix = 0;
                }
                this.buffer[i] = this.smbuf[this.ix];
                ++i;
                ++this.ix;
            }
            return this.buffer.length;
        }
    }

    class SweepWaveform
    extends Waveform {
        int ix;
        double omega;
        double nextOmega;
        double t;
        double startOmega;

        SweepWaveform() {
        }

        int getChannels() {
            return 1;
        }

        boolean start() {
            this.getBuffer();
            this.ix = 0;
            this.nextOmega = this.omega = 251.32741228718345 / (double)DFilterFrame.this.sampleRate;
            this.startOmega = this.omega;
            this.t = 0.0;
            return true;
        }

        int getData() {
            double nmul = 1.0;
            double nadd = 0.0;
            double maxspeed = 1.0 / (0.66 * (double)DFilterFrame.this.sampleRate);
            double minspeed = 1 / (DFilterFrame.this.sampleRate * 16);
            if (DFilterFrame.this.logFreqCheckItem.getState()) {
                nmul = Math.pow(Math.PI * 2 / this.startOmega, 2.0 * (minspeed + (maxspeed - minspeed) * (double)DFilterFrame.this.inputBar.getValue() / 1000.0));
            } else {
                nadd = (Math.PI * 2 - this.startOmega) * (minspeed + (maxspeed - minspeed) * (double)DFilterFrame.this.inputBar.getValue() / 1000.0);
            }
            int i = 0;
            while (i != this.buffer.length) {
                ++this.ix;
                this.t += this.omega;
                if (this.t > Math.PI * 2) {
                    this.t -= Math.PI * 2;
                    this.omega = this.nextOmega;
                    if (this.nextOmega > Math.PI) {
                        this.omega = this.nextOmega = this.startOmega;
                    }
                }
                this.buffer[i] = (short)(Math.sin(this.t) * 32000.0);
                this.nextOmega = this.nextOmega * nmul + nadd;
                ++i;
            }
            return this.buffer.length;
        }

        String getInputText() {
            return "Sweep Speed";
        }

        boolean needsFrequency() {
            return false;
        }
    }

    class TriangleWaveform
    extends Waveform {
        int ix;
        short[] smbuf;

        TriangleWaveform() {
        }

        int getChannels() {
            return 1;
        }

        boolean start() {
            this.getBuffer();
            this.ix = 0;
            this.smbuf = new short[1];
            return true;
        }

        int getData() {
            int i;
            int period = (int)(Math.PI * 2 / DFilterFrame.this.inputW);
            if (period != this.smbuf.length) {
                this.smbuf = new short[period];
                double p2 = (double)period / 2.0;
                i = 0;
                while ((double)i < p2) {
                    this.smbuf[i] = (short)((double)i / p2 * 64000.0 - 32000.0);
                    ++i;
                }
                while (i != period) {
                    this.smbuf[i] = (short)((2.0 - (double)i / p2) * 64000.0 - 32000.0);
                    ++i;
                }
            }
            i = 0;
            while (i != this.buffer.length) {
                if (this.ix >= period) {
                    this.ix = 0;
                }
                this.buffer[i] = this.smbuf[this.ix];
                ++i;
                ++this.ix;
            }
            return this.buffer.length;
        }
    }

    class View
    extends Rectangle {
        int right;
        int bottom;

        View(Dimension r) {
            super(r);
        }

        View(int a, int b, int c, int d) {
            super(a, b, c, d);
            this.right = a + c - 1;
            this.bottom = b + d - 1;
        }

        void drawLabel(Graphics g, String str) {
            g.setColor(Color.white);
            DFilterFrame.this.centerString(g, str, this.y - 5);
        }
    }

    abstract class Waveform {
        short[] buffer;

        Waveform() {
        }

        boolean start() {
            return true;
        }

        abstract int getData();

        int getChannels() {
            return 2;
        }

        void getBuffer() {
            this.buffer = new short[DFilterFrame.this.getPower2(DFilterFrame.this.sampleRate / 12) * this.getChannels()];
        }

        String getInputText() {
            return "Input Frequency";
        }

        boolean needsFrequency() {
            return true;
        }
    }
}

