/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.DirectFilter;
import cn.org.gddsn.signal.filter.FFT;
import cn.org.gddsn.signal.filter.FIRFilterType;
import cn.org.gddsn.signal.filter.Filter;

class CustomFIRFilter
extends FIRFilterType {
    double[] uresp;

    CustomFIRFilter() {
        if (this.uresp == null) {
            this.uresp = new double[1024];
        }
    }

    int select() {
        this.auxLabels[0] = "Order";
        this.auxBars[0] = 120;
        int i = 0;
        while (i != 512) {
            this.uresp[i] = 1.0;
            ++i;
        }
        return 1;
    }

    void setup() {
    }

    double getUserResponse(double w) {
        double q = this.uresp[(int)(w * (double)this.uresp.length / Math.PI)];
        return q * q;
    }

    void edit(double x, double x2, double y) {
        int xi1 = (int)(x * (double)this.uresp.length);
        int xi2 = (int)(x2 * (double)this.uresp.length);
        while (xi1 < xi2) {
            if (xi1 >= 0 && xi1 < this.uresp.length) {
                this.uresp[xi1] = y;
            }
            ++xi1;
        }
    }

    Filter genFilter() {
        int n = this.auxBars[0];
        int nsz = this.uresp.length * 4;
        double[] fbuf = new double[nsz];
        int nsz2 = nsz / 2;
        int nsz4 = nsz2 / 2;
        int i = 0;
        while (i != nsz4) {
            double ur;
            fbuf[i * 2] = ur = this.uresp[i] / (double)nsz2;
            if (i > 0) {
                fbuf[nsz - i * 2] = ur;
            }
            ++i;
        }
        new FFT(nsz2).transform(fbuf, true);
        DirectFilter f = new DirectFilter();
        f.aList = new double[n];
        f.nList = new int[n];
        i = 0;
        while (i != n) {
            int i2 = (i - n / 2) * 2;
            f.aList[i] = fbuf[i2 & nsz - 1] * this.getWindow(i, n);
            f.nList[i] = i;
            ++i;
        }
        this.setResponse(f);
        return f;
    }

    void getInfo(String[] x) {
        int n = this.auxBars[0];
        x[0] = "Order: " + n;
    }

    boolean needsWindow() {
        return true;
    }
}

