/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.DirectFilter;
import cn.org.gddsn.signal.filter.FIRFilterType;
import cn.org.gddsn.signal.filter.Filter;

class BoxFilter
extends FIRFilterType {
    double cw;
    double r;
    double norm;
    int n;

    BoxFilter() {
    }

    int select() {
        this.auxLabels[0] = "Fundamental Freq";
        this.auxBars[0] = 500;
        this.auxLabels[1] = "Position";
        this.auxBars[1] = 300;
        this.auxLabels[2] = "Length/Width";
        this.auxBars[2] = 100;
        this.auxLabels[3] = "Order";
        this.auxBars[3] = 100;
        return 4;
    }

    void setCutoff(double f) {
    }

    void setup() {
        this.cw = (double)this.auxBars[0] * Math.PI / 1000.0;
        if (this.cw < 0.147) {
            this.cw = 0.147;
        }
        this.r = (double)this.auxBars[1] / 1000.0;
        this.n = this.auxBars[3];
    }

    Filter genFilter() {
        int j;
        DirectFilter f = new DirectFilter();
        int nn = 20;
        double[][] ws = new double[nn][nn];
        double[][] mg = new double[nn][nn];
        double px = this.r * Math.PI;
        double py = 1.5707963267948966;
        double ly = (double)this.auxBars[2] / 100.0;
        int i = 0;
        while (i != nn) {
            j = 0;
            while (j != nn) {
                ws[i][j] = this.cw * Math.sqrt((double)(i * i) + (double)(j * j) / ly);
                mg[i][j] = Math.cos((double)i * px) * Math.cos((double)j * py);
                ++j;
            }
            ++i;
        }
        mg[0][0] = 0.0;
        f.aList = new double[this.n];
        double sum = 0.0;
        double ecoef = -2.5 / (double)this.n;
        int k = 0;
        while (k != this.n) {
            double q = 0.0;
            i = 0;
            while (i != nn) {
                j = 0;
                while (j != nn) {
                    double ph = (double)k * ws[i][j];
                    q += mg[i][j] * Math.cos(ph);
                    ++j;
                }
                ++i;
            }
            f.aList[k] = q * Math.exp(ecoef * (double)k);
            sum += q;
            ++k;
        }
        i = 0;
        while (i != this.n) {
            int n = i++;
            f.aList[n] = f.aList[n] / sum;
        }
        this.setResponse(f);
        return f;
    }

    void getInfo(String[] x) {
        x[0] = "Order: " + this.n;
    }
}

