/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

import cn.org.gddsn.signal.FFT;

public class Hilbert {
    private Hilbert() {
    }

    public static double[] hilbert(double[] xr) {
        int j;
        FFT FFT2 = new FFT();
        double[] im = new double[xr.length];
        FFT2.doFFT(xr, im, xr.length, 1);
        double[] h = new double[xr.length];
        if (xr.length % 2 == 0) {
            h[0] = 1.0;
            h[xr.length / 2] = 1.0;
            j = 1;
            while (j < xr.length / 2) {
                h[j] = 2.0;
                ++j;
            }
        } else {
            h[0] = 1.0;
            j = 1;
            while (j <= (xr.length + 1) / 2) {
                h[j] = 2.0;
                ++j;
            }
        }
        double[] fr = FFT2.getReal();
        double[] fi = FFT2.getIm();
        int j2 = 0;
        while (j2 < xr.length) {
            int n = j2;
            fr[n] = fr[n] * h[j2];
            int n2 = j2;
            fi[n2] = fi[n2] * h[j2];
            ++j2;
        }
        FFT2.doFFT(fr, fi, fr.length, -1);
        return FFT2.getIm();
    }

    public static void main(String[] args) {
        double[] xr = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0};
        double[] h = Hilbert.hilbert(xr);
        int i = 0;
        while (i < h.length) {
            System.out.println(h[i]);
            ++i;
        }
    }
}

