/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

import cn.org.gddsn.signal.FIRFilterDoubleH;
import cn.org.gddsn.signal.FIRFilterDoubleZ;

public class FIRFilter {
    protected int ntaps;
    protected double[] h;
    protected double[] z;
    protected int state = 0;

    public double[] filt(double[] xn) {
        double[] yn = new double[xn.length];
        int k = 0;
        while (k < yn.length) {
            this.z[this.state] = xn[k];
            int i = 0;
            while (i < this.ntaps) {
                int n = k;
                yn[n] = yn[n] + this.h[i] * this.z[(this.state - i + this.ntaps) % this.ntaps];
                ++i;
            }
            ++this.state;
            this.state %= this.ntaps;
            ++k;
        }
        return yn;
    }

    public double filt(double input) {
        return this.filt_split(input);
    }

    public double filt_basic(double input) {
        this.z[0] = input;
        double accum = 0.0;
        int ii = 0;
        while (ii < this.ntaps) {
            accum += this.h[ii] * this.z[ii];
            ++ii;
        }
        ii = this.ntaps - 2;
        while (ii >= 0) {
            this.z[ii + 1] = this.z[ii];
            --ii;
        }
        return accum;
    }

    public double filt_shuffle(double input) {
        this.z[0] = input;
        double accum = this.h[this.ntaps - 1] * this.z[this.ntaps - 1];
        int ii = this.ntaps - 2;
        while (ii >= 0) {
            accum += this.h[ii] * this.z[ii];
            this.z[ii + 1] = this.z[ii];
            --ii;
        }
        return accum;
    }

    public double filt_circular(double input) {
        this.z[this.state] = input;
        if (++this.state >= this.ntaps) {
            this.state = 0;
        }
        double accum = 0.0;
        int ii = this.ntaps - 1;
        while (ii >= 0) {
            accum += this.h[ii] * this.z[this.state];
            if (++this.state >= this.ntaps) {
                this.state = 0;
            }
            --ii;
        }
        return accum;
    }

    public double filt_split(double input) {
        double accum = 0.0;
        int p_h = 0;
        int p_z = 0 + this.state;
        this.z[p_z] = input;
        int end_ntaps = this.ntaps - this.state;
        int ii = 0;
        while (ii < end_ntaps) {
            accum += this.h[p_h++] * this.z[p_z++];
            ++ii;
        }
        p_z = 0;
        ii = 0;
        while (ii < this.state) {
            accum += this.h[p_h++] * this.z[p_z++];
            ++ii;
        }
        if (--this.state < 0) {
            this.state += this.ntaps;
        }
        return accum;
    }

    public double[] getH() {
        return this.h;
    }

    public void setH(double[] b) {
        this.ntaps = b.length;
        this.h = new double[this.ntaps];
        System.arraycopy(b, 0, this.h, 0, this.ntaps);
        this.z = new double[this.ntaps];
        this.state = 0;
    }

    public static void main(String[] args) {
        double output;
        int NTAPS = 6;
        double[] h = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        int IMP_SIZE = 3 * NTAPS;
        double[] imp = new double[IMP_SIZE];
        imp[5] = 1.0;
        System.out.printf("Testing fir_basic:\n   ", new Object[0]);
        FIRFilter fir = new FIRFilter();
        fir.setH(h);
        int ii = 0;
        while (ii < IMP_SIZE) {
            output = fir.filt_basic(imp[ii]);
            System.out.printf("%3.1f ", output);
            ++ii;
        }
        System.out.printf("\n\n", new Object[0]);
        System.out.printf("Testing fir_shuffle:\n   ", new Object[0]);
        fir = new FIRFilter();
        fir.setH(h);
        ii = 0;
        while (ii < IMP_SIZE) {
            output = fir.filt_shuffle(imp[ii]);
            System.out.printf("%3.1f ", output);
            ++ii;
        }
        System.out.printf("\n\n", new Object[0]);
        System.out.printf("Testing fir_circular:\n   ", new Object[0]);
        fir = new FIRFilter();
        fir.setH(h);
        ii = 0;
        while (ii < IMP_SIZE) {
            output = fir.filt_circular(imp[ii]);
            System.out.printf("%3.1f ", output);
            ++ii;
        }
        System.out.printf("\n\n", new Object[0]);
        System.out.printf("Testing fir_split:\n   ", new Object[0]);
        fir = new FIRFilter();
        fir.setH(h);
        ii = 0;
        while (ii < IMP_SIZE) {
            output = fir.filt_split(imp[ii]);
            System.out.printf("%3.1f ", output);
            ++ii;
        }
        System.out.printf("\n\n", new Object[0]);
        System.out.printf("Testing fir_double_z:\n   ", new Object[0]);
        fir = new FIRFilterDoubleZ();
        fir.setH(h);
        ii = 0;
        while (ii < IMP_SIZE) {
            output = fir.filt(imp[ii]);
            System.out.printf("%3.1f ", output);
            ++ii;
        }
        System.out.printf("\n\n", new Object[0]);
        System.out.printf("Testing fir_double_h:\n   ", new Object[0]);
        fir = new FIRFilterDoubleH();
        fir.setH(h);
        ii = 0;
        while (ii < IMP_SIZE) {
            output = fir.filt(imp[ii]);
            System.out.printf("%3.1f ", output);
            ++ii;
        }
        fir = new FIRFilter();
        double[] b = new double[]{0.3, 0.51, 0.1};
        fir.setH(b);
        double[] x = new double[100];
        int i = 0;
        while (i < x.length) {
            x[i] = (double)i * 0.1;
            ++i;
        }
        fir.filt(x);
    }
}

