/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.semaphore;

import cn.org.gddsn.semaphore.MultiReadOneWrite;

public class TestReadWrite
implements Runnable {
    public static final int IDLE = 0;
    public static final int READING = 1;
    public static final int WRITING = 2;
    private static int nextIdx = 0;
    private static Object lock = new Object();
    private int stateIdx;
    private static int[] states = new int[6];
    private MultiReadOneWrite controller;

    public static void main(String[] args) {
        MultiReadOneWrite that = new MultiReadOneWrite();
        Thread t1 = new Thread(new TestReadWrite(that));
        Thread t2 = new Thread(new TestReadWrite(that));
        Thread t3 = new Thread(new TestReadWrite(that));
        Thread t4 = new Thread(new TestReadWrite(that));
        Thread t5 = new Thread(new TestReadWrite(that));
        t1.start();
        t2.start();
        t3.start();
        t4.start();
        t5.start();
    }

    public TestReadWrite(MultiReadOneWrite c) {
        this.controller = c;
        this.stateIdx = nextIdx++;
    }

    public void run() {
        while (true) {
            if (Math.random() > 0.1) {
                this.controller.enterRead();
                TestReadWrite.states[this.stateIdx] = 1;
                this.showStates();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                TestReadWrite.states[this.stateIdx] = 0;
                this.controller.leaveRead();
                this.showStates();
                continue;
            }
            this.controller.enterWrite();
            TestReadWrite.states[this.stateIdx] = 2;
            this.showStates();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TestReadWrite.states[this.stateIdx] = 0;
            this.controller.leaveWrite();
            this.showStates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showStates() {
        Object object = lock;
        synchronized (object) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int i = 0;
            while (i < nextIdx) {
                System.out.print(states[i] == 0 ? "@" : (states[i] == 1 ? "R" : "W"));
                ++i;
            }
            System.out.println();
        }
    }
}

