/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.rts;

import cn.org.gddsn.liss.client.LissClient;
import cn.org.gddsn.liss.client.LissException;
import cn.org.gddsn.liss.client.LissOutputStream;
import cn.org.gddsn.liss.port.MiniSeedHeaderFilter;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import cn.org.gddsn.seis.rts.NotifyAction;
import cn.org.gddsn.util.Log4jConfig;
import edu.iris.miniseedutils.steim.GenericCompressMiniSeedRecord;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;

public class Event2Server
implements Runnable {
    static Logger logger = Logger.getLogger(Event2Server.class);
    private LissClient lissClient = null;
    private MiniSeedHeaderFilter miniSeedHeaderFilter = null;
    private String eventDirectory;
    private Map stationMap = null;
    private BufferedOutputStream socketOutputStream = null;
    private EvtData evtData;
    private String defaultNetworkId = "DZ";
    private boolean orderByTime = true;
    private int sleepMs = 250;
    private NotifyAction notifyAction;
    private Hashtable<ChannelLocator, List<GenericMiniSeedRecord>> glist = new Hashtable();

    public void run() {
        try {
            this.processDirectory(new File(this.eventDirectory));
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    private void connectServer(String[] stnCodes) throws Exception {
        this.lissClient.init();
        String[] stringArray = stnCodes;
        int n = stnCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String ns = stringArray[n2];
            try {
                this.lissClient.addStation(new String[]{ns});
            }
            catch (LissException ex) {
                logger.info(ex);
            }
            ++n2;
        }
        this.lissClient.setRtServerPassiveMode(true);
        LissOutputStream lissOutputStream = null;
        lissOutputStream = this.lissClient.storeRealTimeStream(stnCodes);
        this.socketOutputStream = new BufferedOutputStream(lissOutputStream);
        if (this.notifyAction != null) {
            this.notifyAction.action();
        }
    }

    private void closeServer() throws Exception {
        this.socketOutputStream.close();
        this.lissClient.quit();
    }

    private void processDirectory(File dir) throws Exception {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.processDirectory(files[i]);
            } else {
                this.processFile(files[i]);
            }
            ++i;
        }
    }

    public void processEvtData() throws Exception {
        int tch = this.evtData.getTCN();
        String[] stnCodes = new String[tch];
        int i = 0;
        while (i < tch) {
            String stn;
            ChannelLocator cl = this.evtData.getChannelLocator(i);
            String net = cl.getNetCode();
            if (net.equals("XX")) {
                net = this.defaultNetworkId;
                logger.info("rename networkID to default: " + this.defaultNetworkId);
            }
            if ((stn = (String)this.stationMap.get(cl.getStationCode())) != null) {
                stnCodes[i] = String.valueOf(net) + "/" + stn;
                logger.info("rename " + cl.getStationCode() + " to " + stn);
            } else {
                stnCodes[i] = String.valueOf(net) + "/" + cl.getStationCode();
            }
            ++i;
        }
        if (this.orderByTime) {
            int maxSize = -1;
            int i2 = 0;
            while (i2 < tch) {
                int size = this.processTimeSeries(this.evtData.getTimeSeries(i2), stnCodes[i2]);
                if (size > maxSize) {
                    maxSize = size;
                }
                ++i2;
            }
            logger.info("sort waveform by time.");
            this.connectServer(stnCodes);
            logger.info("connected SSS");
            boolean hasData = true;
            long ms = this.evtData.getArrivalTime(0).getTime();
            boolean addTime = true;
            while (hasData) {
                hasData = false;
                addTime = true;
                if (addTime) {
                    ms += 1000L;
                }
                Thread.sleep(this.sleepMs);
                Collection<List<GenericMiniSeedRecord>> c = this.glist.values();
                for (List<GenericMiniSeedRecord> list : c) {
                    if (list.size() <= 0) continue;
                    hasData = true;
                    GenericMiniSeedRecord g = list.get(0);
                    if (ms <= g.getStartTime().getTime()) continue;
                    this.socketOutputStream.write(g.getBytes());
                    list.remove(0);
                    addTime = false;
                }
            }
            logger.info("sent waveform to SSS");
        } else {
            this.connectServer(stnCodes);
            logger.info("connected SSS");
            i = 0;
            while (i < tch) {
                this.processTimeSeries(this.evtData.getTimeSeries(i), stnCodes[i]);
                ++i;
            }
            logger.info("sent waveform to SSS");
        }
        this.closeServer();
        logger.info("closed SSS");
    }

    private void processFile(File evtFile) throws Exception {
        try {
            this.evtData = EvtData.readEvtData(evtFile.getPath());
        }
        catch (Exception ex) {
            logger.info(ex.getMessage(), ex);
        }
        if (this.evtData != null) {
            this.processEvtData();
        } else {
            logger.warn("could not process " + evtFile);
        }
    }

    private int processTimeSeries(TimeSeries ts, String netStation) throws IOException {
        LinkedList<GenericMiniSeedRecord> list = new LinkedList<GenericMiniSeedRecord>();
        this.glist.put(ts.getChannelLocator(), list);
        short steimLevel = 2;
        short dframes = 7;
        GenericCompressMiniSeedRecord cmsr = new GenericCompressMiniSeedRecord(steimLevel, dframes);
        cmsr.setStartTime(new TimeStamp(ts.getArrivalTime().getTime()));
        cmsr.setSampleRate((int)ts.getSampleRate());
        logger.info("process channel: " + ts.getChannelLocator());
        int idx = netStation.indexOf(47);
        cmsr.setStationInfo(netStation.substring(0, idx), netStation.substring(idx + 1), ts.getAuxId(), ts.getChannelCode());
        cmsr.setActivityFlag(0);
        double[] sdata = ts.getSampData();
        int[] buf = new int[sdata.length];
        int j = 0;
        while (j < buf.length) {
            buf[j] = (int)sdata[j];
            ++j;
        }
        int nSamps = cmsr.encodeMiniSeedRecord(buf, buf.length);
        if (nSamps != buf.length) {
            logger.warn("Error in handle gaps data");
        }
        Vector vec = cmsr.getComressFrame();
        Enumeration Enum2 = vec.elements();
        while (Enum2.hasMoreElements()) {
            byte[] msBytes = (byte[])Enum2.nextElement();
            if (this.orderByTime) {
                list.add(GenericMiniSeedRecord.buildMiniSeedRecord(this.filtMiniSeedHead(msBytes)));
                continue;
            }
            this.socketOutputStream.write(this.filtMiniSeedHead(msBytes));
        }
        return list.size();
    }

    private byte[] filtMiniSeedHead(byte[] buf) {
        if (this.miniSeedHeaderFilter == null) {
            return buf;
        }
        GenericMiniSeedRecord gmsr = this.miniSeedHeaderFilter.filter(GenericMiniSeedRecord.buildMiniSeedRecord(buf));
        return gmsr.getBytes();
    }

    public String getEventDirectory() {
        return this.eventDirectory;
    }

    public void setEventDirectory(String eventDirectory) {
        this.eventDirectory = eventDirectory;
    }

    public LissClient getLissClient() {
        return this.lissClient;
    }

    public void setLissClient(LissClient lissClient) {
        this.lissClient = lissClient;
    }

    public void setMiniSeedHeaderFilter(MiniSeedHeaderFilter miniSeedHeaderFilter) {
        this.miniSeedHeaderFilter = miniSeedHeaderFilter;
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain("Event2Server.properties");
        FileSystemResource res = new FileSystemResource("Event2Server.xml");
        XmlBeanFactory factory = new XmlBeanFactory(res);
        Event2Server event2Server = (Event2Server)factory.getBean("event2Server");
        event2Server.run();
    }

    public String getDefaultNetworkId() {
        return this.defaultNetworkId;
    }

    public void setDefaultNetworkId(String defaultNetworkId) {
        this.defaultNetworkId = defaultNetworkId;
    }

    public Map getStationMap() {
        return this.stationMap;
    }

    public void setStationMap(Map stationMap) {
        this.stationMap = stationMap;
    }

    public boolean isOrderByTime() {
        return this.orderByTime;
    }

    public void setOrderByTime(boolean orderByTime) {
        this.orderByTime = orderByTime;
    }

    public int getSleepMs() {
        return this.sleepMs;
    }

    public void setSleepMs(int sleepMs) {
        this.sleepMs = sleepMs;
    }

    public void setEvtData(EvtData evtData) {
        this.evtData = evtData;
    }

    public NotifyAction getNotifyAction() {
        return this.notifyAction;
    }

    public void setNotifyAction(NotifyAction notifyAction) {
        this.notifyAction = notifyAction;
    }
}

