/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.regions.geotools;

import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.regions.geotools.CreateFeature;
import cn.org.gddsn.seis.regions.geotools.DataResource;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;

public class GeoUtils {
    static Logger logger = Logger.getLogger(GeoUtils.class);

    private static double Rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static FeatureIterator loadShpFile(String filename) {
        long now_ms = System.currentTimeMillis();
        FeatureIterator iterator = null;
        try {
            ShapefileDataStore shpDataStore = new ShapefileDataStore(DataResource.toURL(filename));
            FeatureSource fs = shpDataStore.getFeatureSource();
            FeatureCollection features = fs.getFeatures();
            logger.info("***feature size=" + features.size());
            iterator = features.features();
        }
        catch (Exception e) {
            logger.info("load shpfile occur exception: " + e.getMessage());
        }
        logger.info("Load shpfile time: " + (System.currentTimeMillis() - now_ms));
        return iterator;
    }

    public static SimpleFeature seisCounty(SourceParam sourceParam) {
        SimpleFeature simpleFeature = null;
        Object features = null;
        FeatureIterator iterator = GeoUtils.loadShpFile(DataResource.COUNTY_SHP);
        CreateFeature cf = new CreateFeature();
        Geometry g_point = (Geometry)cf.genSeisFeature(sourceParam).getDefaultGeometry();
        Geometry g_polygon = null;
        System.out.println("### step2: filter county feature   size=" + features.size());
        try {
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                g_polygon = (Geometry)feature.getDefaultGeometry();
                if (!g_point.within(g_polygon)) continue;
                simpleFeature = feature;
                System.out.println("ok find county, id=" + feature.getID());
                break;
            }
        }
        finally {
            iterator.close();
        }
        return simpleFeature;
    }

    public static boolean needReport(double lat, double lon, double ms) {
        Point ptG;
        Object geoName = null;
        Coordinate ptc = new Coordinate(lon, lat);
        GeometryFactory geomFac = new GeometryFactory();
        Point g_point = ptG = geomFac.createPoint(ptc);
        FeatureIterator iterator = GeoUtils.loadShpFile(DataResource.QUICK_REPORT_RANGE_SHP);
        Geometry g_polygon = null;
        boolean bReport = false;
        try {
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                g_polygon = (Geometry)feature.getDefaultGeometry();
                double msAttr = (Double)feature.getAttribute(5);
                if (!g_point.within(g_polygon)) continue;
                System.out.println("yes it is within " + feature.getAttribute(1) + "kilometers");
                if (ms >= msAttr) {
                    System.out.println("and ms>= " + msAttr + " so should report !!!");
                    bReport = true;
                } else {
                    System.out.println("but ms=" + ms + " <" + msAttr + " so no report");
                }
                break;
            }
        }
        finally {
            iterator.close();
        }
        return bReport;
    }

    public static double distanceOfTwoPoints(double lat1, double lng1, double lat2, double lng2, GaussSphere gs) {
        double radLat1 = GeoUtils.Rad(lat1);
        double radLat2 = GeoUtils.Rad(lat2);
        double a = GeoUtils.Rad(lat1) - GeoUtils.Rad(lat2);
        double b = GeoUtils.Rad(lng1) - GeoUtils.Rad(lng2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= gs == GaussSphere.WGS84 ? 6378137.0 : (gs == GaussSphere.Xian80 ? 6378140.0 : 6378245.0);
        s = Math.round(s * 10000.0) / 10000L;
        return s;
    }

    public static double distanceFromCity(double lat, double lon) {
        double distance = 4.084070449666731E7;
        double tmp = 0.0;
        SimpleFeature f = null;
        long now_ms = System.currentTimeMillis();
        FeatureIterator iterator = GeoUtils.loadShpFile(DataResource.POINT_DISHI_SHP);
        try {
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                tmp = GeoUtils.distanceOfTwoPoints(lat, lon, feature.getBounds().getMinY(), feature.getBounds().getMinX(), GaussSphere.WGS84);
                if (!(distance >= tmp)) continue;
                distance = tmp;
                f = feature;
            }
        }
        finally {
            iterator.close();
        }
        logger.info("*** total cal time: " + (System.currentTimeMillis() - now_ms));
        String name1 = (String)f.getAttribute(1);
        String name = null;
        try {
            name = new String(name1.getBytes("ISO8859-1"), "GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        logger.info("nearest distance=" + distance / 1000.0 + "km,  name = " + name);
        return distance / 1000.0;
    }

    public static double distanceFromCounty(double lat, double lon) {
        double distance = 4.084070449666731E7;
        double tmp = 0.0;
        SimpleFeature f = null;
        long now_ms = System.currentTimeMillis();
        FeatureIterator iterator = GeoUtils.loadShpFile(DataResource.POINT_XIAN_SHP);
        try {
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                tmp = GeoUtils.distanceOfTwoPoints(lat, lon, feature.getBounds().getMinY(), feature.getBounds().getMinX(), GaussSphere.WGS84);
                if (!(distance >= tmp)) continue;
                distance = tmp;
                f = feature;
            }
        }
        finally {
            iterator.close();
        }
        logger.info("*** total cal time: " + (System.currentTimeMillis() - now_ms));
        String name1 = (String)f.getAttribute(1);
        String name = null;
        try {
            name = new String(name1.getBytes("ISO8859-1"), "GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        logger.info("nearest distance=" + distance / 1000.0 + "km,  name = " + name);
        return distance / 1000.0;
    }

    public static void main(String[] args) {
        GeoUtils.needReport(23.2, 112.3, 3.5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GaussSphere {
        Beijing54,
        Xian80,
        WGS84;

    }
}

