/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.regions.geotools;

import cn.org.gddsn.seis.regions.RegionsFE;
import cn.org.gddsn.seis.regions.geotools.DataResource;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;

public class GeoRegion {
    static Logger logger = Logger.getLogger(GeoRegion.class);
    private static FeatureCollection features = null;

    static {
        GeoRegion.loadShpFile();
    }

    private static FeatureCollection loadShpFile() {
        long now_ms = System.currentTimeMillis();
        try {
            ShapefileDataStore shpDataStore = new ShapefileDataStore(DataResource.toURL(DataResource.COUNTY_SHP));
            FeatureSource fs = shpDataStore.getFeatureSource();
            features = fs.getFeatures();
        }
        catch (Exception e) {
            logger.info("load shpfile occur exception");
            e.printStackTrace();
        }
        return features;
    }

    public static String getPointName(double lat, double lon) {
        long now_ms;
        String geoName;
        block8: {
            Point ptG;
            geoName = null;
            if (features == null) {
                return RegionsFE.getRegionName(lat, lon);
            }
            Coordinate ptc = new Coordinate(lon, lat);
            GeometryFactory geomFac = new GeometryFactory();
            Point g_point = ptG = geomFac.createPoint(ptc);
            now_ms = System.currentTimeMillis();
            FeatureIterator iterator = features.features();
            try {
                try {
                    while (iterator.hasNext()) {
                        Geometry g_polygon;
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        if (!feature.getBounds().contains(lon, lat) || !g_point.within(g_polygon = (Geometry)feature.getDefaultGeometry())) continue;
                        String fullname = (String)feature.getAttribute(3);
                        geoName = new String(fullname.getBytes("ISO8859-1"), "GBK");
                        logger.info("Found county, id=" + feature.getID() + ", name=" + geoName);
                        break;
                    }
                }
                catch (Exception e) {
                    logger.info("search occur exception");
                    e.printStackTrace();
                    iterator.close();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                iterator.close();
                throw throwable;
            }
            iterator.close();
        }
        logger.info("*** Searching time: " + (System.currentTimeMillis() - now_ms));
        if (geoName == null) {
            return RegionsFE.getRegionName(lat, lon);
        }
        return geoName;
    }

    public static String getName(double lat, double lon) {
        long now_ms;
        String geoName;
        block8: {
            Point ptG;
            geoName = null;
            Coordinate ptc = new Coordinate(lon, lat);
            GeometryFactory geomFac = new GeometryFactory();
            Point g_point = ptG = geomFac.createPoint(ptc);
            now_ms = System.currentTimeMillis();
            FeatureIterator iterator = features.features();
            String[][] comStrs = new String[10][2];
            int count = 0;
            try {
                try {
                    while (iterator.hasNext()) {
                        String tmpName;
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        Geometry g_polygon = (Geometry)feature.getDefaultGeometry();
                        if (!(g_point.distance(g_polygon) <= 0.08992805755395683)) continue;
                        String fullname = (String)feature.getAttribute(3);
                        comStrs[count][0] = tmpName = new String(fullname.getBytes("ISO8859-1"), "GBK");
                        comStrs[count][1] = Float.toString((float)Math.round(g_point.distance(g_polygon) * 111.2 * 10.0) / 10.0f);
                        logger.info("\u8ddd\u79bb " + tmpName + " " + comStrs[count][1] + "km");
                        ++count;
                    }
                    logger.info("find matched name count = " + count);
                    if (count > 0) {
                        geoName = GeoRegion.assembleNames(comStrs, count);
                    }
                }
                catch (Exception e) {
                    logger.info("error " + e.getMessage());
                    iterator.close();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                iterator.close();
                throw throwable;
            }
            iterator.close();
        }
        logger.info("*** Searching time: " + (System.currentTimeMillis() - now_ms));
        if (geoName == null) {
            return RegionsFE.getRegionName(lat, lon);
        }
        return geoName;
    }

    public static String assembleNames(String[][] comStrs, int count) {
        StringBuilder geoName = new StringBuilder();
        String finalName = null;
        if (count == 1) {
            geoName.append(comStrs[0][0]);
            finalName = geoName.substring(0);
        } else if (!GeoRegion.isSamePro(comStrs, count)) {
            comStrs = GeoRegion.arrangSeq(comStrs, count);
            int i = 0;
            while (i < count - 1) {
                geoName.append(String.valueOf(comStrs[i][0]) + ",");
                ++i;
            }
            geoName.append(String.valueOf(comStrs[count - 1][0]) + " \u4ea4\u754c");
            finalName = geoName.substring(0);
        } else {
            comStrs = GeoRegion.arrangSeq(comStrs, count);
            boolean onlyOne = false;
            int i = 0;
            while (i < count) {
                if (!(Float.parseFloat(comStrs[i][1]) <= 5.0f)) {
                    if (i != 1) break;
                    onlyOne = true;
                    break;
                }
                geoName.append(String.valueOf(comStrs[i][0]) + ",");
                ++i;
            }
            geoName.append("\u4ea4\u754c");
            finalName = geoName.substring(0);
            finalName = onlyOne ? finalName.replace(",\u4ea4\u754c", "") : finalName.replace(",\u4ea4\u754c", " \u4ea4\u754c");
        }
        return finalName;
    }

    public static String[][] arrangSeq(String[][] comStrs, int count) {
        String[][] newComStrs = new String[count][2];
        float[] dis = new float[count];
        int i = 0;
        while (i < count) {
            dis[i] = Float.parseFloat(comStrs[i][1]);
            ++i;
        }
        int locId = 0;
        int j = 0;
        while (j < count) {
            float tmp = 10.0f;
            int k = 0;
            while (k < count) {
                if (dis[k] <= tmp) {
                    tmp = dis[k];
                    locId = k;
                }
                ++k;
            }
            dis[locId] = 11.0f;
            newComStrs[j][0] = comStrs[locId][0];
            newComStrs[j][1] = comStrs[locId][1];
            ++j;
        }
        return newComStrs;
    }

    public static boolean isSamePro(String[][] comStrs, int count) {
        boolean samePro = true;
        String proName0 = comStrs[0][0].substring(0, 3);
        int m = 0;
        while (m < count) {
            String proNameM = comStrs[m][0].substring(0, 3);
            if (!proNameM.equals(proName0)) {
                samePro = false;
            }
            ++m;
        }
        return samePro;
    }

    public static void main(String[] args) {
        DOMConfigurator.configure("log4j.xml");
        double lat = 22.00238;
        double lon = 73.96417;
        long testCount = 0L;
        while (true) {
            logger.info("***************** test_" + testCount + " name(" + lat + "," + lon + ")***************************");
            logger.info(GeoRegion.getName(lat, lon));
            ++testCount;
            if ((lon += 1.0) < 136.0) continue;
            lon = 73.96417;
            if (!((lat += 1.0) < 54.0)) break;
        }
    }
}

