/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.regions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class RegionsFE {
    private static final short[][] feGeoRegionsArray = new short[182][362];
    private static final String[] feGeoRegionsNames;

    static {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(RegionsFE.class.getResourceAsStream("ferdata.dat")));
            int i = 0;
            while (i < 182) {
                String line = br.readLine();
                StringTokenizer st = new StringTokenizer(line, " ,");
                int j = 0;
                while (j < 362) {
                    RegionsFE.feGeoRegionsArray[i][j] = Short.parseShort(st.nextToken());
                    ++j;
                }
                ++i;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Error readding resource ferdata.dat");
        }
        feGeoRegionsNames = new String[]{"Central Alaska", "Southern Alaska", "Bering Sea", "Komandorskiye Ostrova Region", "Near Islands, Aleutian Islands", "Rat Islands, Aleutian Islands", "Andreanof Islands, Aleutian Islands", "Pribilof Islands, Alaska Region", "Fox Islands, Aleutian Islands", "Unimak Island Region, Alaska", "Bristol Bay", "Alaska Peninsula", "Kodiak Island Region, Alaska", "Kenai Peninsula, Alaska", "Gulf of Alaska", "South of Aleutian Islands", "South of Alaska", "Southern Yukon Territory, Canada", "Southeastern Alaska", "Off Coast of Southeastern Alaska", "West of Vancouver Island", "Queen Charlotte Islands Region", "British Columbia, Canada", "Alberta, Canada", "Vancouver Island, Canada Region", "Off Coast of Washington", "Near Coast of Washington", "Washington-Oregon Border Region", "Washington", "Off Coast of Oregon", "Near Coast of Oregon", "Oregon", "Western Idaho", "Off Coast of N. California", "Near Coast of N. California", "Northern California", "Nevada", "Off Coast of California", "Central California", "California-Nevada Border Region", "Southern Nevada", "Western Arizona", "Southern California", "California-Arizona Border Region", "Calif.-Baja Calif. Border Region", "W. Arizona-Sonora Border Region", "Off W Coast of Baja California", "Baja California, Mexico", "Gulf of California", "Sonora, Mexico", "Off Coast of Central Mexico", "Near Coast of Central Mexico", "Revilla Gigedo Islands Region", "Off Coast of Jalisco, Mexico", "Near Coast of Jalisco, Mexico", "Near Coast of Michoacan, Mexico", "Michoacan, Mexico", "Near Coast of Guerrero, Mexico", "Guerrero, Mexico", "Oaxaca, Mexico", "Chiapas, Mexico", "Mexico-Guatemala Border Region", "Off Coast of Mexico", "Off Coast of Michoacan, Mexico", "Off Coast of Guerrero, Mexico", "Near Coast of Oaxaca, Mexico", "Off Coast of Oaxaca, Mexico", "Off Coast of Chiapas, Mexico", "Near Coast of Chiapas, Mexico", "Guatemala", "Near Coast of Guatemala", "Honduras", "El Salvador", "Near Coast of Nicaragua", "Nicaragua", "Off Coast of Central America", "Off Coast of Costa Rica", "Costa Rica", "North of Panama", "Panama-Costa Rica Border Region", "Panama", "Panama-Colombia Border Region", "South of Panama", "Yucatan Peninsula, Mexico", "Cuba Region", "Jamaica Region", "Haiti Region", "Dominican Republic Region", "Mona Passage", "Puerto Rico Region", "Virgin Islands", "Leeward Islands", "Belize", "Caribbean Sea", "Windward Islands", "Near North Coast of Colombia", "Near Coast of Venezuela", "Trinidad", "Northern Colombia", "Lake Maracaibo, Venezuela", "Venezuela", "Near West Coast of Colombia", "Colombia", "Off Coast of Ecuador", "Near Coast of Ecuador", "Colombia-Ecuador Border Region", "Ecuador", "Off Coast of Northern Peru", "Near Coast of Northern Peru", "Peru-Ecuador Border Region", "Northern Peru", "Peru-Brazil Border Region", "Western Brazil", "Off Coast of Peru", "Near Coast of Peru", "Central Peru", "Southern Peru", "Peru-Bolivia Border Region", "Northern Bolivia", "Central Bolivia", "Off Coast of Northern Chile", "Near Coast of Northern Chile", "Northern Chile", "Chile-Bolivia Border Region", "Southern Bolivia", "Paraguay", "Chile-Argentina Border Region", "Jujuy Province, Argentina", "Salta Province, Argentina", "Catamarca Province, Argentina", "Tucuman Province, Argentina", "Santiago Del Estero Prov., Argentina", "Northeastern Argentina", "Off Coast of Central Chile", "Near Coast of Central Chile", "Central Chile", "San Juan Province, Argentina", "La Rioja Province, Argentina", "Mendoza Province, Argentina", "San Luis Province, Argentina", "Cordoba Province, Argentina", "Uruguay", "Off Coast of Southern Chile", "Southern Chile", "S. Chile-Argentina Border Region", "Southern Argentina", "Tierra Del Fuego", "Falkland Islands Region", "Drake Passage", "Scotia Sea", "South Georgia Island Region", "South Georgia Rise", "South Sandwich Islands Region", "South Shetland Islands", "Antarctic Peninsula", "Southwestern Atlantic Ocean", "Weddell Sea", "Off W. Coast of N. Island, N.Z.", "North Island, New Zealand", "Off E. Coast of N. Island, N.Z.", "Off W. Coast of S. Island, N.Z.", "South Island, New Zealand", "Cook Strait, New Zealand", "Off E. Coast of S. Island, N.Z.", "North of Macquarie Island", "Auckland Islands, N.Z. Region", "Macquarie Island Region", "South of New Zealand", "Samoa Islands Region", "Samoa Islands", "South of Fiji Islands", "West of Tonga Islands", "Tonga Islands", "Tonga Islands Region", "South of Tonga Islands", "North of New Zealand", "Kermadec Islands Region", "Kermadec Islands, New Zealand", "South of Kermadec Islands", "North of Fiji Islands", "Fiji Islands Region", "Fiji Islands", "Santa Cruz Islands Region", "Santa Cruz Islands", "Vanuatu Islands Region", "Vanuatu Islands", "New Caledonia", "Loyalty Islands", "Southeast of Loyalty Islands", "New Ireland Region, P.N.G.", "North of Solomon Islands", "New Britain Region, P.N.G.", "Solomon Islands", "D'Entrecasteaux Islands Region", "South of Solomon Islands", "Irian Jaya Region, Indonesia", "Near North Coast of Irian Jaya", "Ninigo Islands Region, P.N.G.", "Admiralty Islands Region, P.N.G.", "Near N. Coast of New Guinea, PNG.", "Irian Jaya, Indonesia", "New Guinea, Papua New Guinea", "Bismarck Sea", "Aru Islands Region, Indonesia", "Near South Coast of Irian Jaya", "Near S. Coast of New Guinea, PNG.", "Eastern New Guinea Reg., P.N.G.", "Arafura Sea", "W. Caroline Islands, Micronesia", "South of Mariana Islands", "Southeast of Honshu, Japan", "Bonin Islands, Japan Region", "Volcano Islands, Japan Region", "West of Mariana Islands", "Mariana Islands Region", "Mariana Islands", "Kamchatka Peninsula, Russia", "Near East Coast of Kamchatka", "Off East Coast of Kamchatka", "Northwest of Kuril Islands", "Kuril Islands", "East of Kuril Islands", "Eastern Sea of Japan", "Hokkaido, Japan Region", "Off Coast of Hokkaido, Japan", "Near West Coast of Honshu, Japan", "Eastern Honshu, Japan", "Near East Coast of Honshu, Japan", "Off East Coast of Honshu, Japan", "Near S. Coast of Honshu, Japan", "South Korea", "Western Honshu, Japan", "Near S. Coast of Western Honshu", "Northwest of Ryukyu Islands", "Kyushu, Japan", "Shikoku, Japan", "Southeast of Shikoku, Japan", "Ryukyu Islands, Japan", "Southeast of Ryukyu Islands", "West of Bonin Islands", "Philippine Sea", "Near Coast of Southeastern China", "Taiwan Region", "Taiwan", "Northeast of Taiwan", "Southwestern Ryukyu Islands, Japan", "Southeast of Taiwan", "Philippine Islands Region", "Luzon, Philippines", "Mindoro, Philippines", "Samar, Philippines", "Palawan, Philippines", "Sulu Sea", "Panay, Philippines", "Cebu, Philippines", "Leyte, Philippines", "Negros, Philippines", "Sulu Archipelago, Philippines", "Mindanao, Philippines", "East of Philippine Islands", "Borneo", "Celebes Sea", "Talaud Islands, Indonesia", "North of Halmahera, Indonesia", "Minahassa Peninsula, Sulawesi", "Northern Molucca Sea", "Halmahera, Indonesia", "Sulawesi, Indonesia", "Southern Molucca Sea", "Ceram Sea", "Buru, Indonesia", "Seram, Indonesia", "Southwest of Sumatra, Indonesia", "Southern Sumatra, Indonesia", "Java Sea", "Sunda Strait, Indonesia", "Java, Indonesia", "Bali Sea", "Flores Sea", "Banda Sea", "Tanimbar Islands Reg., Indonesia", "South of Java, Indonesia", "Bali Region, Indonesia", "South of Bali, Indonesia", "Sumbawa Region, Indonesia", "Flores Region, Indonesia", "Sumba Region, Indonesia", "Savu Sea", "Timor Region", "Timor Sea", "South of Sumbawa, Indonesia", "South of Sumba, Indonesia", "South of Timor, Indonesia", "Myanmar-India Border Region", "Myanmar-Bangladesh Border Region", "Myanmar", "Myanmar-China Border Region", "Near South Coast of Myanmar", "Southeast Asia", "Hainan Island, China", "South China Sea", "Eastern Kashmir", "Kashmir-India Border Region", "Kashmir-Xizang, China Border Region", "Western-Xizang, China India Border Reg.", "Xizang, China", "Sichuan, China", "Northern India", "Nepal-India Border Region", "Nepal", "Sikkim, India", "Bhutan", "Eastern Xizang, China-India Border Reg.", "Southern India", "India-Bangladesh Border Region", "Bangladesh", "Northeastern India", "Yunnan, China", "Bay of Bengal", "Kyrgyzstan-Xinjiang, China Border Reg.", "Southern Xinjiang, China", "Gansu, China", "Western Nei Mongol, China", "Kashmir-Xinjiang, China Border Region", "Qinghai, China", "Southwestern Siberia, Russia", "Lake Baykal Region, Russia", "East of Lake Baykal, Russia", "Eastern Kazakhstan", "Lake Issyk Kul Region", "Kazakhstan-Xinjiang, China Border Reg.", "Northern Xinjiang, China", "Russia-Mongolia Border Region", "Mongolia", "Ural Mountains Region, Russia", "Western Kazakhstan", "Eastern Caucasus", "Caspian Sea", "Northwestern Uzbekistan", "Turkmenistan", "Turkmenistan-Iran Border Region", "Turkmenistan-Afghanistan Border Reg.", "Turkey-Iran Border Region", "Armenia-Azerbaijan-Iran Border Reg.", "Northwestern Iran", "Iran-Iraq Border Region", "Western Iran", "Northern and Central Iran", "Northwestern Afghanistan", "Southwestern Afghanistan", "Eastern Arabian Peninsula", "Persian Gulf", "Southern Iran", "Southwestern Pakistan", "Gulf of Oman", "Off Coast of Pakistan", "Ukraine/Moldova/SW Russia Region", "Romania", "Bulgaria", "Black Sea", "Crimea Region, Ukraine", "Northwestern Caucasus", "Greece Bulgaria Border Region", "Greece", "Aegean Sea", "Turkey", "Georgia Armenia Turkey Border Reg.", "Southern Greece", "Dodecanese Islands, Greece", "Crete, Greece", "Eastern Mediterranean Sea", "Cyprus Region", "Dead Sea Region", "Jordan/Syria Region", "Iraq", "Portugal", "Spain", "Pyrenees", "Near South Coast of France", "Corsica, France", "Central Italy", "Adriatic Sea", "NW Balkan Region", "West of Gibraltar", "Strait of Gibraltar", "Balearic Islands, Spain", "Western Mediterranean Sea", "Sardinia, Italy", "Tyrrhenian Sea", "Southern Italy", "Albania", "Greece-Albania Border Region", "Madeira Islands, Portugal Region", "Canary Islands, Spain Region", "Morocco", "Northern Algeria", "Tunisia", "Sicily, Italy", "Ionian Sea", "Central Mediterranean Sea", "Near Coast of Libya", "North Atlantic Ocean", "Northern Mid Atlantic Ridge", "Azores Islands Region", "Azores Islands, Portugal", "Central Mid Atlantic Ridge", "North of Ascension Island", "Ascension Island Region", "South Atlantic Ocean", "Southern Mid Atlantic Ridge", "Tristan da Cunha Region", "Bouvet Island Region", "Southwest of Africa", "Southeastern Atlantic Ocean", "Eastern Gulf of Aden", "Socotra Region", "Arabian Sea", "Lakshadweep Region, India", "Northeastern Somalia", "North Indian Ocean", "Carlsberg Ridge", "Maldive Islands Region", "Laccadive Sea", "Sri Lanka", "South Indian Ocean", "Chagos Archipelago Region", "Mauritius/Reunion Region", "Southwest Indian Ridge", "Mid Indian Ridge", "South of Africa", "Prince Edward Islands Region", "Crozet Islands Region", "Kerguelen Islands Region", "Broken Ridge", "Southeast Indian Ridge", "Southern Kerguelen Plateau", "South of Australia", "Saskatchewan, Canada", "Manitoba, Canada", "Hudson Bay", "Ontario, Canada", "Hudson Strait Region, Canada", "Northern Quebec, Canada", "Davis Strait", "Labrador, Canada", "Labrador Sea", "Southern Quebec, Canada", "Gaspe Peninsula, Canada", "Eastern Quebec, Canada", "Anticosti Island, Canada", "New Brunswick, Canada", "Nova Scotia, Canada", "Prince Edward Island, Canada", "Gulf of St. Lawrence", "Newfoundland, Canada", "Montana", "Eastern Idaho", "Hebgen Lake Region", "Yellowstone Region, Wyoming", "Wyoming", "North Dakota", "South Dakota", "Nebraska", "Minnesota", "Iowa", "Wisconsin", "Illinois", "Michigan", "Indiana", "Southern Ontario, Canada", "Ohio", "New York", "Pennsylvania", "Vermont New Hampshire Region", "Maine", "Southern New England", "Gulf of Maine", "Utah", "Colorado", "Kansas", "Iowa-Missouri Border Region", "Missouri-Kansas Border Region", "Missouri", "Missouri-Arkansas Border Region", "Eastern Missouri", "New Madrid, Missouri Region", "Cape Girardeau, Missouri Region", "Southern Illinois", "Southern Indiana", "Kentucky", "West Virginia", "Virginia", "Chesapeake Bay Region", "New Jersey", "Eastern Arizona", "New Mexico", "Texas Panhandle Region", "Western Texas", "Oklahoma", "Central Texas", "Arkansas-Oklahoma Border Region", "Arkansas", "Louisiana-Texas Border Region", "Louisiana", "Mississippi", "Tennessee", "Alabama", "Western Florida", "Georgia, USA", "Florida-Georgia Border Region", "South Carolina", "North Carolina", "Off East Coast of United States", "Florida Peninsula", "Bahama Islands", "E. Arizona-Sonora Border Region", "New Mexico-Chihuahua Border Reg.", "Texas-Mexico Border Region", "Southern Texas", "Near Coast of Texas", "Chihuahua, Mexico", "Northern Mexico", "Central Mexico", "Jalisco, Mexico", "Veracruz, Mexico", "Gulf of Mexico", "Bay of Campeche", "Brazil", "Guyana", "Suriname", "French Guiana", "Ireland", "United Kingdom", "North Sea", "Southern Norway", "Sweden", "Baltic Sea", "France", "Bay of Biscay", "The Netherlands", "Belgium", "Denmark", "Germany", "Switzerland", "Northern Italy", "Austria", "Czech and Slovak Republics", "Poland", "Hungary", "Northwest Africa", "Southern Algeria", "Libya", "Egypt", "Red Sea", "Western Arabian Peninsula", "Chad Region", "Sudan", "Ethiopia", "Western Gulf of Aden", "Northwestern Somalia", "Off S. Coast of Northwest Africa", "Cameroon", "Equatorial Guinea", "Central African Republic", "Gabon", "Republic of Congo", "Democratic Republic of Congo", "Uganda", "Lake Victoria Region", "Kenya", "Southern Somalia", "Lake Tanganyika Region", "Tanzania", "Northwest of Madagascar", "Angola", "Zambia", "Malawi", "Namibia", "Botswana", "Zimbabwe", "Mozambique", "Mozambique Channel", "Madagascar", "South Africa", "Lesotho", "Swaziland", "Off Coast of South Africa", "Northwest of Australia", "West of Australia", "Western Australia", "Northern Territory, Australia", "South Australia", "Gulf of Carpentaria", "Queensland, Australia", "Coral Sea", "Northwest of New Caledonia", "Southwest of New Caledonia", "Southwest of Australia", "Off South Coast of Australia", "Near Coast of South Australia", "New South Wales, Australia", "Victoria, Australia", "Near SE Coast of Australia", "Near East Coast of Australia", "East of Australia", "Norfolk Island, Australia Region", "Northwest of New Zealand", "Bass Strait, Australia", "Tasmania, Australia Region", "Southeast of Australia", "North Pacific Ocean", "Hawaiian Islands Region", "Hawaii", "E. Caroline Islands, Micronesia", "Marshall Islands Region", "Enewetak Atoll Reg, Marshall Islands", "Bikini Atoll Reg., Marshall Islands", "Gilbert Islands, Kiribati Region", "Johnston Island Region", "Line Islands, Kiribati Region", "Palmyra Island Region, Kiribati", "Kiritimati Region, Kiribati", "Tuvalu Region", "Phoenix Islands, Kiribati Region", "Tokelau Islands Region", "Northern Cook Islands", "Cook Islands Region", "Society Islands Region", "Tubuai Islands Region", "Marquesas Islands Region", "Tuamotu Archipelago Region", "South Pacific Ocean", "Lomonosov Ridge", "Arctic Ocean", "Near North Coast of Greenland", "Eastern Greenland", "Iceland Region", "Iceland", "Jan Mayen Island Region", "Greenland Sea", "North of Svalbard", "Norwegian Sea", "Svalbard Region", "North of Franz Josef Land", "Franz Josef Land, Russia", "Northern Norway", "Barents Sea", "Novaya Zemlya, Russia", "Kara Sea", "Near Coast of Western Siberia, Russia", "North of Severnaya Zemlya", "Severnaya Zemlya, Russia", "Near Coast of Central Siberia, Russia", "East of Severnaya Zemlya", "Laptev Sea", "Southeastern Siberia, Russia", "E Russia-NE China Border Region", "Northeastern China", "North Korea", "Sea of Japan", "Primor'ye, Russia", "Sakhalin, Russia", "Sea of Okhotsk", "Southeastern China", "Yellow Sea, China", "Off coast of Eastern China", "North of New Siberian Islands", "New Siberian Islands, Russia", "East Siberian Sea", "Near Northern Coast of Eastern Siberia", "Eastern Siberia, Russia", "Chukchi Sea", "Bering Strait", "St. Lawrence Island, Alaska Reg.", "Beaufort Sea", "Northern Alaska", "Northern Yukon Territory, Canada", "Queen Elizabeth Islands, Canada", "NW Territories - Nunavut, Canada", "Western Greenland", "Baffin Bay", "Baffin Island Region, Canada", "Southeast Central Pacific Ocean", "Southern East Pacific Rise", "Easter Island Region", "West Chile Rise", "Juan Fernandez Islands Region", "East of North Island, N.Z.", "Chatham Islands, N.Z. Region", "South of Chatham Islands", "Pacific Antarctic Ridge", "Southern Pacific Ocean", "East Central Pacific Ocean", "Central East Pacific Rise", "West of Galapagos Islands", "Galapagos Islands Region", "Galapagos Islands, Ecuador", "Southwest of Galapagos Islands", "Southeast of Galapagos Islands", "South of Tasmania", "West of Macquarie Island", "Balleny Islands Region", "Andaman Islands, India Region", "Nicobar Islands, India Region", "Off West Coast of Northern Sumatra", "Northern Sumatra, Indonesia", "Malay Peninsula", "Gulf of Thailand", "Southeastern Afghanistan", "Pakistan", "Southwestern Kashmir", "India-Pakistan Border Region", "Central Kazakhstan", "Southeastern Uzbekistan", "Tajikistan", "Kyrgyzstan", "Afghanistan-Tajikistan Border Region", "Hindu Kush Region, Afghanistan", "Tajikistan-Xinjiang, China Border Region", "Northwestern Kashmir", "Finland", "Norway-Russia Border Region", "Finland-Russia Border Region", "Baltics/Belarus/Northwestern Russia Reg.", "Northwestern Siberia, Russia", "Northcentral Siberia, Russia", "Victoria Land, Antarctica", "Ross Sea", "Antarctica", "Northern East Pacific Rise", "North of Honduras", "East of South Sandwich Islands", "Thailand", "Laos", "Cambodia", "Vietnam", "Gulf of Tongking", "Reykjanes Ridge", "Azores Cape St. Vincent Ridge", "Owen Fracture Zone Region", "Indian Ocean Triple Junction", "Western Indian Antarctic Ridge", "Western Sahara", "Mauritania", "Mali", "Sengal-Gambia Region", "Guinea Region", "Sierra Leone", "Liberia Region", "Cote D'Ivoire", "Burkina Faso", "Ghana", "Benin-Togo Region", "Niger", "Nigeria", "Southeast of Easter Island", "Galapagos Triple Junction Region"};
    }

    public static String getRegionName(double lat, double lon) {
        String name = RegionsFE.getFeGeoRegionName(lat, lon);
        if (name != "") {
            return name;
        }
        return RegionsFE.getFeGeoRegionName(lat, lon);
    }

    public static String getFeGeoRegionName(double lat, double lon) {
        int _lat = (int)lat;
        int _lon = (int)lon;
        if (lat >= 0.0) {
            ++_lat;
        }
        if (lon >= 0.0) {
            ++_lon;
        }
        if (lat >= -90.0 && lat <= 90.0 && lon >= -180.0 && lon <= 180.0) {
            return feGeoRegionsNames[feGeoRegionsArray[_lat + 90][_lon + 180] - 1];
        }
        return "unknown Region";
    }

    public static int getFeGeoRegionNum(double lat, double lon) {
        int _lat = (int)lat;
        int _lon = (int)lon;
        if (lat >= 0.0) {
            ++_lat;
        }
        if (lon >= 0.0) {
            ++_lon;
        }
        if (lat >= -90.0 && lat <= 90.0 && lon >= -180.0 && lon <= 180.0) {
            return feGeoRegionsArray[_lat + 90][_lon + 180];
        }
        return -1;
    }

    public static void main(String[] args) {
        String fe = RegionsFE.getFeGeoRegionName(30.0, 90.0);
        int num = RegionsFE.getFeGeoRegionNum(30.0, 90.0);
        System.out.println("fe=" + fe + ", " + num);
    }
}

