/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.regions;

import cn.org.gddsn.convert.SphereUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class CityInfo {
    static Logger logger = Logger.getLogger(CityInfo.class);
    private float lat;
    private float lon;
    private String name;
    private float population;
    private float distance;
    private float azimuth;
    private static List<CityInfo> CITIES = new LinkedList<CityInfo>();

    static {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(CityInfo.class.getResourceAsStream("city.dat")));
            String line = null;
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, " ,");
                CityInfo ci = new CityInfo();
                ci.lat = Float.parseFloat(st.nextToken());
                ci.lon = Float.parseFloat(st.nextToken());
                ci.name = st.nextToken();
                CITIES.add(ci);
            }
            br.close();
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), e);
            logger.warn("Error readding resource city.dat");
        }
    }

    public String toString() {
        return String.format("%1$.0f km %2$s from %3$s", Float.valueOf(this.distance), CityInfo.getAzimuthString(this.azimuth), this.name);
    }

    public static void main(String[] args) {
        CityInfo ci = CityInfo.findNearestCity(-0.51f, 124.33f);
        System.out.println("ci=" + ci);
    }

    public static CityInfo findNearestCity(float lat0, float lon0) {
        double delta = Double.MAX_VALUE;
        CityInfo nci = null;
        SphereUtil.DELTAI ndt = null;
        for (CityInfo ci : CITIES) {
            SphereUtil.DELTAI dt = SphereUtil.deltai(ci.lat, ci.lon, lat0, lon0);
            if (!(dt.delta < delta)) continue;
            delta = dt.delta;
            nci = ci;
            ndt = dt;
        }
        if (nci != null) {
            CityInfo r = new CityInfo();
            r.lat = nci.lat;
            r.lon = nci.lon;
            r.name = nci.name;
            r.population = nci.population;
            r.distance = (float)(ndt.delta * (double)111.19f);
            r.azimuth = (float)ndt.az1;
            return r;
        }
        return null;
    }

    public static String getAzimuthString(float azi) {
        if (azi <= 5.0f) {
            return "N";
        }
        if (azi > 5.0f && azi <= 45.0f) {
            return "NE";
        }
        if (azi > 45.0f && azi <= 85.0f) {
            return "EN";
        }
        if (azi > 85.0f && azi <= 95.0f) {
            return "E";
        }
        if (azi > 95.0f && azi <= 135.0f) {
            return "ES";
        }
        if (azi > 135.0f && azi <= 175.0f) {
            return "SE";
        }
        if (azi > 175.0f && azi <= 185.0f) {
            return "S";
        }
        if (azi > 185.0f && azi <= 225.0f) {
            return "SW";
        }
        if (azi > 225.0f && azi <= 265.0f) {
            return "WS";
        }
        if (azi > 265.0f && azi <= 275.0f) {
            return "W";
        }
        if (azi > 275.0f && azi <= 315.0f) {
            return "WN";
        }
        if (azi > 315.0f && azi <= 355.0f) {
            return "NW";
        }
        return "N";
    }

    public float getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(float azimuth) {
        this.azimuth = azimuth;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setDistance(float distance) {
        this.distance = distance;
    }

    public float getLat() {
        return this.lat;
    }

    public void setLat(float lat) {
        this.lat = lat;
    }

    public float getLon() {
        return this.lon;
    }

    public void setLon(float lon) {
        this.lon = lon;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getPopulation() {
        return this.population;
    }

    public void setPopulation(float population) {
        this.population = population;
    }
}

