/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.realtimeplot.gui;

import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.config.StationProfile;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SetupDialog
extends JDialog {
    static Logger logger = Logger.getLogger(SetupDialog.class);
    static final String pnfile = "IPPlot.properties";
    static final String nnfile = "cfg/network.xml";
    static StationProfile sprofile = null;
    static ChannelLocator[] cls = null;
    Properties props = null;
    Vector vecUnSeclect = new Vector();
    Vector vecSelected = new Vector();
    boolean breLoad = false;
    JPanel panel1 = new JPanel();
    ButtonGroup buttonGroupConnectionType = new ButtonGroup();
    JPanel jPanel1 = new JPanel();
    JRadioButton jRadioButtonTCP = new JRadioButton();
    JRadioButton jRadioButtonUDP = new JRadioButton();
    JPanel jPanel2 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JTextField jTextFieldServer = new JTextField();
    JTextField jTextFieldUser = new JTextField();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JTextField jTextFieldPort = new JTextField();
    JLabel jLabel1 = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList jListUnSelect = new JList();
    JScrollPane jScrollPane2 = new JScrollPane();
    JList jListSelected = new JList();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JButton jButtonAdd = new JButton();
    JButton jButtonRemove = new JButton();
    JPasswordField jPasswordField = new JPasswordField();
    JButton jButtonOK = new JButton();
    JButton jButtonCancel = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    static {
        try {
            sprofile = new StationProfile();
            sprofile.parseNetwork(new FileInputStream(nnfile));
            cls = sprofile.getAllChannelLocator();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    public SetupDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
        this.setInitValue();
        this.update();
    }

    public SetupDialog() {
        this((Frame)null, "", false);
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout1);
        this.jRadioButtonTCP.setToolTipText("");
        this.jRadioButtonTCP.setSelected(true);
        this.jRadioButtonTCP.setText("TCP");
        this.jRadioButtonUDP.setText("UDP");
        this.jRadioButtonUDP.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SetupDialog.this.jRadioButtonUDP_itemStateChanged(e);
            }
        });
        this.jPanel2.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setRows(4);
        this.jLabel2.setText("\ufffd\u00fb\ufffd");
        this.jLabel3.setText("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.jLabel4.setText("\ufffd\u02ff\ufffd");
        this.jLabel1.setText("\ufffd\ufffd\ufffd\ufffd");
        this.jLabel5.setText("\u03b4\ufffd\ufffd\u02be\ufffd\ufffd\u0368\ufffd1\ufffd");
        this.jLabel6.setText("\ufffd\ufffd\u02be\ufffd\ufffd\u0368\ufffd1\ufffd");
        this.jButtonAdd.setText("\ufffd\ufffd\ufffd");
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetupDialog.this.jButtonAdd_actionPerformed(e);
            }
        });
        this.jButtonRemove.setText("\u027e\ufffd\ufffd");
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetupDialog.this.jButtonRemove_actionPerformed(e);
            }
        });
        this.jPasswordField.setText("");
        this.jButtonOK.setActionCommand("jButtonOK");
        this.jButtonOK.setText("\u0237\ufffd\ufffd");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetupDialog.this.jButtonOK_actionPerformed(e);
            }
        });
        this.jButtonCancel.setActionCommand("jButtonOK");
        this.jButtonCancel.setText("\u0221\ufffd\ufffd");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetupDialog.this.jButtonCancel_actionPerformed(e);
            }
        });
        this.jPanel1.add((Component)this.jRadioButtonTCP, null);
        this.jPanel1.add((Component)this.jRadioButtonUDP, null);
        this.panel1.add((Component)this.jButtonOK, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(36, 48, 16, 39), 22, 0));
        this.panel1.add((Component)this.jButtonCancel, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(36, 12, 16, 31), 0, 0));
        this.panel1.add((Component)this.jScrollPane2, new GridBagConstraints(4, 1, 1, 3, 1.0, 1.0, 10, 1, new Insets(13, 17, 0, 26), -86, 201));
        this.panel1.add((Component)this.jLabel6, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 17, 0, 71), 57, 9));
        this.panel1.add((Component)this.jLabel5, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 31, 0, 0), 45, 9));
        this.panel1.add((Component)this.jScrollPane1, new GridBagConstraints(1, 1, 2, 3, 1.0, 1.0, 10, 1, new Insets(13, 31, 0, 0), -86, 201));
        this.panel1.add((Component)this.jButtonRemove, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(57, 16, 108, 0), 0, 0));
        this.panel1.add((Component)this.jButtonAdd, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(97, 16, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.jListUnSelect, null);
        this.jScrollPane2.getViewport().add((Component)this.jListSelected, null);
        this.getContentPane().add(this.panel1);
        this.buttonGroupConnectionType.add(this.jRadioButtonUDP);
        this.buttonGroupConnectionType.add(this.jRadioButtonTCP);
        this.panel1.add((Component)this.jPanel2, new GridBagConstraints(0, 2, 1, 2, 1.0, 1.0, 10, 1, new Insets(17, 32, 106, 15), 167, 109));
        this.jPanel2.add((Component)this.jLabel3, null);
        this.jPanel2.add((Component)this.jTextFieldServer, null);
        this.jPanel2.add((Component)this.jLabel4, null);
        this.jPanel2.add((Component)this.jTextFieldPort, null);
        this.jPanel2.add((Component)this.jLabel2, null);
        this.jPanel2.add((Component)this.jTextFieldUser, null);
        this.jPanel2.add((Component)this.jLabel1, null);
        this.jPanel2.add((Component)this.jPasswordField, null);
        this.panel1.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(16, 50, 0, 0), 121, 26));
    }

    void jRadioButtonUDP_itemStateChanged(ItemEvent e) {
        if (this.jRadioButtonUDP.isSelected()) {
            this.jPasswordField.setEditable(false);
            this.jTextFieldUser.setEnabled(false);
            this.props.put("IPPlot.connection.type", "UDP");
        }
        if (this.jRadioButtonTCP.isSelected()) {
            this.jPasswordField.setEditable(true);
            this.jTextFieldUser.setEnabled(true);
            this.props.put("IPPlot.connection.type", "TCP");
        }
    }

    private int getIdx(ChannelLocator cl) {
        int i = -1;
        i = 0;
        while (i < cls.length) {
            if (cls[i].equals(cl)) {
                return i;
            }
            ++i;
        }
        return i;
    }

    void setInitValue() {
        int i = 0;
        while (i < cls.length) {
            this.vecUnSeclect.add(cls[i]);
            ++i;
        }
        this.props = new Properties();
        try {
            this.props.load(new FileInputStream(pnfile));
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
        boolean bTCP = true;
        String connectionType = this.props.getProperty("IPPlot.connection.type", "TCP");
        if (connectionType == null) {
            bTCP = true;
        } else {
            if (connectionType.equalsIgnoreCase("TCP")) {
                this.jRadioButtonTCP.setSelected(true);
                this.jPasswordField.setEditable(true);
                this.jTextFieldUser.setEnabled(true);
            }
            if (connectionType.equalsIgnoreCase("UDP")) {
                this.jRadioButtonUDP.setSelected(true);
                this.jPasswordField.setEditable(false);
                this.jTextFieldUser.setEnabled(false);
            }
        }
        this.jTextFieldServer.setText(this.props.getProperty("IPPlot.connection.host", "127.0.0.1"));
        this.jTextFieldPort.setText(this.props.getProperty("IPPlot.connection.port", "5000"));
        this.jTextFieldUser.setText(this.props.getProperty("IPPlot.connection.user", "ipplot"));
        this.jPasswordField.setText(this.props.getProperty("IPPlot.connection.password", "ipplot"));
        String line = this.props.getProperty("IPPlot.channel");
        StringTokenizer st = new StringTokenizer(line, " +");
        while (st.hasMoreTokens()) {
            StringTokenizer st0 = new StringTokenizer(st.nextToken(), " /");
            ChannelLocator cl = new ChannelLocator(st0.nextToken(), st0.nextToken(), st0.nextToken(), st0.nextToken());
            this.vecUnSeclect.remove(cl);
            this.vecSelected.add(cl);
        }
    }

    void save() {
        this.props.put("IPPlot.connection.host", this.jTextFieldServer.getText());
        this.props.put("IPPlot.connection.port", this.jTextFieldPort.getText());
        this.props.put("IPPlot.connection.user", this.jTextFieldUser.getText());
        this.props.put("IPPlot.connection.password", new String(this.jPasswordField.getPassword()));
        StringBuffer sb = new StringBuffer();
        Enumeration en = this.vecSelected.elements();
        while (en.hasMoreElements()) {
            sb.append(en.nextElement());
            sb.append(" + ");
        }
        this.props.put("IPPlot.channel", sb.toString());
        try {
            FileOutputStream fos = new FileOutputStream(pnfile);
            this.props.store(fos, "IPPlot configuration");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void update() {
        this.jListSelected.removeAll();
        this.jListUnSelect.removeAll();
        Collections.sort(this.vecSelected);
        Collections.sort(this.vecUnSeclect);
        this.jListSelected.setListData(this.vecSelected);
        this.jListUnSelect.setListData(this.vecUnSeclect);
        this.jScrollPane1.validate();
        this.jScrollPane2.validate();
    }

    void jButtonAdd_actionPerformed(ActionEvent e) {
        Object[] objs = this.jListUnSelect.getSelectedValues();
        int i = 0;
        while (i < objs.length) {
            this.vecUnSeclect.remove(objs[i]);
            this.vecSelected.add(objs[i]);
            ++i;
        }
        this.update();
    }

    void jButtonRemove_actionPerformed(ActionEvent e) {
        Object[] objs = this.jListSelected.getSelectedValues();
        int i = 0;
        while (i < objs.length) {
            this.vecSelected.remove(objs[i]);
            this.vecUnSeclect.add(objs[i]);
            ++i;
        }
        this.update();
    }

    void jButtonOK_actionPerformed(ActionEvent e) {
        this.breLoad = true;
        this.save();
        this.dispose();
    }

    void jButtonCancel_actionPerformed(ActionEvent e) {
        this.breLoad = false;
        this.dispose();
    }

    public boolean isReload() {
        return this.breLoad;
    }
}

