/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.realtimeplot.gui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class RtsAlarm
implements Runnable,
LineListener {
    static Logger logger = Logger.getLogger(RtsAlarm.class);
    Clip clip = null;
    URL completeURL;
    boolean looping = false;
    long alarmTime;
    String event_id = "";

    public RtsAlarm(URL baseURL, boolean looping) {
        this.completeURL = baseURL;
        this.looping = looping;
    }

    public RtsAlarm(URL baseURL) {
        this(baseURL, false);
    }

    public void run() {
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(this.completeURL);
            AudioFormat format = ais.getFormat();
            if (format.getEncoding() == AudioFormat.Encoding.ULAW || format.getEncoding() == AudioFormat.Encoding.ALAW) {
                AudioFormat tmp = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
                ais = AudioSystem.getAudioInputStream(tmp, ais);
                format = tmp;
            }
            DataLine.Info info = new DataLine.Info(Clip.class, format, (int)(ais.getFrameLength() * (long)format.getFrameSize()));
            this.clip = (Clip)AudioSystem.getLine(info);
            Thread.sleep(1000L);
            this.clip.open(ais);
            this.clip.addLineListener(this);
            if (this.looping) {
                this.clip.loop(-1);
            } else {
                this.clip.start();
            }
            JOptionPane.showMessageDialog(null, String.valueOf(this.event_id) + " alarm at " + new Date(this.alarmTime), "Event Alarm", 0);
            this.clip.stop();
            this.clip.close();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public void update(LineEvent event) {
        if (event.getType() != LineEvent.Type.STOP) {
            // empty if block
        }
    }

    public static void main(String[] args) {
        URL codeBase = null;
        try {
            codeBase = new URL("file:/usr/home/hwh/projects/RTS/audio/spacemusic.au");
        }
        catch (MalformedURLException e) {
            logger.warn(e.getMessage());
        }
        RtsAlarm t = new RtsAlarm(codeBase, true);
    }
}

