/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.realtimeplot.gui;

import cn.org.gddsn.liss.port.MiniSeedStreamInf;
import cn.org.gddsn.seis.realtimeplot.gui.IPPlotFrame;
import cn.org.gddsn.util.Log4jConfig;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class IPPlotClass {
    static Logger logger = Logger.getLogger(IPPlotClass.class);
    boolean packFrame = true;
    IPPlotFrame frame = null;
    static XmlBeanFactory factory;

    public IPPlotClass() {
        FileSystemResource res = new FileSystemResource("IPPlot.xml");
        factory = new XmlBeanFactory(res);
        IPPlotFrame frame = (IPPlotFrame)factory.getBean("frame");
        frame.setSize(1024, 768);
        if (this.packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
        if (frame.isAlarm()) {
            DefaultMessageListenerContainer container = (DefaultMessageListenerContainer)factory.getBean("listenerContainer");
            container.start();
        }
    }

    public void setExtenalPort(MiniSeedStreamInf amssi) {
        this.frame.setExtenalPort(amssi);
    }

    public static void main(String[] args) {
        Log4jConfig.loadForMain("IPPlotClass.properties");
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
        }
        new IPPlotClass();
    }
}

