/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.realtimeplot.gui;

import cn.org.gddsn.seis.realtimeplot.gui.RtsAlarm;
import cn.org.gddsn.util.Log4jConfig;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class AlarmTopicHandler
implements MessageListener {
    static Logger logger = Logger.getLogger(AlarmTopicHandler.class);
    private JmsTemplate jmsTemplate;
    private RtsAlarm alarm = new RtsAlarm(AlarmTopicHandler.getEventAlarmAudio(), true);

    public void send(final String startOrStop) {
        this.jmsTemplate.send(new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return session.createTextMessage("Alarm/" + startOrStop);
            }
        });
    }

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            TextMessage tm = (TextMessage)message;
            try {
                String msg = tm.getText();
                logger.info("Got msg: " + msg);
                if (msg.equals("Alarm/Start") && this.alarm != null) {
                    Thread thr = new Thread(this.alarm);
                    thr.start();
                }
                if (msg.equals("Alarm/Stop") && this.alarm != null) {
                    // empty if block
                }
            }
            catch (JMSException ex) {
                logger.warn(ex.getMessage(), ex);
            }
        }
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public static String getCrntDir() {
        String CrntDir = System.getProperty("user.dir");
        if (CrntDir == null) {
            return "";
        }
        return CrntDir;
    }

    public static URL getEventAlarmAudio() {
        URL codeBase = null;
        try {
            codeBase = new URL("file:" + AlarmTopicHandler.getCrntDir() + "/" + "audio/alarm.au");
        }
        catch (MalformedURLException e) {
            logger.warn(e.getMessage());
        }
        return codeBase;
    }

    public static void main(String[] args) {
        Log4jConfig.loadForMain("log4j.properties");
        FileSystemResource res = new FileSystemResource("IPPlot.xml");
        XmlBeanFactory ac = new XmlBeanFactory(res);
        DefaultMessageListenerContainer container = (DefaultMessageListenerContainer)ac.getBean("listenerContainer");
        container.start();
    }
}

