/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor.edas.gui;

import cn.org.gddsn.liss.port.edas.Edas24IPIO;
import cn.org.gddsn.seis.monitor.edas.Controler;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame;
import cn.org.gddsn.seis.monitor.edas.gui.StationParamDialog_jButtonCancel_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.StationParamDialog_jButtonGet_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.StationParamDialog_jButtonSet_actionAdapter;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class StationParamDialog
extends JDialog {
    static Logger logger = Logger.getLogger(StationParamDialog.class);
    JLabel jLabelSensor_sn = new JLabel();
    JTextField jTextFieldSensorSN = new JTextField();
    JLabel jLabelStnName = new JLabel();
    JTextField jTextFieldStnName = new JTextField();
    JLabel jLabel1_short_name = new JLabel();
    JTextField jTextFieldStn_sn = new JTextField();
    JLabel jLabel_stn_sn = new JLabel();
    JTextField jTextFieldShortName = new JTextField();
    JTextField jTextFieldSenNum = new JTextField();
    JLabel jLabel_num_of_sen = new JLabel();
    JLabel jLabel1 = new JLabel();
    JTextField jTextFieldChanNum = new JTextField();
    JTextField jTextFieldLat = new JTextField();
    JLabel jLabel2 = new JLabel();
    JTextField jTextFieldLong = new JTextField();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JLabel jLabel7 = new JLabel();
    JTextField jTextFieldAlt = new JTextField();
    JTextField jTextFieldStartTime = new JTextField();
    JTextField jTextFieldNetFlag = new JTextField();
    JTextField jTextField1Version = new JTextField();
    JButton jButtonCancel = new JButton();
    JButton jButtonSet = new JButton();
    JButton jButtonGet = new JButton();
    GridLayout gridLayout1 = new GridLayout(7, 4);

    public StationParamDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.setDefaultCloseOperation(2);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.toGUI();
    }

    public StationParamDialog() {
        this(new Frame(), "StationParamDialog", false);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridLayout1);
        this.jLabelStnName.setToolTipText("");
        this.jLabelStnName.setText("stn_name:");
        this.jLabel1_short_name.setText("short_name");
        this.jLabel_stn_sn.setToolTipText("");
        this.jLabel_stn_sn.setText("stn_sn:");
        this.jLabel_num_of_sen.setText("num_of_sen:");
        this.jLabel1.setText("num_of_chan:");
        this.jLabel2.setText("Latitude:");
        this.jLabel3.setText("Longitude:");
        this.jLabel4.setText("Altitude");
        this.jLabel5.setText("Start Time:");
        this.jLabel6.setText("Net Flag:");
        this.jLabel7.setText("Version:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new StationParamDialog_jButtonCancel_actionAdapter(this));
        this.jButtonSet.setText("Set");
        this.jButtonSet.addActionListener(new StationParamDialog_jButtonSet_actionAdapter(this));
        this.jButtonGet.setText("Get");
        this.jButtonGet.addActionListener(new StationParamDialog_jButtonGet_actionAdapter(this));
        this.jTextFieldSensorSN.setEditable(false);
        this.jTextField1Version.setEditable(false);
        this.jTextFieldStartTime.setEditable(false);
        this.jTextFieldChanNum.setEditable(false);
        this.jTextFieldSenNum.setEditable(false);
        this.getContentPane().add((Component)this.jLabelSensor_sn, null);
        this.getContentPane().add((Component)this.jTextFieldSensorSN, null);
        this.getContentPane().add((Component)this.jLabel_stn_sn, null);
        this.getContentPane().add((Component)this.jTextFieldStn_sn, null);
        this.getContentPane().add((Component)this.jLabelStnName, null);
        this.getContentPane().add((Component)this.jTextFieldStnName, null);
        this.getContentPane().add((Component)this.jLabel1_short_name, null);
        this.getContentPane().add((Component)this.jTextFieldShortName, null);
        this.getContentPane().add((Component)this.jLabel_num_of_sen, null);
        this.getContentPane().add((Component)this.jTextFieldSenNum, null);
        this.getContentPane().add((Component)this.jLabel1, null);
        this.getContentPane().add((Component)this.jTextFieldChanNum, null);
        this.getContentPane().add((Component)this.jLabel2, null);
        this.getContentPane().add((Component)this.jTextFieldLat, null);
        this.getContentPane().add((Component)this.jLabel3, null);
        this.getContentPane().add((Component)this.jTextFieldLong, null);
        this.getContentPane().add((Component)this.jLabel4, null);
        this.getContentPane().add((Component)this.jTextFieldAlt, null);
        this.getContentPane().add((Component)this.jLabel5, null);
        this.getContentPane().add((Component)this.jTextFieldStartTime, null);
        this.getContentPane().add((Component)this.jLabel6, null);
        this.getContentPane().add((Component)this.jTextFieldNetFlag, null);
        this.getContentPane().add((Component)this.jLabel7, null);
        this.getContentPane().add((Component)this.jTextField1Version, null);
        this.getContentPane().add((Component)this.jButtonSet, null);
        this.getContentPane().add((Component)this.jButtonGet, null);
        this.getContentPane().add((Component)this.jButtonCancel, null);
        this.jLabelSensor_sn.setText("sensor_sn:");
    }

    public void jButtonCancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void jButtonGet_actionPerformed(ActionEvent e) {
        this.toGUI();
    }

    public void jButtonSet_actionPerformed(ActionEvent e) {
        this.toModel();
    }

    public void toModel() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            Edas24IPIO.STATION_INFO info = new Edas24IPIO.STATION_INFO();
            info.stanum.set(Short.parseShort(this.jTextFieldStn_sn.getText()));
            info.name.set(this.jTextFieldStnName.getText());
            info.abb.set(this.jTextFieldShortName.getText());
            info.lat.set((int)(Float.parseFloat(this.jTextFieldLat.getText()) * 3600000.0f));
            info.lon.set((int)(Float.parseFloat(this.jTextFieldLong.getText()) * 3600000.0f));
            info.alt.set((int)(Float.parseFloat(this.jTextFieldAlt.getText()) * 100000.0f));
            info.netmark.set(this.jTextFieldNetFlag.getText());
            edasIO.config(0, 0, info);
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
            frame.enableGUI(false);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }

    private void toGUI() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            Edas24IPIO.Frame frm = edasIO.inquire(0, 0);
            Edas24IPIO.STATION_INFO info = (Edas24IPIO.STATION_INFO)frm.body;
            this.jTextFieldStn_sn.setText("" + info.stanum.get());
            this.jTextFieldStnName.setText(info.name.get());
            this.jTextFieldShortName.setText(info.abb.get());
            this.jTextFieldSenNum.setText("" + info.seinum.get());
            this.jTextFieldChanNum.setText("" + info.chnum.get());
            this.jTextFieldLat.setText("" + (double)info.lat.get() / 3600000.0);
            this.jTextFieldLong.setText("" + (double)info.lon.get() / 3600000.0);
            this.jTextFieldAlt.setText("" + (double)info.alt.get() / 100.0 / 1000.0);
            this.jTextFieldStartTime.setText(info.useDate.get());
            this.jTextFieldNetFlag.setText(info.netmark.get());
            this.jTextField1Version.setText(info.version.get());
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
            frame.enableGUI(false);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }
}

