/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.monitor.edas.gui;

import cn.org.gddsn.liss.port.edas.Edas24IPIO;
import cn.org.gddsn.seis.monitor.edas.Controler;
import cn.org.gddsn.seis.monitor.edas.gui.Das_jButtonCanel_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.Das_jButtonGet_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.Das_jButtonSet_actionAdapter;
import cn.org.gddsn.seis.monitor.edas.gui.EdasFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class DasDialog
extends JDialog {
    static Logger logger = Logger.getLogger(DasDialog.class);
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton jButtonCanel = new JButton();
    JButton jButtonGet = new JButton();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    Border border1 = BorderFactory.createLineBorder(Color.black, 2);
    Border border2 = new TitledBorder(this.border1, "Phase");
    JLabel jLabel1 = new JLabel();
    JComboBox jComboBoxSensor = new JComboBox();
    JLabel jLabel2 = new JLabel();
    JComboBox jComboBoxSampRate = new JComboBox();
    JRadioButton jRadioButtonLinear = new JRadioButton();
    JRadioButton jRadioButtonMin = new JRadioButton();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    GridLayout gridLayout2 = new GridLayout();
    JButton jButtonSet = new JButton();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    Border border3 = BorderFactory.createEtchedBorder(0, Color.white, new Color(166, 166, 166));
    Border border4 = new TitledBorder(this.border3, "Input Control");
    Border border5 = BorderFactory.createEtchedBorder(0, Color.white, new Color(166, 166, 166));
    Border border6 = new TitledBorder(this.border5, "High Filter");
    JLabel jLabel3 = new JLabel();
    JComboBox jList1 = new JComboBox();
    JRadioButton jRadioButtonV10 = new JRadioButton();
    JRadioButton jRadioButtonV20 = new JRadioButton();
    ButtonGroup buttonGroup2 = new ButtonGroup();

    public DasDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.setDefaultCloseOperation(2);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.toGUI();
    }

    public DasDialog() {
        this(new Frame(), "DAS Set", false);
    }

    private void jbInit() throws Exception {
        this.border4 = new TitledBorder(BorderFactory.createEtchedBorder(0, Color.white, new Color(166, 166, 166)), "Input Control");
        this.border2 = new TitledBorder(BorderFactory.createEtchedBorder(0, Color.white, new Color(166, 166, 166)), "Phase");
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(0, Color.white, new Color(166, 166, 166)), "SampleRate");
        this.panel1.setLayout(this.borderLayout1);
        this.jButtonCanel.setText("Cancel");
        this.jButtonCanel.addActionListener(new Das_jButtonCanel_actionAdapter(this));
        this.jButtonGet.setText("Get");
        this.jButtonGet.addActionListener(new Das_jButtonGet_actionAdapter(this));
        this.jPanel1.setLayout(this.gridLayout1);
        this.jPanel3.setBorder(this.titledBorder1);
        this.jPanel3.setLayout(this.gridLayout2);
        this.jPanel4.setBorder(this.border2);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setRows(2);
        this.jLabel1.setText("Sensor:");
        this.jLabel2.setText("Sample Rate:");
        this.jRadioButtonLinear.setSelected(true);
        this.jRadioButtonLinear.setText("Linear");
        this.jRadioButtonMin.setText("Minimum");
        DefaultComboBoxModel<String> model2 = new DefaultComboBoxModel<String>(new String[]{"1:1sps", "2:10sps", "3:20sps", "4:50sps", "5:100sps", "6:125sps", "7:200sps", "8:500sps"});
        DefaultComboBoxModel<String> model3 = new DefaultComboBoxModel<String>(new String[]{"0:DC", "1:10S", "2:30S", "3:100S", "4:300S", "5:1000S", "6:3000S"});
        this.jComboBoxSampRate.setModel(model2);
        DefaultComboBoxModel<String> model1 = new DefaultComboBoxModel<String>(new String[]{"Sensor A"});
        this.jComboBoxSensor.setModel(model1);
        this.gridLayout2.setColumns(2);
        this.gridLayout2.setRows(2);
        this.jButtonSet.setText("Set");
        this.jButtonSet.addActionListener(new Das_jButtonSet_actionAdapter(this));
        this.jPanel5.setBorder(this.border4);
        this.jPanel6.setBorder(this.border6);
        this.jLabel3.setText("Cut Freq:");
        this.jRadioButtonV10.setSelected(true);
        this.jRadioButtonV10.setText("10V");
        this.jRadioButtonV20.setText("20V");
        this.jList1.setModel(model3);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanel1, "Center");
        this.jPanel1.add(this.jPanel3);
        this.jPanel3.add(this.jLabel1);
        this.jPanel3.add(this.jComboBoxSensor);
        this.jPanel3.add(this.jLabel2);
        this.jPanel3.add(this.jComboBoxSampRate);
        this.jPanel1.add(this.jPanel4);
        this.jPanel1.add(this.jPanel5);
        this.jPanel5.add(this.jRadioButtonV10);
        this.jPanel5.add(this.jRadioButtonV20);
        this.jPanel1.add(this.jPanel6);
        this.jPanel6.add(this.jLabel3);
        this.jPanel6.add(this.jList1);
        this.jPanel4.add(this.jRadioButtonLinear);
        this.jPanel4.add(this.jRadioButtonMin);
        this.buttonGroup1.add(this.jRadioButtonLinear);
        this.buttonGroup1.add(this.jRadioButtonMin);
        this.buttonGroup2.add(this.jRadioButtonV10);
        this.buttonGroup2.add(this.jRadioButtonV20);
        this.panel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add(this.jButtonSet);
        this.jPanel2.add(this.jButtonGet);
        this.jPanel2.add(this.jButtonCanel);
    }

    public void jButtonGet_actionPerformed(ActionEvent e) {
        this.toGUI();
    }

    public void jButtonSet_actionPerformed(ActionEvent e) {
        this.toModel();
    }

    public void jButtonCanel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void toGUI() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            Edas24IPIO.Frame frm = edasIO.inquire(0, 5);
            Edas24IPIO.SAMPLE_RATE info = (Edas24IPIO.SAMPLE_RATE)frm.body;
            if (info.phase.get() == 4) {
                this.jRadioButtonLinear.setSelected(true);
            } else {
                this.jRadioButtonMin.setSelected(true);
            }
            this.jComboBoxSampRate.setSelectedIndex(info.samrate.get() - 1);
            frm = edasIO.inquire(0, 3);
            Edas24IPIO.HI_FILTER filter = (Edas24IPIO.HI_FILTER)frm.body;
            this.jList1.setSelectedIndex(filter.lowcut.get());
            frm = edasIO.inquire(0, 7);
            Edas24IPIO.INPUT_CONTROL input = (Edas24IPIO.INPUT_CONTROL)frm.body;
            if (input.range.get() == 0) {
                this.jRadioButtonV10.setSelected(true);
            } else {
                this.jRadioButtonV20.setSelected(true);
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
            frame.enableGUI(false);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }

    private void toModel() {
        Edas24IPIO edasIO = Controler.edas24Client.getEdas24IPIO();
        try {
            Edas24IPIO.SAMPLE_RATE info = new Edas24IPIO.SAMPLE_RATE();
            byte selected = this.jRadioButtonLinear.isSelected() ? (byte)4 : 8;
            info.phase.set(selected);
            info.samrate.set((byte)(this.jComboBoxSampRate.getSelectedIndex() + 1));
            edasIO.config(0, 5, info);
            Edas24IPIO.HI_FILTER filter = new Edas24IPIO.HI_FILTER();
            filter.lowcut.set((short)this.jList1.getSelectedIndex());
            edasIO.config(0, 3, filter);
            Edas24IPIO.INPUT_CONTROL input = new Edas24IPIO.INPUT_CONTROL();
            if (this.jRadioButtonV10.isSelected()) {
                input.range.set((short)0);
            } else {
                input.range.set((short)1);
            }
            filter.lowcut.set((short)this.jList1.getSelectedIndex());
            edasIO.config(0, 7, input);
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("IOException: " + ioEx.getMessage());
            frame.enableGUI(false);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            EdasFrame frame = (EdasFrame)this.getOwner();
            frame.warnStatusBar("Exception: " + ex.getMessage());
            frame.enableGUI(false);
        }
    }
}

