/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.locsat;

import cn.org.gddsn.seis.SourceParam;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class PhaseDataHeader {
    private int myear;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private float second;
    private float latInit;
    private float lonInit;
    private float depthInit;
    private float eventMag;
    private int numData;
    private int hiYear = 19;
    private int from = 0;

    public void parse(SourceParam p, int numData) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(p.getOriginTime());
        this.myear = c.get(1) % 100;
        this.hiYear = c.get(1) / 100;
        this.month = c.get(2) + 1;
        this.day = c.get(5);
        this.hour = c.get(11);
        this.minute = c.get(12);
        this.second = (float)c.get(13) + (float)c.get(14) / 1000.0f;
        this.latInit = (float)p.getLat();
        this.lonInit = (float)p.getLon();
        this.depthInit = (float)p.getDepth();
        this.eventMag = 0.0f;
        this.numData = numData;
    }

    public void parse(String buf) {
        this.from = 0;
        this.myear = Integer.parseInt(this.getNextField(buf, 2).trim());
        this.month = Integer.parseInt(this.getNextField(buf, 2).trim());
        this.day = Integer.parseInt(this.getNextField(buf, 3).trim());
        this.hour = Integer.parseInt(this.getNextField(buf, 2).trim());
        this.minute = Integer.parseInt(this.getNextField(buf, 2).trim());
        StringTokenizer st = new StringTokenizer(buf.substring(this.from));
        this.second = Float.parseFloat(st.nextToken().trim());
        this.latInit = Float.parseFloat(st.nextToken().trim());
        this.lonInit = Float.parseFloat(st.nextToken().trim());
        this.depthInit = Float.parseFloat(st.nextToken().trim());
        this.eventMag = Float.parseFloat(st.nextToken().trim());
        this.numData = Integer.parseInt(st.nextToken().trim());
        this.hiYear = st.hasMoreTokens() ? Integer.parseInt(st.nextToken().trim()) : 19;
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("%1$02d%2$02d%3$02d %4$02d%5$02d", this.myear, this.month, this.day, this.hour, this.minute);
        fmt.format("%1$6.2f%2$9.4f%3$10.4f%4$7.2f%5$7.2f  %6$3d %7$02d", Float.valueOf(this.second), Float.valueOf(this.latInit), Float.valueOf(this.lonInit), Float.valueOf(this.depthInit), Float.valueOf(this.eventMag), this.numData, this.hiYear);
        return sb.substring(0);
    }

    private String getNextField(String buf, int width) {
        String field = buf.substring(this.from, this.from + width);
        this.from += width;
        return field;
    }

    public int getDay() {
        return this.day;
    }

    public float getDepthInit() {
        return this.depthInit;
    }

    public float getEventMag() {
        return this.eventMag;
    }

    public int getFrom() {
        return this.from;
    }

    public int getHour() {
        return this.hour;
    }

    public float getLatInit() {
        return this.latInit;
    }

    public float getLonInit() {
        return this.lonInit;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getMonth() {
        return this.month;
    }

    public int getMyear() {
        return this.myear;
    }

    public int getNumData() {
        return this.numData;
    }

    public float getSecond() {
        return this.second;
    }

    public int getYear() {
        return this.hiYear * 100 + this.myear;
    }

    public double getOriginTimeInit() {
        GregorianCalendar c = new GregorianCalendar();
        c.set(this.getYear(), this.month - 1, this.day, this.hour, this.minute, (int)this.second);
        return (double)(c.getTime().getTime() / 1000L) + (double)(this.second - (float)((int)this.second));
    }
}

