/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.locsat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class LocsatControl {
    static Logger logger = Logger.getLogger(LocsatControl.class);
    private String dirTT;
    private String prefixTT;
    private String corr_dir;
    private String corr_type;
    private boolean useLocation = true;
    private boolean fixDepth = true;
    private boolean verbose = true;
    private double confidenceLevel = 0.9;
    private double damp = -1.0;
    private double est_std_err = 2.4;
    private int num_dof = 8;
    private int maxIterations = 40;
    private double initLat = -99999.0;
    private double initLong = -99999.0;
    private double initDepth = 10.0;
    private String controlFile;

    public LocsatControl() {
    }

    public LocsatControl(String controlFile) {
        this.controlFile = controlFile;
        try {
            this.parse(new File(controlFile));
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public void save() throws IOException {
        this.save(new File(this.controlFile));
    }

    public void parse() throws IOException {
        this.parse(new File(this.controlFile));
    }

    public void parse(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = br.readLine();
        StringTokenizer st = new StringTokenizer(line);
        this.dirTT = st.nextToken();
        this.prefixTT = st.nextToken();
        line = br.readLine();
        st = new StringTokenizer(line);
        this.corr_dir = st.nextToken();
        this.corr_type = st.nextToken();
        line = br.readLine();
        st = new StringTokenizer(line);
        this.useLocation = st.nextToken().equals("y");
        this.fixDepth = st.nextToken().equals("y");
        this.verbose = st.nextToken().equals("y");
        this.confidenceLevel = Double.parseDouble(st.nextToken());
        this.damp = Double.parseDouble(st.nextToken());
        this.est_std_err = Double.parseDouble(st.nextToken());
        this.num_dof = Integer.parseInt(st.nextToken());
        this.maxIterations = Integer.parseInt(st.nextToken());
        br.close();
    }

    public void save(File file) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(file));
        pw.format(String.format("%1$s %2$s\n", this.dirTT, this.prefixTT), new Object[0]);
        pw.format(String.format("%1$s %2$s\n", this.corr_dir, this.corr_type), new Object[0]);
        pw.format(String.format("%s %s %s %.2f %.2f %.2f %d %d\n", this.useLocation ? "y" : "n", this.fixDepth ? "y" : "n", this.verbose ? "y" : "n", this.confidenceLevel, this.damp, this.est_std_err, this.num_dof, this.maxIterations), new Object[0]);
        pw.close();
    }

    public String getDirTT() {
        return this.dirTT;
    }

    public void setDirTT(String stationCode) {
        this.dirTT = stationCode;
    }

    public boolean isFixDepth() {
        return this.fixDepth;
    }

    public void setFixDepth(boolean fixDepth) {
        this.fixDepth = fixDepth;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public boolean isUseLocation() {
        return this.useLocation;
    }

    public void setUseLocation(boolean useLocation) {
        this.useLocation = useLocation;
    }

    public double getInitDepth() {
        return this.initDepth;
    }

    public void setInitDepth(double initDepth) {
        this.initDepth = initDepth;
    }

    public double getInitLat() {
        return this.initLat;
    }

    public void setInitLat(double initLat) {
        this.initLat = initLat;
    }

    public double getInitLong() {
        return this.initLong;
    }

    public void setInitLong(double initLong) {
        this.initLong = initLong;
    }

    public String getControlFile() {
        return this.controlFile;
    }

    public void setControlFile(String controlFile) {
        this.controlFile = controlFile;
        try {
            this.parse(new File(controlFile));
        }
        catch (IOException ex) {
            logger.warn(ex.getMessage(), ex);
        }
    }

    public double getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public String getCorr_dir() {
        return this.corr_dir;
    }

    public String getCorr_type() {
        return this.corr_type;
    }

    public double getDamp() {
        return this.damp;
    }

    public String getPrefixTT() {
        return this.prefixTT;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public double getEst_std_err() {
        return this.est_std_err;
    }

    public int getNum_dof() {
        return this.num_dof;
    }
}

