/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.locsat;

import cn.org.gddsn.seis.location.locsat.LocsatControl;
import cn.org.gddsn.seis.location.locsat.Phase;
import cn.org.gddsn.seis.location.locsat.PhaseDataHeader;
import cn.org.gddsn.seis.location.locsat.libloc.Locsat0;
import cn.org.gddsn.seis.regions.RegionsFE;
import cn.org.gddsn.util.Log4jConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import org.netlib.util.floatW;
import org.netlib.util.intW;

public class LocSAT {
    static Logger logger = Logger.getLogger(LocSAT.class);
    public static final int GLerror1 = 1;
    public static final int GLerror2 = 2;
    public static final int GLerror3 = 3;
    public static final int GLerror4 = 4;
    public static final int GLerror5 = 5;
    public static final int GLerror6 = 6;
    public static final int GLerror7 = 7;
    public static final int GLerror8 = 8;
    public static final int GLerror9 = 9;
    public static final int GLerror10 = 10;
    public static final int GLerror11 = 11;
    public static final int TTerror1 = 12;
    public static final int TTerror2 = 13;
    public static final int TTerror3 = 14;
    public static final int TTerror4 = 15;
    public static final int SSerror1 = 16;
    String[] golocate_error_table = new String[]{"NA", "Locsat0:  Exceeded maximum iterations.", "Locsat0:  Solution did not converge.", "Locsat0:  Too few usable data.", "Locsat0:  Too few data to constrain O.T.", "Locsat0:  Insufficient data for a solution.", "Locsat0:  SVD routine cannot decompose matrix.", "Locate:  Warning - no observations to process.", "Locate:  Bad assoc data.", "Locate:  Bad origin data.", "Locate:  Bad origerr data.", "Locate:  Mismatch between arrival/assoc data.", "TT Tables:  Null wave id list.", "TT Tables:  Error opening tables.", "TT Tables:  Error reading tables, unexpected EOF.", "TT Tables:  Unknown error reading tables.", "Site Table:  Null station list."};
    public static final double NULL_TIME = -9.999999999999E9;
    public static final double STRIKE_NULL = -1.0;
    public static final double STRIKE_MIN = 0.0;
    public static final double STRIKE_MAX = 360.0;
    public static final int MAXTBD = 181;
    public static final int MAXTBZ = 20;
    public static final int ERR = -1;
    public static final int ERROR = 1;
    public static final int NOERROR = 0;
    String dir;
    String[] phase_type_ptr;
    int num_phase_types;
    int maxtbd = 181;
    int maxtbz = 20;
    float[][] tbd;
    float[][] tbz;
    float[][][] tbtt;
    float[] tbd1;
    float[] tbz1;
    float[] tbtt1;
    boolean first_table_read = true;
    int[] ntbd;
    int[] ntbz;
    int len_dir;
    int len_n_p_t = 9;
    int extrap_distance;
    int extrap_depth;
    int extrap_in_hole;
    int num_sta;
    String cortyp;
    int sta_cor_level;
    String net;
    int len_sta_id;
    String[] sta_id;
    float[] sta_lat;
    float[] sta_lon;
    float[] sta_elev;
    float[] sta_cor;
    boolean first_site_list = true;
    static String[] default_phases = new String[]{"LQ", "LR", "Lg", "P", "PKP", "PP", "PcP", "Pg", "Pn", "Rg", "S", "SKS", "SS", "ScS", "Sn", "Sg", "pP", "sP", "Pb", "Sb"};

    public int setup_sites(String new_net, Site[] new_sites, int new_num_sta) {
        if (!this.first_site_list && new_net != null && this.net != null && new_net.equals(this.net)) {
            return 0;
        }
        if (new_net != null) {
            this.net = new String(new_net);
        }
        if (new_num_sta == 0 || new_sites == null) {
            logger.warn("Error setup_sites: Null station list");
            return 16;
        }
        this.first_site_list = false;
        this.num_sta = new_num_sta;
        this.len_sta_id = 7;
        this.sta_id = new String[this.num_sta];
        this.sta_lat = new float[this.num_sta];
        this.sta_lon = new float[this.num_sta];
        this.sta_cor = new float[this.num_sta];
        this.sta_elev = new float[this.num_sta];
        int i = 0;
        while (i < this.num_sta) {
            this.sta_id[i] = new_sites[i].sta;
            this.sta_lat[i] = new_sites[i].lat;
            this.sta_lon[i] = new_sites[i].lon;
            this.sta_elev[i] = new_sites[i].elev;
            this.sta_cor[i] = 0.0f;
            ++i;
        }
        return 0;
    }

    int setup_tttables(String new_dir, String[] new_phase_types, int new_num_phase_types) {
        int _j;
        if (new_num_phase_types == 0 || new_phase_types == null) {
            logger.warn("Error setup_tttables: Null phase_type list");
            return 12;
        }
        if (!this.first_table_read && new_dir.equals(this.dir) && this.lstcmp(this.phase_type_ptr, new_phase_types)) {
            return 0;
        }
        this.first_table_read = false;
        this.dir = new String(new_dir);
        this.len_dir = this.dir.length();
        this.num_phase_types = new_num_phase_types;
        this.phase_type_ptr = new String[this.num_phase_types];
        int i = 0;
        while (i < this.num_phase_types) {
            this.phase_type_ptr[i] = new_phase_types[i];
            ++i;
        }
        this.ntbz = null;
        this.ntbd = null;
        this.tbz = null;
        this.tbd = null;
        this.tbtt = null;
        this.ntbd = new int[this.num_phase_types];
        this.ntbz = new int[this.num_phase_types];
        this.tbd = new float[this.num_phase_types][this.maxtbd];
        this.tbz = new float[this.num_phase_types][this.maxtbz];
        this.tbtt = new float[this.num_phase_types][this.maxtbz][this.maxtbd];
        int ierr = LocSAT.rdtttab(this.dir, this.phase_type_ptr, this.num_phase_types, this.maxtbd, this.maxtbz, this.ntbd, this.ntbz, this.tbd, this.tbz, this.tbtt);
        this.tbd1 = new float[this.num_phase_types * this.maxtbd];
        this.tbz1 = new float[this.num_phase_types * this.maxtbz];
        this.tbtt1 = new float[this.num_phase_types * this.maxtbz * this.maxtbd];
        int _k = 0;
        while (_k < this.num_phase_types) {
            _j = 0;
            while (_j < this.maxtbz) {
                this.tbz1[_k * this.maxtbz + _j] = this.tbz[_k][_j];
                ++_j;
            }
            ++_k;
        }
        this.tbz = null;
        _k = 0;
        while (_k < this.num_phase_types) {
            int _i = 0;
            while (_i < this.maxtbd) {
                this.tbd1[_k * this.maxtbd + _i] = this.tbd[_k][_i];
                ++_i;
            }
            ++_k;
        }
        this.tbd = null;
        _k = 0;
        while (_k < this.num_phase_types) {
            _j = 0;
            while (_j < this.maxtbz) {
                int _i = 0;
                while (_i < this.maxtbd) {
                    this.tbtt1[_k * this.maxtbz * this.maxtbd + _j * this.maxtbd + _i] = this.tbtt[_k][_j][_i];
                    ++_i;
                }
                ++_j;
            }
            ++_k;
        }
        this.tbtt = null;
        if (ierr == 0) {
            return 0;
        }
        if (ierr == 1) {
            logger.warn("setup_tttables: Error opening travel-time tables");
            return 13;
        }
        if (ierr == 2) {
            logger.warn("setup_tttables: Error reading travel-time tables: Unexpected E-O-F");
            return 14;
        }
        logger.warn("setup_tttables: Unknown error reading travel-time tables");
        return 15;
    }

    public int locate_event(String network, Site[] sites, int num_sites, Arrival[] arrival, Assoc[] assoc, Origin origin, Origerr origerr, Locator_params locator_params, Locator_errors[] locator_errors, int num_obs) {
        floatW lat = new floatW(0.0f);
        floatW lon = new floatW(0.0f);
        floatW depth = new floatW(0.0f);
        floatW torg = new floatW(0.0f);
        floatW semi_major_axis = new floatW(0.0f);
        floatW semi_minor_axis = new floatW(0.0f);
        floatW strike = new floatW(0.0f);
        floatW sxx = new floatW(0.0f);
        floatW syy = new floatW(0.0f);
        floatW szz = new floatW(0.0f);
        floatW stt = new floatW(0.0f);
        floatW sxy = new floatW(0.0f);
        floatW sxz = new floatW(0.0f);
        floatW syz = new floatW(0.0f);
        floatW stx = new floatW(0.0f);
        floatW sty = new floatW(0.0f);
        floatW stz = new floatW(0.0f);
        floatW sighat = new floatW(0.0f);
        floatW snssd = new floatW(0.0f);
        intW ndf = new intW(0);
        floatW depth_error = new floatW(0.0f);
        floatW origin_time_error = new floatW(0.0f);
        intW igap = new intW(0);
        intW niter = new intW(0);
        intW ierr = new intW(0);
        floatW lat_init = new floatW(0.0f);
        floatW lon_init = new floatW(0.0f);
        floatW depth_init = new floatW(0.0f);
        floatW fixing_depth = new floatW(0.0f);
        floatW est_std_error = new floatW(0.0f);
        floatW azimuth_wt = new floatW(0.0f);
        floatW damp = new floatW(0.0f);
        PrintWriter pwOut = null;
        boolean error_found = false;
        int loc_err = this.setup_sites(network, sites, num_sites);
        if (loc_err != 0) {
            logger.warn("locate_event: Aborting location process");
            return loc_err;
        }
        if (this.first_table_read) {
            String new_dir = locator_params.prefix;
            int new_num_phase_types = default_phases.length;
            String[] new_phase_types = default_phases;
            this.sta_cor_level = locator_params.cor_level;
            loc_err = this.setup_tttables(new_dir, new_phase_types, new_num_phase_types);
            if (loc_err != 0) {
                return loc_err;
            }
        }
        if (num_obs == 0 || arrival == null) {
            logger.warn("Warning locate_event: No observations to process");
            return 7;
        }
        if (assoc == null) {
            logger.warn("Error locate_event: Bad assoc data");
            return 8;
        }
        if (origin == null) {
            logger.warn("Error locate_event: Bad origin pointer");
            return 9;
        }
        if (origerr == null) {
            logger.warn("Error locate_event: Bad origerr pointer");
            return 10;
        }
        int i = 0;
        while (i < num_obs) {
            if (arrival[i].arid != assoc[i].arid) {
                logger.warn("Error locate_event: Mismatch between arrival/assoc.");
                return 11;
            }
            ++i;
        }
        lat_init.val = locator_params.lat_init;
        lon_init.val = locator_params.lon_init;
        depth_init.val = locator_params.depth_init;
        est_std_error.val = locator_params.est_std_error;
        int num_dof = locator_params.num_dof;
        float conf_level = locator_params.conf_level;
        damp.val = locator_params.damp;
        int max_iterations = locator_params.max_iterations;
        boolean fix_depth = locator_params.fix_depth;
        boolean verbose = locator_params.verbose;
        String outfile_name = locator_params.outfile_name;
        fixing_depth.val = locator_params.fixing_depth;
        lat_init.val = origin.lat;
        lon_init.val = origin.lon;
        if (!locator_params.use_location) {
            lon_init.val = -999.0f;
            lat_init.val = -999.0f;
        }
        if (fix_depth) {
            depth_init.val = fixing_depth.val;
        }
        int max_data = 3 * num_obs;
        String[] data_phase_type = new String[max_data];
        String[] data_sta_id = new String[max_data];
        String[] data_type = new String[max_data];
        String[] data_defining = new String[max_data];
        float[] obs_data = new float[max_data];
        float[] data_std_err = new float[max_data];
        int[] data_arrival_id_index = new int[max_data];
        int[] obs_data_index = new int[max_data];
        float[] sta_delta = new float[this.num_sta];
        float[] sta_azimuth = new float[this.num_sta];
        float[] sta_back_azimuth = new float[this.num_sta];
        float[] data_importances = new float[max_data];
        float[] zfimp = new float[max_data];
        float[] data_residual = new float[max_data];
        int[] sta_index = new int[max_data];
        int[] data_err_code = new int[max_data];
        i = 0;
        while (!LocSAT.VALID_TIME(arrival[i].time) && i < num_obs) {
            ++i;
        }
        double time_offset = i < num_obs ? arrival[i].time : 0.0;
        i = 0;
        while (i < num_obs) {
            if (LocSAT.VALID_TIME(arrival[i].time)) {
                time_offset = Math.min(time_offset, arrival[i].time);
            }
            ++i;
        }
        i = 0;
        int num_data = 0;
        while (i < num_obs) {
            data_arrival_id_index[num_data] = arrival[i].arid;
            data_sta_id[num_data] = arrival[i].sta;
            data_type[num_data] = "t";
            data_defining[num_data] = assoc[i].timedef;
            data_phase_type[num_data] = assoc[i].phase;
            obs_data[num_data] = (float)(arrival[i].time - time_offset);
            data_std_err[num_data] = arrival[i].deltim;
            obs_data_index[num_data] = i;
            ++num_data;
            if (LocSAT.VALID_SEAZ(arrival[i].azimuth)) {
                data_arrival_id_index[num_data] = arrival[i].arid;
                data_sta_id[num_data] = arrival[i].sta;
                data_type[num_data] = "a";
                data_defining[num_data] = assoc[i].azdef;
                data_phase_type[num_data] = assoc[i].phase;
                obs_data[num_data] = arrival[i].azimuth;
                data_std_err[num_data] = arrival[i].delaz;
                obs_data_index[num_data] = i;
                ++num_data;
            }
            if (LocSAT.VALID_SLOW(arrival[i].slow)) {
                data_arrival_id_index[num_data] = arrival[i].arid;
                data_sta_id[num_data] = arrival[i].sta;
                data_type[num_data] = "s";
                data_defining[num_data] = assoc[i].slodef;
                data_phase_type[num_data] = assoc[i].phase;
                obs_data[num_data] = arrival[i].slow;
                data_std_err[num_data] = arrival[i].delslo;
                obs_data_index[num_data] = i;
                ++num_data;
            }
            ++i;
        }
        if (verbose) {
            try {
                pwOut = new PrintWriter(new FileWriter(outfile_name));
            }
            catch (IOException ioEx) {
                verbose = false;
                logger.warn("Could not open " + outfile_name);
            }
        }
        Locsat0.locsat0(data_sta_id, data_phase_type, data_type, data_defining, obs_data, data_std_err, data_arrival_id_index, num_data, this.sta_id, this.sta_lat, this.sta_lon, this.sta_elev, this.sta_cor, this.num_sta, this.phase_type_ptr, this.num_phase_types, this.maxtbd, this.maxtbz, this.ntbd, this.ntbz, this.tbd1, this.tbz1, this.tbtt1, time_offset, lat_init, lon_init, depth_init, est_std_error, num_dof, conf_level, azimuth_wt, damp, max_iterations, verbose, fix_depth, outfile_name, pwOut, lat, lon, depth, torg, sighat, snssd, ndf, semi_major_axis, semi_minor_axis, strike, depth_error, origin_time_error, sxx, syy, szz, stt, sxy, sxz, syz, stx, sty, stz, sta_delta, sta_azimuth, sta_back_azimuth, data_importances, zfimp, data_residual, sta_index, data_err_code, igap, niter, ierr);
        if (verbose) {
            pwOut.close();
        }
        if (ierr.val == 6) {
            logger.warn("locate_event: Error 6 from locsat0: SVD routine can't decompose matrix\n");
        } else if (ierr.val == 5) {
            logger.warn("locate_event: Error 5 from locsat0: Insufficient data for a solution\n");
        } else if (ierr.val == 4) {
            logger.warn("locate_event: Error 4 from locsat0: Too few data to constrain O.T.\n");
        } else if (ierr.val == 3) {
            logger.warn("locate_event: Error 3 from locsat0: Too few usable data\n");
        } else if (ierr.val == 2) {
            logger.warn("locate_event: Error 2 from locsat0: Solution did not converge\n");
        } else if (ierr.val == 1) {
            logger.warn("locate_event: Error 1 from locsat0: Exceeded maximum iterations\n");
        } else {
            int j;
            if (Float.isNaN(lat.val) || Float.isNaN(lon.val) || Float.isNaN(depth.val)) {
                logger.warn("locate_event: SVD routine can't decompose matrix, SVD return NaN\n");
                ierr.val = 6;
                return ierr.val;
            }
            origin.lat = lat.val;
            origin.lon = lon.val;
            origin.depth = depth.val;
            origin.algorithm = "LocSAT";
            origin.auth = "Locator:";
            String user = System.getenv("USER");
            if (user != null) {
                origin.auth = String.valueOf(origin.auth) + user;
            }
            origin.grn = RegionsFE.getFeGeoRegionNum(lat.val, lon.val);
            origin.igap = igap.val;
            origerr.sdobs = sighat.val;
            origerr.sxx = sxx.val;
            origerr.syy = syy.val;
            origerr.szz = szz.val;
            origerr.sxy = sxy.val;
            origerr.sxz = sxz.val;
            origerr.syz = syz.val;
            origerr.stt = stt.val;
            origerr.stx = stx.val;
            origerr.sty = sty.val;
            origerr.stz = stz.val;
            origerr.smajax = semi_major_axis.val;
            origerr.sminax = semi_minor_axis.val;
            origerr.stime = origin_time_error.val;
            origerr.sdepth = depth_error.val;
            if ((double)strike.val < 0.0 && (double)strike.val != -1.0) {
                while ((double)strike.val < 0.0) {
                    strike.val += 180.0f;
                }
            }
            origerr.strike = strike.val;
            if (ierr.val == 4) {
                logger.warn("locate_event: Error 4 from locsta0: Unconstrained origin time");
                origin.time = -9.999999999999E9;
                origerr.stt = stt.val;
                origerr.stx = stx.val;
                origerr.sty = sty.val;
                origerr.stz = stz.val;
            } else if (ierr.val == 0) {
                origin.time = (double)torg.val + time_offset;
            }
            i = 0;
            while (i < num_data) {
                j = obs_data_index[i];
                locator_errors[j].arid = data_arrival_id_index[i];
                if (data_type[i].equals("t")) {
                    if (ierr.val != 4) {
                        assoc[j].timeres = data_residual[i];
                        locator_errors[j].time = data_err_code[i];
                        if (data_err_code[i] != 0) {
                            error_found = true;
                            assoc[j].timedef = "n";
                        }
                    }
                    assoc[j].azres = -999.0f;
                    assoc[j].slores = -999.0f;
                } else if (data_type[i].equals("a")) {
                    assoc[j].azres = data_residual[i];
                    locator_errors[j].az = data_err_code[i];
                    if (data_err_code[i] != 0) {
                        error_found = true;
                        assoc[j].azdef = "n";
                    }
                } else if (data_type[i].equals("s")) {
                    assoc[j].slores = data_residual[i];
                    locator_errors[j].slow = data_err_code[i];
                    if (data_err_code[i] != 0) {
                        error_found = true;
                        assoc[j].slodef = "n";
                    }
                }
                if (error_found) {
                    locator_errors[j].arid = assoc[j].arid;
                    error_found = false;
                }
                ++i;
            }
            i = 0;
            while (i < num_data) {
                j = obs_data_index[i];
                int k = sta_index[i] - 1;
                assoc[j].delta = sta_delta[k];
                assoc[j].seaz = sta_back_azimuth[k];
                assoc[j].esaz = sta_azimuth[k];
                ++i;
            }
            i = 0;
            j = 0;
            while (i < num_obs) {
                if (assoc[i].timedef.equals("d")) {
                    ++j;
                }
                ++i;
            }
            origin.ndef = j;
            origin.nass = i;
        }
        return ierr.val;
    }

    int find_phase(String phase) {
        int n = -1;
        int i = 0;
        while (i < this.num_phase_types) {
            if (phase.equals(this.phase_type_ptr[i])) {
                n = i;
                break;
            }
            ++i;
        }
        return n;
    }

    public static int rdtttab(String froot, String[] phase_type_ptr, int nwav, int maxtbd, int maxtbz, int[] ntbd, int[] ntbz, float[][] tbd, float[][] tbz, float[][][] tbtt) {
        int ntbzx = 0;
        int ntbdx = 0;
        BufferedReader br = null;
        int cnt = 0;
        int num_files = 0;
        StringTokenizer st = null;
        String line = null;
        int err = 0;
        int k = 0;
        while (k < nwav && err == 0) {
            block27: {
                String filnam = String.valueOf(froot) + "." + phase_type_ptr[k];
                try {
                    br = new BufferedReader(new FileReader(filnam));
                }
                catch (IOException ex) {
                    logger.warn("File " + filnam + " will not open!");
                    ntbd[k] = 0;
                    ntbz[k] = 0;
                    break block27;
                }
                ++cnt;
                try {
                    br.readLine();
                    line = br.readLine();
                    st = new StringTokenizer(line);
                    ntbzx = Integer.parseInt(st.nextToken());
                }
                catch (Exception ex) {
                    logger.warn("Error in reading number of depth samples!");
                    err = 2;
                }
                if (err == 0 && (ntbz[k] = ntbzx) > maxtbz) {
                    logger.warn(String.format("%s %s, %d used, %d skipped\n", "\nToo many depth samples in file", filnam, maxtbz, ntbzx - maxtbz));
                    ntbz[k] = maxtbz;
                }
                int i = 0;
                while (i < ntbzx && err == 0) {
                    try {
                        line = br.readLine();
                    }
                    catch (IOException ex) {
                        logger.warn("Error in reading depth sample!");
                        err = 2;
                    }
                    st = new StringTokenizer(line);
                    while (st.hasMoreTokens()) {
                        if (i >= ntbz[k]) continue;
                        tbz[k][i++] = Float.parseFloat(st.nextToken());
                    }
                }
                try {
                    line = br.readLine();
                    st = new StringTokenizer(line);
                    ntbdx = Integer.parseInt(st.nextToken());
                }
                catch (Exception ex) {
                    logger.warn("Error in reading number of distance samples!");
                    err = 2;
                }
                if (err == 0 && (ntbd[k] = ntbdx) > maxtbd) {
                    logger.warn(String.format("%s %s, %d used, %d skipped\n", "\nToo many distance samples in file", filnam, maxtbd, ntbdx - maxtbd));
                    ntbd[k] = maxtbd;
                }
                i = 0;
                while (i < ntbdx && err == 0) {
                    try {
                        line = br.readLine();
                    }
                    catch (IOException ex) {
                        logger.warn("Error in reading delta sample!");
                        err = 2;
                    }
                    st = new StringTokenizer(line);
                    while (st.hasMoreTokens()) {
                        if (i >= ntbd[k]) continue;
                        tbd[k][i++] = Float.parseFloat(st.nextToken());
                    }
                }
                int j = 0;
                while (j < ntbzx && err == 0) {
                    try {
                        line = br.readLine();
                    }
                    catch (IOException ex) {
                        logger.warn("Error in reading travel time sample!");
                        err = 2;
                    }
                    i = 0;
                    while (i < ntbdx && err == 0) {
                        try {
                            line = br.readLine();
                        }
                        catch (IOException ex) {
                            logger.warn("Error in reading travel time sample!");
                            err = 2;
                        }
                        st = new StringTokenizer(line);
                        while (st.hasMoreTokens()) {
                            if (j >= ntbd[k]) continue;
                            tbtt[k][j][i++] = Float.parseFloat(st.nextToken());
                        }
                    }
                    ++j;
                }
                ++num_files;
                try {
                    br.close();
                }
                catch (IOException ex) {
                    logger.warn("Error in cloing file!");
                    err = 2;
                }
            }
            ++k;
        }
        if (num_files == 0 && cnt > 0) {
            logger.warn(String.format("rdtttab: No tables can be read\n", new Object[0]));
            err = 1;
        }
        return err;
    }

    boolean lstcmp(String[] list1, String[] list2) {
        boolean found = false;
        if (list1.length != list2.length) {
            return false;
        }
        int i = 0;
        while (i < list1.length) {
            found = false;
            int j = 0;
            while (j < list2.length) {
                if (list1[i].equals(list2[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) break;
            ++i;
        }
        return found;
    }

    public static boolean VALID_TIME(double x) {
        return x > -9.999999999E9;
    }

    public static boolean VALID_SEAZ(double x) {
        return x >= 0.0 && x <= 360.0;
    }

    public static boolean VALID_SLOW(double x) {
        return x >= 0.0;
    }

    public void find_dist(int phase_id, double tcalc, double[] delta, int[] iterr) {
        iterr[0] = 0;
        if ((double)this.tbtt[phase_id][0][0] > tcalc) {
            iterr[0] = 1;
            return;
        }
        int i = 0;
        while (i < this.ntbd[phase_id]) {
            if ((double)this.tbtt[phase_id][0][i] > tcalc) {
                double tmp = (tcalc - (double)this.tbtt[phase_id][0][i - 1]) / (double)(this.tbtt[phase_id][0][i] - this.tbtt[phase_id][0][i - 1]);
                delta[0] = (double)this.tbd[phase_id][i - 1] + tmp * (double)(this.tbd[phase_id][i] - this.tbd[phase_id][i - 1]);
                return;
            }
            ++i;
        }
    }

    public void find_ttime(int phase_id, double delta, double[] tcalc, int[] iterr) {
        iterr[0] = 0;
        if ((double)this.tbd[phase_id][0] > delta) {
            iterr[0] = 1;
            return;
        }
        int i = 0;
        while (i < this.ntbd[phase_id]) {
            if ((double)this.tbd[phase_id][i] > delta) {
                double tmp = (delta - (double)this.tbd[phase_id][i - 1]) / (double)(this.tbd[phase_id][i] - this.tbd[phase_id][i - 1]);
                tcalc[0] = (double)this.tbtt[phase_id][0][i - 1] + tmp * (double)(this.tbtt[phase_id][0][i] - this.tbtt[phase_id][0][i - 1]);
                return;
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain("LocSAT.properties");
        LocSAT locSAT = new LocSAT();
        String outFile = "out";
        String staFile = "sta";
        String inFile = "in";
        String ctlFile = "ctl";
        Options options = new Options();
        Option help = new Option("h", "print this message");
        OptionBuilder.withArgName((String)"Control filename");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"contains information on how to perform the location");
        Option ctl = OptionBuilder.create((String)"c");
        OptionBuilder.withArgName((String)"Station filename");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"contains station information");
        Option sta = OptionBuilder.create((String)"s");
        OptionBuilder.withArgName((String)"Data filename");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"contains observed phase data");
        Option in = OptionBuilder.create((String)"d");
        OptionBuilder.withArgName((String)"Output  filename");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"contains location result");
        Option out = OptionBuilder.create((String)"o");
        options.addOption(help).addOption(ctl).addOption(sta).addOption(in).addOption(out);
        BasicParser parser = new BasicParser();
        CommandLine cmd = parser.parse(options, args);
        if (args.length == 0 || cmd.hasOption(help.getOpt())) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("LocSAT", options);
            System.exit(-1);
        }
        if (cmd.hasOption(ctl.getOpt())) {
            ctlFile = cmd.getOptionValue(ctl.getOpt());
        }
        if (cmd.hasOption(sta.getOpt())) {
            staFile = cmd.getOptionValue(sta.getOpt());
        }
        if (cmd.hasOption(in.getOpt())) {
            inFile = cmd.getOptionValue(in.getOpt());
        }
        if (cmd.hasOption(out.getOpt())) {
            outFile = cmd.getOptionValue(out.getOpt());
        }
        Site[] sites = new Site[1200];
        Locator_params locator_params = new Locator_params();
        Origerr origerr = new Origerr();
        Origin origin = new Origin();
        String newnet = null;
        int num_obs = 0;
        int num_data = 0;
        int num_sta = 0;
        locator_params.outfile_name = outFile;
        LocsatControl locsatCtl = new LocsatControl();
        locsatCtl.parse(new File(ctlFile));
        locator_params.prefix = String.valueOf(locsatCtl.getDirTT()) + "/" + locsatCtl.getPrefixTT();
        locator_params.cor_level = 0;
        locator_params.fix_depth = locsatCtl.isFixDepth();
        locator_params.verbose = locsatCtl.isVerbose();
        locator_params.conf_level = (float)locsatCtl.getConfidenceLevel();
        locator_params.damp = (float)locsatCtl.getDamp();
        locator_params.est_std_error = (float)locsatCtl.getEst_std_err();
        locator_params.num_dof = locsatCtl.getNum_dof();
        locator_params.max_iterations = locsatCtl.getMaxIterations();
        locator_params.use_location = locsatCtl.isUseLocation();
        BufferedReader br = new BufferedReader(new FileReader(staFile));
        num_sta = 0;
        String line = null;
        StringTokenizer st = null;
        while ((line = br.readLine()) != null) {
            sites[num_sta] = new Site();
            st = new StringTokenizer(line);
            sites[num_sta].sta = st.nextToken();
            sites[num_sta].lat = Float.parseFloat(st.nextToken());
            sites[num_sta].lon = Float.parseFloat(st.nextToken());
            sites[num_sta].elev = Float.parseFloat(st.nextToken());
            ++num_sta;
        }
        if (num_sta >= 1200) {
            logger.warn("Number of stations greater than dimension 1200 remaining Stations ignored!");
        }
        br.close();
        br = new BufferedReader(new FileReader(inFile));
        while (true) {
            long now = System.currentTimeMillis();
            PhaseDataHeader pd = new PhaseDataHeader();
            line = br.readLine();
            if (line == null) {
                br.close();
                return;
            }
            pd.parse(line);
            locator_params.lat_init = pd.getLatInit();
            locator_params.lon_init = pd.getLonInit();
            locator_params.depth_init = pd.getDepthInit();
            num_data = pd.getNumData();
            double origin_time_init = pd.getOriginTimeInit();
            origin.lat = locator_params.lat_init;
            origin.lon = locator_params.lon_init;
            origin.depth = locator_params.depth_init;
            origerr.sdobs = -1.0f;
            origerr.smajax = -1.0f;
            origerr.sminax = -1.0f;
            origerr.strike = -1.0f;
            origerr.stime = -1.0f;
            origerr.sdepth = -1.0f;
            origerr.sxx = -1.0f;
            origerr.sxz = -1.0f;
            origerr.syz = -1.0f;
            origerr.syy = -1.0f;
            origerr.szz = -1.0f;
            origerr.sxy = -1.0f;
            origerr.stt = -1.0f;
            origerr.stx = -1.0f;
            origerr.sty = -1.0f;
            origerr.stz = -1.0f;
            Arrival[] arrival = new Arrival[num_data];
            Assoc[] assoc = new Assoc[num_data];
            Locator_errors[] locator_errors = new Locator_errors[num_data];
            int i = 0;
            while (i < num_data) {
                arrival[i] = new Arrival();
                assoc[i] = new Assoc();
                locator_errors[i] = new Locator_errors();
                ++i;
            }
            assoc[0].orid = 90000001;
            locator_params.fixing_depth = locator_params.depth_init;
            num_obs = 0;
            int n = 0;
            while ((line = br.readLine()) != null && n < num_data) {
                Phase ph = new Phase();
                ph.parse(line);
                if (ph.getDataType().equals("t")) {
                    if (n != 0) {
                        ++num_obs;
                    }
                    arrival[num_obs].time = origin_time_init + (double)ph.getDatum();
                    arrival[num_obs].azimuth = -1.0f;
                    arrival[num_obs].slow = -1.0f;
                    arrival[num_obs].deltim = ph.getStdErr();
                    assoc[num_obs].timedef = ph.getArrivalType();
                } else if (ph.getDataType().equals("a")) {
                    arrival[num_obs].azimuth = ph.getDatum();
                    arrival[num_obs].delaz = ph.getStdErr();
                    assoc[num_obs].azdef = ph.getArrivalType();
                } else if (ph.getDataType().equals("s")) {
                    arrival[num_obs].slow = ph.getDatum();
                    arrival[num_obs].delslo = ph.getStdErr();
                    assoc[num_obs].slodef = ph.getArrivalType();
                }
                arrival[num_obs].arid = ph.getId();
                assoc[num_obs].arid = ph.getId();
                arrival[num_obs].sta = ph.getStationCode();
                assoc[num_obs].sta = ph.getStationCode();
                assoc[num_obs].phase = ph.getPhase();
                ++n;
            }
            ++num_obs;
            if (n >= 1200) {
                logger.warn("Number of data greater than dimension: 1200, remaining Data ignored!");
            }
            int status = locSAT.locate_event(newnet, sites, num_sta, arrival, assoc, origin, origerr, locator_params, locator_errors, num_obs);
            ++status;
            --status;
            Date date = new Date((long)(origin.time * 1000.0));
            System.out.printf("Origin time: %1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL\n\n", date);
            System.out.println("locsat time: " + (System.currentTimeMillis() - now));
        }
    }

    public static class Arrival {
        public String sta;
        public String chan;
        public double time;
        public int arid;
        public int stassid;
        public int chanid;
        public int jdate;
        public String iphase;
        public String stype;
        public float deltim;
        public float azimuth;
        public float delaz;
        public float slow;
        public float delslo;
        public float ema;
        public float rect;
        public float amp;
        public float per;
        public float logat;
        public String clip;
        public String fm;
        public float snr;
        public String qual;
        public String auth;
        public int commid;
        public String lddate;
    }

    public static class Assoc {
        public int arid;
        public int orid;
        public String sta;
        public String phase;
        public float belief;
        public float delta;
        public float seaz;
        public float esaz;
        public float timeres;
        public String timedef;
        public float azres;
        public String azdef;
        public float slores;
        public String slodef;
        public float emares;
        public float wgt;
        public String vmodel;
        public int commid;
        public String lddate;
    }

    public static class Locator_errors {
        public int arid;
        public int time;
        public int az;
        public int slow;
    }

    public static class Locator_params {
        public int num_dof;
        public float est_std_error;
        public float conf_level;
        public float damp;
        public int max_iterations;
        public boolean fix_depth;
        public float fixing_depth;
        public float lat_init;
        public float lon_init;
        public float depth_init;
        public boolean use_location;
        public boolean verbose;
        public int cor_level;
        public String outfile_name;
        public String prefix;
    }

    public static class Origerr {
        public long orid;
        public float sxx;
        public float syy;
        public float szz;
        public float stt;
        public float sxy;
        public float sxz;
        public float syz;
        public float stx;
        public float sty;
        public float stz;
        public float sdobs;
        public float smajax;
        public float sminax;
        public float strike;
        public float sdepth;
        public float stime;
        public float conf;
        public int commid;
        public String lddate;
    }

    public static class Origin {
        public float lat;
        public float lon;
        public float depth;
        public double time;
        public int orid;
        public int evid;
        public int jdate;
        public int nass;
        public int ndef;
        public int ndp;
        public int grn;
        public int igap;
        public String etype;
        public float depdp;
        public String dtype;
        public float mb;
        public int mbid;
        public float ms;
        public int msid;
        public float ml;
        public int mlid;
        public String algorithm;
        public String auth;
        public long commid;
        public String lddate;
    }

    public static class Site {
        public String sta;
        public int ondate;
        public int offdate;
        public float lat;
        public float lon;
        public float elev;
        public String staname;
        public String statype;
        public String refsta;
        public float dnorth;
        public float deast;
        public String lddate;
    }
}

