/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.hypoinverse;

import java.util.Formatter;
import java.util.GregorianCalendar;

public class Phase {
    private String stationCode;
    private String netCode;
    private String blank1 = " ";
    private String compCode;
    private String chanCode;
    private String blank2 = " ";
    private String remarkP = " P";
    private String firstMotionP = " ";
    private int weightCodeP = 0;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private float arrivalP;
    private float residualP;
    private float weightActuallyUsedP;
    private float arrivalS;
    private String remarkS = "  ";
    private String blank = " ";
    private int weightCodeS = 0;
    private float residualS;
    private float amp;
    private int ampUnitsCode = 0;
    private float weightActuallyUsedS;
    private float delayTimeP;
    private float delayTimeS;
    private float delta;
    private float emergencAngle;
    private int ampMagWeightCode;
    private int durationMagWeightCode;
    private float period;
    private String stationRemark = " ";
    private float codaDuration;
    private float azimuth;
    private float durationMag;
    private float ampMag;
    private float importanceArrivalP;
    private float importanceArrivalS;
    private String dataSourceCode = "W";
    private String durationMagLabelCode = " ";
    private String ampMagLabelCode = " ";
    private String location = "  ";
    private int ampType = 0;
    private String alternateCompCode = "---";
    private String ampMagUsedFlag = " ";
    private String durationMagUsedFlag = " ";
    private int from = 0;

    public void parse(cn.org.gddsn.seis.Phase p) {
        this.stationCode = p.getStationCode();
        this.netCode = p.getNetCode();
        this.compCode = "0";
        this.chanCode = p.getChanCode();
        if (p.getPhaType() == 0 && p.getPhaseName().startsWith("P")) {
            this.remarkP = p.getClarity() == null ? " P" : String.valueOf(p.getClarity()) + "P";
            this.firstMotionP = p.getWsign();
            if (this.firstMotionP == null) {
                this.firstMotionP = " ";
            }
            this.weightCodeP = p.getWeight() == 1 ? 0 : 4;
        } else {
            this.remarkP = "  ";
            this.firstMotionP = " ";
            this.weightCodeP = 4;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(p.getPhaseTime());
        this.year = c.get(1);
        this.month = c.get(2) + 1;
        this.day = c.get(5);
        this.hour = c.get(11);
        this.minute = c.get(12);
        this.arrivalP = (float)c.get(13) + (float)c.get(14) / 1000.0f;
        this.residualP = 0.0f;
        this.weightActuallyUsedP = 0.0f;
        this.arrivalS = (float)c.get(13) + (float)c.get(14) / 1000.0f;
        if (p.getPhaType() == 0 && p.getPhaseName().startsWith("S")) {
            this.remarkS = p.getClarity() == null ? " S" : String.valueOf(p.getClarity()) + "S";
            this.weightCodeS = p.getWeight() == 1 ? 0 : 4;
        } else {
            this.remarkS = "  ";
            this.weightCodeS = 4;
        }
        this.residualS = 0.0f;
        this.amp = 0.0f;
        this.ampUnitsCode = 0;
        this.weightActuallyUsedS = 0.0f;
        this.delayTimeP = 0.0f;
        this.delayTimeS = 0.0f;
        this.delta = 0.0f;
        this.emergencAngle = 0.0f;
        this.ampMagWeightCode = 0;
        this.durationMagWeightCode = 0;
        this.period = (float)p.getPeriod();
        this.stationRemark = " ";
        this.codaDuration = 0.0f;
        this.azimuth = (int)p.getAzimuth();
        if (this.azimuth < 0.0f) {
            this.azimuth = 0.0f;
        }
        this.durationMag = 0.0f;
        this.ampMag = 0.0f;
        this.importanceArrivalP = 0.0f;
        this.importanceArrivalS = 0.0f;
    }

    public void parse(String buf) {
        this.from = 0;
        this.stationCode = this.getNextField(buf, 5).trim();
        this.netCode = this.getNextField(buf, 3).trim();
        this.compCode = this.getNextField(buf, 1);
        this.chanCode = this.getNextField(buf, 4).trim();
        this.remarkP = this.getNextField(buf, 2);
        this.firstMotionP = this.getNextField(buf, 1);
        this.weightCodeP = Integer.parseInt(this.getNextField(buf, 1));
        this.year = Integer.parseInt(this.getNextField(buf, 4));
        this.month = Integer.parseInt(this.getNextField(buf, 2).trim());
        this.day = Integer.parseInt(this.getNextField(buf, 2).trim());
        this.hour = Integer.parseInt(this.getNextField(buf, 2).trim());
        this.minute = Integer.parseInt(this.getNextField(buf, 2).trim());
        this.arrivalP = (float)Integer.parseInt(this.getNextField(buf, 5).trim()) / 100.0f;
        this.residualP = (float)Integer.parseInt(this.getNextField(buf, 4).trim()) / 100.0f;
        this.weightActuallyUsedP = (float)Integer.parseInt(this.getNextField(buf, 3).trim()) / 100.0f;
        this.arrivalS = (float)Integer.parseInt(this.getNextField(buf, 5).trim()) / 100.0f;
        this.remarkS = this.getNextField(buf, 3).trim();
        this.weightCodeS = Integer.parseInt(this.getNextField(buf, 1));
        this.residualS = (float)Integer.parseInt(this.getNextField(buf, 4).trim()) / 100.0f;
        this.amp = (float)Integer.parseInt(this.getNextField(buf, 7).trim()) / 100.0f;
        this.ampUnitsCode = Integer.parseInt(this.getNextField(buf, 2).trim());
        this.weightActuallyUsedS = (float)Integer.parseInt(this.getNextField(buf, 3).trim()) / 100.0f;
        this.delayTimeP = (float)Integer.parseInt(this.getNextField(buf, 4).trim()) / 100.0f;
        this.delayTimeS = (float)Integer.parseInt(this.getNextField(buf, 4).trim()) / 100.0f;
        this.delta = (float)Integer.parseInt(this.getNextField(buf, 4).trim()) / 10.0f;
        this.emergencAngle = Integer.parseInt(this.getNextField(buf, 3).trim());
        this.ampMagWeightCode = Integer.parseInt(this.getNextField(buf, 1));
        this.durationMagWeightCode = Integer.parseInt(this.getNextField(buf, 1));
        this.period = (float)Integer.parseInt(this.getNextField(buf, 3).trim()) / 100.0f;
        this.stationRemark = this.getNextField(buf, 1);
        this.codaDuration = Integer.parseInt(this.getNextField(buf, 4).trim());
        this.azimuth = Integer.parseInt(this.getNextField(buf, 3).trim());
        this.durationMag = (float)Integer.parseInt(this.getNextField(buf, 3).trim()) / 100.0f;
        this.ampMag = (float)Integer.parseInt(this.getNextField(buf, 3).trim()) / 100.0f;
        this.importanceArrivalP = (float)Integer.parseInt(this.getNextField(buf, 4).trim()) / 1000.0f;
        this.importanceArrivalS = (float)Integer.parseInt(this.getNextField(buf, 4).trim()) / 1000.0f;
        this.dataSourceCode = this.getNextField(buf, 1);
        this.durationMagLabelCode = this.getNextField(buf, 1);
        this.ampMagLabelCode = this.getNextField(buf, 1);
        if (buf.length() > 112) {
            this.location = this.getNextField(buf, 2);
            this.ampType = Integer.parseInt(this.getNextField(buf, 2).trim());
            this.alternateCompCode = this.getNextField(buf, 3);
            this.ampMagUsedFlag = this.getNextField(buf, 1);
            this.durationMagUsedFlag = this.getNextField(buf, 1);
        }
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("%1$-5s%2$2s %3$1s%4$3s ", this.stationCode, this.netCode, this.compCode, this.chanCode);
        fmt.format("%1$2s%2$1s%3$1d", this.remarkP, this.firstMotionP, this.weightCodeP);
        fmt.format("%1$4d%2$02d%3$02d%4$02d%5$02d", this.year, this.month, this.day, this.hour, this.minute);
        fmt.format("%1$5d%2$4d%3$3d", (int)(this.arrivalP * 100.0f), (int)(this.residualP * 100.0f), (int)(this.weightActuallyUsedP * 100.0f));
        fmt.format("%1$5d%2$2s %3$1d%4$4d", (int)(this.arrivalS * 100.0f), this.remarkS, this.weightCodeS, (int)(this.residualS * 100.0f));
        fmt.format("%1$7d%2$2d%3$3d%4$4d%5$4d", (int)(this.amp * 100.0f), this.ampUnitsCode, (int)(this.weightActuallyUsedS * 100.0f), (int)(this.delayTimeP * 100.0f), (int)(this.delayTimeS * 100.0f));
        fmt.format("%1$4d%2$3d%3$1d%4$1d%5$3d", (int)(this.delta * 10.0f), (int)this.emergencAngle, this.ampMagWeightCode, this.durationMagWeightCode, (int)(this.period * 100.0f));
        fmt.format("%1$1s%2$4d%3$3d%4$3d%5$3d", this.stationRemark, (int)this.codaDuration, (int)this.azimuth, (int)(this.durationMag * 100.0f), (int)(this.ampMag * 100.0f));
        fmt.format("%1$4d%2$4d%3$1s%4$1s%5$1s", (int)(this.importanceArrivalP * 1000.0f), (int)(this.importanceArrivalS * 1000.0f), this.dataSourceCode, this.durationMagLabelCode, this.ampMagLabelCode);
        fmt.format("%1$2s%2$2d%3$3s%4$1s%5$1s", this.location, this.ampType, this.alternateCompCode, this.ampMagUsedFlag, this.durationMagUsedFlag);
        return sb.substring(0);
    }

    private String getNextField(String buf, int width) {
        String field = buf.substring(this.from, this.from + width);
        this.from += width;
        return field;
    }

    public String getAlternateCompCode() {
        return this.alternateCompCode;
    }

    public void setAlternateCompCode(String alternateCompCode) {
        this.alternateCompCode = alternateCompCode;
    }

    public float getAmp() {
        return this.amp;
    }

    public void setAmp(float amp) {
        this.amp = amp;
    }

    public float getAmpMag() {
        return this.ampMag;
    }

    public void setAmpMag(float ampMag) {
        this.ampMag = ampMag;
    }

    public String getAmpMagLabelCode() {
        return this.ampMagLabelCode;
    }

    public void setAmpMagLabelCode(String ampMagLabelCode) {
        this.ampMagLabelCode = ampMagLabelCode;
    }

    public String getAmpMagUsedFlag() {
        return this.ampMagUsedFlag;
    }

    public void setAmpMagUsedFlag(String ampMagUsedFlag) {
        this.ampMagUsedFlag = ampMagUsedFlag;
    }

    public int getAmpMagWeightCode() {
        return this.ampMagWeightCode;
    }

    public void setAmpMagWeightCode(int ampMagWeightCode) {
        this.ampMagWeightCode = ampMagWeightCode;
    }

    public int getAmpType() {
        return this.ampType;
    }

    public void setAmpType(int ampType) {
        this.ampType = ampType;
    }

    public int getAmpUnitsCode() {
        return this.ampUnitsCode;
    }

    public void setAmpUnitsCode(int ampUnitsCode) {
        this.ampUnitsCode = ampUnitsCode;
    }

    public float getArrivalP() {
        return this.arrivalP;
    }

    public void setArrivalP(float arrivalP) {
        this.arrivalP = arrivalP;
    }

    public float getArrivalS() {
        return this.arrivalS;
    }

    public void setArrivalS(float arrivalS) {
        this.arrivalS = arrivalS;
    }

    public float getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(float azimuth) {
        this.azimuth = azimuth;
    }

    public String getBlank() {
        return this.blank;
    }

    public void setBlank(String blank) {
        this.blank = blank;
    }

    public String getBlank1() {
        return this.blank1;
    }

    public void setBlank1(String blank1) {
        this.blank1 = blank1;
    }

    public String getBlank2() {
        return this.blank2;
    }

    public void setBlank2(String blank2) {
        this.blank2 = blank2;
    }

    public String getChanCode() {
        return this.chanCode;
    }

    public void setChanCode(String chanCode) {
        this.chanCode = chanCode;
    }

    public float getCodaDuration() {
        return this.codaDuration;
    }

    public void setCodaDuration(float codaDuration) {
        this.codaDuration = codaDuration;
    }

    public String getCompCode() {
        return this.compCode;
    }

    public void setCompCode(String compCode) {
        this.compCode = compCode;
    }

    public String getDataSourceCode() {
        return this.dataSourceCode;
    }

    public void setDataSourceCode(String dataSourceCode) {
        this.dataSourceCode = dataSourceCode;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public float getDelayTimeP() {
        return this.delayTimeP;
    }

    public void setDelayTimeP(float delayTimeP) {
        this.delayTimeP = delayTimeP;
    }

    public float getDelayTimeS() {
        return this.delayTimeS;
    }

    public void setDelayTimeS(float delayTimeS) {
        this.delayTimeS = delayTimeS;
    }

    public float getDelta() {
        return this.delta;
    }

    public void setDelta(float delta) {
        this.delta = delta;
    }

    public float getDurationMag() {
        return this.durationMag;
    }

    public void setDurationMag(float durationMag) {
        this.durationMag = durationMag;
    }

    public String getDurationMagLabelCode() {
        return this.durationMagLabelCode;
    }

    public void setDurationMagLabelCode(String durationMagLabelCode) {
        this.durationMagLabelCode = durationMagLabelCode;
    }

    public String getDurationMagUsedFlag() {
        return this.durationMagUsedFlag;
    }

    public void setDurationMagUsedFlag(String durationMagUsedFlag) {
        this.durationMagUsedFlag = durationMagUsedFlag;
    }

    public int getDurationMagWeightCode() {
        return this.durationMagWeightCode;
    }

    public void setDurationMagWeightCode(int durationMagWeightCode) {
        this.durationMagWeightCode = durationMagWeightCode;
    }

    public float getEmergencAngle() {
        return this.emergencAngle;
    }

    public void setEmergencAngle(float emergencAngle) {
        this.emergencAngle = emergencAngle;
    }

    public String getFirstMotionP() {
        return this.firstMotionP;
    }

    public void setFirstMotionP(String firstMotionP) {
        this.firstMotionP = firstMotionP;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public float getImportanceArrivalP() {
        return this.importanceArrivalP;
    }

    public void setImportanceArrivalP(float importanceArrivalP) {
        this.importanceArrivalP = importanceArrivalP;
    }

    public float getImportanceArrivalS() {
        return this.importanceArrivalS;
    }

    public void setImportanceArrivalS(float importanceArrivalS) {
        this.importanceArrivalS = importanceArrivalS;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public String getNetCode() {
        return this.netCode;
    }

    public void setNetCode(String netCode) {
        this.netCode = netCode;
    }

    public float getPeriod() {
        return this.period;
    }

    public void setPeriod(float period) {
        this.period = period;
    }

    public String getRemarkP() {
        return this.remarkP;
    }

    public void setRemarkP(String remarkP) {
        this.remarkP = remarkP;
    }

    public String getRemarkS() {
        return this.remarkS;
    }

    public void setRemarkS(String remarkS) {
        this.remarkS = remarkS;
    }

    public float getResidualP() {
        return this.residualP;
    }

    public void setResidualP(float residualP) {
        this.residualP = residualP;
    }

    public float getResidualS() {
        return this.residualS;
    }

    public void setResidualS(float residualS) {
        this.residualS = residualS;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public void setStationCode(String stationCode) {
        this.stationCode = stationCode;
    }

    public String getStationRemark() {
        return this.stationRemark;
    }

    public void setStationRemark(String stationRemark) {
        this.stationRemark = stationRemark;
    }

    public float getWeightActuallyUsedP() {
        return this.weightActuallyUsedP;
    }

    public void setWeightActuallyUsedP(float weightActuallyUsedP) {
        this.weightActuallyUsedP = weightActuallyUsedP;
    }

    public float getWeightActuallyUsedS() {
        return this.weightActuallyUsedS;
    }

    public void setWeightActuallyUsedS(float weightActuallyUsedS) {
        this.weightActuallyUsedS = weightActuallyUsedS;
    }

    public int getWeightCodeP() {
        return this.weightCodeP;
    }

    public void setWeightCodeP(int weightCodeP) {
        this.weightCodeP = weightCodeP;
    }

    public int getWeightCodeS() {
        return this.weightCodeS;
    }

    public void setWeightCodeS(int weightCodeS) {
        this.weightCodeS = weightCodeS;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }
}

