/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.linalg.Distance;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

class TravelTimeTable
implements ComputedTravelTime {
    static Logger logger = Logger.getLogger(TravelTimeTable.class);
    int TTTableColumSum;
    int TTTableRowSum;
    int TTDepthSum;
    double[][][] TTTable;
    double[] Depth;
    String[][] phaseName = null;

    private int getColumnIndex(double depth) {
        int depthIndex = 0;
        int min = 0;
        int max = this.TTDepthSum;
        do {
            if (depth < this.Depth[min + (max - min) / 2]) {
                max = min + (max - min) / 2;
                continue;
            }
            min += (max - min) / 2;
        } while (min + 1 < max);
        depthIndex = max >= this.TTDepthSum ? this.TTDepthSum - 1 : (this.Depth[max] - depth > depth - this.Depth[min] ? min : max);
        return depthIndex;
    }

    private int getColumn(double depth, String pName) {
        int depthIndex = this.getColumnIndex(depth);
        int idx = -1;
        while (++idx < this.TTTableColumSum && this.phaseName[depthIndex][idx] != null && !this.phaseName[depthIndex][idx].equals(pName)) {
        }
        if (idx == this.TTTableColumSum || this.phaseName[depthIndex][idx] == null) {
            return -1;
        }
        return idx;
    }

    public double calTravelTime(double[] Src, double[] Stn, int phaseType) {
        double Delta = Distance.norm(Src, Stn, 2);
        return this.calTravelTime(Src[2], Delta / 111.19, phaseType);
    }

    public double calDelta(double depth, double time, int phaseType) {
        return this.calDelta(depth, time, this.getPhaseType(phaseType));
    }

    public double calTravelTime(double depth, double Delta, int phaseType) {
        return this.calTravelTime(depth, Delta, this.getPhaseType(phaseType));
    }

    protected void readTableIN(String propertyKey) {
        String fname = "";
        try {
            Properties attrib = new Properties();
            attrib.load(new FileInputStream("Main.cfg"));
            fname = attrib.getProperty(propertyKey);
            if (fname == null) {
                logger.fatal("\"Main.cfg\" did not include \"" + propertyKey + "\" section !");
                return;
            }
            FileReader fs = new FileReader(fname);
            BufferedReader ds = new BufferedReader(fs);
            String LineStr = ds.readLine();
            StringTokenizer st = new StringTokenizer(LineStr);
            this.TTDepthSum = Integer.parseInt(st.nextToken());
            LineStr = ds.readLine();
            st = new StringTokenizer(LineStr);
            this.TTTableRowSum = Integer.parseInt(st.nextToken());
            LineStr = ds.readLine();
            st = new StringTokenizer(LineStr);
            this.TTTableColumSum = Integer.parseInt(st.nextToken());
            this.TTTable = new double[this.TTDepthSum][this.TTTableRowSum][this.TTTableColumSum];
            this.Depth = new double[this.TTDepthSum];
            this.phaseName = new String[this.TTDepthSum][this.TTTableColumSum];
            int i = 0;
            while (i < this.TTDepthSum) {
                int j = 0;
                while (j < this.TTTableRowSum) {
                    int k = 0;
                    while (k < this.TTTableColumSum) {
                        this.TTTable[i][j][k] = -1.0;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.TTDepthSum) {
                LineStr = ds.readLine();
                if (logger.isDebugEnabled()) {
                    logger.debug("reading line: " + LineStr);
                }
                st = new StringTokenizer(LineStr);
                int row = Integer.parseInt(st.nextToken());
                LineStr = ds.readLine();
                st = new StringTokenizer(LineStr);
                int colume = Integer.parseInt(st.nextToken());
                LineStr = ds.readLine();
                st = new StringTokenizer(LineStr);
                this.Depth[i] = Double.valueOf(st.nextToken());
                LineStr = ds.readLine();
                st = new StringTokenizer(LineStr);
                if (logger.isDebugEnabled()) {
                    logger.debug("reading phase name: " + LineStr);
                }
                int k = 0;
                while (k < colume) {
                    this.phaseName[i][k] = st.nextToken();
                    ++k;
                }
                int j = 0;
                while (j < row) {
                    LineStr = ds.readLine();
                    st = new StringTokenizer(LineStr);
                    int k2 = 0;
                    while (k2 < colume) {
                        this.TTTable[i][j][k2] = Double.valueOf(st.nextToken());
                        ++k2;
                    }
                    ++j;
                }
                ++i;
            }
            ds.close();
            fs.close();
        }
        catch (IOException e) {
            logger.fatal("In TravelTimeTable.readTableIN(),  Read " + fname + " Error!");
        }
    }

    public String getPhaseType(int phaseType) {
        String pType = "";
        if (phaseType == 1) {
            pType = "Pn";
        } else if (phaseType == 2) {
            pType = "Sn";
        } else if (phaseType == 3) {
            pType = "Pg";
        } else if (phaseType == 4) {
            pType = "Sg";
        } else if (phaseType == 8) {
            pType = "P";
        } else if (phaseType == 9) {
            pType = "S";
        } else if (phaseType == 13) {
            pType = "Pg1";
        } else if (phaseType == 14) {
            pType = "Sg1";
        } else if (phaseType == 11) {
            pType = "LG1";
        } else if (phaseType == 12) {
            pType = "LG2";
        } else if (phaseType == 5) {
            pType = "Pg,Sg";
        } else if (phaseType == 6) {
            pType = "Pn,Sn";
        } else if (phaseType == 7) {
            pType = "Pn,Sg";
        } else if (phaseType == 10) {
            pType = "P,S";
        }
        return pType;
    }

    public double calTravelTime(double[] Src, double[] Stn, String phaseType) {
        double Delta = Distance.norm(Src, Stn, 2);
        return this.calTravelTime(Src[2], Delta / 111.19, phaseType);
    }

    public double calTravelTime(double depth, double Delta, String phaseType) {
        double retVal;
        block25: {
            double max_l;
            double min_l;
            double max_f;
            double min_f;
            double rate;
            block26: {
                int max;
                int min;
                boolean isSingle;
                int lcolIdx;
                int depthIndex;
                block24: {
                    int fcolIdx;
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block18: {
                                        String sName;
                                        block19: {
                                            block17: {
                                                retVal = 0.0;
                                                depthIndex = this.getColumnIndex(depth);
                                                fcolIdx = 0;
                                                lcolIdx = 0;
                                                isSingle = false;
                                                if (phaseType.indexOf(44) != -1) break block17;
                                                isSingle = true;
                                                fcolIdx = this.getColumn(depth, phaseType);
                                                if (fcolIdx == -1) {
                                                    return Double.NaN;
                                                }
                                                break block18;
                                            }
                                            isSingle = false;
                                            int idx = phaseType.indexOf(44);
                                            String pName = phaseType.substring(0, idx);
                                            sName = phaseType.substring(idx + 1);
                                            fcolIdx = this.getColumn(depth, pName);
                                            if (fcolIdx != -1) break block19;
                                            return Double.NaN;
                                        }
                                        lcolIdx = this.getColumn(depth, sName);
                                        if (lcolIdx != -1) break block18;
                                        return Double.NaN;
                                    }
                                    min = 0;
                                    max = this.TTTableRowSum;
                                    if (isSingle) {
                                        min = this.getFirstValidIndex(depthIndex, fcolIdx);
                                        max = this.getLastValidIndex(depthIndex, fcolIdx);
                                    } else {
                                        min = Math.max(this.getFirstValidIndex(depthIndex, fcolIdx), this.getFirstValidIndex(depthIndex, lcolIdx));
                                        max = Math.min(this.getLastValidIndex(depthIndex, fcolIdx), this.getLastValidIndex(depthIndex, lcolIdx));
                                    }
                                    if (!(Delta < this.TTTable[depthIndex][min][0])) break block20;
                                    return Double.NaN;
                                }
                                if (!(Delta > this.TTTable[depthIndex][max][0])) break block21;
                                return Double.NaN;
                            }
                            rate = 0.0;
                            do {
                                if (Delta < this.TTTable[depthIndex][min + (max - min) / 2][0]) {
                                    max = min + (max - min) / 2;
                                    continue;
                                }
                                min += (max - min) / 2;
                            } while (min + 1 < max);
                            if (max < this.TTTableRowSum - 1) break block22;
                            return Double.NaN;
                        }
                        if (min != 0) break block23;
                        return 0.0;
                    }
                    rate = Math.abs(this.TTTable[depthIndex][min][0] - Delta) / Math.abs(this.TTTable[depthIndex][max][0] - this.TTTable[depthIndex][min][0]);
                    min_f = this.TTTable[depthIndex][min][fcolIdx];
                    max_f = this.TTTable[depthIndex][max][fcolIdx];
                    if (!(min_f < 0.0) && !(max_f < 0.0)) break block24;
                    return Double.NaN;
                }
                if (isSingle) {
                    retVal = min_f + rate * (max_f - min_f);
                    break block25;
                }
                min_l = this.TTTable[depthIndex][min][lcolIdx];
                max_l = this.TTTable[depthIndex][max][lcolIdx];
                if (!(min_l < 0.0) && !(max_l < 0.0)) break block26;
                return Double.NaN;
            }
            try {
                retVal = min_l + rate * (max_l - min_l);
                retVal -= min_f + rate * (max_f - min_f);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                retVal = Double.NaN;
            }
        }
        return retVal;
    }

    /*
     * Exception decompiling
     */
    public double calDelta(double depth, double time, String phaseType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getFirstValidIndex(int depthIndex, int colIdx) {
        int min = 0;
        int i = 0;
        while (i < this.TTTableRowSum) {
            if (this.TTTable[depthIndex][i][colIdx] > 0.0) {
                min = i;
                break;
            }
            ++i;
        }
        return min;
    }

    private int getLastValidIndex(int depthIndex, int colIdx) {
        int max = 0;
        int i = this.TTTableRowSum - 1;
        while (i >= 0) {
            if (this.TTTable[depthIndex][i][colIdx] > 0.0) {
                max = i;
                break;
            }
            --i;
        }
        return max;
    }
}

