/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.linalg.Distance;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Time;
import java.io.IOException;
import java.io.OptionalDataException;
import org.apache.log4j.Logger;

public class TauPToolkit
implements ComputedTravelTime {
    static Logger logger = Logger.getLogger(TauPToolkit.class);
    TauP_Time timeTools = new TauP_Time();
    private String phaseType = "";
    private String modelName = "";

    public TauPToolkit() {
        this.setTauModel("iasp91");
    }

    public TauPToolkit(String modelName) {
        this.setTauModel(modelName);
        logger.info(this.timeTools.getTauModelName());
    }

    public void setTauModel(String modelName) {
        try {
            if (!this.modelName.equals(modelName)) {
                this.timeTools.loadTauModel(modelName);
                this.modelName = modelName;
            }
        }
        catch (TauModelException ex) {
            logger.warn(ex.getMessage(), ex);
        }
        catch (OptionalDataException odEx) {
            logger.warn(odEx.getMessage(), odEx);
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
        }
    }

    public Arrival[] getArrivals(String phaseType, double Depth2, double Delta) {
        Arrival[] retVal = null;
        try {
            if (!this.phaseType.equals(phaseType)) {
                this.timeTools.clearPhaseNames();
                this.timeTools.parsePhaseList(phaseType);
                this.phaseType = phaseType;
            }
            this.timeTools.depthCorrect(Depth2);
            this.timeTools.calculate(Delta);
            retVal = this.timeTools.getArrivals();
        }
        catch (TauModelException tauMEx) {
            logger.warn(tauMEx.getMessage(), tauMEx);
        }
        return retVal;
    }

    public double calTravelTime(double depth, double Delta, int phaseType) {
        return this.calTravelTime(depth, Delta, this.getPhaseType(phaseType));
    }

    public double calTravelTime(double[] Src, double[] Stn, int phaseType) {
        double Delta = Distance.norm(Src, Stn, 2);
        return this.calTravelTime(Src[2], Delta / 111.19, phaseType);
    }

    public double calTravelTime(double[] Src, double[] Stn, String phaseType) {
        double Delta = Distance.norm(Src, Stn, 2);
        return this.calTravelTime(Src[2], Delta / 111.19, phaseType);
    }

    public double calTravelTime(double depth, double delta, String phaseType) {
        double retVal = Double.NaN;
        if (phaseType.indexOf("Pg") != -1 || phaseType.indexOf("Sg") != -1) {
            return retVal;
        }
        try {
            if (!this.phaseType.equals(phaseType)) {
                this.timeTools.clearPhaseNames();
                this.timeTools.parsePhaseList(phaseType);
                this.phaseType = phaseType;
            }
            this.timeTools.depthCorrect(depth);
            this.timeTools.calculate(delta);
            Arrival[] arrivals = this.timeTools.getArrivals();
            if (arrivals.length == 0) {
                return retVal;
            }
            retVal = arrivals.length == 1 ? arrivals[0].getTime() : (arrivals.length == 2 && phaseType.indexOf(44) != -1 ? Math.abs(arrivals[0].getTime() - arrivals[1].getTime()) : arrivals[0].getTime());
        }
        catch (TauModelException tauMEx) {
            logger.warn(tauMEx.getMessage(), tauMEx);
            return retVal;
        }
        return retVal;
    }

    public double calDelta(double depth, double time, int phaseType) {
        return this.calDelta(depth, time, this.getPhaseType(phaseType));
    }

    public double calDelta(double depth, double time, String phaseType) {
        double retVal;
        block17: {
            retVal = Double.NaN;
            if (phaseType.indexOf("Pg") != -1 || phaseType.indexOf("Sg") != -1) {
                return retVal;
            }
            try {
                if (!this.phaseType.equals(phaseType)) {
                    this.timeTools.clearPhaseNames();
                    this.timeTools.parsePhaseList(phaseType);
                    this.phaseType = phaseType;
                }
                this.timeTools.depthCorrect(depth);
                if (phaseType.indexOf(44) == -1) {
                    double delta = 0.0;
                    while (delta < 182.0) {
                        this.timeTools.calculate(delta);
                        Arrival[] arrivals = this.timeTools.getArrivals();
                        if (arrivals.length > 0 && time < arrivals[0].getTime()) {
                            double minDel = delta - 2.0;
                            while (minDel < delta + 0.01) {
                                this.timeTools.calculate(minDel);
                                arrivals = this.timeTools.getArrivals();
                                if (arrivals.length > 0) {
                                    if (!(time > arrivals[0].getTime())) {
                                        retVal = minDel;
                                        this.timeTools.calculate(retVal);
                                        arrivals = this.timeTools.getArrivals();
                                        if (arrivals.length == 0 || Math.abs(time - arrivals[0].getTime()) > 1.0) {
                                            retVal = Double.NaN;
                                        }
                                        break block17;
                                    }
                                } else {
                                    retVal = Double.NaN;
                                }
                                minDel += 0.01;
                            }
                            break block17;
                        }
                        delta += 2.0;
                    }
                    break block17;
                }
                double S_P = Double.NaN;
                double delta = 0.0;
                while (delta < 182.0) {
                    this.timeTools.calculate(delta);
                    Arrival[] arrivals = this.timeTools.getArrivals();
                    S_P = this.getS_PTime(arrivals, phaseType);
                    if (arrivals.length > 1 && !Double.isNaN(S_P) && time < S_P) {
                        double minDel = delta - 2.0;
                        while (minDel < delta + 0.1) {
                            this.timeTools.calculate(minDel);
                            arrivals = this.timeTools.getArrivals();
                            S_P = this.getS_PTime(arrivals, phaseType);
                            if (arrivals.length > 1 && !Double.isNaN(S_P) && time < S_P) {
                                if (Math.abs(time - S_P) > 10.0) {
                                    logger.info("Your picked phase may be wrong!");
                                }
                                retVal = minDel - 0.05;
                                break block17;
                            }
                            minDel += 0.1;
                        }
                        break;
                    }
                    delta += 2.0;
                }
            }
            catch (TauModelException tauMEx) {
                logger.warn(tauMEx.getMessage(), tauMEx);
                return retVal;
            }
        }
        return retVal;
    }

    private double getS_PTime(Arrival[] arrivals, String phaseType) {
        int idx = phaseType.indexOf(44);
        String pName = phaseType.substring(0, idx);
        String sName = phaseType.substring(idx + 1);
        double ptime = Double.MAX_VALUE;
        int i = 0;
        while (i < arrivals.length) {
            if (pName.equals(arrivals[i].getName()) && ptime > arrivals[i].getTime()) {
                ptime = arrivals[i].getTime();
            }
            ++i;
        }
        if (ptime > 7200.0) {
            return Double.NaN;
        }
        double stime = Double.MAX_VALUE;
        int i2 = 0;
        while (i2 < arrivals.length) {
            if (sName.equals(arrivals[i2].getName()) && stime > arrivals[i2].getTime()) {
                stime = arrivals[i2].getTime();
            }
            ++i2;
        }
        if (stime > 7200.0) {
            return Double.NaN;
        }
        double retVal = Math.abs(stime - ptime);
        return retVal;
    }

    public String getPhaseType(int phaseType) {
        String pType = "";
        if (phaseType == 1) {
            pType = "Pn";
        } else if (phaseType == 2) {
            pType = "Sn";
        } else if (phaseType == 3) {
            pType = "Pg";
        } else if (phaseType == 4) {
            pType = "Sg";
        } else if (phaseType == 8) {
            pType = "P";
        } else if (phaseType == 9) {
            pType = "S";
        } else if (phaseType == 11) {
            pType = "LG1";
        } else if (phaseType == 12) {
            pType = "LG2";
        } else if (phaseType == 5) {
            pType = "Pg,Sg";
        } else if (phaseType == 6) {
            pType = "Pn,Sn";
        } else if (phaseType == 7) {
            pType = "Pn,Sg";
        } else if (phaseType == 10) {
            pType = "P,S";
        }
        return pType;
    }

    public static void main(String[] args) {
        TauPToolkit tauKit = new TauPToolkit();
        double s = 0.0;
        while (s < 200.0) {
            double delta = tauKit.calDelta(20.0, s, "P");
            System.out.format("%.2f, %.3f\n", s, delta);
            s += 0.2;
        }
    }
}

