/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.BasicStation;
import cn.org.gddsn.seis.evtformat.EvtData;
import java.util.Collection;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StationMapping {
    public Hashtable<String, String> s2ns = new Hashtable(256);
    public Hashtable<String, String> ns2s = new Hashtable(256);

    public void buildStationMap(EvtData evt) {
        this.s2ns.clear();
        this.ns2s.clear();
        int i = 0;
        while (i < evt.getTCN()) {
            String net = evt.getNetworkCode(i);
            String sta = evt.getStationCode(i);
            String key = String.valueOf(net) + "/" + sta;
            String sta1 = this.ns2s.get(key);
            if (sta1 == null) {
                this.ns2s.put(key, sta);
                String nsta1 = this.s2ns.get(sta);
                if (nsta1 == null) {
                    this.s2ns.put(sta, key);
                } else {
                    int n = 0;
                    while (n < 10000) {
                        nsta1 = this.s2ns.get("S" + n);
                        if (nsta1 == null) {
                            this.ns2s.put(key, "S" + n);
                            this.s2ns.put("S" + n, key);
                            break;
                        }
                        ++n;
                    }
                }
            }
            ++i;
        }
    }

    public void buildStationMap(Collection<BasicStation> stnList) {
        this.s2ns.clear();
        this.ns2s.clear();
        block0: for (BasicStation bs : stnList) {
            String net = bs.getNet();
            String sta = bs.getSta();
            String key = String.valueOf(net) + "/" + sta;
            String sta1 = this.ns2s.get(key);
            if (sta1 != null) continue;
            this.ns2s.put(key, sta);
            String nsta1 = this.s2ns.get(sta);
            if (nsta1 == null) {
                this.s2ns.put(sta, key);
                continue;
            }
            int n = 0;
            while (n < 10000) {
                nsta1 = this.s2ns.get("S" + n);
                if (nsta1 == null) {
                    this.ns2s.put(key, "S" + n);
                    this.s2ns.put("S" + n, key);
                    continue block0;
                }
                ++n;
            }
        }
    }

    public String getStation(String net_sta) {
        return this.ns2s.get(net_sta);
    }

    public String getNetStation(String sta) {
        return this.s2ns.get(sta);
    }
}

