/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.convert.DoubleFormat;
import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.convert.cs_printf;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.PhaseList;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.BaseLocationInf;
import cn.org.gddsn.seis.location.CalMagnitude;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.location.LocData;
import cn.org.gddsn.seis.location.LocalPlusCountry;
import cn.org.gddsn.seis.location.MagnitudeInf;
import cn.org.gddsn.seis.location.OutputInfoForLoc;
import cn.org.gddsn.seis.regions.RegionsFE;
import cn.org.gddsn.seis.regions.geotools.GeoRegion;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.apache.log4j.Logger;

public final class OneStnLocation
extends LocData
implements BaseLocationInf {
    static Logger logger = Logger.getLogger(OneStnLocation.class);
    private PhaseList phaseList = new PhaseList();
    int stnForLoc = -1;
    private double Azimuth;
    private double inc;
    private double delta;
    private double ml;
    private double ms;
    double mb = Double.NaN;
    private double depth;
    ComputedTravelTime TTT = new LocalPlusCountry();
    Vector ress = new Vector();
    private MagnitudeInf magnitudeInf = new CalMagnitude();

    public void setDepth(double newDepth) {
        this.depth = newDepth;
    }

    public void setComputedTravelTime(ComputedTravelTime newTTT) {
        this.TTT = newTTT;
    }

    public void setTrySource(SourceParam trySource) {
    }

    public void setEvtData(EvtData mainEvent) {
    }

    public SourceParam[] getDetailSource() {
        SourceParam[] sps = new SourceParam[this.ress.size()];
        int i = 0;
        while (i < sps.length) {
            sps[i] = (SourceParam)this.ress.elementAt(i);
            ++i;
        }
        return sps;
    }

    public boolean findSourceLoc() {
        if (this.stnForLoc != -1) {
            return this.oneStnLoc(this.stnForLoc);
        }
        int n = 0;
        double lon = 0.0;
        double lat = 0.0;
        double Ms = 0.0;
        int nMs = 0;
        double Ml = 0.0;
        int nMl = 0;
        double _mb = 0.0;
        int nmb = 0;
        int i = 0;
        while (i < this.getStnSum()) {
            if (this.oneStnLoc(i)) {
                this.ress.addElement((SourceParam)this.sourceParam.clone());
                ++n;
                lon += this.sourceParam.lon;
                lat += this.sourceParam.lat;
                if (!Double.isNaN(this.sourceParam.ms)) {
                    Ms += this.sourceParam.ms;
                    ++nMs;
                }
                if (!Double.isNaN(this.sourceParam.ml)) {
                    Ml += this.sourceParam.ml;
                    ++nMl;
                }
                if (!Double.isNaN(this.sourceParam.mb)) {
                    _mb += this.sourceParam.mb;
                    ++nmb;
                }
            }
            ++i;
        }
        if (n != 0) {
            this.sourceParam.lon = lon / (double)n;
            this.sourceParam.lat = lat / (double)n;
            this.sourceParam.ms = Ms / (double)nMs;
            this.sourceParam.ml = Ml / (double)nMl;
            this.sourceParam.mb = _mb / (double)nmb;
            if (this.sourceParam.ms > 0.0) {
                this.sourceParam.setM(this.sourceParam.getMs());
                this.sourceParam.setMSource("Ms");
            } else {
                this.sourceParam.setM(CalMagnitude.Ml2Ms(this.sourceParam.getMl()));
                this.sourceParam.setMSource("ML");
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean oneStnLoc(int stn) {
        double timeP = 0.0;
        double timeS = 0.0;
        double difTime = 0.0;
        String strPhaseType = "";
        String firstPhaseName = "";
        Vector<String> phases = this.phaseList.getPhaseP();
        Collections.sort(this.stnPhases[stn]);
        Enumeration Enu = this.stnPhases[stn].elements();
        Phase phaseF = null;
        Phase phaseN = null;
        while (Enu.hasMoreElements()) {
            phaseF = (Phase)Enu.nextElement();
            if (phaseF.getPhaType() != 0 || phaseF.getWeight() != 1 || !phases.contains(phaseF.getPhaseName())) continue;
            strPhaseType = String.valueOf(phaseF.getPhaseName()) + ",";
            timeP = (double)(phaseF.getPhaseTime().getTime() - this.BaseDate.getTime()) / 1000.0;
            firstPhaseName = phaseF.getPhaseName();
            this.Azimuth = phaseF.getAzimuth();
            this.inc = phaseF.getIncident();
            break;
        }
        if (!strPhaseType.endsWith(",")) {
            return false;
        }
        if (Double.isNaN(this.Azimuth)) {
            return false;
        }
        phases = this.phaseList.getATPhase();
        int count = 0;
        while (Enu.hasMoreElements()) {
            phaseN = (Phase)Enu.nextElement();
            if (phaseN.getPhaType() != 0 || phaseN.getWeight() != 1 || phaseN.getPhaseName().equals(phaseF.getPhaseName())) continue;
            strPhaseType = String.valueOf(strPhaseType) + phaseN.getPhaseName();
            timeS = (double)(phaseN.getPhaseTime().getTime() - this.BaseDate.getTime()) / 1000.0;
            ++count;
        }
        if (count > 1) {
            logger.info("Please Select only two phases to do SSDP");
            return false;
        }
        if (count == 0) {
            return false;
        }
        difTime = timeS - timeP;
        this.sourceParam.cenLat = this.getStnLocations()[stn].getLat();
        this.sourceParam.cenLon = this.getStnLocations()[stn].getLon();
        if (strPhaseType.indexOf("Pg") != -1 || strPhaseType.indexOf("Sg") != -1) {
            this.TTT = new LocalPlusCountry();
        }
        this.delta = this.TTT.calDelta(this.depth, difTime, strPhaseType) * 111.19;
        if (Double.isNaN(this.delta)) {
            return false;
        }
        this.sourceParam.originTime.setTime((long)((timeP - this.TTT.calTravelTime(this.depth, this.delta / 111.19, firstPhaseName)) * 1000.0) + this.BaseDate.getTime());
        Point2D.Double p = new Point2D.Double();
        SphereUtil.filam(this.sourceParam.cenLat, this.sourceParam.cenLon, this.delta, this.Azimuth, p);
        logger.info("In OneStationLocation.findSource,S?_P? = " + difTime);
        logger.info("In OneStationLocation.findSource,Delta = " + this.delta);
        logger.info("In OneStationLocation.findSource,Azimuth = " + this.Azimuth);
        this.sourceParam.lat = ((Point2D)p).getX();
        this.sourceParam.lon = ((Point2D)p).getY();
        Point2D.Double p2d = new Point2D.Double();
        SphereUtil.filam(this.sourceParam.cenLat, this.sourceParam.cenLon, this.delta, this.Azimuth, p2d);
        this.sourceParam.lon = ((Point2D)p2d).getY();
        this.sourceParam.lat = ((Point2D)p2d).getX();
        logger.info("In OneStationLocation.findSource,Lon = " + this.sourceParam.lon);
        logger.info("In OneStationLocation.findSource,Lat = " + this.sourceParam.lat);
        this.calcM(stn);
        this.sourceParam.ml = this.ml;
        this.sourceParam.ms = this.ms;
        this.sourceParam.mb = this.mb;
        logger.info("In OneStationLocation.findSource,Ml = " + this.ml);
        logger.info("In OneStationLocation.findSource,Ms = " + this.ms);
        logger.info("In OneStationLocation.findSource,mb = " + this.mb);
        if (this.sourceParam.ms > 0.0) {
            this.sourceParam.setM(this.sourceParam.getMs());
            this.sourceParam.setMSource("Ms");
        } else {
            this.sourceParam.setM(CalMagnitude.Ml2Ms(this.sourceParam.getMl()));
            this.sourceParam.setMSource("ML");
        }
        this.sourceParam.depth = this.depth;
        this.sourceParam.setAzimuth(this.Azimuth);
        this.sourceParam.delta = this.delta;
        this.sourceParam.setFeRegion(GeoRegion.getName(this.sourceParam.getLat(), this.sourceParam.getLon()));
        this.sourceParam.setFeNum(RegionsFE.getFeGeoRegionNum(this.sourceParam.getLat(), this.sourceParam.getLon()));
        this.sourceParam.setLocation(this.sourceParam.getFeRegion());
        this.sourceParam.setLocProgram("SingleStation");
        return true;
    }

    void calcM(int stn) {
        Phase phaseZ = this.getPhase(stn, "SMZ");
        Phase phaseE = this.getPhase(stn, "SME");
        Phase phaseN = this.getPhase(stn, "SMN");
        this.ml = this.magnitudeInf.getML(phaseZ, phaseE, phaseN, this.delta);
        this.fillPhaseMag(phaseZ, this.ml, "ML");
        this.fillPhaseMag(phaseE, this.ml, "ML");
        this.fillPhaseMag(phaseN, this.ml, "ML");
        phaseZ = this.getPhase(stn, "LZ");
        phaseE = this.getPhase(stn, "LE");
        phaseN = this.getPhase(stn, "LN");
        this.ms = this.magnitudeInf.getMs(phaseZ, phaseE, phaseN, this.delta);
        this.fillPhaseMag(phaseZ, this.ms, "Ms");
        this.fillPhaseMag(phaseE, this.ms, "Ms");
        this.fillPhaseMag(phaseN, this.ms, "Ms");
        phaseZ = this.getPhase(stn, "PMZ");
        if (phaseZ != null) {
            this.mb = this.magnitudeInf.getMb(phaseZ.getAmp(), phaseZ.getPeriod(), this.delta / 111.19, phaseZ.getRecType());
            this.fillPhaseMag(phaseZ, this.mb, "mb");
        }
    }

    private void fillPhaseMag(Phase p, double m, String type) {
        if (p != null) {
            p.setMagVal((float)this.ml);
            p.setMagName(type);
        }
    }

    public OneStnLocation(int astnForLoc) {
        this.stnForLoc = astnForLoc;
    }

    public OneStnLocation() {
    }

    public void setStnForLoc(int newStnForLoc) {
        this.stnForLoc = newStnForLoc;
    }

    public OutputInfoForLoc getOutputInfoForLoc() {
        OutputInfoForLoc outputInfoForLoc = new OutputInfoForLoc();
        double[] ML = new double[this.getStnSum()];
        double[] Ms = new double[this.getStnSum()];
        double[] mb = new double[this.getStnSum()];
        double[] deltas = new double[this.getStnSum()];
        double[] r = new double[this.getLocPhaSum()];
        ML[0] = this.sourceParam.ml;
        Ms[0] = this.sourceParam.ms;
        mb[0] = this.sourceParam.mb;
        deltas[0] = this.delta;
        outputInfoForLoc.setDetailDelta(deltas);
        outputInfoForLoc.setDetailML(ML);
        outputInfoForLoc.setDetailMs(Ms);
        outputInfoForLoc.setDetailMb(mb);
        outputInfoForLoc.setLocPhaSum(this.getLocPhaSum());
        outputInfoForLoc.setLocStnSum(this.getStnSum());
        outputInfoForLoc.setResidual(r);
        outputInfoForLoc.setSource(this.getSourceParam());
        Vector<Phase> vp = this.getStnPhases(0);
        for (Phase p : vp) {
            p.setDistance((float)this.delta);
        }
        return outputInfoForLoc;
    }

    public String getDetailLocationResult() {
        StringBuffer textArea = new StringBuffer();
        textArea.append("                    Locating Result of Regional Earthquake:\n");
        textArea.append(" ******************************************************************************\n");
        String strTime = this.getTime(this.sourceParam.originTime);
        String strDate = this.getDate(this.sourceParam.originTime);
        textArea.append(" Origin Time  :  " + strDate + "        " + strTime + "\n");
        long latIntPart = (long)Math.floor(Math.abs(this.sourceParam.lat));
        double latDotPart = Math.abs(this.sourceParam.lat) - (double)latIntPart;
        long lonIntPart = (long)Math.floor(Math.abs(this.sourceParam.lon));
        double lonDotPart = Math.abs(this.sourceParam.lon) - (double)lonIntPart;
        StringBuffer strBuffer = new StringBuffer();
        cs_printf P = new cs_printf(strBuffer);
        P.printf(" Epicentre    :  %02d\u00b0%04.2f\u2032         %03d\u00b0%04.2f\u2032   \n", new Integer((int)latIntPart), new Double(latDotPart *= 60.0), new Integer((int)lonIntPart), new Double(lonDotPart *= 60.0));
        P.printf(" Magnitude    :  %02.1f(ML)\t%02.1f(Ms)\t%02.1f(mb)\n", new Double(this.sourceParam.ml), new Double(this.sourceParam.ms), new Double(this.sourceParam.mb));
        textArea.append(strBuffer.toString());
        textArea.append(" Focal Depth  : " + DoubleFormat.toString(this.sourceParam.depth, 1));
        textArea.append("          Residual : " + DoubleFormat.toString(this.sourceParam.rms, 3) + "\n");
        textArea.append("Number of Used Phase :       Numberof stations : " + this.getStnSum() + "\n");
        textArea.append("Quality of Locating:   0          Quality of station distribution:  0\n");
        textArea.append("Average Quality Level of Locating Earthquake:  0\n");
        textArea.append("Epicentre Accuracy:   N/A(km)    Depth Accuracy:   N/A\n");
        textArea.append("No.\tStname\tPhase\tDate\t\tTime\t\tt-res\tdelta\tML\tMs\tMb\n");
        int i = 0;
        while (i < this.getStnSum()) {
            boolean first = true;
            Enumeration Enu = this.stnPhases[i].elements();
            while (Enu.hasMoreElements()) {
                Phase phase = (Phase)Enu.nextElement();
                try {
                    this.getPhaseType(phase.getPhaseName());
                }
                catch (IllegalArgumentException ex) {
                    continue;
                }
                if (first) {
                    first = false;
                    textArea.append("" + i);
                    textArea.append("\t");
                    textArea.append(phase.getStationCode());
                    textArea.append("\t");
                    textArea.append(phase.getPhaseName());
                    if (phase.getWeight() == 0) {
                        textArea.append("-");
                    }
                    textArea.append("\t");
                    textArea.append(this.getDate(phase.getPhaseTime()));
                    textArea.append("\t");
                    textArea.append(this.getTime(phase.getPhaseTime()));
                    textArea.append("\t");
                    textArea.append("\t");
                    textArea.append(DoubleFormat.toString(this.delta, 2));
                    textArea.append("\t");
                    double ml = this.ml;
                    if (Double.isNaN(ml)) {
                        textArea.append(" ");
                    } else {
                        textArea.append(DoubleFormat.toString(ml, 2));
                    }
                    textArea.append("\t");
                    double ms = this.ms;
                    if (Double.isNaN(ms)) {
                        textArea.append(" ");
                    } else {
                        textArea.append(DoubleFormat.toString(ms, 2));
                    }
                    textArea.append("\t");
                    double mb = this.mb;
                    if (Double.isNaN(mb)) {
                        textArea.append(" ");
                    } else {
                        textArea.append(DoubleFormat.toString(mb, 2));
                    }
                    textArea.append("\t");
                    textArea.append("\n");
                    continue;
                }
                textArea.append(" ");
                textArea.append("\t");
                textArea.append(" ");
                textArea.append("\t");
                textArea.append(phase.getPhaseName());
                if (phase.getWeight() == 0) {
                    textArea.append("-");
                }
                textArea.append("\t");
                textArea.append(this.getDate(phase.getPhaseTime()));
                textArea.append("\t");
                textArea.append(this.getTime(phase.getPhaseTime()));
                textArea.append("\t");
                textArea.append("\t");
                textArea.append("\n");
            }
            ++i;
        }
        textArea.append(" ******************************************************************************\n");
        return new String(textArea);
    }

    private String getDate(Date d) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        StringBuffer strBuffer = new StringBuffer();
        cs_printf P = new cs_printf(strBuffer);
        int month = c.get(2) + 1;
        P.printf("%4d-%02d-%02d", new Integer(c.get(1)), new Integer(month), new Integer(c.get(5)));
        return strBuffer.toString();
    }

    private String getTime(Date d) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        long t = d.getTime();
        double sec = (double)c.get(13) + (double)(t % 1000L) / 1000.0;
        StringBuffer strBuffer = new StringBuffer();
        cs_printf P = new cs_printf(strBuffer);
        P.printf("%02d:%02d:%04.2f", new Integer(c.get(11)), new Integer(c.get(12)), new Double(sec));
        return strBuffer.toString();
    }

    public void setMagnitudeInf(MagnitudeInf magnitudeInf) {
        this.magnitudeInf = magnitudeInf;
    }

    public MagnitudeInf getMagnitudeInf() {
        return this.magnitudeInf;
    }
}

