/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

public class Magnitude {
    private static final double[] __qml = new double[]{0.0, 1.4, 1.4, 1.5, 1.6, 1.7, 1.9, 2.1, 2.3, 2.4, 2.5, 2.6, 2.7, 2.8, 2.8, 2.8, 2.8, 2.9, 2.9, 3.0, 3.0, 3.0, 3.1, 3.1, 3.2, 3.2, 3.3, 3.3, 3.4, 3.4, 3.5, 3.5, 3.6, 3.65, 3.7, 3.7, 3.8, 3.8, 3.9, 3.9, 4.0, 4.0, 4.1, 4.1, 4.2, 4.2, 4.3, 4.3, 4.3, 4.4, 4.4, 4.5, 4.5, 4.5, 4.6, 4.6, 4.6, 4.6, 4.7, 4.7, 4.7, 4.7, 4.8, 4.8, 4.8, 4.8, 4.8, 4.9, 4.9, 4.9, 4.9, 4.9, 5.2, 5.4, 5.5, 5.7};
    private static final double DELTA_MIN = 3.0;
    private static final double DELTA_MAX = 105.0;
    private static final double D2R = Math.PI / 180;
    private static final double EARTH_RADIUS = 6370998.685023;
    private static final double[][] __qmb = new double[][]{{5.6, 5.8, 6.1, 6.4, 6.5, 7.0, 7.0, 7.2, 7.3, 7.2, 7.1, 7.0, 6.6, 6.3, 5.9, 5.9, 5.9, 6.0, 6.1, 6.1, 6.2, 6.3, 6.4, 6.5, 6.5, 6.5, 6.6, 6.6, 6.6, 6.7, 6.7, 6.7, 6.7, 6.6, 6.6, 6.5, 6.5, 6.4, 6.4, 6.5, 6.5, 6.5, 6.6, 6.7, 6.8, 6.9, 6.9, 6.8, 6.7, 6.7, 6.7, 6.7, 6.8, 6.8, 6.8, 6.8, 6.8, 6.9, 6.9, 6.9, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 6.9, 6.9, 6.9, 6.9, 6.8, 6.8, 6.9, 6.9, 6.9, 6.8, 6.7, 6.8, 6.9, 7.0, 7.0, 7.0, 6.9, 7.0, 7.1, 7.0, 7.0, 7.1, 7.1, 7.2, 7.1, 7.2, 7.3, 7.4, 7.5, 7.5, 7.3, 7.4, 7.4, 7.5, 7.6, 7.7, 7.8, 7.8, 7.9, 8.0}, {0.0, 0.0, 0.0, 6.3, 6.5, 6.8, 7.0, 7.0, 7.1, 7.0, 7.0, 6.9, 6.5, 6.1, 5.9, 5.9, 5.9, 6.0, 6.1, 6.2, 6.2, 6.3, 6.3, 6.4, 6.4, 6.4, 6.5, 6.5, 6.6, 6.6, 6.7, 6.7, 6.7, 6.7, 6.7, 6.6, 6.6, 6.5, 6.5, 6.5, 6.5, 6.5, 6.6, 6.7, 6.7, 6.8, 6.8, 6.8, 6.8, 6.7, 6.7, 6.7, 6.8, 6.8, 6.8, 6.8, 6.8, 6.9, 6.9, 6.9, 6.9, 6.9, 6.9, 6.9, 6.9, 6.9, 6.9, 6.9, 6.9, 6.9, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.9, 7.0, 7.0, 7.0, 7.0, 7.1, 7.1, 7.0, 7.1, 7.2, 7.2, 7.2, 7.2, 7.2, 7.3, 7.3, 7.3, 7.3, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.8, 7.9, 8.0}, {0.0, 0.0, 0.0, 6.0, 6.2, 6.5, 6.6, 6.8, 6.9, 6.9, 6.8, 6.7, 6.5, 6.0, 5.9, 5.9, 5.9, 6.0, 6.1, 6.1, 6.2, 6.2, 6.3, 6.3, 6.3, 6.4, 6.4, 6.4, 6.5, 6.5, 6.6, 6.6, 6.7, 6.7, 6.7, 6.7, 6.7, 6.6, 6.6, 6.5, 6.5, 6.5, 6.5, 6.6, 6.7, 6.7, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.9, 6.9, 6.9, 6.9, 6.9, 6.9, 6.8, 6.8, 6.8, 6.8, 6.8, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.8, 6.8, 6.7, 6.7, 6.7, 6.8, 6.8, 6.8, 6.9, 7.0, 7.0, 7.0, 7.1, 7.1, 7.2, 7.2, 7.2, 7.2, 7.2, 7.3, 7.3, 7.3, 7.3, 7.3, 7.4, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 7.9, 8.0}, {0.0, 0.0, 0.0, 6.0, 6.1, 6.4, 6.5, 6.6, 6.8, 6.7, 6.7, 6.5, 6.1, 6.0, 5.9, 6.0, 6.0, 6.0, 6.1, 6.1, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.4, 6.4, 6.5, 6.5, 6.6, 6.6, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.6, 6.6, 6.6, 6.6, 6.6, 6.7, 6.7, 6.7, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.9, 6.9, 6.9, 6.9, 6.9, 6.9, 6.8, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.8, 6.8, 6.8, 6.9, 6.9, 7.0, 7.0, 7.1, 7.2, 7.2, 7.2, 7.2, 7.3, 7.3, 7.3, 7.3, 7.4, 7.4, 7.5, 7.5, 7.7, 7.8, 7.8, 7.9, 7.9, 8.0}, {0.0, 0.0, 0.0, 6.0, 6.0, 6.3, 6.4, 6.6, 6.7, 6.6, 6.5, 6.4, 6.0, 6.0, 6.0, 6.0, 6.0, 6.1, 6.1, 6.1, 6.1, 6.1, 6.2, 6.2, 6.3, 6.3, 6.4, 6.4, 6.5, 6.5, 6.5, 6.6, 6.6, 6.7, 6.7, 6.7, 6.7, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.7, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.9, 6.9, 6.8, 6.8, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.7, 6.7, 6.7, 6.8, 6.8, 6.8, 6.9, 6.9, 7.0, 7.1, 7.1, 7.2, 7.2, 7.3, 7.3, 7.3, 7.4, 7.4, 7.4, 7.5, 7.6, 7.7, 7.8, 7.8, 7.9, 7.9, 8.0}, {0.0, 0.0, 0.0, 6.0, 6.0, 6.2, 6.4, 6.4, 6.4, 6.4, 6.3, 6.2, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.4, 6.4, 6.5, 6.5, 6.5, 6.5, 6.6, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.5, 6.5, 6.5, 6.5, 6.5, 6.6, 6.6, 6.6, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.6, 6.6, 6.6, 6.6, 6.6, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.6, 6.6, 6.6, 6.6, 6.7, 6.8, 6.8, 6.8, 6.9, 6.9, 7.0, 7.0, 7.1, 7.2, 7.2, 7.3, 7.3, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 7.9, 8.0, 8.0}, {0.0, 0.0, 0.0, 5.9, 6.0, 6.0, 6.0, 6.1, 6.1, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.3, 6.3, 6.4, 6.4, 6.4, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.3, 6.3, 6.3, 6.3, 6.3, 6.2, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.4, 6.4, 6.4, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.6, 6.6, 6.6, 6.6, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.6, 6.6, 6.6, 6.7, 6.7, 6.8, 6.8, 6.9, 6.9, 7.0, 7.1, 7.1, 7.2, 7.2, 7.2, 7.3, 7.4, 7.5, 7.7, 7.8, 7.9, 7.9, 8.0, 8.0}, {0.0, 0.0, 0.0, 5.7, 5.7, 5.8, 5.8, 5.8, 5.9, 5.9, 6.0, 6.0, 6.1, 6.2, 6.2, 6.2, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.3, 6.3, 6.3, 6.3, 6.3, 6.2, 6.2, 6.2, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.2, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.3, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.6, 6.6, 6.6, 6.6, 6.6, 6.7, 6.7, 6.7, 6.8, 6.8, 6.9, 7.0, 7.0, 7.1, 7.1, 7.2, 7.2, 7.3, 7.3, 7.4, 7.6, 7.8, 7.9, 8.0, 8.0, 8.0}, {0.0, 0.0, 0.0, 5.6, 5.7, 5.7, 5.8, 5.8, 5.9, 6.0, 6.0, 6.1, 6.1, 6.1, 6.2, 6.2, 6.2, 6.1, 6.1, 6.1, 6.1, 6.2, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.2, 6.2, 6.1, 6.1, 6.0, 6.0, 6.0, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.3, 6.3, 6.4, 6.4, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.8, 6.9, 6.9, 7.0, 7.0, 7.1, 7.2, 7.2, 7.3, 7.3, 7.4, 7.6, 7.8, 7.9, 8.0, 8.0, 8.0}, {0.0, 0.0, 0.0, 5.7, 5.7, 5.8, 5.9, 6.0, 6.1, 6.2, 6.2, 6.2, 6.2, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.2, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.3, 6.4, 6.4, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.7, 6.7, 6.7, 6.7, 6.7, 6.7, 6.8, 6.8, 6.9, 6.9, 7.0, 7.0, 7.1, 7.1, 7.2, 7.3, 7.3, 7.4, 7.6, 7.8, 7.9, 8.0, 8.0, 8.0}, {0.0, 0.0, 0.0, 5.7, 5.8, 5.9, 6.0, 6.1, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.1, 6.1, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.4, 6.4, 6.4, 6.5, 6.5, 6.5, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.6, 6.6, 6.6, 6.6, 6.6, 6.6, 6.7, 6.7, 6.8, 6.9, 6.9, 6.9, 7.0, 7.1, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 8.0, 8.0}, {0.0, 0.0, 0.0, 5.8, 5.9, 5.9, 6.1, 6.1, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.3, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.5, 6.5, 6.5, 6.5, 6.5, 6.6, 6.6, 6.7, 6.7, 6.8, 6.8, 6.9, 6.9, 7.0, 7.0, 7.1, 7.2, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.8, 7.8, 7.9}, {0.0, 0.0, 0.0, 5.8, 5.8, 5.9, 6.0, 6.1, 6.2, 6.2, 6.2, 6.3, 6.3, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.2, 6.2, 6.2, 6.2, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.2, 6.2, 6.2, 6.3, 6.3, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.3, 6.4, 6.4, 6.5, 6.5, 6.6, 6.6, 6.7, 6.7, 6.8, 6.8, 6.9, 6.9, 7.0, 7.1, 7.1, 7.2, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.7, 7.7, 7.8, 7.8}, {0.0, 0.0, 0.0, 5.8, 5.8, 5.9, 5.9, 6.0, 6.1, 6.1, 6.2, 6.2, 6.2, 6.3, 6.3, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.2, 6.2, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.1, 6.2, 6.2, 6.2, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.3, 6.4, 6.4, 6.5, 6.5, 6.6, 6.7, 6.7, 6.8, 6.8, 6.9, 6.9, 7.0, 7.0, 7.1, 7.1, 7.2, 7.2, 7.3, 7.4, 7.5, 7.6, 7.6, 7.7, 7.7, 7.7, 7.7}, {0.0, 0.0, 0.0, 5.7, 5.8, 5.8, 5.8, 5.9, 5.8, 5.9, 6.0, 6.0, 6.1, 6.1, 6.2, 6.2, 6.3, 6.3, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.2, 6.2, 6.2, 6.1, 6.1, 6.1, 6.0, 6.0, 6.0, 6.0, 6.1, 6.1, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.3, 6.4, 6.4, 6.5, 6.5, 6.6, 6.7, 6.7, 6.8, 6.8, 6.8, 7.0, 7.0, 7.0, 7.1, 7.1, 7.2, 7.2, 7.3, 7.3, 7.4, 7.5, 7.6, 7.6, 7.6, 7.7, 7.7}, {0.0, 0.0, 0.0, 5.7, 5.7, 5.7, 5.8, 5.8, 5.8, 5.8, 5.8, 5.9, 5.9, 5.9, 6.0, 6.1, 6.1, 6.1, 6.2, 6.2, 6.3, 6.3, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.4, 6.3, 6.3, 6.3, 6.3, 6.3, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.1, 6.1, 6.1, 6.1, 6.1, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.1, 6.1, 6.1, 6.1, 6.2, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.4, 6.4, 6.4, 6.5, 6.5, 6.5, 6.6, 6.7, 6.7, 6.8, 6.9, 6.9, 7.0, 7.0, 7.0, 7.1, 7.1, 7.2, 7.2, 7.3, 7.3, 7.4, 7.5, 7.5, 7.5, 7.6, 7.6}, {0.0, 0.0, 0.0, 5.7, 5.7, 5.7, 5.7, 5.7, 5.7, 5.8, 5.8, 5.8, 5.8, 5.8, 5.9, 5.9, 6.0, 6.0, 6.0, 6.0, 6.1, 6.1, 6.1, 6.2, 6.2, 6.3, 6.3, 6.3, 6.3, 6.3, 6.4, 6.4, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.2, 6.2, 6.2, 6.2, 6.2, 6.2, 6.1, 6.1, 6.1, 6.1, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.1, 6.1, 6.1, 6.1, 6.2, 6.2, 6.2, 6.2, 6.2, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.3, 6.4, 6.4, 6.4, 6.4, 6.5, 6.5, 6.6, 6.7, 6.7, 6.8, 6.9, 6.9, 7.0, 7.0, 7.0, 7.1, 7.1, 7.2, 7.2, 7.3, 7.4, 7.4, 7.4, 7.5, 7.5}};
    private static final double[][] GFZ_mB = new double[][]{{5.0, 5.6567}, {5.9001, 5.7164}, {6.4401, 5.788}, {7.9703, 5.9868}, {10.0405, 6.134}, {12.5608, 6.1857}, {15.8911, 6.13}, {18.9514, 6.0306}, {22.0117, 6.1499}, {23.0018, 6.1658}, {24.1719, 6.2215}, {25.342, 6.3169}, {26.8722, 6.4919}, {29.9325, 6.6431}, {32.0027, 6.6749}, {34.0729, 6.6789}, {36.7732, 6.6669}, {40.0135, 6.659}, {43.0738, 6.659}, {47.3042, 6.6948}, {49.9145, 6.7266}, {53.5149, 6.7584}, {58.6454, 6.7664}, {59.9955, 6.7823}, {65.486, 6.8141}, {68.4563, 6.822}, {69.9865, 6.83}, {76.2871, 6.838}, {80.2475, 6.8459}, {84.658, 6.8459}, {88.4383, 6.9851}, {90.1485, 7.0647}, {92.7588, 7.1919}, {96.8092, 7.3868}, {100.1395, 7.534}, {101.4896, 7.5897}, {102.2097, 7.6175}, {105.0, 7.6931}};

    private static double lmagn(double amp, double dist) {
        double del = 0.0;
        int i0 = 0;
        if (amp <= 0.0) {
            return Double.NaN;
        }
        double kdist = dist * 111.18;
        if (kdist > 1000.0) {
            return Double.NaN;
        }
        if (kdist > 600.0) {
            del = 100.0;
            i0 = 65;
        } else if (kdist > 100.0) {
            del = 10.0;
            i0 = 11;
        } else {
            del = 5.0;
            i0 = 1;
        }
        int qlen = __qml.length;
        int idist = (int)(kdist / del) + i0;
        if (idist >= qlen) {
            return Double.NaN;
        }
        double tanalpha = (__qml[idist + 1] - __qml[idist]) / del;
        int ixx = (int)(kdist / del);
        double xx = kdist - (double)ixx * del;
        double sm10 = xx * tanalpha + __qml[idist];
        return Math.log10(amp) + sm10;
    }

    public static double compute_ML(double amplitude, double delta, double depth) {
        return Magnitude.lmagn(amplitude, delta);
    }

    public static double compute_Mwp(double amplitude, double delta, double offset, double slope, double alpha, double rho, double fp) {
        if (delta < 3.0 || delta > 105.0) {
            return Double.NaN;
        }
        double r = Math.PI / 180 * delta * 6370998.685023;
        double momfac = Math.PI * 4 * rho * Math.pow(alpha, 3.0) * r / fp;
        double M0 = amplitude * momfac;
        double Mw = (Math.log10(M0) - 9.1) / 1.5;
        double Mwp = (Mw - offset) / slope;
        return Mwp;
    }

    public static double compute_Mwp(double amplitude, double delta) {
        return Magnitude.compute_Mwp(amplitude, delta, 2.25, 0.625, 7900.0, 3400.0, 1.0);
    }

    private static double bmagnz(double amplitude, double period, double delta, double depth) {
        double s1;
        int k;
        if (depth < 0.0 || depth > 800.0 || delta < 5.0 || delta > 109.0) {
            return Double.NaN;
        }
        if (period < 0.1 || period > 9.0) {
            return Double.NaN;
        }
        if (amplitude <= 0.0) {
            return Double.NaN;
        }
        if (depth < 100.0) {
            k = (int)(depth / 25.0) + 2;
            s1 = 0.04 * (depth - 25.0 * (double)(k - 2));
        } else {
            k = Math.min((int)(depth / 50.0) + 4, 17);
            s1 = 0.02 * (depth - 50.0 * (double)(k - 4));
        }
        int j = Math.max(Math.min((int)delta, 108), 2);
        double s2 = delta - (double)j;
        double q1 = __qmb[k - 2][j - 2] + s1 * (__qmb[k - 1][j - 2] - __qmb[k - 2][j - 2]);
        double Q = q1 + s2 * (__qmb[k - 2][j - 1] + s1 * (__qmb[k - 1][j - 1] - __qmb[k - 2][j - 1]) - q1);
        double mb = Math.log10(amplitude / period) + Q;
        return mb;
    }

    public static double compute_mb(double amplitude, double period, double delta, double depth) {
        return Magnitude.bmagnz(amplitude, period, delta, depth);
    }

    public static double compute_mb_fromVelocity(double amplitude, double delta, double depth) {
        return Magnitude.bmagnz(amplitude, Math.PI * 2, delta, depth);
    }

    public static double compute_Mw_from_mB(double mB) {
        return 1.3333333333333333 * mB - 2.4;
    }

    public static double compute_gfz_mb(double amplitude, double period, double delta, double depth) {
        if (depth < 0.0 || depth >= 80.0 || delta < 5.0 || delta >= 105.0) {
            return Double.NaN;
        }
        if (amplitude <= 0.0 || period <= 0.0) {
            return Double.NaN;
        }
        int k = 0;
        int i = 0;
        while (i < GFZ_mB.length) {
            if (GFZ_mB[i][0] > delta) {
                k = i;
                break;
            }
            ++i;
        }
        double Q = GFZ_mB[k - 1][1] + (GFZ_mB[k][1] - GFZ_mB[k - 1][1]) / (GFZ_mB[k][0] - GFZ_mB[k - 1][0]) * (delta - GFZ_mB[k - 1][0]);
        double mB = Math.log10(amplitude / period) + Q;
        return mB;
    }

    public static double compute_gfz_mb_fromVelocity(double amplitude, double delta, double depth) {
        return Magnitude.compute_gfz_mb(amplitude, Math.PI * 2, delta, depth);
    }

    public static void main(String[] args) {
        System.out.println(Magnitude.compute_gfz_mb_fromVelocity(Math.PI * 2, 105.0, 10.0));
    }
}

