/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import org.apache.log4j.Logger;

public class LocationMath {
    static Logger logger = Logger.getLogger(LocationMath.class);

    public static double median(int n, double[] f) {
        double[] x = new double[n];
        System.arraycopy(f, 0, x, 0, n);
        LocationMath.hpsort(n, x);
        double m = n % 2 == 1 ? x[n / 2] : 0.5 * (x[n / 2] + x[n / 2 - 1]);
        return m;
    }

    public static double mean(double[] f, int s, int n) {
        double m = 0.0;
        int i = s;
        while (i < s + n) {
            m += f[i] / (double)n;
            ++i;
        }
        return m;
    }

    public static double trimmedMean(int n, double[] f, double percent) {
        if (n == 1) {
            return f[0];
        }
        double xl = percent * 0.01;
        double[] x = new double[n];
        System.arraycopy(f, 0, x, 0, n);
        LocationMath.hpsort(n, x);
        int k = (int)((double)n * xl + 1.0E-5);
        double trmean = ((double)(k + 1) - (double)n * xl) * (x[k] + x[n - k - 1]);
        int i = k + 1;
        while (i < n - k - 1) {
            trmean += x[i];
            ++i;
        }
        return trmean /= (double)n * (1.0 - 2.0 * xl);
    }

    private static int find_absmax(double[] f, int start, int end, double offset) {
        if (start < 0) {
            start = 0;
        }
        double fmax = Math.abs(f[start] - offset);
        int imax = start;
        int i = start;
        while (i < end) {
            double ff = Math.abs(f[i] - offset);
            if (ff > fmax) {
                imax = i;
                fmax = ff;
            }
            ++i;
        }
        return imax;
    }

    public static double[] measurePeriod(double[] f, int idx0, int start, int end, double fs, double offset) {
        int imax;
        double per = 0.0;
        double std = 0.0;
        double f0 = f[idx0] - offset;
        if (f0 == 0.0) {
            double[] r = new double[]{Double.NaN, -1.0};
            return r;
        }
        int ip1 = idx0;
        while (ip1 >= start && (f[ip1] - offset) * f0 >= 0.0) {
            --ip1;
        }
        int ip2 = ip1;
        while (ip2 >= start && (f[ip2] - offset) * f0 < 0.0) {
            --ip2;
        }
        int in1 = idx0;
        while (in1 < end && (f[in1] - offset) * f0 >= 0.0) {
            ++in1;
        }
        int in2 = in1;
        while (in2 < end && (f[in2] - offset) * f0 < 0.0) {
            ++in2;
        }
        double wt = 0.0;
        double pp = 0.0;
        double[] m = new double[5];
        int nm = 0;
        if (ip2 >= start) {
            wt += 0.5;
            pp += 0.5 * (double)(ip1 - ip2);
            m[nm++] = ip1 - ip2;
            imax = LocationMath.find_absmax(f, ip2, ip1, offset);
            wt += 1.0;
            pp += (double)(idx0 - imax);
            m[nm++] = idx0 - imax;
        }
        if (ip1 >= start && in1 < end) {
            wt += 1.0;
            pp += (double)(in1 - ip1);
            m[nm++] = in1 - ip1;
        }
        if (in2 < end) {
            wt += 0.5;
            pp += 0.5 * (double)(in2 - in1);
            m[nm++] = in2 - in1;
            imax = LocationMath.find_absmax(f, in1, in2, offset);
            wt += 1.0;
            pp += (double)(imax - idx0);
            m[nm++] = imax - idx0;
        }
        if (nm >= 3) {
            double avg = 0.0;
            double sum = 0.0;
            int i = 0;
            while (i < nm) {
                avg += m[i];
                ++i;
            }
            avg /= (double)nm;
            i = 0;
            while (i < nm) {
                sum += (m[i] - avg) * (m[i] - avg);
                ++i;
            }
            std = 2.0 * Math.sqrt(sum / (double)(nm - 1)) / fs;
        } else {
            std = 0.0;
        }
        per = wt < 0.9 ? Double.NaN : 2.0 * pp / (wt * fs);
        double[] r = new double[]{per, std};
        return r;
    }

    public static double[] fitLine(double[] f, int s, int len) {
        int mx = (len - 1) / 2;
        double mf = LocationMath.mean(f, s, len);
        double mxf = 0.0;
        int i = 0;
        while (i < len) {
            mxf += (double)(i - mx) * (f[s + i] - mf) / (double)(len - 1);
            ++i;
        }
        double sx2 = 0.0;
        int i2 = 0;
        while (i2 < len) {
            sx2 += (double)((i2 - mx) * (i2 - mx) / (len - 1));
            ++i2;
        }
        double bfx = mxf / sx2;
        double[] r = new double[]{bfx, mf - bfx * (double)mx};
        return r;
    }

    public static double[] detrend(double[] f, int s, int len) {
        double[] p = LocationMath.fitLine(f, s, len);
        int i = s;
        while (i < s + len) {
            int n = i;
            f[n] = f[n] - (p[0] * (double)i + p[1]);
            ++i;
        }
        return f;
    }

    public static void hpsort(int n, double[] x) {
        double rra;
        int ir = n;
        double[] ra = new double[n + 1];
        System.arraycopy(x, 0, ra, 1, n);
        if (n < 2) {
            return;
        }
        int ll = (n >> 1) + 1;
        while (true) {
            if (ll > 1) {
                rra = ra[--ll];
            } else {
                rra = ra[ir];
                ra[ir] = ra[1];
                if (--ir == 1) break;
            }
            int i = ll;
            int j = ll + ll;
            while (j <= ir) {
                if (j < ir && ra[j] < ra[j + 1]) {
                    ++j;
                }
                if (rra < ra[j]) {
                    ra[i] = ra[j];
                    i = j;
                    j <<= 1;
                    continue;
                }
                j = ir + 1;
            }
            ra[i] = rra;
        }
        ra[1] = rra;
        System.arraycopy(ra, 1, x, 0, n);
    }

    public static void main(String[] args) {
        LocationMath.test_trimmedMean();
    }

    public static void test_trimmedMean() {
        double[] f = new double[]{4.7};
        System.out.println(LocationMath.trimmedMean(f.length, f, 25.0));
    }

    public static void testMeasurePeriod() {
        double fs = 100.0;
        double[] f = new double[40000];
        double freq = 5.0;
        int i = 0;
        while (i < f.length) {
            double t = (double)i / fs;
            f[i] = Math.sin(Math.PI * 2 * freq * t);
            ++i;
        }
        double[] p = LocationMath.measurePeriod(f, 20000, 0, f.length, 100.0, 0.0);
        System.out.println(p[0] + "," + p[1]);
    }

    public static void testFitLine() {
        double[] f = new double[100];
        int i = 0;
        while (i < f.length) {
            f[i] = 500 + i;
            ++i;
        }
        double[] p = LocationMath.fitLine(f, 0, f.length);
        System.out.println(p[0] + "," + p[1]);
    }

    public static void main0(String[] args) {
        double[] a = new double[]{5.0, 2.0, 4.0, 2.0, 3.0, 6.0, 45.0, 1.0, 3.0, -1.0};
        LocationMath.hpsort(a.length, a);
        System.out.println();
    }
}

