/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.location.LocationData;
import java.util.Date;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class LocData
extends LocationData {
    static Logger logger = Logger.getLogger(LocData.class);
    private double lon0;
    private double lat0;
    protected Date BaseDate;

    public int getLocationData(double[] lat, double[] lon, double[] arriveT, int phaseType) {
        String phaseName = "";
        switch (phaseType) {
            case 3: {
                phaseName = "Pg";
                break;
            }
            case 4: {
                phaseName = "Sg";
                break;
            }
            case 1: {
                phaseName = "Pn";
                break;
            }
            case 2: {
                phaseName = "Sn";
                break;
            }
            case 8: {
                phaseName = "P";
                break;
            }
            case 9: {
                phaseName = "S";
                break;
            }
            case 13: {
                phaseName = "Pg1";
                break;
            }
            case 14: {
                phaseName = "Sg1";
                break;
            }
            default: {
                logger.warn("IN Nearloc.recLocationData(): Could not use unknow phase type to on location !");
                System.exit(-1);
            }
        }
        int m = 0;
        int i = 0;
        while (i < this.stnPhases.length) {
            Enumeration Enu = this.stnPhases[i].elements();
            while (Enu.hasMoreElements()) {
                Phase phase = (Phase)Enu.nextElement();
                if (!phase.getPhaseName().equals(phaseName) || phase.getWeight() != 1) continue;
                lat[m] = this.stnLocations[i].getLat();
                lon[m] = this.stnLocations[i].getLon();
                arriveT[m] = (double)(phase.getPhaseTime().getTime() - this.BaseDate.getTime()) / 1000.0;
                ++m;
            }
            ++i;
        }
        return m;
    }

    public double getLat0() {
        return this.lat0;
    }

    public double getLon0() {
        return this.lon0;
    }

    protected void initLocData() {
        if (this.getStnPhases() != null && this.getStnLocations() != null) {
            this.setOPoint();
            this.setBaseDate();
        }
    }

    private void setOPoint() {
        double lonSum = 0.0;
        double latSum = 0.0;
        int nstn = 0;
        int i = 0;
        while (i < this.stnLocations.length) {
            if (this.hasValidPhase(i)) {
                lonSum += this.stnLocations[i].getLon();
                latSum += this.stnLocations[i].getLat();
                ++nstn;
            }
            ++i;
        }
        this.lon0 = lonSum / (double)nstn * Math.PI / 180.0;
        this.lat0 = latSum / (double)nstn * Math.PI / 180.0;
    }

    private void setBaseDate() {
        this.BaseDate = new Date();
        int i = 0;
        while (i < this.stnPhases.length) {
            Enumeration Enu = this.stnPhases[i].elements();
            if (Enu.hasMoreElements()) {
                Phase phase = (Phase)Enu.nextElement();
                this.BaseDate.setTime(phase.getPhaseTime().getTime() - 120000L);
            }
            ++i;
        }
    }

    public int getPhaseType(String phaseName) throws IllegalArgumentException {
        int type = Integer.MAX_VALUE;
        if (phaseName.equalsIgnoreCase("Pg")) {
            type = 3;
        } else if (phaseName.equalsIgnoreCase("Sg")) {
            type = 4;
        } else if (phaseName.equalsIgnoreCase("Pn")) {
            type = 1;
        } else if (phaseName.equalsIgnoreCase("Sn")) {
            type = 2;
        } else if (phaseName.equalsIgnoreCase("P")) {
            type = 8;
        } else if (phaseName.equalsIgnoreCase("S")) {
            type = 9;
        } else if (phaseName.equalsIgnoreCase("Pg1")) {
            type = 13;
        } else if (phaseName.equalsIgnoreCase("Sg1")) {
            type = 14;
        } else {
            throw new IllegalArgumentException(String.valueOf(phaseName) + " is a wrong argument");
        }
        return type;
    }

    public int setWeight(double[] weight, int start, int phaseType) {
        String phaseName = "";
        switch (phaseType) {
            case 3: {
                phaseName = "Pg";
                break;
            }
            case 4: {
                phaseName = "Sg";
                break;
            }
            case 1: {
                phaseName = "Pn";
                break;
            }
            case 2: {
                phaseName = "Sn";
                break;
            }
            case 8: {
                phaseName = "P";
                break;
            }
            case 9: {
                phaseName = "S";
                break;
            }
            case 13: {
                phaseName = "Pg1";
                break;
            }
            case 14: {
                phaseName = "Sg1";
                break;
            }
            default: {
                logger.warn("Could not use unknow phase type to on location !");
                System.exit(-1);
            }
        }
        int m = 0;
        int i = 0;
        while (i < this.stnPhases.length) {
            Enumeration Enu = this.stnPhases[i].elements();
            while (Enu.hasMoreElements()) {
                Phase phase = (Phase)Enu.nextElement();
                if (!phase.getPhaseName().equals(phaseName)) continue;
                phase.setWeight(weight[start + m] > 0.5 ? 1 : 0);
                ++m;
            }
            ++i;
        }
        return m;
    }
}

