/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.linalg.Distance;
import cn.org.gddsn.optimization.BinaryToDoubleFunction;
import cn.org.gddsn.optimization.GeneticMin;
import cn.org.gddsn.optimization.RealValueFunction;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.BaseLocationInf;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.location.MagnitudeInf;
import cn.org.gddsn.seis.location.NearLocData;
import cn.org.gddsn.seis.location.OutputInfoForLoc;

public final class KnownDUPlugGALoc
extends NearLocData
implements BaseLocationInf,
RealValueFunction {
    double[] Ld;
    double[] L;
    double[] du;
    double[] u;
    double LdSum;
    double avgU;
    double DL;
    double totalT;
    double[] T;
    double[] stnX;
    double[] stnY;
    double[] arriveT;
    double[] stn = new double[3];
    int phsCnts;
    SourceParam trySource;
    double residual;

    public KnownDUPlugGALoc(SourceParam newTrySource) {
        this.trySource = newTrySource;
    }

    public void setMagnitudeInf(MagnitudeInf magnitudeInf) {
    }

    public void setComputedTravelTime(ComputedTravelTime newTTT) {
    }

    public OutputInfoForLoc getOutputInfoForLoc() {
        return null;
    }

    public String getDetailLocationResult() {
        return null;
    }

    public void setTrySource(SourceParam trySource) {
    }

    public void setEvtData(EvtData mainEvent) {
    }

    private void initVar() {
        int stnSum = this.getStnSum();
        this.stnX = new double[stnSum];
        this.stnY = new double[stnSum];
        this.arriveT = new double[stnSum];
        this.T = new double[stnSum];
        this.Ld = new double[stnSum];
        this.L = new double[stnSum];
        this.du = new double[stnSum];
        this.u = new double[stnSum];
    }

    public double funk(double[] x) {
        return this.onePhaesTypeErrorSum(x, 3);
    }

    private double onePhaesTypeErrorSum(double[] x, int phaseType) {
        this.phsCnts = this.recLocationData(this.stnX, this.stnY, this.arriveT, phaseType);
        if (this.phsCnts == 0) {
            return 0.0;
        }
        this.LdSum = 0.0;
        this.totalT = 0.0;
        int i = 0;
        while (i < this.phsCnts) {
            this.stn[0] = this.stnX[i];
            this.stn[1] = this.stnY[i];
            this.stn[2] = 0.0;
            this.Ld[i] = Distance.norm(x, this.stn, 3);
            this.LdSum += this.Ld[i];
            this.totalT += this.arriveT[i] - x[3];
            ++i;
        }
        this.avgU = this.totalT / this.LdSum;
        this.DL = -(this.LdSum * x[4]) / (this.avgU + x[4]);
        double dl = this.DL / (double)this.phsCnts;
        double QSum = 0.0;
        int i2 = 0;
        while (i2 < this.phsCnts) {
            this.L[i2] = this.Ld[i2] + dl;
            QSum += this.L[i2] * this.L[i2];
            ++i2;
        }
        double retVal = 0.0;
        double tmpT = 0.0;
        int i3 = 0;
        while (i3 < this.phsCnts) {
            this.du[i3] = (this.LdSum + this.DL) * this.L[i3] * x[4] / QSum;
            this.u[i3] = this.avgU + this.du[i3];
            this.T[i3] = this.u[i3] * this.L[i3];
            tmpT = this.arriveT[i3] - x[3] - this.T[i3];
            retVal += tmpT * tmpT;
            ++i3;
        }
        return retVal / (double)this.phsCnts;
    }

    public double getResidual() {
        return this.residual;
    }

    public boolean findSourceLoc() {
        double[] trialLoc = new double[5];
        trialLoc[0] = this.Tran.getX(this.trySource.lon * Math.PI / 180.0, this.trySource.lat * Math.PI / 180.0);
        trialLoc[1] = this.Tran.getY(this.trySource.lon * Math.PI / 180.0, this.trySource.lat * Math.PI / 180.0);
        trialLoc[2] = 0.0;
        trialLoc[3] = (double)(this.trySource.originTime.getTime() - this.BaseDate.getTime()) / 1000.0;
        BinaryToDoubleFunction bf = new BinaryToDoubleFunction();
        double[] paraMin = new double[]{trialLoc[0] - 150.0, trialLoc[1] - 150.0, 0.0, trialLoc[3] - 3.0, -0.08};
        int[] bitsLength = new int[]{8, 8, 3, 8, 6};
        double[] paraStep = new double[]{300.0 / Math.pow(2.0, 8.0), 300.0 / Math.pow(2.0, 8.0), 40.0 / Math.pow(2.0, 3.0), 6.0 / Math.pow(2.0, 8.0), 0.08 / Math.pow(2.0, 6.0)};
        bf.setParaMin(paraMin);
        bf.setParaStep(paraStep);
        bf.setBitsLength(bitsLength);
        bf.setFunk(this);
        GeneticMin gm = new GeneticMin();
        gm.setAddNewGeneSize(10);
        gm.setUpdateP(0.0);
        gm.setCrossP(0.8);
        gm.setSelectP(0.99);
        gm.setAvgError(0.01);
        gm.setFunk(bf);
        gm.setPopulationSize(30);
        gm.setIterateMax(100);
        gm.SearchMin();
        this.residual = gm.minError();
        double[] res = gm.getResult();
        this.setLocRes(res);
        this.sourceParam.lon = this.Tran.getLon(res[0], res[1]) / Math.PI * 180.0;
        this.sourceParam.lat = this.Tran.getLat(res[0], res[1]) / Math.PI * 180.0;
        this.sourceParam.depth = res[2];
        this.sourceParam.rms = this.residual;
        this.sourceParam.originTime.setTime(this.BaseDate.getTime() + Math.round(res[3] * 1000.0));
        return true;
    }

    protected void initLocData() {
        super.initLocData();
        this.initVar();
    }
}

