/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.location.ComputedTravelTime;
import org.apache.log4j.Logger;

public abstract class HLayedTravelTime
implements ComputedTravelTime {
    static Logger logger = Logger.getLogger(HLayedTravelTime.class);
    String fineName;
    double[] Height;
    double[] V;

    public double calDelta(double depth, double time, int phaseType) {
        return 0.0;
    }

    public double calTravelTime(double depth, double Deta, int type) {
        return 0.0;
    }

    public double calTravelTime(double[] Src, double[] Stn, int type) {
        double ret = 0.0;
        switch (type) {
            case 3: {
                ret = this.getPG(Src, Stn);
                break;
            }
            case 1: {
                ret = this.getPN(Src, Stn);
                break;
            }
        }
        return ret;
    }

    private double getPN(double[] Src, double[] Stn) {
        return 0.0;
    }

    private double getPG(double[] Src, double[] Stn) {
        double sinSita;
        double Sita;
        if (Src[2] < 0.0) {
            logger.fatal("The Depth is up to ground!");
            System.exit(-1);
        }
        int Layers = this.Height.length;
        int inLayer = 0;
        double Delta = Math.sqrt((Src[0] - Stn[0]) * (Src[0] - Stn[0]) + (Src[1] - Stn[1]) * (Src[1] - Stn[1]));
        double eps = 0.05;
        int i = 0;
        while (i < Layers - 1) {
            if (Src[2] >= this.Height[i] && Src[2] < this.Height[i + 1]) {
                inLayer = i;
            }
            ++i;
        }
        if (Src[2] >= this.Height[Layers - 1]) {
            inLayer = Layers - 1;
        }
        double Zeta = Src[2] - this.Height[inLayer];
        double sitaMin = Math.atan(Delta / Src[2]);
        double sitaMax = Math.atan(Delta / Zeta);
        double tryDelta = 0.0;
        do {
            Sita = sitaMin + (sitaMax - sitaMin) / 2.0;
            tryDelta = Zeta / Math.cos(Sita);
            int j = inLayer;
            while (j > 0) {
                sinSita = Math.sin(Sita) * this.V[j - 1] / this.V[j];
                double tanSita = sinSita / Math.sqrt(1.0 - sinSita * sinSita);
                tryDelta += (this.Height[j] - this.Height[j - 1]) * tanSita;
                --j;
            }
            if (tryDelta >= Delta) {
                sitaMax = Sita;
                continue;
            }
            sitaMin = Sita;
        } while (Math.abs(tryDelta - Delta) > 0.05);
        Sita = sitaMin + (sitaMax - sitaMin) / 2.0;
        double TrvlTime = Zeta / Math.cos(Sita);
        int j = inLayer;
        while (j > 0) {
            sinSita = Math.sin(Sita) * this.V[j - 1] / this.V[j];
            TrvlTime += (this.Height[j] - this.Height[j - 1]) / Math.sqrt(1.0 - sinSita * sinSita);
            --j;
        }
        return TrvlTime;
    }
}

