/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class CalibrationCurve {
    static Logger logger = Logger.getLogger(CalibrationCurve.class);
    private String magName;
    private String units1;
    private String units2;
    private int segments;
    private double[] depthMin;
    private double[] depthMax;
    private double[][][] q;

    public CalibrationCurve(String magPattern) {
        this.read(magPattern);
    }

    private void read(String magPattern) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(CalibrationCurve.class.getResourceAsStream("magnitude/" + magPattern)));
            String line = br.readLine();
            StringTokenizer st = new StringTokenizer(line, "# ");
            st.nextToken();
            this.magName = st.nextToken();
            line = br.readLine();
            st = new StringTokenizer(line, "# ");
            st.nextToken();
            this.units1 = st.nextToken();
            line = br.readLine();
            st = new StringTokenizer(line, "# ");
            st.nextToken();
            this.units2 = st.nextToken();
            line = br.readLine();
            st = new StringTokenizer(line, "#= ");
            st.nextToken();
            this.segments = Integer.parseInt(st.nextToken());
            this.depthMin = new double[this.segments];
            this.depthMax = new double[this.segments];
            this.q = new double[this.segments][][];
            int i = 0;
            while (i < this.segments) {
                line = br.readLine();
                st = new StringTokenizer(line, "#= ");
                st.nextToken();
                int ndel = Integer.parseInt(st.nextToken());
                st.nextToken();
                this.depthMin[i] = Double.parseDouble(st.nextToken());
                st.nextToken();
                this.depthMax[i] = Double.parseDouble(st.nextToken());
                double[][] qn = new double[ndel][2];
                int j = 0;
                while (j < ndel) {
                    line = br.readLine();
                    st = new StringTokenizer(line, " ");
                    qn[j][0] = Double.parseDouble(st.nextToken());
                    qn[j][1] = Double.parseDouble(st.nextToken());
                    ++j;
                }
                this.q[i] = qn;
                ++i;
            }
            br.close();
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public double getQValue(double delta, double depth) {
        int nd = -1;
        int i = 0;
        while (i < this.segments) {
            if (this.depthMin[i] <= depth && depth <= this.depthMax[i]) {
                nd = i;
                break;
            }
            ++i;
        }
        if (nd == -1) {
            return Double.NaN;
        }
        int min = 0;
        int max = this.q[nd].length;
        double[][] qn = this.q[nd];
        do {
            if (delta < qn[min + (max - min) / 2][0]) {
                max = min + (max - min) / 2;
                continue;
            }
            min += (max - min) / 2;
        } while (min + 1 < max);
        if (min >= this.q[nd].length) {
            return Double.NaN;
        }
        if (this.q[nd][min][0] > delta) {
            return Double.NaN;
        }
        return this.q[nd][min][1];
    }

    public String getMagName() {
        return this.magName;
    }

    public int getSegments() {
        return this.segments;
    }

    public String getUnits1() {
        return this.units1;
    }

    public String getUnits2() {
        return this.units2;
    }

    public static void main(String[] args) {
        CalibrationCurve a = new CalibrationCurve("c_P_h");
        System.out.println(a.getQValue(1.0, 20.0));
    }
}

