/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.location.Magnitude;
import cn.org.gddsn.seis.location.MagnitudeInf;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Formatter;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class CalMagnitude
implements MagnitudeInf {
    static Logger logger = Logger.getLogger(CalMagnitude.class);
    public static final int MB_MIN_DIST = 16;
    public static final int MB_MAX_DIST = 120;
    private static double[] mb_sigma = new double[]{5.9, 5.9, 5.9, 6.0, 6.0, 6.1, 6.2, 6.3, 6.3, 6.5, 6.4, 6.5, 6.6, 6.6, 6.6, 6.7, 6.7, 6.7, 6.7, 6.7, 6.6, 6.5, 6.5, 6.4, 6.4, 6.5, 6.5, 6.5, 6.5, 6.7, 6.8, 6.9, 6.9, 6.8, 6.7, 6.7, 6.7, 6.7, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.8, 6.6, 7.0, 6.9, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 6.9, 6.9, 6.9, 6.9, 6.8, 6.8, 6.9, 6.9, 6.9, 6.8, 6.7, 6.8, 6.9, 7.0, 7.0, 7.0, 6.9, 6.9, 7.1, 7.0, 7.0, 7.1, 7.1, 7.2, 7.1, 7.2, 7.3, 7.4, 7.5, 7.5, 7.4, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 7.9, 8.0, 8.1, 8.2, 8.2, 8.4, 8.6, 8.7, 8.8, 8.9, 9.0, 9.0, 9.0};
    public static final int MagR1 = 1;
    public static final int MagR2 = 2;
    int RfunColumSum = 3;
    int RfunRowSum;
    double[][] Rfun;
    private static final double[] Q_MS = new double[]{3.49, 3.5, 3.5, 3.5, 3.51, 3.51, 3.51, 3.51, 3.52, 3.52, 3.52, 3.52, 3.52, 3.53, 3.53, 3.53, 3.53, 3.53, 3.54, 3.54, 3.54, 3.54, 3.54, 3.54, 3.54, 3.54, 3.54, 3.54, 3.54, 3.54, 3.54, 3.53, 3.53, 3.53, 3.52, 3.52, 3.52, 3.52, 3.51, 3.51, 3.51, 3.5, 3.49, 3.47, 3.44, 3.41, 3.39, 3.34, 3.29, 3.19};

    public CalMagnitude() {
        this.readRFunIN();
    }

    void readRFunIN() {
        String fname = "";
        try {
            String LineStr;
            Properties attrib = new Properties();
            attrib.load(new FileInputStream("Main.cfg"));
            fname = attrib.getProperty("RFun");
            if (fname == null) {
                logger.fatal("\"Main.cfg\" did not include  \"RFun\" section !");
                return;
            }
            FileReader fs = new FileReader(fname);
            BufferedReader ds = new BufferedReader(fs);
            do {
                LineStr = ds.readLine();
                ++this.RfunRowSum;
            } while (LineStr != null);
            --this.RfunRowSum;
            ds.close();
            fs.close();
            fs = new FileReader(fname);
            ds = new BufferedReader(fs);
            this.Rfun = new double[this.RfunRowSum][this.RfunColumSum];
            int i = 0;
            while (i < this.RfunRowSum) {
                LineStr = ds.readLine();
                StringTokenizer st = new StringTokenizer(LineStr);
                int j = 0;
                while (j < this.RfunColumSum) {
                    this.Rfun[i][j] = Double.valueOf(st.nextToken());
                    ++j;
                }
                ++i;
            }
            ds.close();
            fs.close();
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), e);
            logger.fatal("In CalMagnitude.readRFunIN, Reading " + fname + " Error!");
            return;
        }
    }

    public double getRFun(double Delta, int MagType2) {
        int min = 0;
        int max = this.RfunRowSum;
        if (Delta <= this.Rfun[min][0]) {
            return this.Rfun[min][MagType2];
        }
        if (Delta >= this.Rfun[max - 1][0]) {
            return this.Rfun[max - 1][MagType2];
        }
        do {
            if (Delta < this.Rfun[min + (max - min) / 2][0]) {
                max = min + (max - min) / 2;
                continue;
            }
            min += (max - min) / 2;
        } while (min + 1 < max);
        double rate = Math.abs(this.Rfun[min][0] - Delta) / Math.abs(this.Rfun[max][0] - this.Rfun[min][0]);
        return this.Rfun[min][MagType2] + rate * Math.abs(this.Rfun[max][MagType2] - this.Rfun[min][MagType2]);
    }

    public double getML(double amp, double delta) {
        double R = this.getRFun(delta, 1);
        if (amp < 1.0E-7) {
            return Double.NaN;
        }
        if (Double.isNaN(amp)) {
            return Double.NaN;
        }
        if (delta > this.Rfun[this.RfunRowSum - 1][0]) {
            return Double.NaN;
        }
        return Math.log(amp) / Math.log(10.0) + R;
    }

    public double getMs(double amp, double delta) {
        if (Double.isNaN(delta)) {
            return Double.NaN;
        }
        double Ms = Math.log(amp) / Math.log(10.0);
        Ms = delta < 130.0 ? (Ms += 1.66 * Math.log(delta) / Math.log(10.0) + 3.5) : (Ms += Q_MS[(int)(delta - 129.5)] + 3.5);
        return Ms;
    }

    public double getMs(Phase phaseZ, Phase phaseE, Phase phaseN, double delta) {
        double Ms = Double.NaN;
        if (Double.isNaN(delta)) {
            return Ms;
        }
        Phase phase = null;
        double amp = 0.0;
        if (phaseZ != null) {
            phase = phaseZ;
        }
        if (phaseE != null) {
            phase = phaseE;
        }
        if (phaseN != null) {
            phase = phaseN;
        }
        if (phase == null) {
            return Double.NaN;
        }
        if (phase.getRecType() == 1) {
            amp = phaseE == null && phaseN != null ? phaseN.getAmp() / (Math.PI * 2) : (phaseE != null && phaseN == null ? phaseE.getAmp() / (Math.PI * 2) : (phaseE != null && phaseN != null ? (phaseN.getAmp() + phaseE.getAmp()) / 2.0 / (Math.PI * 2) : (phaseZ != null ? phaseZ.getAmp() / (Math.PI * 2) : Double.NaN)));
        } else if (phase.getRecType() == 0) {
            amp = phaseE == null && phaseN != null ? phaseN.getAmp() / phaseN.getPeriod() : (phaseE != null && phaseN == null ? phaseE.getAmp() / phaseE.getPeriod() : (phaseE != null && phaseN != null ? (phaseN.getAmp() / phaseN.getPeriod() + phaseE.getAmp() / phaseE.getPeriod()) / 2.0 : (phaseZ != null ? phaseZ.getAmp() / phaseZ.getPeriod() : Double.NaN)));
        }
        return this.getMs(amp, delta / 111.19);
    }

    public double getML(Phase phase, double delta) {
        double ml = Double.NaN;
        if (Double.isNaN(delta)) {
            return ml;
        }
        double R = this.getRFun(delta, 1);
        if (phase.getRecType() == 0 && phase.getAmp() > 0.0 && phase.getPeriod() > 0.0 && delta > 0.0) {
            ml = Math.log(phase.getAmp()) / Math.log(10.0) + R;
        }
        return ml;
    }

    public double getML(Phase phaseZ, Phase phaseE, Phase phaseN, double delta) {
        double ml = Double.NaN;
        if (Double.isNaN(delta)) {
            return ml;
        }
        double R = this.getRFun(delta, 1);
        Phase phase = null;
        double amp = 0.0;
        if (phaseZ != null) {
            phase = phaseZ;
        }
        if (phaseE != null) {
            phase = phaseE;
        }
        if (phaseN != null) {
            phase = phaseN;
        }
        if (phase == null) {
            return Double.NaN;
        }
        if (phase.getRecType() == 1) {
            amp = phaseE == null && phaseN != null ? phaseN.getPeriod() * phaseN.getAmp() / (Math.PI * 2) : (phaseE != null && phaseN == null ? phaseE.getPeriod() * phaseE.getAmp() / (Math.PI * 2) : (phaseE != null && phaseN != null ? (phaseN.getPeriod() * phaseN.getAmp() + phaseE.getPeriod() * phaseE.getAmp()) / 2.0 / (Math.PI * 2) : (phaseZ != null ? phaseZ.getPeriod() * phaseZ.getAmp() / (Math.PI * 2) : Double.NaN)));
            ml = this.getML(amp, delta);
        } else if (phase.getRecType() == 0) {
            if (phaseE == null && phaseN != null) {
                ml = Math.log(phaseN.getAmp()) / Math.log(10.0) + R;
            } else if (phaseE != null && phaseN == null) {
                ml = Math.log(phaseE.getAmp()) / Math.log(10.0) + R;
            } else if (phaseE != null && phaseN != null) {
                amp = (phaseN.getAmp() + phaseE.getAmp()) / 2.0;
                ml = Math.log(amp) / Math.log(10.0) + R;
            } else {
                ml = phaseZ != null ? Math.log(phaseZ.getAmp()) / Math.log(10.0) + R : Double.NaN;
            }
        } else {
            logger.warn("phase record type is unknow, ingore ML calculation.");
            ml = Double.NaN;
        }
        return ml;
    }

    public double getMb(double ampl, double period, double delta, double depth) {
        return Magnitude.compute_mb(ampl, period, delta, depth);
    }

    public double getMb(double ampl, double period, double distance, int type) {
        int idist = (int)Math.round(distance);
        if (idist < 16 || idist > 120) {
            return Double.NaN;
        }
        if (ampl <= 0.0 || period <= 0.0) {
            return Double.NaN;
        }
        double tmp = type == 0 ? Math.log10(ampl / period) + mb_sigma[idist - 16] : Math.log10(ampl / (Math.PI * 2)) + mb_sigma[idist - 16];
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("mb %1$3.1f, distance %2$5.1f, period %3$5.2f, ampl %4$f", tmp, distance, period, ampl);
        return tmp;
    }

    public static double Ml2Ms(double ml) {
        return 1.13 * ml - 1.08;
    }

    public static double Ms2Ml(double ms) {
        return (ms + 1.08) / 1.13;
    }
}

