/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.seed;

import JSci.maths.Complex;
import cn.org.gddsn.jopens.entity.seed.Blockette050;
import cn.org.gddsn.jopens.entity.seed.Blockette052;
import cn.org.gddsn.jopens.entity.seed.Blockette053;
import cn.org.gddsn.jopens.entity.seed.Blockette058;
import cn.org.gddsn.jopens.entity.seed.Blockette074;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.entity.seed.Response;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.entity.seed.TimeSpan;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.RTOneChannelData;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import cn.org.gddsn.seis.evtformat.seed.SeedVolumeDatabasePlugin;
import cn.org.gddsn.seis.evtformat.seed.SeedVolumePlugin;
import edu.iris.miniseedutils.steim.GenericCompressMiniSeedRecord;
import edu.iris.miniseedutils.steim.MiniSeedRecord;
import edu.iris.timeutils.TimeStamp;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeedVolume
extends EvtData {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(SeedVolume.class);
    private Dataless dataless = null;
    private boolean uniTime = false;
    private Date beg = null;
    private Date end = null;
    private boolean bUseTimeSpan = false;
    private transient SeedVolumePlugin seedVolumePlugin;
    private String networkRegex = null;
    private String stationRegex = null;
    private String locIdRegex = null;
    private String chanRegex = null;

    public SeedVolume() {
        this.evtFormat = 7;
    }

    public SeedVolume(boolean uniTime) {
        this.evtFormat = 7;
        this.uniTime = uniTime;
    }

    public void setTimeSpan(Date beg, Date end) {
        this.beg = beg;
        this.end = end;
        this.bUseTimeSpan = true;
    }

    public void setUniTime(boolean uniTime) {
        this.uniTime = uniTime;
    }

    public void cleanTimeSpan() {
        this.bUseTimeSpan = false;
        this.beg = null;
        this.end = null;
    }

    @Override
    public boolean readEvtFile(String fileName) {
        ChannelLocator cl;
        long uniSTms;
        long now_ms = new Date().getTime();
        this.list.clear();
        Iterator itr = null;
        RTOneChannelData ocd2 = null;
        this.dataless = this.seedVolumePlugin.getDataless();
        if (this.dataless == null) {
            return false;
        }
        for (Station stn : this.dataless.getSeedConfig().getStation()) {
            Blockette050 b050 = stn.getBlockette050();
            for (Channel chn : stn.getChannel()) {
                RTOneChannelData oneChannel = new RTOneChannelData();
                oneChannel.setStationSeqNumber(stn.getSeqNumber());
                oneChannel.setNetworkCode(b050.getNetworkCode());
                oneChannel.setStationCode(b050.getStation());
                oneChannel.setAuxId(chn.getBlockette052().getLocation());
                oneChannel.setChannelCode(chn.getBlockette052().getChannel());
                if (logger.isDebugEnabled()) {
                    logger.debug("PreProcess: " + oneChannel.getNetworkCode() + "/" + oneChannel.getStationCode() + "/" + oneChannel.getAuxId() + "/" + oneChannel.getChannelCode());
                }
                this.list.add(oneChannel);
            }
        }
        this.setTimeSeries();
        long uniEDms = -1L;
        if (this.bUseTimeSpan) {
            uniSTms = this.beg.getTime();
            uniEDms = this.end.getTime();
        } else {
            uniSTms = this.dataless.getVolumeIndex().getBlockette010().getStartTime().getTime();
            uniEDms = this.dataless.getVolumeIndex().getBlockette010().getEndTime().getTime();
        }
        for (RTOneChannelData ocd2 : this.list) {
            if (this.uniTime) {
                ocd2.setArrivalTime(new Date(uniSTms));
                continue;
            }
            TimeSpan ts = this.dataless.getTimeSpan().get(0);
            Blockette074 b074 = ts.findBlockette074(ocd2.getNetworkCode(), ocd2.getStationCode(), ocd2.getAuxId(), ocd2.getChannelCode());
            ocd2.setArrivalTime(b074.getStartTime());
        }
        itr = this.list.iterator();
        while (itr.hasNext()) {
            ocd2 = (RTOneChannelData)itr.next();
            String chanId = String.valueOf(ocd2.getNetworkCode()) + "/" + ocd2.getStationCode() + "/" + ocd2.getAuxId() + "/" + ocd2.getChannelCode();
            if (logger.isDebugEnabled()) {
                logger.debug("Process Station Info: " + chanId);
            }
            Station stn = this.dataless.findStation(ocd2.getNetworkCode(), ocd2.getStationCode());
            Blockette050 b050 = stn.getBlockette050();
            if (stn == null) {
                logger.warn("station should not be null, check database for " + chanId);
                logger.warn("remove " + chanId);
                itr.remove();
                continue;
            }
            ocd2.setStationLocation(new Location(b050.getLatitude(), b050.getLongitude(), b050.getElevation() / 1000.0));
            int chn_size = stn.getChannel().size();
            ocd2.setChannelComp(chn_size);
            ocd2.setStationType(chn_size + "C");
            ocd2.setCoordSys("");
            Channel chn = stn.findChannel(ocd2.getAuxId(), ocd2.getChannelCode());
            Blockette052 b052 = chn.getBlockette052();
            if (b052 == null) {
                logger.warn("Channel should not be null, check database for " + chanId);
                logger.warn("remove " + chanId);
                itr.remove();
                continue;
            }
            Response rsp = chn.findResponse(0);
            if (rsp == null) {
                logger.warn("Response stage 0 should not be null, check database for " + chanId);
                logger.warn("remove " + chanId);
                itr.remove();
                continue;
            }
            Blockette058 b058 = rsp.getBlockette058();
            if (b058 == null) {
                logger.warn("Response stage 0 Blockette058 should not be null, check database for " + chanId);
                logger.warn("remove " + chanId);
                itr.remove();
                continue;
            }
            ocd2.setCalper(b058.getFreq());
            ocd2.setCalibFactor(b058.getSensitivity() / 1000000.0);
            ocd2.setHAng(b052.getAzimuth());
            ocd2.setVAng(b052.getDip());
            ocd2.setInstrumentType("");
            ocd2.setOriginalType(1);
            ocd2.setSampleRate(b052.getSampleRate());
            rsp = chn.findResponse(1);
            if (rsp == null) {
                logger.warn("Could not find Stage 1 rsp for: " + chn.getStation().getBlockette050().getStation());
                logger.warn("remove " + chanId);
                itr.remove();
                continue;
            }
            Blockette053 b053 = rsp.getBlockette053();
            if (b053 == null) {
                logger.warn("Response stage 1 Blockette053 should not be null, check database for " + chanId);
                logger.warn("remove " + chanId);
                itr.remove();
                continue;
            }
            ocd2.setScaleFactor(b053.getNormalizationFactor());
            Complex[] zero = new Complex[b053.getZeros().size()];
            Complex[] pole = new Complex[b053.getPoles().size()];
            int i = 0;
            while (i < zero.length) {
                zero[i] = new Complex(b053.getZeros().get(i).getRealPart(), b053.getZeros().get(i).getImPart());
                ++i;
            }
            i = 0;
            while (i < pole.length) {
                pole[i] = new Complex(b053.getPoles().get(i).getRealPart(), b053.getPoles().get(i).getImPart());
                ++i;
            }
            ocd2.setZero(zero);
            ocd2.setPole(pole);
        }
        long n_now_ms = new Date().getTime();
        if (this.list.size() == 0) {
            logger.warn("no channel info found");
            return false;
        }
        logger.info("Total Channel :" + this.list.size() + ",Load station info elapse time: " + (n_now_ms - now_ms) + " ms.");
        now_ms = n_now_ms;
        double[] dat = null;
        int nTotal = -1;
        MiniSeedRecord msr = null;
        Vector<Element> bufVec = new Vector<Element>(512, 128);
        logger.info("process waveform...");
        msr = this.seedVolumePlugin.getNextMiniSeedData();
        if (msr == null) {
            logger.warn("Your open event do not have waveform data!");
            return false;
        }
        do {
            cl = new ChannelLocator(msr.getNetwork(), msr.getStation(), msr.getLocID(), msr.getChannel());
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Process Wavform: " + msr);
        } while (this.getTimeSeries(cl) == null && (msr = this.seedVolumePlugin.getNextMiniSeedData()) != null);
        if (this.getTimeSeries(cl) == null) {
            logger.warn("All waveform could not found his Station info.");
            return false;
        }
        ChannelLocator pre_cl = cl;
        TimeSeries tSeries = this.getTimeSeries(cl);
        double srate = tSeries.getSampleRate();
        long start_ms = tSeries.getArrivalTime().getTime();
        logger.info(cl + "\trate= " + srate + "/startTime=" + tSeries.getArrivalTime());
        if (this.bUseTimeSpan) {
            nTotal = (int)Math.round((double)(uniEDms - uniSTms) * srate / 1000.0);
            if (nTotal < 0) {
                nTotal = -1;
            }
        } else {
            nTotal = -1;
        }
        if (this.uniTime && uniEDms != -1L) {
            nTotal = (int)Math.round((double)(uniEDms - uniSTms) * srate / 1000.0);
        }
        do {
            if (this.getTimeSeries(cl = new ChannelLocator(msr.getNetwork(), msr.getStation(), msr.getLocID(), msr.getChannel())) == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug(msr + " could not found his Station info.");
                continue;
            }
            if (!cl.equals(pre_cl)) {
                dat = this.getSamples(fileName, pre_cl, start_ms, srate, nTotal, bufVec);
                tSeries.setSampData(dat);
                bufVec.removeAllElements();
                pre_cl = cl;
                tSeries = this.getTimeSeries(cl);
                srate = tSeries.getSampleRate();
                if (msr.getSampleRate() != srate) {
                    logger.warn(cl + ": waveform sample rate(" + msr.getSampleRate() + ") is not as same as sample rate in channel table(" + srate + ").");
                }
                start_ms = tSeries.getArrivalTime().getTime();
                if (this.bUseTimeSpan) {
                    nTotal = (int)Math.round((double)(uniEDms - uniSTms) * srate / 1000.0);
                    if (nTotal < 0) {
                        nTotal = -1;
                    }
                } else {
                    nTotal = -1;
                }
                if (this.uniTime && uniEDms != -1L && (nTotal = (int)Math.round((double)(uniEDms - uniSTms) * srate / 1000.0)) < 0) {
                    nTotal = -1;
                }
            }
            long ms = Math.round(msr.getStartTime() * 1000.0);
            Element e = new Element();
            e.start_ms = ms;
            e.len = msr.getNumSamples();
            e.intDat = new int[e.len];
            System.arraycopy(msr.getData(), 0, e.intDat, 0, e.len);
            e.end_ms = ms + (long)((int)Math.round((double)(e.len * 1000) / msr.getSampleRate()));
            bufVec.add(e);
        } while ((msr = this.seedVolumePlugin.getNextMiniSeedData()) != null);
        dat = this.getSamples(fileName, pre_cl, start_ms, srate, nTotal, bufVec);
        tSeries.setSampData(dat);
        n_now_ms = new Date().getTime();
        logger.info("DECODE MiniSeed elapse time: " + (n_now_ms - now_ms) + " ms.");
        now_ms = n_now_ms;
        ListIterator li = this.list.listIterator();
        StringBuilder sb = new StringBuilder();
        this.noDataChannel.clear();
        while (li.hasNext()) {
            TimeSeries ts = (TimeSeries)li.next();
            if (ts.getSampData() != null) continue;
            if (this.cleanNodataChannel) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Remove no data channel: " + ts.getChannelLocator());
                }
                li.remove();
            } else {
                srate = ts.getSampleRate();
                nTotal = (int)Math.round((double)(uniEDms - uniSTms) * srate / 1000.0);
                ts.setSampData(new double[nTotal]);
            }
            this.noDataChannel.add(ts.getChannelLocator());
            sb.append(String.valueOf(ts.getNetworkCode()) + "/" + ts.getStationCode() + " ");
        }
        logger.warn("These stations have not data: " + sb.substring(0));
        this.setTimeSeries();
        try {
            int i = 0;
            while (i < this.TSN) {
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        this.seedVolumePlugin.cleanUpSource();
        return true;
    }

    private double[] getSamples(String event_id, ChannelLocator cl, long start_ms, double srate, int nTotal, Vector<Element> vec) {
        int cnt = 0;
        Collections.sort(vec);
        if (nTotal == -1) {
            Element E2 = vec.lastElement();
            nTotal = (int)Math.round((double)(E2.end_ms - start_ms) * srate / 1000.0);
        }
        double[] dat = new double[nTotal];
        long pre_end_ms = start_ms;
        Enumeration<Element> enu = vec.elements();
        while (enu.hasMoreElements()) {
            Element E3 = enu.nextElement();
            if (E3.end_ms < pre_end_ms) continue;
            int firstIdx = 0;
            int endIdx = E3.len;
            int ngaps = (int)Math.round((double)(E3.start_ms - pre_end_ms) * srate / 1000.0);
            if (ngaps > 0) {
                cnt += ngaps;
                if (logger.isDebugEnabled()) {
                    logger.info("Event ID is " + event_id + ", contain gaps : " + cl + " at " + new Date(pre_end_ms) + ",length=" + (double)ngaps / srate + " seconds");
                }
                if (cnt > dat.length) {
                    if (logger.isDebugEnabled()) {
                        logger.info("Event ID is " + event_id + ", contain big gaps ignore blocks after gaps: " + cl);
                    }
                    return dat;
                }
            } else if (ngaps < 0) {
                firstIdx = -ngaps;
                endIdx = E3.len;
            }
            int j = firstIdx;
            while (j < endIdx) {
                if (cnt >= dat.length) break;
                dat[cnt++] = E3.intDat[j];
                ++j;
            }
            pre_end_ms = E3.end_ms;
        }
        return dat;
    }

    @Override
    public boolean writeEvtFile(String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            int seq = this.dataless.writeSeedVolumeDataless(fos);
            int begSec = 0;
            int cutSec = this.getMaxTRL();
            DecimalFormat fmt = new DecimalFormat("000000");
            short steimLevel = 2;
            short dframes = 63;
            GenericCompressMiniSeedRecord cmsr = new GenericCompressMiniSeedRecord(steimLevel, dframes);
            int tcn = this.getTCN();
            int chn = 0;
            while (chn < tcn) {
                TimeSeries TS = this.getTimeSeries(chn);
                cmsr.setStartTime(new TimeStamp(TS.getArrivalTime().getTime() + (long)(begSec * 1000)));
                cmsr.setSampleRate((int)Math.round(TS.getSampleRate()));
                cmsr.setStationInfo(TS.getNetworkCode(), TS.getStationCode(), TS.getAuxId(), TS.getChannelCode());
                cmsr.setActivityFlag(0);
                double[] sdata = TS.getSampData();
                int[] buf = new int[cutSec * (int)Math.round(TS.getSampleRate())];
                int begPnt = begSec * (int)Math.round(TS.getSampleRate());
                int j = 0;
                while (j < buf.length) {
                    buf[j] = (int)sdata[begPnt + j];
                    ++j;
                }
                int nSamps = cmsr.encodeMiniSeedRecord(buf, buf.length);
                if (nSamps != buf.length) {
                    logger.warn("Error in handle gaps data in addWaveForm()");
                }
                Vector vec = cmsr.getComressFrame();
                Enumeration Enum2 = vec.elements();
                while (Enum2.hasMoreElements()) {
                    byte[] msBytes = (byte[])Enum2.nextElement();
                    System.arraycopy(fmt.format(seq++).getBytes(), 0, msBytes, 0, 6);
                    fos.write(msBytes);
                }
                ++chn;
            }
            fos.close();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            return false;
        }
        return true;
    }

    @Override
    public boolean readEvtFile(URL urlFile) {
        throw new UnsupportedOperationException("Method readEvtFile() not yet implemented.");
    }

    @Override
    public boolean writeEvtFile(URL urlFile) {
        throw new UnsupportedOperationException("Method writeEvtFile() not yet implemented.");
    }

    public SeedVolumePlugin getSeedVolumePlugin() {
        return this.seedVolumePlugin;
    }

    public void setSeedVolumePlugin(SeedVolumePlugin seedVolumePlugin) {
        this.seedVolumePlugin = seedVolumePlugin;
    }

    public Dataless getDataless() {
        return this.dataless;
    }

    public void setDataless(Dataless dataless) {
        this.dataless = dataless;
    }

    public String getChanRegex() {
        return this.chanRegex;
    }

    public void setChanRegex(String chanRegex) {
        this.chanRegex = chanRegex;
        this.setChannelFilter();
    }

    public String getLocIdRegex() {
        return this.locIdRegex;
    }

    public void setLocIdRegex(String locIdRegex) {
        this.locIdRegex = locIdRegex;
        this.setChannelFilter();
    }

    public String getNetworkRegex() {
        return this.networkRegex;
    }

    public void setNetworkRegex(String networkRegex) {
        this.networkRegex = networkRegex;
        this.setChannelFilter();
    }

    public String getStationRegex() {
        return this.stationRegex;
    }

    public void setStationRegex(String stationRegex) {
        this.stationRegex = stationRegex;
        this.setChannelFilter();
    }

    private void setChannelFilter() {
        String channelFilter = "";
        if (this.networkRegex != null && this.networkRegex.length() != 0) {
            channelFilter = String.valueOf(channelFilter) + " AND Net_code REGEXP '" + this.networkRegex + "'";
        }
        if (this.stationRegex != null && this.stationRegex.length() != 0) {
            channelFilter = String.valueOf(channelFilter) + " AND Sta_code REGEXP '" + this.stationRegex + "'";
        }
        if (this.locIdRegex != null && this.locIdRegex.length() != 0) {
            channelFilter = String.valueOf(channelFilter) + " AND Loc_id REGEXP '" + this.locIdRegex + "'";
        }
        if (this.chanRegex != null && this.chanRegex.length() != 0) {
            channelFilter = String.valueOf(channelFilter) + " AND Chn_code REGEXP '" + this.chanRegex + "'";
        }
        this.seedVolumePlugin.setChannelFilter(channelFilter);
    }

    public static void main(String[] args) {
        FileSystemResource res = new FileSystemResource("JOPENS-service-test.xml");
        XmlBeanFactory factory = new XmlBeanFactory(res);
        SeedVolumeService service = (SeedVolumeService)factory.getBean("seedVolumeService");
        SeedVolumeDatabasePlugin plugin = new SeedVolumeDatabasePlugin();
        plugin.setSeedVolumeService(service);
        plugin.setSource(1L, null);
        SeedVolume seedVolume = new SeedVolume();
        seedVolume.setSeedVolumePlugin(plugin);
        seedVolume.readEvtFile("");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Element
    implements Comparable<Element> {
        long start_ms;
        int[] intDat;
        int len;
        long end_ms;

        Element() {
        }

        @Override
        public int compareTo(Element anotherElement) {
            long diff = this.start_ms - anotherElement.start_ms;
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }
    }
}

