/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.sac;

import JSci.maths.ArrayMath;
import cn.org.gddsn.io.LittleEndianOutputStream;
import cn.org.gddsn.seis.evtformat.EvtData;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class SAC {
    public static final float F_UNUSED = -12345.0f;
    public static final int I_UNUSED = -12345;
    public static final String K_UNUSED = "-12345";
    public static final int itime = 1;
    public static final int irlim = 2;
    public static final int iamph = 3;
    public static final int ixy = 4;
    public static final int iunkn = 5;
    public static final int idisp = 6;
    public static final int ivel = 7;
    public static final int iacc = 8;
    public static final int ib = 9;
    public static final int iday = 10;
    public static final int io = 11;
    public static final int ia = 12;
    public static final int it0 = 13;
    public static final int it1 = 14;
    public static final int it2 = 15;
    public static final int it3 = 16;
    public static final int it4 = 17;
    public static final int it5 = 18;
    public static final int it6 = 19;
    public static final int it7 = 20;
    public static final int it8 = 21;
    public static final int it9 = 22;
    public static final int iradnv = 23;
    public static final int itannv = 24;
    public static final int iradev = 25;
    public static final int itanev = 26;
    public static final int inorth = 27;
    public static final int ieast = 28;
    public static final int ihorza = 29;
    public static final int idown = 30;
    public static final int iup = 31;
    public static final int illlbb = 32;
    public static final int iwwsn1 = 33;
    public static final int iwwsn2 = 34;
    public static final int ihglp = 35;
    public static final int isro = 36;
    public static final int inucl = 37;
    public static final int ipren = 38;
    public static final int ipostn = 39;
    public static final int iquake = 40;
    public static final int ipreq = 41;
    public static final int ipostq = 42;
    public static final int ichem = 43;
    public static final int iother = 44;
    public static final int igood = 45;
    public static final int iglch = 46;
    public static final int idrop = 47;
    public static final int ilowsn = 48;
    public static final int irldta = 49;
    public static final int ivolts = 50;
    public static final int ixyz = 51;
    public static final int imb = 52;
    public static final int ims = 53;
    public static final int iml = 54;
    public static final int imw = 55;
    public static final int imd = 56;
    public static final int imx = 57;
    public static final int ineic = 58;
    public static final int ipde = 59;
    public static final int iisc = 60;
    public static final int ireb = 61;
    public static final int iusgs = 62;
    public static final int ibrk = 63;
    public static final int icaltech = 64;
    public static final int illnl = 65;
    public static final int ievloc = 66;
    public static final int ijsop = 67;
    public static final int iuser = 68;
    public static final int iunknown = 69;
    public static final int iqb = 70;
    public static final int iqb1 = 71;
    public static final int iqb2 = 72;
    public static final int iqbx = 73;
    public static final int iqmt = 74;
    public static final int ieq = 75;
    public static final int ieq1 = 76;
    public static final int ieq2 = 77;
    public static final int ime = 78;
    public static final int iex = 79;
    public static final int inu = 80;
    public static final int inc = 81;
    public static final int io_ = 82;
    public static final int il = 83;
    public static final int ir = 84;
    public static final int it = 85;
    public static final int iu = 86;
    public float DELTA = -12345.0f;
    public float DEPMIN = -12345.0f;
    public float DEPMAX = -12345.0f;
    public float SCALE = -12345.0f;
    public float ODELTA = -12345.0f;
    public float B = -12345.0f;
    public float E = -12345.0f;
    public float O = -12345.0f;
    public float A = -12345.0f;
    public float INTERNAL0 = -12345.0f;
    public float T0 = -12345.0f;
    public float T1 = -12345.0f;
    public float T2 = -12345.0f;
    public float T3 = -12345.0f;
    public float T4 = -12345.0f;
    public float T5 = -12345.0f;
    public float T6 = -12345.0f;
    public float T7 = -12345.0f;
    public float T8 = -12345.0f;
    public float T9 = -12345.0f;
    public float F = -12345.0f;
    public float RESP0 = -12345.0f;
    public float RESP1 = -12345.0f;
    public float RESP2 = -12345.0f;
    public float RESP3 = -12345.0f;
    public float RESP4 = -12345.0f;
    public float RESP5 = -12345.0f;
    public float RESP6 = -12345.0f;
    public float RESP7 = -12345.0f;
    public float RESP8 = -12345.0f;
    public float RESP9 = -12345.0f;
    public float STLA = -12345.0f;
    public float STLO = -12345.0f;
    public float STEL = -12345.0f;
    public float STDP = -12345.0f;
    public float EVLA = -12345.0f;
    public float EVLO = -12345.0f;
    public float EVEL = -12345.0f;
    public float EVDP = -12345.0f;
    public float MAG = -12345.0f;
    public float USER0 = -12345.0f;
    public float USER1 = -12345.0f;
    public float USER2 = -12345.0f;
    public float USER3 = -12345.0f;
    public float USER4 = -12345.0f;
    public float USER5 = -12345.0f;
    public float USER6 = -12345.0f;
    public float USER7 = -12345.0f;
    public float USER8 = -12345.0f;
    public float USER9 = -12345.0f;
    public float DIST = -12345.0f;
    public float AZ = -12345.0f;
    public float BAZ = -12345.0f;
    public float GCARC = -12345.0f;
    public float INTERNAL1 = -12345.0f;
    public float INTERNAL2 = -12345.0f;
    public float DEPMEN = -12345.0f;
    public float CMPAZ = -12345.0f;
    public float CMPINC = -12345.0f;
    public float XMINIMUM = -12345.0f;
    public float XMAXIMUM = -12345.0f;
    public float YMINIMUM = -12345.0f;
    public float YMAXIMUM = -12345.0f;
    public float ADJTM = -12345.0f;
    public float UNUSED0 = -12345.0f;
    public float UNUSED1 = -12345.0f;
    public float UNUSED2 = -12345.0f;
    public float UNUSED3 = -12345.0f;
    public float UNUSED4 = -12345.0f;
    public float UNUSED5 = -12345.0f;
    public float UNUSED6 = -12345.0f;
    public int NZYEAR = -12345;
    public int NZJDAY = -12345;
    public int NZHOUR = -12345;
    public int NZMIN = -12345;
    public int NZSEC = -12345;
    public int NZMSEC = -12345;
    public int NVHDR = -12345;
    public int NORID = -12345;
    public int NEVID = -12345;
    public int NPTS = -12345;
    public int INTERNAL3 = -12345;
    public int NWFID = -12345;
    public int NXSIZE = -12345;
    public int NYSIZE = -12345;
    public int UNUSED7 = -12345;
    public int IFTYPE = -12345;
    public int IDEP = -12345;
    public int IZTYPE = -12345;
    public int UNUSED8 = -12345;
    public int IINST = -12345;
    public int ISTREG = -12345;
    public int IEVREG = -12345;
    public int IEVTYP = -12345;
    public int IQUAL = -12345;
    public int ISYNTH = -12345;
    public int IMAGTYP = -12345;
    public int IMAGSRC = -12345;
    public int UNUSED9 = -12345;
    public int UNUSED10 = -12345;
    public int UNUSED11 = -12345;
    public int UNUSED12 = -12345;
    public int UNUSED13 = -12345;
    public int UNUSED14 = -12345;
    public int UNUSED15 = -12345;
    public int UNUSED16 = -12345;
    public boolean LEVEN = false;
    public boolean LPSPOL = false;
    public boolean LOVROK = true;
    public boolean LCALDA = false;
    public boolean UNUSED17 = false;
    public String KSTNM = "-12345";
    public String KEVNM = "-12345";
    public String KHOLE = "-12345";
    public String KO = "-12345";
    public String KA = "-12345";
    public String KT0 = "-12345";
    public String KT1 = "-12345";
    public String KT2 = "-12345";
    public String KT3 = "-12345";
    public String KT4 = "-12345";
    public String KT5 = "-12345";
    public String KT6 = "-12345";
    public String KT7 = "-12345";
    public String KT8 = "-12345";
    public String KT9 = "-12345";
    public String KF = "-12345";
    public String KUSER0 = "-12345";
    public String KUSER1 = "-12345";
    public String KUSER2 = "-12345";
    public String KCMPNM = "-12345";
    public String KNETWK = "-12345";
    public String KDATRD = "-12345";
    public String KINST = "-12345";
    public float[] data1;
    public float[] data2;

    public static void evtData2SAC(EvtData evt, File outDir, boolean bb) throws IOException {
        int i = 0;
        while (i < evt.getTCN()) {
            SAC.evtData2SAC(evt, i, outDir, bb);
            ++i;
        }
    }

    public static void evtData2SAC(EvtData evt, int chn, File outDir, boolean bb) throws IOException {
        SAC sac = new SAC();
        String fname = null;
        sac.NPTS = evt.getSampData(chn).length;
        double[] sd = evt.getSampData(chn);
        sac.data1 = new float[sac.NPTS];
        double gain = evt.getCalibFactor(chn);
        int i = 0;
        while (i < sac.NPTS) {
            sac.data1[i] = (float)sd[i];
            ++i;
        }
        sac.NVHDR = 6;
        sac.B = 0.0f;
        sac.E = (float)evt.getTRL(chn);
        sac.IFTYPE = 1;
        sac.LEVEN = true;
        sac.DELTA = (float)(1.0 / evt.getSampleRate(chn));
        sac.IDEP = 5;
        sac.SCALE = (float)gain;
        sac.DEPMIN = (float)ArrayMath.min(sd);
        sac.DEPMAX = (float)ArrayMath.max(sd);
        sac.DEPMEN = (float)ArrayMath.mean(sd);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(evt.getArrivalTime(chn));
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        sac.NZYEAR = cal.get(1);
        sac.NZJDAY = cal.get(6);
        sac.NZHOUR = cal.get(11);
        sac.NZMIN = cal.get(12);
        sac.NZSEC = cal.get(13);
        sac.NZMSEC = cal.get(14);
        sac.IZTYPE = 9;
        sac.KNETWK = evt.getNetworkCode(chn);
        sac.KSTNM = evt.getStationCode(chn);
        sac.STLA = (float)evt.getStationLocation(chn).getLatitude();
        sac.STLO = (float)evt.getStationLocation(chn).getLongtitude();
        sac.STEL = (float)evt.getStationLocation(chn).getAltitude();
        sac.CMPAZ = (float)evt.getHAng(chn);
        sac.CMPINC = -((float)evt.getVAng(chn));
        sac.KCMPNM = evt.getChannelCode(chn);
        sac.LPSPOL = false;
        sac.LCALDA = true;
        fname = String.format("%04d.%03d.%02d.%02d.%02d.%04d.%2s.%s.%s.%s.D.SAC", sac.NZYEAR, sac.NZJDAY, sac.NZHOUR, sac.NZMIN, sac.NZSEC, sac.NZMSEC * 10, sac.KNETWK, sac.KSTNM, evt.getAuxId(chn), sac.KCMPNM);
        if (bb) {
            LittleEndianOutputStream leOut = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(new File(outDir, fname)), 8192));
            SAC.writeBinarySAC(leOut, sac);
            leOut.close();
        } else {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(new File(outDir, String.valueOf(fname) + "_ASC")), 8192));
            SAC.writeAsciiSAC(pw, sac);
        }
    }

    public static void writeBinarySAC(LittleEndianOutputStream leOut, SAC sac) throws IOException {
        leOut.writeFloat(sac.DELTA);
        leOut.writeFloat(sac.DEPMIN);
        leOut.writeFloat(sac.DEPMAX);
        leOut.writeFloat(sac.SCALE);
        leOut.writeFloat(sac.ODELTA);
        leOut.writeFloat(sac.B);
        leOut.writeFloat(sac.E);
        leOut.writeFloat(sac.O);
        leOut.writeFloat(sac.A);
        leOut.writeFloat(sac.INTERNAL0);
        leOut.writeFloat(sac.T0);
        leOut.writeFloat(sac.T1);
        leOut.writeFloat(sac.T2);
        leOut.writeFloat(sac.T3);
        leOut.writeFloat(sac.T4);
        leOut.writeFloat(sac.T5);
        leOut.writeFloat(sac.T6);
        leOut.writeFloat(sac.T7);
        leOut.writeFloat(sac.T8);
        leOut.writeFloat(sac.T9);
        leOut.writeFloat(sac.F);
        leOut.writeFloat(sac.RESP0);
        leOut.writeFloat(sac.RESP1);
        leOut.writeFloat(sac.RESP2);
        leOut.writeFloat(sac.RESP3);
        leOut.writeFloat(sac.RESP4);
        leOut.writeFloat(sac.RESP5);
        leOut.writeFloat(sac.RESP6);
        leOut.writeFloat(sac.RESP7);
        leOut.writeFloat(sac.RESP8);
        leOut.writeFloat(sac.RESP9);
        leOut.writeFloat(sac.STLA);
        leOut.writeFloat(sac.STLO);
        leOut.writeFloat(sac.STEL);
        leOut.writeFloat(sac.STDP);
        leOut.writeFloat(sac.EVLA);
        leOut.writeFloat(sac.EVLO);
        leOut.writeFloat(sac.EVEL);
        leOut.writeFloat(sac.EVDP);
        leOut.writeFloat(sac.MAG);
        leOut.writeFloat(sac.USER0);
        leOut.writeFloat(sac.USER1);
        leOut.writeFloat(sac.USER2);
        leOut.writeFloat(sac.USER3);
        leOut.writeFloat(sac.USER4);
        leOut.writeFloat(sac.USER5);
        leOut.writeFloat(sac.USER6);
        leOut.writeFloat(sac.USER7);
        leOut.writeFloat(sac.USER8);
        leOut.writeFloat(sac.USER9);
        leOut.writeFloat(sac.DIST);
        leOut.writeFloat(sac.AZ);
        leOut.writeFloat(sac.BAZ);
        leOut.writeFloat(sac.GCARC);
        leOut.writeFloat(sac.INTERNAL1);
        leOut.writeFloat(sac.INTERNAL2);
        leOut.writeFloat(sac.DEPMEN);
        leOut.writeFloat(sac.CMPAZ);
        leOut.writeFloat(sac.CMPINC);
        leOut.writeFloat(sac.XMINIMUM);
        leOut.writeFloat(sac.XMAXIMUM);
        leOut.writeFloat(sac.YMINIMUM);
        leOut.writeFloat(sac.YMAXIMUM);
        leOut.writeFloat(sac.UNUSED0);
        leOut.writeFloat(sac.UNUSED1);
        leOut.writeFloat(sac.UNUSED2);
        leOut.writeFloat(sac.UNUSED3);
        leOut.writeFloat(sac.UNUSED4);
        leOut.writeFloat(sac.UNUSED5);
        leOut.writeFloat(sac.UNUSED6);
        leOut.writeInt(sac.NZYEAR);
        leOut.writeInt(sac.NZJDAY);
        leOut.writeInt(sac.NZHOUR);
        leOut.writeInt(sac.NZMIN);
        leOut.writeInt(sac.NZSEC);
        leOut.writeInt(sac.NZMSEC);
        leOut.writeInt(sac.NVHDR);
        leOut.writeInt(sac.NORID);
        leOut.writeInt(sac.NEVID);
        leOut.writeInt(sac.NPTS);
        leOut.writeInt(sac.INTERNAL3);
        leOut.writeInt(sac.NWFID);
        leOut.writeInt(sac.NXSIZE);
        leOut.writeInt(sac.NYSIZE);
        leOut.writeInt(sac.UNUSED7);
        leOut.writeInt(sac.IFTYPE);
        leOut.writeInt(sac.IDEP);
        leOut.writeInt(sac.IZTYPE);
        leOut.writeInt(sac.UNUSED8);
        leOut.writeInt(sac.IINST);
        leOut.writeInt(sac.ISTREG);
        leOut.writeInt(sac.IEVREG);
        leOut.writeInt(sac.IEVTYP);
        leOut.writeInt(sac.IQUAL);
        leOut.writeInt(sac.ISYNTH);
        leOut.writeInt(sac.IMAGTYP);
        leOut.writeInt(sac.IMAGSRC);
        leOut.writeInt(sac.UNUSED8);
        leOut.writeInt(sac.UNUSED10);
        leOut.writeInt(sac.UNUSED11);
        leOut.writeInt(sac.UNUSED12);
        leOut.writeInt(sac.UNUSED13);
        leOut.writeInt(sac.UNUSED14);
        leOut.writeInt(sac.UNUSED15);
        leOut.writeInt(sac.UNUSED16);
        leOut.writeInt(sac.LEVEN ? 1 : 0);
        leOut.writeInt(sac.LPSPOL ? 1 : 0);
        leOut.writeInt(sac.LOVROK ? 1 : 0);
        leOut.writeInt(sac.LCALDA ? 1 : 0);
        leOut.writeInt(sac.UNUSED17 ? 1 : 0);
        leOut.writeBytes(sac.KSTNM, 8);
        leOut.writeBytes(sac.KEVNM, 16);
        leOut.writeBytes(sac.KHOLE, 8);
        leOut.writeBytes(sac.KO, 8);
        leOut.writeBytes(sac.KA, 8);
        leOut.writeBytes(sac.KT0, 8);
        leOut.writeBytes(sac.KT1, 8);
        leOut.writeBytes(sac.KT2, 8);
        leOut.writeBytes(sac.KT3, 8);
        leOut.writeBytes(sac.KT4, 8);
        leOut.writeBytes(sac.KT5, 8);
        leOut.writeBytes(sac.KT6, 8);
        leOut.writeBytes(sac.KT7, 8);
        leOut.writeBytes(sac.KT8, 8);
        leOut.writeBytes(sac.KT9, 8);
        leOut.writeBytes(sac.KF, 8);
        leOut.writeBytes(sac.KUSER0, 8);
        leOut.writeBytes(sac.KUSER1, 8);
        leOut.writeBytes(sac.KUSER2, 8);
        leOut.writeBytes(sac.KCMPNM, 8);
        leOut.writeBytes(sac.KNETWK, 8);
        leOut.writeBytes(sac.KDATRD, 8);
        leOut.writeBytes(sac.KINST, 8);
        int i = 0;
        while (i < sac.NPTS) {
            leOut.writeFloat(sac.data1[i]);
            ++i;
        }
    }

    public static void writeAsciiSAC(PrintWriter pw, SAC sac) throws IOException {
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.DELTA), Float.valueOf(sac.DEPMIN), Float.valueOf(sac.DEPMAX), Float.valueOf(sac.SCALE), Float.valueOf(sac.ODELTA));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.B), Float.valueOf(sac.E), Float.valueOf(sac.O), Float.valueOf(sac.A), Float.valueOf(sac.INTERNAL0));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.T0), Float.valueOf(sac.T1), Float.valueOf(sac.T2), Float.valueOf(sac.T3), Float.valueOf(sac.T4));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.T5), Float.valueOf(sac.T6), Float.valueOf(sac.T7), Float.valueOf(sac.T8), Float.valueOf(sac.T9));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.F), Float.valueOf(sac.RESP0), Float.valueOf(sac.RESP1), Float.valueOf(sac.RESP2), Float.valueOf(sac.RESP3));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.RESP4), Float.valueOf(sac.RESP5), Float.valueOf(sac.RESP6), Float.valueOf(sac.RESP7), Float.valueOf(sac.RESP8));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.RESP9), Float.valueOf(sac.STLA), Float.valueOf(sac.STLO), Float.valueOf(sac.STEL), Float.valueOf(sac.STDP));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.EVLA), Float.valueOf(sac.EVLO), Float.valueOf(sac.EVEL), Float.valueOf(sac.EVDP), Float.valueOf(sac.MAG));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.USER0), Float.valueOf(sac.USER1), Float.valueOf(sac.USER2), Float.valueOf(sac.USER3), Float.valueOf(sac.USER4));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.USER5), Float.valueOf(sac.USER6), Float.valueOf(sac.USER7), Float.valueOf(sac.USER8), Float.valueOf(sac.USER9));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.DIST), Float.valueOf(sac.AZ), Float.valueOf(sac.BAZ), Float.valueOf(sac.GCARC), Float.valueOf(sac.INTERNAL1));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.INTERNAL2), Float.valueOf(sac.DEPMEN), Float.valueOf(sac.CMPAZ), Float.valueOf(sac.CMPINC), Float.valueOf(sac.XMINIMUM));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.XMAXIMUM), Float.valueOf(sac.YMINIMUM), Float.valueOf(sac.YMAXIMUM), Float.valueOf(sac.UNUSED0), Float.valueOf(sac.UNUSED1));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.UNUSED2), Float.valueOf(sac.UNUSED3), Float.valueOf(sac.UNUSED4), Float.valueOf(sac.UNUSED5), Float.valueOf(sac.UNUSED6));
        pw.printf("%10d %10d %10d %10d %10d\n", sac.NZYEAR, sac.NZJDAY, sac.NZHOUR, sac.NZMIN, sac.NZSEC);
        pw.printf("%10d %10d %10d %10d %10d\n", sac.NZMSEC, sac.NVHDR, sac.NORID, sac.NEVID, sac.NPTS);
        pw.printf("%10d %10d %10d %10d %10d\n", sac.INTERNAL3, sac.NWFID, sac.NXSIZE, sac.NYSIZE, sac.UNUSED7);
        pw.printf("%10d %10d %10d %10d %10d\n", sac.IFTYPE, sac.IDEP, sac.IZTYPE, sac.UNUSED8, sac.IINST);
        pw.printf("%10d %10d %10d %10d %10d\n", sac.ISTREG, sac.IEVREG, sac.IEVTYP, sac.IQUAL, sac.ISYNTH);
        pw.printf("%10d %10d %10d %10d %10d\n", sac.IMAGTYP, sac.IMAGSRC, sac.UNUSED9, sac.UNUSED10, sac.UNUSED11);
        pw.printf("%10d %10d %10d %10d %10d\n", sac.UNUSED12, sac.UNUSED13, sac.UNUSED14, sac.UNUSED15, sac.UNUSED16);
        pw.printf("%10d %10d %10d %10d %10d\n", sac.LEVEN ? 1 : 0, sac.LPSPOL ? 1 : 0, sac.LOVROK ? 1 : 0, sac.LCALDA ? 1 : 0, sac.UNUSED17 ? 1 : 0);
        pw.printf("%8s %8s\n", sac.KSTNM, sac.KEVNM);
        pw.printf("%8s %8s %8s\n", sac.KHOLE, sac.KO, sac.KA);
        pw.printf("%8s %8s %8s\n", sac.KT0, sac.KT1, sac.KT2);
        pw.printf("%8s %8s %8s\n", sac.KT3, sac.KT4, sac.KT5);
        pw.printf("%8s %8s %8s\n", sac.KT6, sac.KT7, sac.KT8);
        pw.printf("%8s %8s %8s\n", sac.KT9, sac.KF, sac.KUSER0);
        pw.printf("%8s %8s %8s\n", sac.KUSER1, sac.KUSER2, sac.KCMPNM);
        pw.printf("%8s %8s %8s\n", sac.KNETWK, sac.KDATRD, sac.KINST);
        int n = sac.NPTS / 5;
        int L = sac.NPTS % 5;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < 5) {
                pw.printf("%15.7g ", Float.valueOf(sac.data1[i * 5 + j]));
                ++j;
            }
            pw.println();
            ++i;
        }
        int j = 0;
        while (j < L) {
            pw.printf("%15.7g ", Float.valueOf(sac.data1[n * 5 + j]));
            ++j;
        }
        pw.println();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Usage: SAC [-b|-a] eventFile outDir");
            System.exit(-1);
        }
        boolean bb = true;
        String fname = null;
        String outDir = null;
        String arg0 = args[0];
        if (arg0.equals("-b") && args.length > 2) {
            bb = true;
            fname = args[1];
            outDir = args[2];
        } else if (arg0.equals("-a") && args.length > 2) {
            bb = false;
            fname = args[1];
            outDir = args[2];
        } else {
            bb = true;
            fname = args[0];
            outDir = args[1];
        }
        EvtData evt = EvtData.readEvtData(fname);
        SAC.evtData2SAC(evt, new File(outDir), bb);
    }
}

