/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.gse;

import cn.org.gddsn.seis.evtformat.gse.BEA2;
import cn.org.gddsn.seis.evtformat.gse.CHK2;
import cn.org.gddsn.seis.evtformat.gse.DAT2;
import cn.org.gddsn.seis.evtformat.gse.DLY2;
import cn.org.gddsn.seis.evtformat.gse.EID2;
import cn.org.gddsn.seis.evtformat.gse.GSEDataMessage;
import cn.org.gddsn.seis.evtformat.gse.OUT2;
import cn.org.gddsn.seis.evtformat.gse.STA2;
import cn.org.gddsn.seis.evtformat.gse.WID2;
import cn.org.gddsn.seis.evtformat.gse.WaveFormBlk;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;

final class GSEWaveFormMsg
extends GSEDataMessage {
    LinkedList list = new LinkedList();

    public GSEWaveFormMsg() {
        this.dataType = "WAVEFORM";
    }

    public void deCod(String aheadLine, BufferedReader reader) throws IOException {
        super.deCod(aheadLine, reader);
        this.headLine = aheadLine;
        while (!this.isDataMessageHead(this.headLine)) {
            WaveFormBlk waveBlk = new WaveFormBlk();
            if (this.headLine.startsWith("WID2")) {
                waveBlk.wid2 = new WID2();
                waveBlk.wid2.deCod(this.headLine, reader);
                this.headLine = waveBlk.wid2.getNextTypeHeadLine();
                waveBlk.sta2 = new STA2();
                waveBlk.sta2.deCod(this.headLine, reader);
                this.headLine = waveBlk.sta2.getNextTypeHeadLine();
                if (aheadLine.startsWith("EID2")) {
                    waveBlk.eid2 = new EID2();
                    waveBlk.eid2.deCod(this.headLine, reader);
                    this.headLine = waveBlk.eid2.getNextTypeHeadLine();
                }
                if (aheadLine.startsWith("BEA2")) {
                    waveBlk.bea2 = new BEA2();
                    waveBlk.bea2.deCod(this.headLine, reader);
                    this.headLine = waveBlk.bea2.getNextTypeHeadLine();
                }
                waveBlk.dat2 = new DAT2();
                waveBlk.dat2.deCod(this.headLine, reader);
                this.headLine = waveBlk.dat2.getNextTypeHeadLine();
                waveBlk.chk2 = new CHK2();
                waveBlk.chk2.deCod(this.headLine, reader);
                this.headLine = waveBlk.chk2.getNextTypeHeadLine();
            } else if (aheadLine.startsWith("OUT2")) {
                waveBlk.out2 = new OUT2();
                waveBlk.out2.deCod(this.headLine, reader);
                this.headLine = waveBlk.out2.getNextTypeHeadLine();
                waveBlk.sta2 = new STA2();
                waveBlk.sta2.deCod(this.headLine, reader);
                this.headLine = waveBlk.sta2.getNextTypeHeadLine();
            } else if (aheadLine.startsWith("DLY2")) {
                waveBlk.dly2 = new DLY2();
                waveBlk.dly2.deCod(this.headLine, reader);
                this.headLine = waveBlk.dly2.getNextTypeHeadLine();
                waveBlk.sta2 = new STA2();
                waveBlk.sta2.deCod(this.headLine, reader);
                this.headLine = waveBlk.sta2.getNextTypeHeadLine();
            }
            this.list.add(waveBlk);
        }
    }

    public void enCod(BufferedWriter writer) throws IOException {
        super.enCod(writer);
        ListIterator lIt = this.list.listIterator();
        while (lIt.hasNext()) {
            WaveFormBlk waveBlk = (WaveFormBlk)lIt.next();
            if (waveBlk.wid2 != null) {
                waveBlk.wid2.enCod(writer);
                waveBlk.sta2.enCod(writer);
                if (waveBlk.eid2 != null) {
                    waveBlk.eid2.enCod(writer);
                }
                if (waveBlk.bea2 != null) {
                    waveBlk.bea2.enCod(writer);
                }
                waveBlk.dat2.enCod(writer);
                waveBlk.chk2.enCod(writer);
                continue;
            }
            if (waveBlk.out2 != null) {
                waveBlk.out2.enCod(writer);
                waveBlk.sta2.enCod(writer);
                continue;
            }
            if (waveBlk.dly2 == null) continue;
            waveBlk.dly2.enCod(writer);
            waveBlk.sta2.enCod(writer);
        }
    }
}

