/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import JSci.maths.Complex;
import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.RTOneChannelData;
import cn.org.gddsn.seis.evtformat.RTResponse;
import cn.org.gddsn.seis.evtformat.RTStationInfo;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.GregorianCalendar;

public class TdeEvent
extends EvtData {
    public boolean readEvtFile(String fileName) {
        try {
            File file = new File(fileName);
            if (!file.isDirectory()) {
                FileInputStream FileIn = new FileInputStream(fileName);
                BufferedInputStream BufferedIn = new BufferedInputStream(FileIn, 4096);
                LittleEndianInputStream DatIn = new LittleEndianInputStream(BufferedIn);
                this.readTDE(DatIn);
                DatIn.close();
                BufferedIn.close();
                FileIn.close();
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            return false;
        }
        return true;
    }

    public boolean writeEvtFile(String fileName) {
        return false;
    }

    public boolean readEvtFile(URL urlFile) {
        return false;
    }

    public boolean writeEvtFile(URL urlFile) {
        return false;
    }

    private void readTDE(LittleEndianInputStream DatIn) throws IOException {
        Complex[] pole = new Complex[]{new Complex(-1.0, 0.5), new Complex(-1.0, -0.5)};
        Complex[] zero = new Complex[]{new Complex(0.0, 0.0), new Complex(0.0, 0.0)};
        int TCN = 3;
        boolean TSN = true;
        TimeSeries[] oneChannel = new RTOneChannelData[TCN];
        RTStationInfo[] rtSI = new RTStationInfo[TCN];
        RTResponse[] rtRsp = new RTResponse[TCN];
        Date[] arrivalTime = new Date[TCN];
        int i = 0;
        while (i < TCN) {
            oneChannel[i] = new RTOneChannelData();
            rtSI[i] = new RTStationInfo();
            rtRsp[i] = new RTResponse();
            arrivalTime[i] = new Date();
            rtSI[i].setNetworkCode("GDDSN");
            rtSI[i].setStationCode("MFS");
            rtSI[i].setAuxId("");
            rtSI[i].setChannelComp(3);
            rtSI[i].setCoordSys("WGS-84");
            rtSI[i].setInstrumentType("S-13");
            rtSI[i].setSampleRate(50.0);
            rtSI[i].setStationLocation(new Location(23.308, 113.445));
            rtSI[i].setStationType("3C");
            rtRsp[i].setCalibFactor(1000.0);
            rtRsp[i].setCalper(1.0);
            rtRsp[i].setScaleFactor(500.0);
            rtRsp[i].setZero(zero);
            rtRsp[i].setPole(zero);
            rtRsp[i].setOriginalType(1);
            if (i == 0) {
                rtSI[0].setChannelCode("SHZ");
                rtSI[0].setHAng(-1.0);
                rtSI[0].setVAng(90.0);
            } else if (i == 1) {
                rtSI[1].setChannelCode("SHE");
                rtSI[1].setHAng(90.0);
                rtSI[1].setVAng(90.0);
            } else {
                rtSI[2].setChannelCode("SHN");
                rtSI[2].setHAng(0.0);
                rtSI[2].setVAng(90.0);
            }
            ++i;
        }
        DatIn.skipBytes(6);
        short year = DatIn.readShort();
        short mon = DatIn.readShort();
        short day = DatIn.readShort();
        short hour = DatIn.readShort();
        short min = DatIn.readShort();
        short sec = DatIn.readShort();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(year, mon, day, hour, min, sec);
        Date EventDate = calendar.getTime();
        int TRL = DatIn.readInt() - 1;
        DatIn.skipBytes(1086);
        double[][] WDat = new double[3][50 * TRL];
        int Base = 0x800000;
        int i2 = 0;
        while (i2 < TRL) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 50) {
                    WDat[j][50 * i2 + k] = DatIn.readInt() - Base;
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < TCN) {
            arrivalTime[i2] = new Date(EventDate.getTime());
            ((RTOneChannelData)oneChannel[i2]).setData(rtSI[i2], rtRsp[i2], arrivalTime[i2], WDat[i2]);
            ++i2;
        }
        this.setTimeSeries(oneChannel);
    }

    public static void main(String[] args) {
        TdeEvent tdeEvent = new TdeEvent();
        tdeEvent.readEvtFile("D:\\public\\EvtFormat\\98071421.tde");
        TdeEvent evtdata = tdeEvent;
    }
}

