/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import JSci.maths.Complex;
import cn.org.gddsn.jopens.entity.seed.Blockette050;
import cn.org.gddsn.jopens.entity.seed.Blockette052;
import cn.org.gddsn.jopens.entity.seed.Blockette053;
import cn.org.gddsn.jopens.entity.seed.Blockette058;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.entity.seed.Response;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.seis.config.StationProfile;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.GeoDevEvtData;
import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.RTOneChannelData;
import cn.org.gddsn.seis.evtformat.RTResponse;
import cn.org.gddsn.seis.evtformat.RTStationInfo;
import cn.org.gddsn.seis.evtformat.RTStreamManager;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import cn.org.gddsn.seis.evtformat.UnsupportedEventFormat;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class RTEvtData
extends EvtData {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(GeoDevEvtData.class);

    public RTEvtData() {
        this.evtFormat = 5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readEvtFile(String fileName) {
        boolean ret = false;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            File file = new File(fileName);
            String parent = file.getParent();
            if (!parent.endsWith(File.separator)) {
                parent = String.valueOf(parent) + File.separator;
            }
            RTStreamManager rtStreamManager = new RTStreamManager();
            LinkedList<TimeSeries> aList = new LinkedList<TimeSeries>();
            String lineStr = reader.readLine();
            if (lineStr == null) {
                reader.close();
                return ret;
            }
            if (!lineStr.equals("FORMAT_RTStreamData")) {
                reader.close();
                throw new UnsupportedEventFormat("RTEvtData waveform discription file format error");
            }
            while (true) {
                if ((lineStr = reader.readLine()) == null) {
                    if (aList.size() != 0) {
                        this.setTimeSeries(aList);
                        ret = true;
                    }
                    reader.close();
                    return ret;
                }
                StringTokenizer st = new StringTokenizer(lineStr);
                String fullName = String.valueOf(parent) + st.nextToken();
                RTOneChannelData rtOneChannelData = rtStreamManager.readTimeSeries(fullName);
                if (rtOneChannelData != null) {
                    aList.add(rtOneChannelData);
                    continue;
                }
                logger.warn(String.valueOf(fullName) + "Not Found!");
            }
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            return ret;
        }
        catch (NoSuchElementException noEx) {
            logger.warn(noEx.getMessage(), noEx);
            return ret;
        }
        catch (ClassNotFoundException cnfEx) {
            logger.warn(cnfEx.getMessage(), cnfEx);
            return ret;
        }
    }

    public boolean writeEvtFile(String fileName) {
        return false;
    }

    public boolean readEvtFile(URL urlFile) {
        return false;
    }

    public boolean writeEvtFile(URL urlFile) {
        return false;
    }

    public boolean writeEventHeadInfoConfigurationFile(String fname) {
        try {
            GZIPOutputStream gzipOut = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(fname), 4096));
            ObjectOutputStream oos = new ObjectOutputStream(gzipOut);
            oos.writeInt(this.getTSN());
            oos.writeInt(this.getTCN());
            ListIterator itr = this.list.listIterator();
            while (itr.hasNext()) {
                RTOneChannelData chanData = (RTOneChannelData)itr.next();
                oos.writeObject(chanData.getStationInfo());
                oos.writeObject(chanData.getResponseInfo());
            }
            oos.flush();
            oos.close();
            gzipOut.close();
        }
        catch (IOException ioEx) {
            logger.warn(ioEx.getMessage(), ioEx);
            return false;
        }
        return true;
    }

    public boolean readCongiguration(Dataless dataless) throws Exception {
        long now_ms = new Date().getTime();
        this.list.clear();
        Iterator itr = null;
        RTOneChannelData ocd2 = null;
        for (Station stn : dataless.getSeedConfig().getStation()) {
            Blockette050 b050 = stn.getBlockette050();
            for (Channel chn : stn.getChannel()) {
                RTOneChannelData oneChannel = new RTOneChannelData();
                oneChannel.setNetworkCode(b050.getNetworkCode());
                oneChannel.setStationCode(b050.getStation());
                oneChannel.setAuxId(chn.getBlockette052().getLocation());
                oneChannel.setChannelCode(chn.getBlockette052().getChannel());
                if (logger.isDebugEnabled()) {
                    logger.debug("PreProcess: " + oneChannel.getNetworkCode() + "/" + oneChannel.getStationCode() + "/" + oneChannel.getAuxId() + "/" + oneChannel.getChannelCode());
                }
                this.list.add(oneChannel);
            }
        }
        this.setTimeSeries();
        long uniSTms = dataless.getVolumeIndex().getBlockette010().getStartTime().getTime();
        for (RTOneChannelData ocd2 : this.list) {
            ocd2.setArrivalTime(new Date(uniSTms));
        }
        for (RTOneChannelData ocd2 : this.list) {
            Station stn;
            String chanId = String.valueOf(ocd2.getNetworkCode()) + "/" + ocd2.getStationCode() + "/" + ocd2.getAuxId() + "/" + ocd2.getChannelCode();
            if (logger.isDebugEnabled()) {
                logger.debug("Process Station Info: " + chanId);
            }
            if ((stn = dataless.findStation(ocd2.getNetworkCode(), ocd2.getStationCode())) == null) {
                logger.warn("station should not be null, check database for " + chanId);
                return false;
            }
            Blockette050 b050 = stn.getBlockette050();
            ocd2.setStationLocation(new Location(b050.getLatitude(), b050.getLongitude(), b050.getElevation() / 1000.0));
            int chn_size = stn.getChannel().size();
            ocd2.setChannelComp(chn_size);
            ocd2.setStationType(chn_size + "C");
            ocd2.setCoordSys("");
            Channel chn = stn.findChannel(ocd2.getAuxId(), ocd2.getChannelCode());
            Blockette052 b052 = chn.getBlockette052();
            if (b052 == null) {
                logger.warn("Channel should not be null, check database for " + chanId);
                return false;
            }
            Response rsp = chn.findResponse(0);
            Blockette058 b058 = rsp.getBlockette058();
            if (b058 == null) {
                logger.warn("Response stage 0 Blockette058 should not be null, check database for " + chanId);
                return false;
            }
            ocd2.setCalper(b058.getFreq());
            ocd2.setCalibFactor(b058.getSensitivity() / 1000000.0);
            ocd2.setHAng(0.0);
            ocd2.setVAng(0.0);
            ocd2.setInstrumentType("");
            ocd2.setOriginalType(1);
            ocd2.setSampleRate(b052.getSampleRate());
            rsp = chn.findResponse(1);
            Blockette053 b053 = rsp.getBlockette053();
            if (b053 == null) {
                logger.warn("Response stage 1 Blockette053 should not be null, check database for " + chanId);
                return false;
            }
            ocd2.setScaleFactor(b053.getNormalizationFactor());
            Complex[] zero = new Complex[b053.getZeros().size()];
            Complex[] pole = new Complex[b053.getPoles().size()];
            int i = 0;
            while (i < zero.length) {
                zero[i] = new Complex(b053.getZeros().get(i).getRealPart(), b053.getZeros().get(i).getImPart());
                ++i;
            }
            i = 0;
            while (i < pole.length) {
                pole[i] = new Complex(b053.getPoles().get(i).getRealPart(), b053.getPoles().get(i).getImPart());
                ++i;
            }
            ocd2.setZero(zero);
            ocd2.setPole(pole);
        }
        long n_now_ms = new Date().getTime();
        if (this.list.size() == 0) {
            logger.warn("no channel info found");
            return false;
        }
        logger.info("Total Channel :" + this.list.size() + ",Load station info elapse time: " + (n_now_ms - now_ms) + " ms.");
        return true;
    }

    public void readXmlConfigurationFile(InputStream is) throws Exception {
        StationProfile sp = new StationProfile();
        sp.parseNetwork(is);
        this.clat = sp.getClat();
        this.clon = sp.getClon();
        this.calt = sp.getCalt() * 1000.0;
        RTStationInfo rtSI = new RTStationInfo();
        RTResponse rtRsp = new RTResponse();
        this.TSN = sp.getNStation();
        this.TCN = 0;
        Vector stnList = sp.getStationList();
        int i = 0;
        while (i < stnList.size()) {
            String stn = (String)stnList.get(i);
            StationProfile.Station st = sp.getStation(stn);
            StationProfile.Channel[] chns = sp.getAllChannel(stn);
            int j = 0;
            while (j < chns.length) {
                rtSI = new RTStationInfo();
                rtRsp = new RTResponse();
                rtSI.setNetworkCode(st.getNet());
                rtSI.setStationCode(st.getSta());
                rtSI.setAuxId(chns[j].getLocID());
                rtSI.setChannelCode(chns[j].getCha());
                rtSI.setStationType(st.getStaType());
                rtSI.setCoordSys(st.getCoordsys());
                rtSI.setInstrumentType(st.getMtype());
                rtSI.setStationLocation(new Location(st.getLat(), st.getLon(), st.getElev()));
                rtSI.setSampleRate(chns[j].getSampleRate());
                rtSI.setHAng(chns[j].getHang());
                rtSI.setVAng(chns[j].getVang());
                rtSI.setChannelComp(chns.length);
                rtRsp.setCalibFactor(chns[j].getTranFun().getSensitivity());
                rtRsp.setCalper(chns[j].getTranFun().getCalper());
                rtRsp.setScaleFactor(chns[j].getTranFun().getSfactor());
                int zeroNum = chns[j].getTranFun().getNzero();
                int poleNum = chns[j].getTranFun().getNpole();
                Complex[] zero = new Complex[zeroNum];
                Complex[] pole = new Complex[poleNum];
                StringTokenizer strt = new StringTokenizer(chns[j].getTranFun().getZero(), " \t\r\n");
                int k = 0;
                while (k < zeroNum) {
                    zero[k] = new Complex(Double.parseDouble(strt.nextToken()), Double.parseDouble(strt.nextToken()));
                    ++k;
                }
                strt = new StringTokenizer(chns[j].getTranFun().getPole(), " \t\r\n");
                k = 0;
                while (k < poleNum) {
                    pole[k] = new Complex(Double.parseDouble(strt.nextToken()), Double.parseDouble(strt.nextToken()));
                    ++k;
                }
                rtRsp.setZero(zero);
                rtRsp.setPole(pole);
                if (chns[j].getTranFun().getIunits().equals("um/s")) {
                    rtRsp.setOriginalType(1);
                } else if (chns[j].getTranFun().getIunits().equals("um")) {
                    rtRsp.setOriginalType(0);
                } else {
                    rtRsp.setOriginalType(2);
                }
                this.list.add(new RTOneChannelData(rtSI, rtRsp, null, null));
                ++j;
                ++this.TCN;
            }
            ++i;
        }
    }

    public void readXmlConfigurationFile(String xmlFile) throws Exception {
        FileInputStream is = new FileInputStream(xmlFile);
        this.readXmlConfigurationFile(is);
        ((InputStream)is).close();
    }

    public void readASCConfigurationFile(String fname) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(fname));
        RTStationInfo rtSI = new RTStationInfo();
        RTResponse rtRsp = new RTResponse();
        String lineStr = reader.readLine();
        StringTokenizer st = new StringTokenizer(lineStr);
        this.TSN = Integer.parseInt(st.nextToken());
        this.TCN = Integer.parseInt(st.nextToken());
        while ((lineStr = reader.readLine()) != null) {
            rtSI = new RTStationInfo();
            rtRsp = new RTResponse();
            st = new StringTokenizer(lineStr);
            rtSI.setNetworkCode(st.nextToken());
            rtSI.setStationCode(st.nextToken());
            rtSI.setAuxId(st.nextToken());
            rtSI.setChannelCode(st.nextToken());
            rtSI.setStationType(st.nextToken());
            rtSI.setCoordSys(st.nextToken());
            rtSI.setInstrumentType(st.nextToken());
            double lat = Double.parseDouble(st.nextToken());
            double lon = Double.parseDouble(st.nextToken());
            double elv = Double.parseDouble(st.nextToken());
            rtSI.setStationLocation(new Location(lat, lon, elv));
            rtSI.setSampleRate(Double.parseDouble(st.nextToken()));
            rtSI.setHAng(Double.parseDouble(st.nextToken()));
            rtSI.setVAng(Double.parseDouble(st.nextToken()));
            rtSI.setChannelComp(Integer.parseInt(st.nextToken()));
            rtRsp.setCalibFactor(Double.parseDouble(st.nextToken()));
            rtRsp.setCalper(Double.parseDouble(st.nextToken()));
            rtRsp.setScaleFactor(Double.parseDouble(st.nextToken()));
            int zeroNum = Integer.parseInt(st.nextToken());
            int poleNum = Integer.parseInt(st.nextToken());
            Complex[] zero = new Complex[zeroNum];
            Complex[] pole = new Complex[poleNum];
            int i = 0;
            while (i < zeroNum) {
                zero[i] = new Complex(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
                ++i;
            }
            i = 0;
            while (i < poleNum) {
                pole[i] = new Complex(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
                ++i;
            }
            rtRsp.setZero(zero);
            rtRsp.setPole(pole);
            rtRsp.setOriginalType(Integer.parseInt(st.nextToken()));
            this.list.add(new RTOneChannelData(rtSI, rtRsp, null, null));
        }
    }

    public boolean readEventHeadInfoConfigurationFile(String fname) {
        try {
            GZIPInputStream gzipIn = new GZIPInputStream(new FileInputStream(fname));
            ObjectInputStream ois = new ObjectInputStream(gzipIn);
            this.TSN = ois.readInt();
            this.TCN = ois.readInt();
            int i = 0;
            while (i < this.TCN) {
                this.list.add(new RTOneChannelData((RTStationInfo)ois.readObject(), (RTResponse)ois.readObject(), null, null));
                ++i;
            }
            ois.close();
            gzipIn.close();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            return false;
        }
        return true;
    }

    public void testReadEvtFile(String fname) {
        this.readEvtFile(fname);
    }

    public void generateRtsCfg(String txtFile, String srFile) throws Exception {
        RTEvtData rtEvtData = new RTEvtData();
        if (txtFile.endsWith(".xml")) {
            rtEvtData.readXmlConfigurationFile(txtFile);
        } else {
            rtEvtData.readASCConfigurationFile(txtFile);
        }
        rtEvtData.writeEventHeadInfoConfigurationFile(srFile);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: java  cn.gd.seismology.evtformat.RTEvtData wfdisc_file");
            System.exit(-1);
        }
        RTEvtData rtEvtData = new RTEvtData();
        rtEvtData.testReadEvtFile(args[0]);
    }
}

