/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.GeoDevEvent;
import cn.org.gddsn.seis.evtformat.GeoDevEvtData;
import cn.org.gddsn.seis.evtformat.Response;
import cn.org.gddsn.seis.evtformat.StationInfo;
import java.io.File;
import java.net.URL;
import java.util.Date;

public class MultiGeoDevEvent
extends GeoDevEvtData {
    public MultiGeoDevEvent() {
        this.evtFormat = 3;
    }

    public boolean readEvtFile(String fileName) {
        try {
            this.getMuliEvtData(new File(fileName));
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            return false;
        }
        return true;
    }

    public boolean writeEvtFile(String fileName) {
        return false;
    }

    public boolean readEvtFile(URL urlFile) {
        return false;
    }

    public boolean writeEvtFile(URL urlFile) {
        return false;
    }

    private void getMuliEvtData(File dirName) {
        int mTCN = 0;
        int mTSN = 0;
        String[] fNames = dirName.list();
        Date[] maEventDate = new Date[fNames.length];
        int[] maTRL = new int[fNames.length];
        StationInfo[] mSI = new StationInfo[fNames.length];
        Response[] mRspns = new Response[fNames.length];
        int[][] mFlag = new int[fNames.length][];
        double[][] mWDat = new double[(fNames.length + 1) * 3][];
        int i = 0;
        while (i < fNames.length) {
            GeoDevEvent ed = new GeoDevEvent();
            ((EvtData)ed).readEvtFile(String.valueOf(dirName.getPath()) + File.separator + fNames[i]);
            mSI[i] = ed.SI[0];
            mRspns[i] = ed.Rspns[0];
            mFlag[i] = ed.Flag[0];
            int j = 0;
            while (j < this.SI[0].stn_par.comp) {
                mWDat[mTCN++] = ed.WDat[j];
                ++j;
            }
            ++mTSN;
            maTRL[i] = ed.TRL;
            maEventDate[i] = new Date(ed.aEventDate[0].getTime());
            ++i;
        }
        this.TCN = mTCN;
        this.TSN = mTSN;
        this.aEventDate = maEventDate;
        this.aTRL = maTRL;
        this.TRL = this.aTRL[0];
        i = 1;
        while (i < this.TSN) {
            if (this.TRL < this.aTRL[i]) {
                this.TRL = this.aTRL[i];
            }
            ++i;
        }
        this.SI = mSI;
        this.Rspns = mRspns;
        this.Flag = mFlag;
        this.WDat = new double[this.TCN][];
        i = 0;
        while (i < this.TCN) {
            this.WDat[i] = mWDat[i];
            ++i;
        }
        this.convertToTimeSeries();
    }

    public static void main(String[] args) {
        new MultiGeoDevEvent();
    }
}

